/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.AsyncScope;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.transactions.TransactionGetResult;
import com.couchbase.client.scala.transactions.TransactionGetResult$;
import com.couchbase.client.scala.transactions.TransactionQueryOptions;
import com.couchbase.client.scala.transactions.TransactionQueryResult;
import com.couchbase.client.scala.transactions.TransactionQueryResult$;
import com.couchbase.client.scala.transactions.internal.EncodingUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001\u0002\n\u0014\u0001yA\u0001\u0002\n\u0001\u0003\u0006\u0004%I!\n\u0005\t]\u0001\u0011\t\u0011)A\u0005M!Aq\u0006\u0001BC\u0002\u0013%\u0001\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u00032\u0011\u0019A\u0004\u0001\"\u0001\u0016s!9a\b\u0001b\u0001\n\u0007y\u0004B\u0002$\u0001A\u0003%\u0001\tC\u0003H\u0001\u0011\u0005\u0001\nC\u0003c\u0001\u0011\u00051\rC\u0003g\u0001\u0011\u0005q\rC\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005e\u0001\u0001\"\u0003\u0002\u001c!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u0007\u0002A\u0011AA*\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003CBq!a\u0011\u0001\t\u0003\tyG\u0001\u0010Bgft7\r\u0016:b]N\f7\r^5p]\u0006#H/Z7qi\u000e{g\u000e^3yi*\u0011A#F\u0001\riJ\fgn]1di&|gn\u001d\u0006\u0003-]\tQa]2bY\u0006T!\u0001G\r\u0002\r\rd\u0017.\u001a8u\u0015\tQ2$A\u0005d_V\u001c\u0007NY1tK*\tA$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001?A\u0011\u0001EI\u0007\u0002C)\ta#\u0003\u0002$C\t1\u0011I\\=SK\u001a\f\u0001\"\u001b8uKJt\u0017\r\\\u000b\u0002MA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\fiJ\fgn]1di&|gN\u0003\u0002,/\u0005!1m\u001c:f\u0013\ti\u0003FA\u000fD_J,GK]1og\u0006\u001cG/[8o\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003%Ig\u000e^3s]\u0006d\u0007%A\u0006f]ZL'o\u001c8nK:$X#A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0005Q*\u0012aA3om&\u0011ag\r\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG/\u0001\u0007f]ZL'o\u001c8nK:$\b%\u0001\u0004=S:LGO\u0010\u000b\u0004uqj\u0004CA\u001e\u0001\u001b\u0005\u0019\u0002\"\u0002\u0013\u0006\u0001\u00041\u0003\"B\u0018\u0006\u0001\u0004\t\u0014\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\u0005\u0001\u0005CA!E\u001b\u0005\u0011%BA\"\"\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u000b\n\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002#\u0015DXmY;uS>t7i\u001c8uKb$\b%A\u0002hKR$2!S(V!\r\t%\nT\u0005\u0003\u0017\n\u0013aAR;ukJ,\u0007CA\u001eN\u0013\tq5C\u0001\u000bUe\u0006t7/Y2uS>tw)\u001a;SKN,H\u000e\u001e\u0005\u0006!\"\u0001\r!U\u0001\u000bG>dG.Z2uS>t\u0007C\u0001*T\u001b\u0005)\u0012B\u0001+\u0016\u0005=\t5/\u001f8d\u0007>dG.Z2uS>t\u0007\"\u0002,\t\u0001\u00049\u0016AA5e!\tAvL\u0004\u0002Z;B\u0011!,I\u0007\u00027*\u0011A,H\u0001\u0007yI|w\u000e\u001e \n\u0005y\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002aC\n11\u000b\u001e:j]\u001eT!AX\u0011\u0002E\u001d,GOU3qY&\u001c\u0017M\u0012:p[B\u0013XMZ3se\u0016$7+\u001a:wKJ<%o\\;q)\rIE-\u001a\u0005\u0006!&\u0001\r!\u0015\u0005\u0006-&\u0001\raV\u0001\u0007S:\u001cXM\u001d;\u0016\u0005!$H\u0003B5~}~$\"!\u00136\t\u000b-T\u00019\u00017\u0002\u0015M,'/[1mSj,'\u000fE\u0002naJl\u0011A\u001c\u0006\u0003_V\tQaY8eK\u000eL!!\u001d8\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>feB\u00111\u000f\u001e\u0007\u0001\t\u0015)(B1\u0001w\u0005\u0005!\u0016CA<{!\t\u0001\u00030\u0003\u0002zC\t9aj\u001c;iS:<\u0007C\u0001\u0011|\u0013\ta\u0018EA\u0002B]fDQ\u0001\u0015\u0006A\u0002ECQA\u0016\u0006A\u0002]Ca!!\u0001\u000b\u0001\u0004\u0011\u0018aB2p]R,g\u000e^\u0001\be\u0016\u0004H.Y2f+\u0011\t9!!\u0005\u0015\r\u0005%\u00111CA\f)\rI\u00151\u0002\u0005\u0007W.\u0001\u001d!!\u0004\u0011\t5\u0004\u0018q\u0002\t\u0004g\u0006EA!B;\f\u0005\u00041\bBBA\u000b\u0017\u0001\u0007A*A\u0002e_\u000eDq!!\u0001\f\u0001\u0004\ty!A\u0005dY>\u001cXm\u00159b]V!\u0011QDA\u001a)\u0015I\u0015qDA\u0018\u0011\u001d\t\t\u0003\u0004a\u0001\u0003G\tAa\u001d9b]B!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*)\n1a\u00198d\u0013\u0011\ti#a\n\u0003\u0017I+\u0017/^3tiN\u0003\u0018M\u001c\u0005\u0007\u0003ca\u0001\u0019A%\u0002\r\u0019,H/\u001e:f\t\u0015)HB1\u0001w\u0003\u0019\u0011X-\\8wKR!\u0011\u0011HA!!\u0011\t%*a\u000f\u0011\u0007\u0001\ni$C\u0002\u0002@\u0005\u0012A!\u00168ji\"1\u0011QC\u0007A\u00021\u000bQ!];fef$B!a\u0012\u0002PA!\u0011ISA%!\rY\u00141J\u0005\u0004\u0003\u001b\u001a\"A\u0006+sC:\u001c\u0018m\u0019;j_:\fV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\r\u0005Ec\u00021\u0001X\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0006\u0004\u0002H\u0005U\u0013q\u000b\u0005\u0007\u0003#z\u0001\u0019A,\t\u000f\u0005es\u00021\u0001\u0002\\\u00059q\u000e\u001d;j_:\u001c\bcA\u001e\u0002^%\u0019\u0011qL\n\u0003/Q\u0013\u0018M\\:bGRLwN\\)vKJLx\n\u001d;j_:\u001cHCBA$\u0003G\ni\u0007C\u0004\u0002fA\u0001\r!a\u001a\u0002\u000bM\u001cw\u000e]3\u0011\u0007I\u000bI'C\u0002\u0002lU\u0011!\"Q:z]\u000e\u001c6m\u001c9f\u0011\u0019\t\t\u0006\u0005a\u0001/RA\u0011qIA9\u0003g\n)\bC\u0004\u0002fE\u0001\r!a\u001a\t\r\u0005E\u0013\u00031\u0001X\u0011\u001d\tI&\u0005a\u0001\u00037\u0002")
public class AsyncTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final ClusterEnvironment environment;
    private final ExecutionContext executionContext;

    private CoreTransactionAttemptContext internal() {
        return this.internal;
    }

    private ClusterEnvironment environment() {
        return this.environment;
    }

    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    public Future<TransactionGetResult> get(AsyncCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().get(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$, this.executionContext());
    }

    public Future<TransactionGetResult> getReplicaFromPreferredServerGroup(AsyncCollection collection, String id) {
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().getReplicaFromPreferredServerGroup(collection.collectionIdentifier(), id)).map((Function1)TransactionGetResult$.MODULE$, this.executionContext());
    }

    public <T> Future<TransactionGetResult> insert(AsyncCollection collection, String id, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_insert", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_insert");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().insert(collection.collectionIdentifier(), id, encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$, this.executionContext()));
        }
        throw new MatchError(try_);
    }

    public <T> Future<TransactionGetResult> replace(TransactionGetResult doc, T content, JsonSerializer<T> serializer) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_replace", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_replace");
        Try<byte[]> try_ = EncodingUtil$.MODULE$.encode(content, span, serializer, this.internal().core().context());
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return Future$.MODULE$.failed(exception);
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            byte[] encoded = (byte[])success.value();
            return this.closeSpan(span, (Future<TransactionGetResult>)FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().replace(doc.internal(), encoded, CodecFlags.JSON_COMPAT_FLAGS, new SpanWrapper(span))).map((Function1)TransactionGetResult$.MODULE$, this.executionContext()));
        }
        throw new MatchError(try_);
    }

    private <T> Future<TransactionGetResult> closeSpan(RequestSpan span, Future<TransactionGetResult> future) {
        future.onComplete((Function1 & Serializable)x0$1 -> {
            AsyncTransactionAttemptContext.$anonfun$closeSpan$1(span, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return future;
    }

    public Future<BoxedUnit> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal().core().context(), (String)"transaction_remove", (RequestSpan)this.internal().span());
        span.lowCardinalityAttribute("db.operation", "transaction_remove");
        Future out = FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().remove(doc.internal(), new SpanWrapper(span))).map((Function1 & Serializable)x$1 -> {
            AsyncTransactionAttemptContext.$anonfun$remove$1(x$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        out.onComplete((Function1 & Serializable)x0$1 -> {
            AsyncTransactionAttemptContext.$anonfun$remove$2(span, x0$1);
            return BoxedUnit.UNIT;
        }, this.executionContext());
        return out;
    }

    public Future<TransactionQueryResult> query(String statement) {
        return this.query(null, statement, null);
    }

    public Future<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Future<TransactionQueryResult> query(AsyncScope scope, String statement, TransactionQueryOptions options) {
        CoreQueryOptions opts = (CoreQueryOptions)Option$.MODULE$.apply((Object)options).map((Function1 & Serializable)v -> v.toCore()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return FutureConversions$.MODULE$.javaMonoToScalaFuture(this.internal().queryBlocking(statement, scope == null ? null : CoreQueryContext.of((String)scope.bucketName(), (String)scope.name()), opts, false)).map((Function1)TransactionQueryResult$.MODULE$, this.executionContext());
    }

    public static final /* synthetic */ void $anonfun$closeSpan$1(RequestSpan span$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            span$1.status(RequestSpan.StatusCode.ERROR);
            span$1.end();
            return;
        }
        if (try_ instanceof Success) {
            span$1.end();
            return;
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ void $anonfun$remove$1(Void x$1) {
    }

    public static final /* synthetic */ void $anonfun$remove$2(RequestSpan span$2, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            span$2.status(RequestSpan.StatusCode.ERROR);
            span$2.end();
            return;
        }
        if (try_ instanceof Success) {
            span$2.end();
            return;
        }
        throw new MatchError((Object)try_);
    }

    public AsyncTransactionAttemptContext(CoreTransactionAttemptContext internal, ClusterEnvironment environment) {
        this.internal = internal;
        this.environment = environment;
        this.executionContext = environment.ec();
    }
}

