/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonDeserializer$IntConvert$;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.JsonSerializer$JsonArraySafeConvert$;
import com.couchbase.client.scala.datastructures.CouchbaseBuffer$;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions$;
import com.couchbase.client.scala.json.JsonArraySafe;
import com.couchbase.client.scala.json.JsonArraySafe$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.RemoveOptions$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001B\u0015+\u0001UB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\ty\u0001\u0011\t\u0011)A\u00051\"AA\f\u0001B\u0001B\u0003%Q\f\u0003\u0005e\u0001\t\u0005\t\u0015a\u0003f\u0011!Y\u0007A!A!\u0002\u0017a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b1\u00029\t\u000bY\u0004A\u0011A<\t\u0013\u0005\u0005\u0001A1A\u0005\u0012\u0005\r\u0001bBA\u0003\u0001\u0001\u0006I\u0001\u0019\u0005\n\u0003\u000f\u0001!\u0019!C\u0005\u0003\u0013A\u0001\"a\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u00033\u0001!\u0019!C\u0005\u00037A\u0001\"a\t\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003K\u0001!\u0019!C\u0005\u0003OA\u0001\"a\f\u0001A\u0003%\u0011\u0011\u0006\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011IA&\u0011\u001d\t9\u0006\u0001C\u0001\u00033Bq!a\u0019\u0001\t\u0003\n)\u0007C\u0004\u0002d\u0001!\t%a\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\b\u0003S\u0003A\u0011AAV\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a-\u0001\t\u0003\n)\fC\u0004\u00028\u0002!I!!/\t\u000f\u00055\u0007\u0001\"\u0011\u0002P\"9\u0011\u0011\u001d\u0001\u0005B\u0005\r\bbBAv\u0001\u0011\u0005\u0013Q\u001e\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\u0011I\u0001\u0001C!\u0003cCqAa\u0003\u0001\t\u0003\u0012iaB\u0005\u0003\u0016)\n\t\u0011#\u0001\u0003\u0018\u0019A\u0011FKA\u0001\u0012\u0003\u0011I\u0002\u0003\u0004wM\u0011\u0005!\u0011\u0005\u0005\n\u0005G1\u0013\u0013!C\u0001\u0005K\u0011qbQ8vG\"\u0014\u0017m]3Ck\u001a4WM\u001d\u0006\u0003W1\na\u0002Z1uCN$(/^2ukJ,7O\u0003\u0002.]\u0005)1oY1mC*\u0011q\u0006M\u0001\u0007G2LWM\u001c;\u000b\u0005E\u0012\u0014!C2pk\u000eD'-Y:f\u0015\u0005\u0019\u0014aA2p[\u000e\u0001QC\u0001\u001cC'\t\u0001q\u0007E\u00029}\u0001k\u0011!\u000f\u0006\u0003um\nq!\\;uC\ndWM\u0003\u0002={\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u00035J!aP\u001d\u0003\u001d\u0005\u00137\u000f\u001e:bGR\u0014UO\u001a4feB\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019\u0005A1\u0001E\u0005\u0005!\u0016CA#J!\t1u)D\u0001>\u0013\tAUHA\u0004O_RD\u0017N\\4\u0011\u0005\u0019S\u0015BA&>\u0005\r\te._\u0001\u0003S\u0012\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)>\u001b\u0005\t&B\u0001*5\u0003\u0019a$o\\8u}%\u0011A+P\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U{A\u0011\u0011LW\u0007\u0002Y%\u00111\f\f\u0002\u000b\u0007>dG.Z2uS>t\u0017aB8qi&|gn\u001d\t\u0004\rz\u0003\u0017BA0>\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011MY\u0007\u0002U%\u00111M\u000b\u0002\u001b\u0007>,8\r\u001b2bg\u0016\u001cu\u000e\u001c7fGRLwN\\(qi&|gn]\u0001\u0007I\u0016\u001cw\u000eZ3\u0011\u0007\u0019L\u0007)D\u0001h\u0015\tAG&A\u0003d_\u0012,7-\u0003\u0002kO\n\u0001\"j]8o\t\u0016\u001cXM]5bY&TXM]\u0001\u0007K:\u001cw\u000eZ3\u0011\u0007\u0019l\u0007)\u0003\u0002oO\nq!j]8o'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018a\u0001;bOB\u0019\u0011\u000f\u001e!\u000e\u0003IT!a]\u001f\u0002\u000fI,g\r\\3di&\u0011QO\u001d\u0002\t\u00072\f7o\u001d+bO\u00061A(\u001b8jiz\"B\u0001_?\u007f\u007fR!\u0011P_>}!\r\t\u0007\u0001\u0011\u0005\u0006I\u001e\u0001\u001d!\u001a\u0005\u0006W\u001e\u0001\u001d\u0001\u001c\u0005\u0006_\u001e\u0001\u001d\u0001\u001d\u0005\u0006\u0019\u001e\u0001\r!\u0014\u0005\u0006y\u001d\u0001\r\u0001\u0017\u0005\b9\u001e\u0001\n\u00111\u0001^\u0003\u0011y\u0007\u000f^:\u0016\u0003\u0001\fQa\u001c9ug\u0002\nq\u0002\\8pWV\u0004\u0018J\\(qi&|gn]\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#a\u0013AA6w\u0013\u0011\t)\"a\u0004\u0003\u001f1{wn[;q\u0013:|\u0005\u000f^5p]N\f\u0001\u0003\\8pWV\u0004\u0018J\\(qi&|gn\u001d\u0011\u0002\u001f5,H/\u0019;f\u0013:|\u0005\u000f^5p]N,\"!!\b\u0011\t\u00055\u0011qD\u0005\u0005\u0003C\tyAA\bNkR\fG/Z%o\u001fB$\u0018n\u001c8t\u0003AiW\u000f^1uK&sw\n\u001d;j_:\u001c\b%\u0001\u0006hKR|\u0005\u000f^5p]N,\"!!\u000b\u0011\t\u00055\u00111F\u0005\u0005\u0003[\tyA\u0001\u0006HKR|\u0005\u000f^5p]N\f1bZ3u\u001fB$\u0018n\u001c8tA\u0005i\u0011N\\:feR|\u0005\u000f^5p]N,\"!!\u000e\u0011\t\u00055\u0011qG\u0005\u0005\u0003s\tyAA\u0007J]N,'\u000f^(qi&|gn]\u0001\u000fS:\u001cXM\u001d;PaRLwN\\:!\u00035\u0011X-\\8wK>\u0003H/[8ogV\u0011\u0011\u0011\t\t\u0005\u0003\u001b\t\u0019%\u0003\u0003\u0002F\u0005=!!\u0004*f[>4Xm\u00149uS>t7/\u0001\bsK6|g/Z(qi&|gn\u001d\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\u0001\u000bi\u0005C\u0004\u0002PQ\u0001\r!!\u0015\u0002\u000b%tG-\u001a=\u0011\u0007\u0019\u000b\u0019&C\u0002\u0002Vu\u00121!\u00138u\u0003!\u0011X-\\8wK\u0006#H\u0003BA.\u0003C\u00022ARA/\u0013\r\ty&\u0010\u0002\u0005+:LG\u000fC\u0004\u0002PU\u0001\r!!\u0015\u0002\rI,Wn\u001c<f)\u0019\tY&a\u001a\u0002l!9\u0011\u0011\u000e\fA\u0002\u0005E\u0013aA5eq\"9\u0011Q\u000e\fA\u0002\u0005E\u0013!B2pk:$Hc\u0001!\u0002r!9\u0011qJ\fA\u0002\u0005E\u0013A\u0006:fiJL\u0018J\u001a#pG\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;\u0015\t\u0005m\u0013q\u000f\u0005\b\u0003sB\u0002\u0019AA>\u0003\u00051\u0007#\u0002$\u0002~\u0005\u0005\u0015bAA@{\tIa)\u001e8di&|g\u000e\r\u0019\u0005\u0003\u0007\u000b\t\n\u0005\u0004\u0002\u0006\u0006-\u0015qR\u0007\u0003\u0003\u000fS1!!#>\u0003\u0011)H/\u001b7\n\t\u00055\u0015q\u0011\u0002\u0004)JL\bcA!\u0002\u0012\u0012Y\u00111SA<\u0003\u0003\u0005\tQ!\u0001E\u0005\ryF%M\u0001\u0007C\u0012$wJ\\3\u0015\t\u0005e\u00151T\u0007\u0002\u0001!1\u0011QT\rA\u0002\u0001\u000bQA^1mk\u0016\fa!\u001b8tKJ$HCBA.\u0003G\u000b)\u000bC\u0004\u0002ji\u0001\r!!\u0015\t\r\u0005\u001d&\u00041\u0001A\u0003\u0011)G.Z7\u0002\u000fA\u0014X\r]3oIR!\u0011\u0011TAW\u0011\u0019\tij\u0007a\u0001\u0001\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0005\u0005m\u0013A\u00027f]\u001e$\b.\u0006\u0002\u0002R\u0005\u0019\u0011\r\u001c7\u0015\u0005\u0005m\u0006#BA_\u0003\u000f\u0004e\u0002BA`\u0003\u0007t1\u0001UAa\u0013\u0005i\u0013bAAc{\u00059\u0001/Y2lC\u001e,\u0017\u0002BAe\u0003\u0017\u00141aU3r\u0015\r\t)-P\u0001\bM>\u0014X-Y2i+\u0011\t\t.!8\u0015\t\u0005m\u00131\u001b\u0005\b\u0003sz\u0002\u0019AAk!\u00191\u0015q\u001b!\u0002\\&\u0019\u0011\u0011\\\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA!\u0002^\u00121\u0011q\\\u0010C\u0002\u0011\u0013\u0011!V\u0001\tSR,'/\u0019;peV\u0011\u0011Q\u001d\t\u0006\u0003{\u000b9\u000fQ\u0005\u0005\u0003S\fYM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003\u0019)\b\u000fZ1uKR1\u00111LAx\u0003cDq!a\u0014\"\u0001\u0004\t\t\u0006\u0003\u0004\u0002\u001e\u0006\u0002\r\u0001Q\u0001\ra\u0006$8\r[%o!2\f7-\u001a\u000b\t\u00033\u000b90a?\u0003\u0006!9\u0011\u0011 \u0012A\u0002\u0005E\u0013\u0001\u00024s_6Dq!!@#\u0001\u0004\ty0A\u0003qCR\u001c\u0007\u000eE\u0003\u0002>\n\u0005\u0001)\u0003\u0003\u0003\u0004\u0005-'\u0001D%uKJ\f'\r\\3P]\u000e,\u0007b\u0002B\u0004E\u0001\u0007\u0011\u0011K\u0001\te\u0016\u0004H.Y2fI\u0006)1\r\\3be\u0006I\u0011N\\:feR\fE\u000e\u001c\u000b\u0007\u00037\u0012yA!\u0005\t\u000f\u0005=C\u00051\u0001\u0002R!9!1\u0003\u0013A\u0002\u0005}\u0018A\u0002<bYV,7/A\bD_V\u001c\u0007NY1tK\n+hMZ3s!\t\tgeE\u0002'\u00057\u00012A\u0012B\u000f\u0013\r\u0011y\"\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t]\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0003\u0003(\tuRC\u0001B\u0015U\ri&1F\u0016\u0003\u0005[\u0001BAa\f\u0003:5\u0011!\u0011\u0007\u0006\u0005\u0005g\u0011)$A\u0005v]\u000eDWmY6fI*\u0019!qG\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\tE\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)1\t\u000bb\u0001\t\u0002")
public class CouchbaseBuffer<T>
extends AbstractBuffer<T> {
    private final String id;
    private final Collection collection;
    private final JsonDeserializer<T> decode;
    private final JsonSerializer<T> encode;
    private final ClassTag<T> tag;
    private final CouchbaseCollectionOptions opts;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;
    private final GetOptions getOptions;
    private final InsertOptions insertOptions;
    private final RemoveOptions removeOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseBuffer$.MODULE$.$lessinit$greater$default$3();
    }

    public CouchbaseCollectionOptions opts() {
        return this.opts;
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    private GetOptions getOptions() {
        return this.getOptions;
    }

    private InsertOptions insertOptions() {
        return this.insertOptions;
    }

    private RemoveOptions removeOptions() {
        return this.removeOptions;
    }

    public T apply(int index) {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.get(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            return (T)value;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            throw new IndexOutOfBoundsException(new StringBuilder(39).append("Index ").append(index).append(" out of bounds, with root cause: ").append(err.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    public void removeAt(int index) {
        this.remove(index, 1);
    }

    public void remove(int idx, int count) {
        Throwable err;
        IndexedSeq spec = package$.MODULE$.Range().apply(idx, idx + count).map((Function1 & Serializable)i -> MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(BoxesRunTime.unboxToInt((Object)i)).append("]").toString()));
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)spec, this.mutateInOptions());
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err2 = failure.exception();
            if (err2 instanceof DocumentNotFoundException) {
                DocumentNotFoundException documentNotFoundException = (DocumentNotFoundException)err2;
                throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(documentNotFoundException.getMessage()).toString());
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            PathNotFoundException pathNotFoundException = (PathNotFoundException)err;
            throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(pathNotFoundException.getMessage()).toString());
        }
        if (bl) {
            Throwable err3 = failure.exception();
            throw err3;
        }
        throw new MatchError(try_);
    }

    public T remove(int index) {
        Throwable err;
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.get(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            Try<MutateInResult> mutateResult = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(index).append("]").toString()), (List)Nil$.MODULE$), this.mutateInOptions().cas(((LookupInResult)op.get()).cas()));
            boolean bl2 = false;
            Failure failure2 = null;
            Try<MutateInResult> try_2 = mutateResult;
            if (try_2 instanceof Success) {
                return (T)value;
            }
            if (try_2 instanceof Failure) {
                bl2 = true;
                failure2 = (Failure)try_2;
                Throwable err2 = failure2.exception();
                if (err2 instanceof CasMismatchException) {
                    return this.remove(index);
                }
            }
            if (bl2) {
                Throwable err3 = failure2.exception();
                throw new CouchbaseException(new StringBuilder(51).append("Found element at index ").append(index).append(" but was unable to remove it").toString(), err3);
            }
            throw new MatchError(try_2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err4 = failure.exception();
            if (err4 instanceof DocumentNotFoundException) {
                DocumentNotFoundException documentNotFoundException = (DocumentNotFoundException)err4;
                throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(documentNotFoundException.getMessage()).toString());
            }
        }
        if (bl && (err = failure.exception()) instanceof PathNotFoundException) {
            PathNotFoundException pathNotFoundException = (PathNotFoundException)err;
            throw new IndexOutOfBoundsException(new StringBuilder(42).append("Failed to remove element with root cause: ").append(pathNotFoundException.getMessage()).toString());
        }
        if (bl) {
            Throwable err5 = failure.exception();
            throw err5;
        }
        throw new MatchError((Object)try_);
    }

    private void retryIfDocDoesNotExist(Function0<Try<?>> f) {
        block2: {
            Try try_;
            Failure failure;
            boolean bl;
            while (true) {
                Try result = (Try)f.apply();
                bl = false;
                failure = null;
                try_ = result;
                if (try_ instanceof Success) break block2;
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                if (!(failure.exception() instanceof DocumentNotFoundException)) break;
                this.initialize();
            }
            if (bl) {
                Throwable err = failure.exception();
                throw err;
            }
            throw new MatchError((Object)try_);
        }
    }

    public CouchbaseBuffer<T> addOne(T value) {
        Function0 & Serializable f = (Function0 & Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAppend("", (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value})), $this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    public void insert(int idx, T elem) {
        this.insertAll(idx, (IterableOnce<T>)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{elem})));
    }

    public CouchbaseBuffer<T> prepend(T value) {
        Function0 & Serializable f = (Function0 & Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayPrepend("", (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{value})), $this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    private void initialize() {
        this.collection.insert(this.id, JsonArraySafe$.MODULE$.create(), this.insertOptions(), JsonSerializer$JsonArraySafeConvert$.MODULE$).get();
    }

    public int length() {
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)new .colon.colon((Object)LookupInSpec$.MODULE$.count(""), (List)Nil$.MODULE$), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable)result -> result.contentAs(0, JsonDeserializer$IntConvert$.MODULE$, ClassTag$.MODULE$.Int()));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            int count = BoxesRunTime.unboxToInt((Object)success.value());
            return count;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return 0;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    private scala.collection.immutable.Seq<T> all() {
        Success success;
        scala.collection.immutable.Seq values;
        Try<GetResult> op = this.collection.get(this.id, this.getOptions());
        Try result = op.flatMap((Function1 & Serializable)x$1 -> x$1.contentAs(JsonDeserializer$JsonArraySafeConvert$.MODULE$, ClassTag$.MODULE$.apply(JsonArraySafe.class))).map((Function1 & Serializable)array -> array.toSeq());
        boolean bl = false;
        Failure failure = null;
        Try try_ = result;
        if (try_ instanceof Success && (values = (scala.collection.immutable.Seq)(success = (Success)try_).value()) != null) {
            scala.collection.immutable.Seq seq = values;
            return seq;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError((Object)try_);
    }

    public <U> void foreach(Function1<T, U> f) {
        this.all().foreach(f);
    }

    public Iterator<T> iterator() {
        return this.all().iterator();
    }

    public void update(int index, T value) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.replace(new StringBuilder(2).append("[").append(index).append("]").toString(), value, this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof PathNotFoundException) {
                throw new IndexOutOfBoundsException();
            }
        }
        if (bl && failure.exception() instanceof DocumentNotFoundException) {
            this.initialize();
            this.update(index, value);
            return;
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public CouchbaseBuffer<T> patchInPlace(int from, IterableOnce<T> patch, int replaced) {
        BoxedUnit boxedUnit;
        int j;
        int len = this.length();
        int i = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(from, 0), len);
        int n = scala.math.package$.MODULE$.min(scala.math.package$.MODULE$.max(replaced, 0), len);
        ListBuffer spec = ListBuffer$.MODULE$.empty();
        Iterator iter = patch.iterator();
        for (j = 0; iter.hasNext() && j < n && i + j < len; ++j) {
            spec.$plus$eq((Object)MutateInSpec$.MODULE$.replace(new StringBuilder(2).append("[").append(i + j).append("]").toString(), iter.next(), this.encode));
        }
        if (iter.hasNext()) {
            boxedUnit = spec.$plus$eq((Object)MutateInSpec$.MODULE$.arrayAppend(new StringBuilder(2).append("[").append(i + j).append("]").toString(), iter.toSeq(), this.encode));
        } else {
            if (j < n) {
                int start = i + j;
                int end = scala.math.package$.MODULE$.min(i + n, len);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(start), end).foreach((Function1 & Serializable)idx -> CouchbaseBuffer.$anonfun$patchInPlace$1(spec, BoxesRunTime.unboxToInt((Object)idx)));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        Function0 & Serializable f = (Function0 & Serializable)() -> $this.collection.mutateIn($this.id, (Seq<MutateInSpec>)spec.toList(), this.mutateInOptions());
        this.retryIfDocDoesNotExist(f);
        return this;
    }

    public void clear() {
        boolean bl = false;
        Failure failure = null;
        Try<MutationResult> try_ = this.collection.remove(this.id, this.removeOptions());
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                return;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
    }

    public void insertAll(int index, IterableOnce<T> values) {
        Try<MutateInResult> result = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)new .colon.colon((Object)MutateInSpec$.MODULE$.arrayAppend(new StringBuilder(2).append("[").append(index).append("]").toString(), values.iterator().toSeq(), this.encode), (List)Nil$.MODULE$), this.mutateInOptions());
        boolean bl = false;
        Failure failure = null;
        Try<MutateInResult> try_ = result;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof DocumentNotFoundException) {
                this.initialize();
                this.insertAll(index, values);
                return;
            }
        }
        if (bl) {
            Throwable err = failure.exception();
            throw err;
        }
        throw new MatchError(try_);
    }

    public static final /* synthetic */ ListBuffer $anonfun$patchInPlace$1(ListBuffer spec$1, int idx) {
        return (ListBuffer)spec$1.$plus$eq((Object)MutateInSpec$.MODULE$.remove(new StringBuilder(2).append("[").append(idx).append("]").toString()));
    }

    public CouchbaseBuffer(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode, ClassTag<T> tag) {
        CouchbaseCollectionOptions couchbaseCollectionOptions;
        this.id = id;
        this.collection = collection;
        this.decode = decode;
        this.encode = encode;
        this.tag = tag;
        Option<CouchbaseCollectionOptions> option = options;
        if (option instanceof Some) {
            CouchbaseCollectionOptions v;
            Some some = (Some)option;
            couchbaseCollectionOptions = v = (CouchbaseCollectionOptions)some.value();
        } else {
            couchbaseCollectionOptions = CouchbaseCollectionOptions$.MODULE$.apply(collection, CouchbaseCollectionOptions$.MODULE$.apply$default$2());
        }
        this.opts = couchbaseCollectionOptions;
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5(), LookupInOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.getOptions = new GetOptions(GetOptions$.MODULE$.apply$default$1(), GetOptions$.MODULE$.apply$default$2(), GetOptions$.MODULE$.apply$default$3(), GetOptions$.MODULE$.apply$default$4(), GetOptions$.MODULE$.apply$default$5(), GetOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.insertOptions = new InsertOptions(InsertOptions$.MODULE$.apply$default$1(), InsertOptions$.MODULE$.apply$default$2(), InsertOptions$.MODULE$.apply$default$3(), InsertOptions$.MODULE$.apply$default$4(), InsertOptions$.MODULE$.apply$default$5(), InsertOptions$.MODULE$.apply$default$6(), InsertOptions$.MODULE$.apply$default$7()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
        this.removeOptions = new RemoveOptions(RemoveOptions$.MODULE$.apply$default$1(), RemoveOptions$.MODULE$.apply$default$2(), RemoveOptions$.MODULE$.apply$default$3(), RemoveOptions$.MODULE$.apply$default$4(), RemoveOptions$.MODULE$.apply$default$5()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

