/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.bucket;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.manager.bucket.CoreBucketSettings;
import com.couchbase.client.core.manager.bucket.CoreCompressionMode;
import com.couchbase.client.core.manager.bucket.CoreEvictionPolicyType;
import com.couchbase.client.core.manager.bucket.CoreStorageBackend;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.durability.Durability$Majority$;
import com.couchbase.client.scala.durability.Durability$MajorityAndPersistToActive$;
import com.couchbase.client.scala.durability.Durability$PersistToMajority$;
import com.couchbase.client.scala.manager.bucket.BucketSettings;
import com.couchbase.client.scala.manager.bucket.BucketType;
import com.couchbase.client.scala.manager.bucket.BucketType$Couchbase$;
import com.couchbase.client.scala.manager.bucket.BucketType$Ephemeral$;
import com.couchbase.client.scala.manager.bucket.BucketType$Memcached$;
import com.couchbase.client.scala.manager.bucket.CompressionMode;
import com.couchbase.client.scala.manager.bucket.CompressionMode$Active$;
import com.couchbase.client.scala.manager.bucket.CompressionMode$Off$;
import com.couchbase.client.scala.manager.bucket.CompressionMode$Passive$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$FullEviction$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$NoEviction$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$NotRecentlyUsed$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$ValueOnly$;
import com.couchbase.client.scala.manager.bucket.StorageBackend;
import com.couchbase.client.scala.manager.bucket.StorageBackend$Couchstore$;
import com.couchbase.client.scala.manager.bucket.StorageBackend$Magma$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple15;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class BucketSettings$
implements Serializable {
    public static final BucketSettings$ MODULE$ = new BucketSettings$();

    public Option<StorageBackend> $lessinit$greater$default$12() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$14() {
        return None$.MODULE$;
    }

    public Option<Duration> $lessinit$greater$default$15() {
        return None$.MODULE$;
    }

    public BucketSettings fromCore(CoreBucketSettings core) {
        Durability durability;
        EjectionMethod ejectionMethod;
        Product product;
        String string = core.name();
        boolean bl = Predef$.MODULE$.Boolean2boolean(core.flushEnabled());
        int n = (int)Predef$.MODULE$.Long2long(core.ramQuotaMB());
        int n2 = Predef$.MODULE$.Integer2int(core.numReplicas());
        boolean bl2 = Predef$.MODULE$.Boolean2boolean(core.replicaIndexes());
        com.couchbase.client.core.config.BucketType bucketType = core.bucketType();
        if (com.couchbase.client.core.config.BucketType.COUCHBASE.equals(bucketType)) {
            product = BucketType$Couchbase$.MODULE$;
        } else if (com.couchbase.client.core.config.BucketType.EPHEMERAL.equals(bucketType)) {
            product = BucketType$Ephemeral$.MODULE$;
        } else if (com.couchbase.client.core.config.BucketType.MEMCACHED.equals(bucketType)) {
            product = BucketType$Memcached$.MODULE$;
        } else {
            throw new CouchbaseException(new StringBuilder(20).append("Unknown bucket type ").append(core.bucketType()).toString());
        }
        CoreEvictionPolicyType coreEvictionPolicyType = core.evictionPolicy();
        if (CoreEvictionPolicyType.FULL.equals(coreEvictionPolicyType)) {
            ejectionMethod = EjectionMethod$FullEviction$.MODULE$;
        } else if (CoreEvictionPolicyType.VALUE_ONLY.equals(coreEvictionPolicyType)) {
            ejectionMethod = EjectionMethod$ValueOnly$.MODULE$;
        } else if (CoreEvictionPolicyType.NOT_RECENTLY_USED.equals(coreEvictionPolicyType)) {
            ejectionMethod = EjectionMethod$NotRecentlyUsed$.MODULE$;
        } else if (CoreEvictionPolicyType.NO_EVICTION.equals(coreEvictionPolicyType)) {
            ejectionMethod = EjectionMethod$NoEviction$.MODULE$;
        } else {
            throw new CouchbaseException(new StringBuilder(22).append("Unknown eviction type ").append(core.evictionPolicy()).toString());
        }
        Option option = Option$.MODULE$.apply((Object)core.maxExpiry()).map((Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)BucketSettings$.$anonfun$fromCore$1(v)));
        Option option2 = Option$.MODULE$.apply((Object)core.compressionMode()).map((Function1 & Serializable)x0$1 -> {
            CoreCompressionMode coreCompressionMode = x0$1;
            if (CoreCompressionMode.OFF.equals(coreCompressionMode)) {
                return CompressionMode$Off$.MODULE$;
            }
            if (CoreCompressionMode.PASSIVE.equals(coreCompressionMode)) {
                return CompressionMode$Passive$.MODULE$;
            }
            if (CoreCompressionMode.ACTIVE.equals(coreCompressionMode)) {
                return CompressionMode$Active$.MODULE$;
            }
            throw new CouchbaseException(new StringBuilder(25).append("Unknown compression type ").append(core.compressionMode()).toString());
        });
        DurabilityLevel durabilityLevel = core.minimumDurabilityLevel();
        if (DurabilityLevel.NONE.equals(durabilityLevel)) {
            durability = Durability$Disabled$.MODULE$;
        } else if (DurabilityLevel.MAJORITY.equals(durabilityLevel)) {
            durability = Durability$Majority$.MODULE$;
        } else if (DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE.equals(durabilityLevel)) {
            durability = Durability$MajorityAndPersistToActive$.MODULE$;
        } else if (DurabilityLevel.PERSIST_TO_MAJORITY.equals(durabilityLevel)) {
            durability = Durability$PersistToMajority$.MODULE$;
        } else {
            throw new CouchbaseException(new StringBuilder(24).append("Unknown durability type ").append(core.minimumDurabilityLevel()).toString());
        }
        BucketSettings out = new BucketSettings(string, bl, n, n2, bl2, (BucketType)product, ejectionMethod, (Option<Object>)option, (Option<CompressionMode>)option2, durability, false, (Option<StorageBackend>)Option$.MODULE$.apply((Object)core.storageBackend()).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BucketSettings$.$anonfun$fromCore$3(x$1))).map((Function1 & Serializable)x0$2 -> {
            CoreStorageBackend coreStorageBackend = x0$2;
            CoreStorageBackend coreStorageBackend2 = CoreStorageBackend.COUCHSTORE;
            CoreStorageBackend coreStorageBackend3 = coreStorageBackend;
            if (!(coreStorageBackend2 != null ? !coreStorageBackend2.equals(coreStorageBackend3) : coreStorageBackend3 != null)) {
                return StorageBackend$Couchstore$.MODULE$;
            }
            CoreStorageBackend coreStorageBackend4 = CoreStorageBackend.MAGMA;
            CoreStorageBackend coreStorageBackend5 = coreStorageBackend;
            if (!(coreStorageBackend4 != null ? !coreStorageBackend4.equals(coreStorageBackend5) : coreStorageBackend5 != null)) {
                return StorageBackend$Magma$.MODULE$;
            }
            throw new CouchbaseException(new StringBuilder(21).append("Unknown storage type ").append(core.storageBackend()).toString());
        }), (Option<Object>)(core.historyRetentionCollectionDefault() != null ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.Boolean2boolean(core.historyRetentionCollectionDefault()))) : None$.MODULE$), (Option<Object>)(core.historyRetentionBytes() != null ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(core.historyRetentionBytes()))) : None$.MODULE$), (Option<Duration>)(core.historyRetentionDuration() != null ? new Some((Object)core.historyRetentionDuration()).map((Function1 & Serializable)in -> DurationConversions$.MODULE$.javaDurationToScala((java.time.Duration)in)) : None$.MODULE$));
        return out;
    }

    public BucketSettings apply(String name, boolean flushEnabled, int ramQuotaMB, int numReplicas, boolean replicaIndexes, BucketType bucketType, EjectionMethod ejectionMethod, Option<Object> maxTTL, Option<CompressionMode> compressionMode, Durability minimumDurabilityLevel, boolean healthy, Option<StorageBackend> storageBackend, Option<Object> historyRetentionCollectionDefault, Option<Object> historyRetentionBytes, Option<Duration> historyRetentionDuration) {
        return new BucketSettings(name, flushEnabled, ramQuotaMB, numReplicas, replicaIndexes, bucketType, ejectionMethod, maxTTL, compressionMode, minimumDurabilityLevel, healthy, storageBackend, historyRetentionCollectionDefault, historyRetentionBytes, historyRetentionDuration);
    }

    public Option<StorageBackend> apply$default$12() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$13() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$14() {
        return None$.MODULE$;
    }

    public Option<Duration> apply$default$15() {
        return None$.MODULE$;
    }

    public Option<Tuple15<String, Object, Object, Object, Object, BucketType, EjectionMethod, Option<Object>, Option<CompressionMode>, Durability, Object, Option<StorageBackend>, Option<Object>, Option<Object>, Option<Duration>>> unapply(BucketSettings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple15((Object)x$0.name(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flushEnabled()), (Object)BoxesRunTime.boxToInteger((int)x$0.ramQuotaMB()), (Object)BoxesRunTime.boxToInteger((int)x$0.numReplicas()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.replicaIndexes()), (Object)x$0.bucketType(), (Object)x$0.ejectionMethod(), x$0.maxTTL(), x$0.compressionMode(), (Object)x$0.minimumDurabilityLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.healthy()), x$0.storageBackend(), x$0.historyRetentionCollectionDefault(), x$0.historyRetentionBytes(), x$0.historyRetentionDuration()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BucketSettings$.class);
    }

    public static final /* synthetic */ int $anonfun$fromCore$1(java.time.Duration v) {
        return (int)TimeUnit.NANOSECONDS.toSeconds(v.toNanos());
    }

    public static final /* synthetic */ boolean $anonfun$fromCore$3(CoreStorageBackend x$1) {
        String string = x$1.alias();
        String string2 = "undefined";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private BucketSettings$() {
    }
}

