/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerRequest;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ManagerUtil$ {
    public static final ManagerUtil$ MODULE$ = new ManagerUtil$();

    public SMono<GenericManagerResponse> sendRequest(Core core, GenericManagerRequest request) {
        return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            core.send((Request)request);
            return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).doOnNext((Function1 & Serializable)x$1 -> {
                ManagerUtil$.$anonfun$sendRequest$2(request, x$1);
                return BoxedUnit.UNIT;
            }).doOnError((Function1 & Serializable)err -> {
                ManagerUtil$.$anonfun$sendRequest$3(request, err);
                return BoxedUnit.UNIT;
            });
        });
    }

    public SMono<GenericManagerResponse> sendRequest(Core core, HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        boolean idempotent = !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null);
        return this.sendRequest(core, new GenericManagerRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, () -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), idempotent, null));
    }

    public SMono<GenericManagerResponse> sendRequest(Core core, HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retryStrategy) {
        HttpMethod httpMethod = method;
        HttpMethod httpMethod2 = HttpMethod.GET;
        boolean idempotent = !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null);
        return this.sendRequest(core, new GenericManagerRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), core.context(), retryStrategy, () -> {
            ByteBuf content = Unpooled.copiedBuffer((CharSequence)body.build(), (Charset)StandardCharsets.UTF_8);
            DefaultFullHttpRequest req = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path, content);
            req.headers().add("Content-Type", (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
            req.headers().add("Content-Length", (Object)BoxesRunTime.boxToInteger((int)content.readableBytes()));
            return req;
        }, idempotent, null));
    }

    public Try<BoxedUnit> checkStatus(GenericManagerResponse response, String action) {
        ResponseStatus responseStatus = response.status();
        ResponseStatus responseStatus2 = ResponseStatus.SUCCESS;
        if (responseStatus == null ? responseStatus2 != null : !responseStatus.equals(responseStatus2)) {
            return new Failure((Throwable)new CouchbaseException(new StringBuilder(44).append("Failed to ").append(action).append("; response status=").append(response.status()).append("; response ").append("body=").append(new String(response.content(), StandardCharsets.UTF_8)).toString()));
        }
        return new Success((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ void $anonfun$sendRequest$2(GenericManagerRequest request$1, GenericManagerResponse x$1) {
        request$1.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$sendRequest$3(GenericManagerRequest request$1, Throwable err) {
        request$1.context().logicallyComplete(err);
    }

    private ManagerUtil$() {
    }
}

