/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.util;

import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreCounterResult;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.api.manager.search.CoreSearchIndex;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreQueryStatus;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.api.search.result.CoreDateRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreNumericRangeSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchFacetResult;
import com.couchbase.client.core.api.search.result.CoreSearchRowLocations;
import com.couchbase.client.core.api.search.result.CoreTermSearchFacetResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.kv.Observe;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.durability.Durability$Majority$;
import com.couchbase.client.scala.durability.Durability$MajorityAndPersistToActive$;
import com.couchbase.client.scala.durability.Durability$PersistToMajority$;
import com.couchbase.client.scala.durability.PersistTo$;
import com.couchbase.client.scala.durability.ReplicateTo$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.CounterResult;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetReplicaResult;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.LookupInReplicaResult;
import com.couchbase.client.scala.kv.LookupInReplicaResult$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.StoreSemantics;
import com.couchbase.client.scala.kv.StoreSemantics$Insert$;
import com.couchbase.client.scala.kv.StoreSemantics$Replace$;
import com.couchbase.client.scala.kv.StoreSemantics$Upsert$;
import com.couchbase.client.scala.manager.search.SearchIndex;
import com.couchbase.client.scala.manager.search.SearchIndex$;
import com.couchbase.client.scala.query.QueryMetaData;
import com.couchbase.client.scala.query.QueryMetrics;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.QueryStatus;
import com.couchbase.client.scala.query.QueryStatus$Aborted$;
import com.couchbase.client.scala.query.QueryStatus$Closed$;
import com.couchbase.client.scala.query.QueryStatus$Completed$;
import com.couchbase.client.scala.query.QueryStatus$Errors$;
import com.couchbase.client.scala.query.QueryStatus$Fatal$;
import com.couchbase.client.scala.query.QueryStatus$Running$;
import com.couchbase.client.scala.query.QueryStatus$Stopped$;
import com.couchbase.client.scala.query.QueryStatus$Success$;
import com.couchbase.client.scala.query.QueryStatus$Timeout$;
import com.couchbase.client.scala.query.QueryStatus$Unknown$;
import com.couchbase.client.scala.query.QueryWarning;
import com.couchbase.client.scala.query.ReactiveQueryResult;
import com.couchbase.client.scala.search.result.SearchFacetResult;
import com.couchbase.client.scala.search.result.SearchFacetResult$DateRangeSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchFacetResult$NumericRangeSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchFacetResult$TermSearchFacetResult$;
import com.couchbase.client.scala.search.result.SearchRowLocations;
import com.couchbase.client.scala.search.result.SearchRowLocations$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.util.annotation.Nullable;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.StructuralCallSite;
import scala.util.Either;
import scala.util.Try;
import ujson.Arr;
import ujson.Bool$;
import ujson.Num;
import ujson.Obj;
import ujson.Obj$;
import ujson.Str;
import ujson.Value;

public final class CoreCommonConverters$ {
    public static final CoreCommonConverters$ MODULE$ = new CoreCommonConverters$();

    public static Method reflMethod$Method1(Class x$1) {
        CallSite methodCache1 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method1 = methodCache1.find(x$1);
        if (method1 != null) {
            return method1;
        }
        method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("timeout", methodCache1.parameterTypes()));
        methodCache1.add(x$1, method1);
        return method1;
    }

    public static Method reflMethod$Method2(Class x$1) {
        CallSite methodCache2 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method2 = methodCache2.find(x$1);
        if (method2 != null) {
            return method2;
        }
        method2 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("timeout", methodCache2.parameterTypes()));
        methodCache2.add(x$1, method2);
        return method2;
    }

    public static Method reflMethod$Method3(Class x$1) {
        CallSite methodCache3 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method3 = methodCache3.find(x$1);
        if (method3 != null) {
            return method3;
        }
        method3 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("retryStrategy", methodCache3.parameterTypes()));
        methodCache3.add(x$1, method3);
        return method3;
    }

    public static Method reflMethod$Method4(Class x$1) {
        CallSite methodCache4 = StructuralCallSite.bootstrap("apply", ()Ljava/lang/Object;);
        Method method4 = methodCache4.find(x$1);
        if (method4 != null) {
            return method4;
        }
        method4 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("parentSpan", methodCache4.parameterTypes()));
        methodCache4.add(x$1, method4);
        return method4;
    }

    public <T> CoreCommonOptions convert(T options) {
        Object object;
        Object object2;
        java.time.Duration duration;
        Object object3;
        T qual1 = options;
        try {
            object3 = CoreCommonConverters$.reflMethod$Method1(qual1.getClass()).invoke(qual1, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        Duration duration2 = (Duration)object3;
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        if (!(duration2 != null ? !duration2.equals(infinite) : infinite != null)) {
            duration = null;
        } else {
            Object object4;
            T qual2 = options;
            try {
                object4 = CoreCommonConverters$.reflMethod$Method2(qual2.getClass()).invoke(qual2, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            duration = java.time.Duration.ofNanos(((Duration)object4).toNanos());
        }
        T qual3 = options;
        try {
            object2 = CoreCommonConverters$.reflMethod$Method3(qual3.getClass()).invoke(qual3, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        T qual4 = options;
        try {
            object = CoreCommonConverters$.reflMethod$Method4(qual4.getClass()).invoke(qual4, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return CoreCommonOptions.of((java.time.Duration)duration, (RetryStrategy)((RetryStrategy)((Option)object2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (RequestSpan)((RequestSpan)((Option)object).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    public CoreCommonOptions makeCommonOptions(Duration timeout, RetryStrategy retryStrategy, RequestSpan parentSpan) {
        Duration duration = timeout;
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        return CoreCommonOptions.of((java.time.Duration)(!(duration != null ? !duration.equals(infinite) : infinite != null) ? null : java.time.Duration.ofNanos(timeout.toNanos())), (RetryStrategy)retryStrategy, (RequestSpan)parentSpan);
    }

    public RetryStrategy makeCommonOptions$default$2() {
        return null;
    }

    public RequestSpan makeCommonOptions$default$3() {
        return null;
    }

    public GetResult convert(CoreGetResult in, ClusterEnvironment env, Option<Transcoder> transcoder) {
        return new GetResult(in.key(), (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)in.content()), in.flags(), in.cas(), (Option<Instant>)Option$.MODULE$.apply((Object)in.expiry()), (Transcoder)transcoder.getOrElse((Function0 & Serializable)() -> env.transcoder()));
    }

    public GetReplicaResult convertReplica(CoreGetResult in, ClusterEnvironment env, Option<Transcoder> transcoder) {
        return new GetReplicaResult(in.key(), (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)in.content()), in.flags(), in.cas(), (Option<Instant>)Option$.MODULE$.apply((Object)in.expiry()), in.replica(), (Transcoder)transcoder.getOrElse((Function0 & Serializable)() -> env.transcoder()));
    }

    public LookupInReplicaResult convertLookupInReplica(CoreSubdocGetResult in, ClusterEnvironment env) {
        return LookupInReplicaResult$.MODULE$.apply(in, (Option<Instant>)None$.MODULE$, in.replica());
    }

    public MutationResult convert(CoreMutationResult in) {
        return new MutationResult(in.cas(), (Option<MutationToken>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.mutationToken())).map((Function1 & Serializable)mt -> new MutationToken(mt.partitionID(), mt.partitionUUID(), mt.sequenceNumber(), mt.bucketName())));
    }

    public MutateInResult convert(CoreSubdocMutateResult in) {
        return new MutateInResult(in.key(), in, in.cas(), (Option<MutationToken>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.mutationToken())).map((Function1 & Serializable)mt -> new MutationToken(mt.partitionID(), mt.partitionUUID(), mt.sequenceNumber(), mt.bucketName())));
    }

    public ExistsResult convert(CoreExistsResult in) {
        return new ExistsResult(in.exists(), in.cas());
    }

    public CounterResult convert(CoreCounterResult in) {
        return new CounterResult(in.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.mutationToken())), in.content());
    }

    public QueryResult convert(CoreQueryResult in) {
        return new QueryResult((scala.collection.immutable.Seq<QueryChunkRow>)CollectionConverters$.MODULE$.ListHasAsScala(in.collectRows()).asScala().toSeq(), this.convert(in.metaData()));
    }

    public ReactiveQueryResult convert(CoreReactiveQueryResult in) {
        return new ReactiveQueryResult(FutureConversions$.MODULE$.javaFluxToScalaFlux(in.rows()), (SMono<QueryMetaData>)FutureConversions$.MODULE$.javaMonoToScalaMono(in.metaData()).map((Function1 & Serializable)md -> MODULE$.convert((CoreQueryMetaData)md)));
    }

    public QueryMetaData convert(CoreQueryMetaData in) {
        return new QueryMetaData(in.requestId(), in.clientContextId(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.signature())), (Option<QueryMetrics>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.metrics())).map((Function1 & Serializable)v -> MODULE$.convert((CoreQueryMetrics)v)), (Seq<QueryWarning>)((Seq)CollectionConverters$.MODULE$.ListHasAsScala(in.warnings()).asScala().map((Function1 & Serializable)v -> new QueryWarning(v.code(), v.message()))), this.convert(in.status()), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(in.profile())));
    }

    public QueryMetrics convert(CoreQueryMetrics in) {
        return new QueryMetrics(DurationConversions$.MODULE$.javaDurationToScala(in.elapsedTime()), DurationConversions$.MODULE$.javaDurationToScala(in.executionTime()), in.resultCount(), in.resultSize(), in.mutationCount(), in.sortCount(), in.errorCount(), in.warningCount());
    }

    public QueryStatus convert(CoreQueryStatus in) {
        CoreQueryStatus coreQueryStatus = in;
        if (CoreQueryStatus.RUNNING.equals(coreQueryStatus)) {
            return QueryStatus$Running$.MODULE$;
        }
        if (CoreQueryStatus.SUCCESS.equals(coreQueryStatus)) {
            return QueryStatus$Success$.MODULE$;
        }
        if (CoreQueryStatus.ERRORS.equals(coreQueryStatus)) {
            return QueryStatus$Errors$.MODULE$;
        }
        if (CoreQueryStatus.COMPLETED.equals(coreQueryStatus)) {
            return QueryStatus$Completed$.MODULE$;
        }
        if (CoreQueryStatus.STOPPED.equals(coreQueryStatus)) {
            return QueryStatus$Stopped$.MODULE$;
        }
        if (CoreQueryStatus.TIMEOUT.equals(coreQueryStatus)) {
            return QueryStatus$Timeout$.MODULE$;
        }
        if (CoreQueryStatus.CLOSED.equals(coreQueryStatus)) {
            return QueryStatus$Closed$.MODULE$;
        }
        if (CoreQueryStatus.FATAL.equals(coreQueryStatus)) {
            return QueryStatus$Fatal$.MODULE$;
        }
        if (CoreQueryStatus.ABORTED.equals(coreQueryStatus)) {
            return QueryStatus$Aborted$.MODULE$;
        }
        if (CoreQueryStatus.UNKNOWN.equals(coreQueryStatus)) {
            return QueryStatus$Unknown$.MODULE$;
        }
        throw new MatchError((Object)coreQueryStatus);
    }

    public SearchRowLocations convert(CoreSearchRowLocations in) {
        return SearchRowLocations$.MODULE$.apply(in);
    }

    public SearchFacetResult convert(CoreSearchFacetResult in) {
        CoreSearchFacetResult coreSearchFacetResult = in;
        if (coreSearchFacetResult instanceof CoreTermSearchFacetResult) {
            CoreTermSearchFacetResult coreTermSearchFacetResult = (CoreTermSearchFacetResult)coreSearchFacetResult;
            return SearchFacetResult$TermSearchFacetResult$.MODULE$.apply(coreTermSearchFacetResult);
        }
        if (coreSearchFacetResult instanceof CoreDateRangeSearchFacetResult) {
            CoreDateRangeSearchFacetResult coreDateRangeSearchFacetResult = (CoreDateRangeSearchFacetResult)coreSearchFacetResult;
            return SearchFacetResult$DateRangeSearchFacetResult$.MODULE$.apply(coreDateRangeSearchFacetResult);
        }
        if (coreSearchFacetResult instanceof CoreNumericRangeSearchFacetResult) {
            CoreNumericRangeSearchFacetResult coreNumericRangeSearchFacetResult = (CoreNumericRangeSearchFacetResult)coreSearchFacetResult;
            return SearchFacetResult$NumericRangeSearchFacetResult$.MODULE$.apply(coreNumericRangeSearchFacetResult);
        }
        throw new MatchError((Object)coreSearchFacetResult);
    }

    public SearchIndex convert(CoreSearchIndex in) {
        return new SearchIndex(in.name(), in.sourceName(), (Option<String>)Option$.MODULE$.apply((Object)in.uuid()), (Option<String>)Option$.MODULE$.apply((Object)in.type()), (Option<Obj>)Option$.MODULE$.apply((Object)this.convert((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(in.params()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (Option<String>)Option$.MODULE$.apply((Object)in.sourceUuid()), (Option<Obj>)Option$.MODULE$.apply((Object)this.convert((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(in.sourceParams()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), (Option<String>)Option$.MODULE$.apply((Object)in.sourceType()), (Option<Obj>)Option$.MODULE$.apply((Object)this.convert((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(in.planParams()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), SearchIndex$.MODULE$.apply$default$10());
    }

    public Obj convert(scala.collection.immutable.Map<String, Object> in) {
        scala.collection.immutable.Map out = (scala.collection.immutable.Map)((MapOps)in.map((Function1 & Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), (Object)this.convertInternal$1(x._2())))).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Option<Value>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                if (A12 != null && ((Option)(A1 = A12)._2()).isDefined()) {
                    return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(A1._1()), ((Option)A1._2()).get());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Option<Value>> x1) {
                Tuple2<String, Option<Value>> tuple2;
                Tuple2<String, Option<Value>> tuple22 = x1;
                return tuple22 != null && ((Option)(tuple2 = tuple22)._2()).isDefined();
            }
        });
        return Obj$.MODULE$.from((IterableOnce)out);
    }

    public CoreSearchIndex convert(SearchIndex in) {
        return CoreSearchIndex.fromJson((String)in.toJson());
    }

    public <T> Future<T> convert(Function0<CoreAsyncResponse<T>> in, ExecutionContext ec) {
        Future future;
        try {
            future = FutureConversions$.MODULE$.javaCFToScalaFutureMappingExceptions(((CoreAsyncResponse)in.apply()).toFuture(), ec);
        }
        catch (Throwable err) {
            future = Future$.MODULE$.failed(err);
        }
        return future;
    }

    public <T> SMono<T> convert(Mono<T> in) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(in);
    }

    public <T> SFlux<T> convert(Flux<T> in) {
        return FutureConversions$.MODULE$.javaFluxToScalaFlux(in);
    }

    public CoreDurability convert(Durability in) {
        Durability durability = in;
        if (Durability$Disabled$.MODULE$.equals(durability)) {
            return CoreDurability.NONE;
        }
        if (durability instanceof Durability.ClientVerified) {
            Observe.ObserveReplicateTo observeReplicateTo;
            Observe.ObservePersistTo observePersistTo;
            Enumeration.Value persistTo;
            Durability.ClientVerified clientVerified = (Durability.ClientVerified)durability;
            Enumeration.Value replicateTo = clientVerified.replicateTo();
            Enumeration.Value value = persistTo = clientVerified.persistTo();
            Enumeration.Value value2 = PersistTo$.MODULE$.None();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                observePersistTo = Observe.ObservePersistTo.NONE;
            } else {
                Enumeration.Value value4 = PersistTo$.MODULE$.One();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    observePersistTo = Observe.ObservePersistTo.ONE;
                } else {
                    Enumeration.Value value6 = PersistTo$.MODULE$.Two();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        observePersistTo = Observe.ObservePersistTo.TWO;
                    } else {
                        Enumeration.Value value8 = PersistTo$.MODULE$.Three();
                        Enumeration.Value value9 = value;
                        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                            observePersistTo = Observe.ObservePersistTo.THREE;
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                }
            }
            Enumeration.Value value10 = replicateTo;
            Enumeration.Value value11 = ReplicateTo$.MODULE$.None();
            Enumeration.Value value12 = value10;
            if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
                observeReplicateTo = Observe.ObserveReplicateTo.NONE;
            } else {
                Enumeration.Value value13 = ReplicateTo$.MODULE$.One();
                Enumeration.Value value14 = value10;
                if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                    observeReplicateTo = Observe.ObserveReplicateTo.ONE;
                } else {
                    Enumeration.Value value15 = ReplicateTo$.MODULE$.Two();
                    Enumeration.Value value16 = value10;
                    if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                        observeReplicateTo = Observe.ObserveReplicateTo.TWO;
                    } else {
                        Enumeration.Value value17 = ReplicateTo$.MODULE$.Three();
                        Enumeration.Value value18 = value10;
                        if (!(value17 != null ? !value17.equals(value18) : value18 != null)) {
                            observeReplicateTo = Observe.ObserveReplicateTo.THREE;
                        } else {
                            throw new MatchError((Object)value10);
                        }
                    }
                }
            }
            return CoreDurability.of((Observe.ObservePersistTo)observePersistTo, (Observe.ObserveReplicateTo)observeReplicateTo);
        }
        if (Durability$Majority$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.MAJORITY);
        }
        if (Durability$MajorityAndPersistToActive$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE);
        }
        if (Durability$PersistToMajority$.MODULE$.equals(durability)) {
            return CoreDurability.of((DurabilityLevel)DurabilityLevel.PERSIST_TO_MAJORITY);
        }
        throw new MatchError((Object)durability);
    }

    public CoreExpiry convertExpiry(@Nullable Duration in) {
        if (in == null) {
            return CoreExpiry.NONE;
        }
        return CoreExpiry.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(in));
    }

    public java.time.Duration convert(Duration in) {
        return java.time.Duration.ofMillis(in.toMillis());
    }

    public CoreStoreSemantics convert(StoreSemantics in) {
        StoreSemantics storeSemantics = in;
        if (StoreSemantics$Replace$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.REPLACE;
        }
        if (StoreSemantics$Insert$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.INSERT;
        }
        if (StoreSemantics$Upsert$.MODULE$.equals(storeSemantics)) {
            return CoreStoreSemantics.UPSERT;
        }
        throw new MatchError((Object)storeSemantics);
    }

    public <T> Supplier<CoreEncodedContent> encoder(Transcoder transcoder, JsonSerializer<T> serializer, T content) {
        return () -> {
            Try<EncodedValue> try_;
            Transcoder transcoder = transcoder;
            if (transcoder instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder;
                try_ = transcoderWithSerializer.encode(content, serializer);
            } else if (transcoder instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder;
                try_ = transcoderWithoutSerializer.encode(content);
            } else {
                throw new MatchError((Object)transcoder);
            }
            EncodedValue value = (EncodedValue)try_.get();
            return new CoreEncodedContent(value){
                private final EncodedValue value$1;

                public byte[] encoded() {
                    return this.value$1.encoded();
                }

                public int flags() {
                    return this.value$1.flags();
                }
                {
                    this.value$1 = value$1;
                }
            };
        };
    }

    private final Option convertInternal$1(Object in) {
        Object object = in;
        if (object instanceof String) {
            String string = (String)object;
            return new Some((Object)new Str(string));
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return new Some((Object)new Num((double)n));
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return new Some((Object)new Num(d));
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return new Some((Object)Bool$.MODULE$.apply(bl));
        }
        if (object instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            return new Some((Object)this.convert((scala.collection.immutable.Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala((Map)linkedHashMap).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            ArrayBuffer ab = new ArrayBuffer();
            arrayList.forEach(v -> {
                Option option = this.convertInternal$1(v);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Value value = (Value)some.value();
                    ab.$plus$eq((Object)value);
                    return;
                }
            });
            return new Some((Object)new Arr(ab));
        }
        return None$.MODULE$;
    }

    private CoreCommonConverters$() {
    }
}

