/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.search.CoreSearchOps;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchResult$;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\rue\u0001\u0002!B\u0001)C\u0001\u0002\u0015\u0001\u0003\u0002\u0013\u0006I!\u0015\u0005\n5\u0002\u0011)\u0019!C\u0001\u0003nC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\nI\u0002\u0011)\u0019!C\u0001\u0003\u0016D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\u0006[\u0002!\tA\u001c\u0005\ti\u0002\u0011\r\u0011b\u0001Bk\"1A\u0010\u0001Q\u0001\nYDqa\u0016\u0001C\u0002\u0013\u0005Q\u0010\u0003\u0004\u007f\u0001\u0001\u0006I\u0001\u0016\u0005\n\u007f\u0002\u0011\r\u0011\"\u0001B\u0003\u0003A\u0001\"a\u0004\u0001A\u0003%\u00111\u0001\u0005\bA\u0002!\t!RA\t\u0011)\tY\u0002\u0001b\u0001\n\u0003\t\u0015Q\u0004\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002 !Q\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011)!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?A!\"!\r\u0001\u0005\u0004%\t!QA\u001a\u0011!\t\t\u0005\u0001Q\u0001\n\u0005U\u0002BCA\"\u0001\t\u0007I\u0011A!\u0002F!A\u00111\u000b\u0001!\u0002\u0013\t9\u0005C\u0006\u0002V\u0001A)\u0019!C\u0001\u0003\u0006]\u0003bCA5\u0001!\u0015\r\u0011\"\u0001B\u0003WB!\"!\u001f\u0001\u0005\u0004%\t!QA>\u0011!\tI\t\u0001Q\u0001\n\u0005u\u0004BCAF\u0001!\u0015\r\u0011\"\u0001\u0002\u000e\"Q\u0011Q\u0013\u0001\t\u0006\u0004%\t!a&\t\u0015\u0005\u0015\u0006\u0001#b\u0001\n\u0003\t9\u000b\u0003\u0006\u00024\u0002A)\u0019!C\u0001\u0003kC!\"!1\u0001\u0011\u000b\u0007I\u0011AAb\u0011)\tY\r\u0001EC\u0002\u0013\u0005\u0011Q\u001a\u0005\b\u0003?\u0002A\u0011AAy\u0011\u001d\t\u0019\t\u0001C\u0001\u0005'Aq!a!\u0001\t\u0003\u0011\u0019\u0004C\u0005\u0003P\u0001\t\n\u0011\"\u0001\u0003R!I!Q\r\u0001\u0012\u0002\u0013\u0005!q\r\u0005\n\u0005W\u0002\u0011\u0013!C\u0001\u0005[BqA!\u001d\u0001\t\u0003\u0011\u0019\bC\u0004\u0003r\u0001!\tAa#\t\u0013\te\u0005!%A\u0005\u0002\tm\u0005\"\u0003BP\u0001E\u0005I\u0011\u0001B4\u0011\u001d\u0011\t\u000b\u0001C\u0001\u0005GCqA!)\u0001\t\u0003\u0011\t\u000eC\u0005\u0003Z\u0002\t\n\u0011\"\u0001\u0003h!9!1\u001c\u0001\u0005\u0002\tu\u0007\"\u0003Bu\u0001E\u0005I\u0011\u0001B4\u0011\u001d\u0011Y\u000f\u0001C\u0001\u0005[D\u0011Ba@\u0001#\u0003%\ta!\u0001\t\u000f\t-\b\u0001\"\u0001\u0004\u0006!911\u0003\u0001\u0005\u0002\rU\u0001\"CB\u0014\u0001E\u0005I\u0011AB\u0015\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007[Aqaa\u000e\u0001\t\u0003\u0019I\u0004C\u0004\u00048\u0001!\ta!\u0010\t\u0011\r%\u0003\u0001\"\u0001B\u0007\u0017:qa!\u0014B\u0011\u0003\u0019yE\u0002\u0004A\u0003\"\u00051\u0011\u000b\u0005\u0007[f\"\taa\u0015\t\u000f\rU\u0013\b\"\u0001\u0004X!91QK\u001d\u0005\u0002\r5\u0004bBB+s\u0011\u00051\u0011\u0010\u0005\t\u0007\u001bKD\u0011A\"\u0004\u0010\"A1QR\u001d\u0005\u0002\r\u001bIJ\u0001\u0007Bgft7m\u00117vgR,'O\u0003\u0002C\u0007\u0006)1oY1mC*\u0011A)R\u0001\u0007G2LWM\u001c;\u000b\u0005\u0019;\u0015!C2pk\u000eD'-Y:f\u0015\u0005A\u0015aA2p[\u000e\u00011C\u0001\u0001L!\tae*D\u0001N\u0015\u0005\u0011\u0015BA(N\u0005\u0019\te.\u001f*fM\u0006YQM\u001c<je>tW.\u001a8u!\ra%\u000bV\u0005\u0003'6\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0006\u000b1!\u001a8w\u0013\tIfK\u0001\nDYV\u001cH/\u001a:F]ZL'o\u001c8nK:$\u0018!D1vi\",g\u000e^5dCR|'/F\u0001]!\ti\u0016-D\u0001_\u0015\t9vL\u0003\u0002a\u0007\u0006!1m\u001c:f\u0013\t\u0011gLA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003A\u0019wN\u001c8fGRLwN\\*ue&tw-F\u0001g!\t9'.D\u0001i\u0015\tIw,\u0001\u0003vi&d\u0017BA6i\u0005A\u0019uN\u001c8fGRLwN\\*ue&tw-A\td_:tWm\u0019;j_:\u001cFO]5oO\u0002\na\u0001P5oSRtD\u0003B8reN\u0004\"\u0001\u001d\u0001\u000e\u0003\u0005Ca\u0001\u0015\u0004\u0005\u0002\u0004\t\u0006\"\u0002.\u0007\u0001\u0004a\u0006\"\u00023\u0007\u0001\u00041\u0017AA3d+\u00051\bCA<{\u001b\u0005A(BA=N\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003wb\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0002\u0007\u0015\u001c\u0007%F\u0001U\u0003\u0011)gN\u001e\u0011\u0002\u0019\r|Wo\u00195cCN,w\n]:\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%q,A\u0002ba&LA!!\u0004\u0002\b\t\u00012i\u001c:f\u0007>,8\r\u001b2bg\u0016|\u0005o]\u0001\u000eG>,8\r\u001b2bg\u0016|\u0005o\u001d\u0011\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003/i\u0011aX\u0005\u0004\u00033y&\u0001B\"pe\u0016\fQb]3be\u000eDG+[7f_V$XCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013q\u0006AA-\u001e:bi&|g.\u0003\u0003\u0002*\u0005\r\"\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u001dM,\u0017M]2i)&lWm\\;uA\u0005\u0001\u0012M\\1msRL7m\u001d+j[\u0016|W\u000f^\u0001\u0012C:\fG.\u001f;jGN$\u0016.\\3pkR\u0004\u0013!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<}\u000bQA]3uefLA!a\u0010\u0002:\ti!+\u001a;ssN#(/\u0019;fOf\faB]3uef\u001cFO]1uK\u001eL\b%A\u0005tK\u0006\u00148\r[(qgV\u0011\u0011q\t\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)!\u0011QJA\u0004\u0003\u0019\u0019X-\u0019:dQ&!\u0011\u0011KA&\u00055\u0019uN]3TK\u0006\u00148\r[(qg\u0006Q1/Z1sG\"|\u0005o\u001d\u0011\u0002+I,\u0017m\u0019;jm\u0016\u0014UoY6fi6\u000bg.Y4feV\u0011\u0011\u0011\f\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0019\u0011WoY6fi*\u0019\u00111M!\u0002\u000f5\fg.Y4fe&!\u0011qMA/\u0005U\u0011V-Y2uSZ,')^2lKRl\u0015M\\1hKJ\fQD]3bGRLg/Z!oC2LH/[2t\u0013:$W\r_'b]\u0006<WM]\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0005\u0003g\n\t'A\u0005b]\u0006d\u0017\u0010^5dg&!\u0011qOA9\u0005u\u0011V-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014\u0018\u0001C9vKJLx\n]:\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u0015qA\u0001\u0006cV,'/_\u0005\u0005\u0003\u000f\u000b\tI\u0001\u0007D_J,\u0017+^3ss>\u00038/A\u0005rk\u0016\u0014\u0018p\u00149tA\u00059!-^2lKR\u001cXCAAH!\u0011\tY&!%\n\t\u0005M\u0015Q\f\u0002\u0013\u0003NLhn\u0019\"vG.,G/T1oC\u001e,'/A\u0003vg\u0016\u00148/\u0006\u0002\u0002\u001aB!\u00111TAQ\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0014\u0001B;tKJLA!a)\u0002\u001e\n\u0001\u0012i]=oGV\u001bXM]'b]\u0006<WM]\u0001\rcV,'/_%oI\u0016DXm]\u000b\u0003\u0003S\u0003B!a+\u000206\u0011\u0011Q\u0016\u0006\u0005\u0003\u0007\u000b\t'\u0003\u0003\u00022\u00065&AF!ts:\u001c\u0017+^3ss&sG-\u001a=NC:\fw-\u001a:\u0002\u001bM,\u0017M]2i\u0013:$W\r_3t+\t\t9\f\u0005\u0003\u0002:\u0006uVBAA^\u0015\u0011\ti%!\u0019\n\t\u0005}\u00161\u0018\u0002\u0018\u0003NLhnY*fCJ\u001c\u0007.\u00138eKbl\u0015M\\1hKJ\f\u0001#\u00198bYf$\u0018nY:J]\u0012,\u00070Z:\u0016\u0005\u0005\u0015\u0007\u0003BA8\u0003\u000fLA!!3\u0002r\tQ\u0012i]=oG\u0006s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\u0006\tRM^3oi&twMR;oGRLwN\\:\u0016\u0005\u0005=\u0007\u0003BAi\u0003/l!!a5\u000b\t\u0005U\u0017\u0011M\u0001\tKZ,g\u000e^5oO&!\u0011\u0011\\Aj\u0005q\t5/\u001f8d\u000bZ,g\u000e^5oO\u001a+hn\u0019;j_:l\u0015M\\1hKJD3aHAo!\u0011\ty.a;\u000f\t\u0005\u0005\u0018q]\u0007\u0003\u0003GT1!!:`\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003S\f\u0019/A\u0005Ti\u0006\u0014\u0017\u000e\\5us&!\u0011Q^Ax\u0005-)fnY8n[&$H/\u001a3\u000b\t\u0005%\u00181\u001d\u000b\u0005\u0003g\fI\u0010E\u0002q\u0003kL1!a>B\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\t\u000f\u0005m\b\u00051\u0001\u0002~\u0006Q!-^2lKRt\u0015-\\3\u0011\t\u0005}(Q\u0002\b\u0005\u0005\u0003\u0011I\u0001E\u0002\u0003\u00045k!A!\u0002\u000b\u0007\t\u001d\u0011*\u0001\u0004=e>|GOP\u0005\u0004\u0005\u0017i\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0010\tE!AB*ue&twMC\u0002\u0003\f5#bA!\u0006\u0003&\t%\u0002#B<\u0003\u0018\tm\u0011b\u0001B\rq\n1a)\u001e;ve\u0016\u0004BA!\b\u0003\"5\u0011!q\u0004\u0006\u0004\u0003\u0007\u000b\u0015\u0002\u0002B\u0012\u0005?\u00111\"U;fef\u0014Vm];mi\"9!qE\u0011A\u0002\u0005u\u0018!C:uCR,W.\u001a8u\u0011\u001d\u0011Y#\ta\u0001\u0005[\tqa\u001c9uS>t7\u000f\u0005\u0003\u0003\u001e\t=\u0012\u0002\u0002B\u0019\u0005?\u0011A\"U;fef|\u0005\u000f^5p]N$\"B!\u0006\u00036\t]\"\u0011\tB#\u0011\u001d\u00119C\ta\u0001\u0003{D\u0011B!\u000f#!\u0003\u0005\rAa\u000f\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0003\u001e\tu\u0012\u0002\u0002B \u0005?\u0011q\"U;fef\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0005\u0007\u0012\u0003\u0013!a\u0001\u0003?\tq\u0001^5nK>,H\u000fC\u0005\u0003H\t\u0002\n\u00111\u0001\u0003J\u0005)\u0011\r\u001a5pGB\u0019AJa\u0013\n\u0007\t5SJA\u0004C_>dW-\u00198\u0002\u001fE,XM]=%I\u00164\u0017-\u001e7uII*\"Aa\u0015+\t\tm\"QK\u0016\u0003\u0005/\u0002BA!\u0017\u0003b5\u0011!1\f\u0006\u0005\u0005;\u0012y&A\u0005v]\u000eDWmY6fI*\u0019\u0011Q]'\n\t\t\r$1\f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD9vKJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t%$\u0006BA\u0010\u0005+\nq\"];fef$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005_RCA!\u0013\u0003V\u0005q\u0011M\\1msRL7m])vKJLHC\u0002B;\u0005\u0003\u0013\u0019\tE\u0003x\u0005/\u00119\b\u0005\u0003\u0003z\tuTB\u0001B>\u0015\r\t\u0019(Q\u0005\u0005\u0005\u007f\u0012YHA\bB]\u0006d\u0017\u0010^5dgJ+7/\u001e7u\u0011\u001d\u00119C\na\u0001\u0003{DqAa\u000b'\u0001\u0004\u0011)\t\u0005\u0003\u0003z\t\u001d\u0015\u0002\u0002BE\u0005w\u0012\u0001#\u00118bYf$\u0018nY:PaRLwN\\:\u0015\u0011\tU$Q\u0012BH\u0005/CqAa\n(\u0001\u0004\ti\u0010C\u0005\u0003:\u001d\u0002\n\u00111\u0001\u0003\u0012B!!\u0011\u0010BJ\u0013\u0011\u0011)Ja\u001f\u0003'\u0005s\u0017\r\\=uS\u000e\u001c\b+\u0019:b[\u0016$XM]:\t\u0013\t\rs\u0005%AA\u0002\u0005}\u0011\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0014\u0016\u0005\u0005#\u0013)&\u0001\rb]\u0006d\u0017\u0010^5dgF+XM]=%I\u00164\u0017-\u001e7uIM\n1b]3be\u000eD\u0017+^3ssRA!Q\u0015B[\u0005s\u00139\rE\u0003x\u0005/\u00119\u000b\u0005\u0003\u0003*\nEVB\u0001BV\u0015\u0011\u0011iKa,\u0002\rI,7/\u001e7u\u0015\r\ti%Q\u0005\u0005\u0005g\u0013YK\u0001\u0007TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u00038*\u0002\r!!@\u0002\u0013%tG-\u001a=OC6,\u0007bBABU\u0001\u0007!1\u0018\t\u0005\u0005{\u0013\u0019-\u0004\u0002\u0003@*!!\u0011\u0019BX\u0003\u001d\tX/\u001a:jKNLAA!2\u0003@\nY1+Z1sG\"\fV/\u001a:z\u0011\u001d\u0011YC\u000ba\u0001\u0005\u0013\u0004BAa3\u0003N6\u0011!qV\u0005\u0005\u0005\u001f\u0014yKA\u0007TK\u0006\u00148\r[(qi&|gn\u001d\u000b\t\u0005K\u0013\u0019N!6\u0003X\"9!qW\u0016A\u0002\u0005u\bbBABW\u0001\u0007!1\u0018\u0005\n\u0005\u0007Z\u0003\u0013!a\u0001\u0003?\tQc]3be\u000eD\u0017+^3ss\u0012\"WMZ1vYR$3'\u0001\u0006eSN\u001cwN\u001c8fGR$BAa8\u0003hB)qOa\u0006\u0003bB\u0019AJa9\n\u0007\t\u0015XJ\u0001\u0003V]&$\b\"\u0003B\"[A\u0005\t\u0019AA\u0010\u0003Q!\u0017n]2p]:,7\r\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005YA-[1h]>\u001cH/[2t)\u0011\u0011yOa?\u0011\u000b]\u00149B!=\u0011\t\tM(q_\u0007\u0003\u0005kT1Aa;`\u0013\u0011\u0011IP!>\u0003#\u0011K\u0017m\u001a8pgRL7m\u001d*fgVdG\u000fC\u0005\u0003~>\u0002\n\u00111\u0001\u0002~\u0006A!/\u001a9peRLE-A\u000beS\u0006<gn\\:uS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\r\r!\u0006BA\u007f\u0005+\"BAa<\u0004\b!9!1F\u0019A\u0002\r%\u0001\u0003BB\u0006\u0007\u001fi!a!\u0004\u000b\u0007\t-\u0018)\u0003\u0003\u0004\u0012\r5!A\u0005#jC\u001etwn\u001d;jGN|\u0005\u000f^5p]N\fA\u0001]5oOR!1qCB\u0010!\u00159(qCB\r!\u0011\u0011\u0019pa\u0007\n\t\ru!Q\u001f\u0002\u000b!&twMU3tk2$\b\"\u0003B\"eA\u0005\t\u0019AB\u0011!\u0015a51EA\u0010\u0013\r\u0019)#\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001dALgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0006\u0016\u0005\u0007C\u0011)\u0006\u0006\u0003\u0004\u0018\r=\u0002b\u0002B\u0016i\u0001\u00071\u0011\u0007\t\u0005\u0007\u0017\u0019\u0019$\u0003\u0003\u00046\r5!a\u0003)j]\u001e|\u0005\u000f^5p]N\fab^1jiVsG/\u001b7SK\u0006$\u0017\u0010\u0006\u0003\u0003`\u000em\u0002b\u0002B\"k\u0001\u0007\u0011q\u0004\u000b\u0007\u0005?\u001cyd!\u0011\t\u000f\t\rc\u00071\u0001\u0002 !9!1\u0006\u001cA\u0002\r\r\u0003\u0003BB\u0006\u0007\u000bJAaa\u0012\u0004\u000e\t)r+Y5u+:$\u0018\u000e\u001c*fC\u0012Lx\n\u001d;j_:\u001c\u0018\u0001\u00069fe\u001a|'/\\$m_\n\fGnQ8o]\u0016\u001cG\u000f\u0006\u0002\u0003b\u0006a\u0011i]=oG\u000ecWo\u001d;feB\u0011\u0001/O\n\u0003s-#\"aa\u0014\u0002\u000f\r|gN\\3diRA1\u0011LB2\u0007K\u001aI\u0007E\u0003\u0004\\\r}s.\u0004\u0002\u0004^)\u0011\u0011.T\u0005\u0005\u0007C\u001aiFA\u0002UefDa\u0001Z\u001eA\u0002\u0005u\bbBB4w\u0001\u0007\u0011Q`\u0001\tkN,'O\\1nK\"911N\u001eA\u0002\u0005u\u0018\u0001\u00039bgN<xN\u001d3\u0015\r\re3qNB9\u0011\u0019!G\b1\u0001\u0002~\"9!1\u0006\u001fA\u0002\rM\u0004c\u00019\u0004v%\u00191qO!\u0003\u001d\rcWo\u001d;fe>\u0003H/[8ogR11\u0011LB>\u0007\u0017Cqa! >\u0001\u0004\u0019y(A\u0005tK\u0016$gj\u001c3fgB1\u0011q`BA\u0007\u000bKAaa!\u0003\u0012\t\u00191+\u001a;\u0011\u0007U\u001b9)C\u0002\u0004\nZ\u0013\u0001bU3fI:{G-\u001a\u0005\b\u0005Wi\u0004\u0019AB:\u0003e)\u0007\u0010\u001e:bGR\u001cE.^:uKJ,eN^5s_:lWM\u001c;\u0015\r\rE51SBK!\u0015\u0019Yfa\u0018U\u0011\u0019!g\b1\u0001\u0002~\"91q\u0013 A\u0002\rM\u0014\u0001B8qiN$Ba!%\u0004\u001c\"91qS A\u0002\rM\u0004")
public class AsyncCluster {
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final CoreCouchbaseOps couchbaseOps;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final CoreSearchOps searchOps;
    private final CoreQueryOps queryOps;
    private volatile byte bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(seedNodes, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(connectionString, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return AsyncCluster$.MODULE$.connect(connectionString, username, password);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public Core core() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return core;
        }
        throw CoreProtostellarUtil.unsupportedCurrentlyInProtostellar();
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public CoreSearchOps searchOps() {
        return this.searchOps;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.couchbaseOps());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.users = new AsyncUserManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this.couchbaseOps(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((byte)(this.bitmap$0 & 0x20) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable)() -> this.reactiveAnalyticsIndexManager(), this.couchbaseOps(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((byte)(this.bitmap$0 & 0x40) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.couchbaseOps(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((byte)(this.bitmap$0 & 0x80) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        block0: {
            CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
            if (!(coreCouchbaseOps instanceof Core)) break block0;
            Core core = (Core)coreCouchbaseOps;
            core.openBucket(bucketName);
        }
        return new AsyncBucket(bucketName, this.couchbaseOps(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable)() -> this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable)() -> this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            HandlerBasicParams hp = new HandlerBasicParams(core);
            AnalyticsHandler analyticsHandler = new AnalyticsHandler(hp);
            Try<AnalyticsRequest> try_ = analyticsHandler.request(statement, options, core, (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                AnalyticsRequest request = (AnalyticsRequest)success.value();
                return analyticsHandler.queryAsync(request, this.ec());
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return Future$.MODULE$.failed(err);
            }
            throw new MatchError(try_);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return CoreCommonConverters$.MODULE$.convert((Function0 & Serializable)() -> this.searchOps().searchQueryAsync(indexName, query.toCore(), options.toCore()), this.ec()).map((Function1 & Serializable)result -> SearchResult$.MODULE$.apply((CoreSearchResult)result), this.ec());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.couchbaseOps().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return Future$.MODULE$.apply((Function0 & Serializable)() -> new DiagnosticsResult(core.diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), core.context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString())), this.ec());
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            CompletableFuture future = HealthPinger.ping((Core)core, OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
            return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
        }
        return Future$.MODULE$.failed((Throwable)CoreProtostellarUtil.unsupportedCurrentlyInProtostellar());
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.couchbaseOps().waitUntilReady(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable)x$1 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            core.initGlobalConfig();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$1) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.couchbaseOps = CoreCouchbaseOps.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.searchOps = this.couchbaseOps().searchOps(null);
        this.queryOps = this.couchbaseOps().queryOps();
    }
}

