/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DesignDocumentNotFoundException;
import com.couchbase.client.core.error.ViewServiceException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.view.DesignDocument;
import com.couchbase.client.scala.manager.view.ReactiveViewIndexManager$;
import com.couchbase.client.scala.manager.view.View;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.view.DesignDocumentNamespace;
import com.couchbase.client.scala.view.DesignDocumentNamespace$;
import com.couchbase.client.scala.view.DesignDocumentNamespace$Development$;
import com.couchbase.client.scala.view.DesignDocumentNamespace$Production$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;
import upickle.default$;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001B\u0012%\u0001EB\u0011b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000b\u001d\t\u0011\u0005\u0003!\u0011!Q\u0001\neB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\u0006\u001d\u0002!\ta\u0014\u0005\t)\u0002\u0011\r\u0011\"\u0001)+\"1a\f\u0001Q\u0001\nYC\u0001b\u0018\u0001C\u0002\u0013\u0005\u0001\u0006\u0019\u0005\u0007O\u0002\u0001\u000b\u0011B1\t\u000b!\u0004A\u0011B5\t\u000bq\u0004A\u0011A?\t\u0013\u00055\u0002!%A\u0005\u0002\u0005=\u0002\"CA#\u0001E\u0005I\u0011AA$\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bB\u0011\"a\u0017\u0001#\u0003%\t!a\f\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005\u001d\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\n\u0003k\u0002\u0011\u0013!C\u0001\u0003_A\u0011\"a\u001e\u0001#\u0003%\t!a\u0012\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!I\u0011Q\u0011\u0001\u0012\u0002\u0013\u0005\u0011q\u0006\u0005\n\u0003\u000f\u0003\u0011\u0013!C\u0001\u0003\u000fBq!!#\u0001\t\u0003\tY\tC\u0004\u0002(\u0002!\t!!+\t\u0013\u0005E\u0006!%A\u0005\u0002\u0005=\u0002\"CAZ\u0001E\u0005I\u0011AA$\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!a3\u0001\t\u0013\ti\rC\u0004\u0002Z\u0002!I!a7\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\u001d9!Q\u0003\u0013\t\u0002\t]aAB\u0012%\u0011\u0003\u0011I\u0002\u0003\u0004O?\u0011\u0005!1\u0004\u0005\t\u0005;yB\u0011\u0001\u0015\u0003 !A!qG\u0010\u0005\u0002!\u0012ID\u0001\rSK\u0006\u001cG/\u001b<f-&,w/\u00138eKbl\u0015M\\1hKJT!!\n\u0014\u0002\tYLWm\u001e\u0006\u0003O!\nq!\\1oC\u001e,'O\u0003\u0002*U\u0005)1oY1mC*\u00111\u0006L\u0001\u0007G2LWM\u001c;\u000b\u00055r\u0013!C2pk\u000eD'-Y:f\u0015\u0005y\u0013aA2p[\u000e\u00011C\u0001\u00013!\t\u0019T'D\u00015\u0015\u0005I\u0013B\u0001\u001c5\u0005\u0019\te.\u001f*fM\u0006a1m\\;dQ\n\f7/Z(qgV\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u0005\u0019\u0011\r]5\u000b\u0005yR\u0013\u0001B2pe\u0016L!\u0001Q\u001e\u0003!\r{'/Z\"pk\u000eD'-Y:f\u001fB\u001c\u0018!D2pk\u000eD'-Y:f\u001fB\u001c\b%\u0001\u0004ck\u000e\\W\r\u001e\t\u0003\t.s!!R%\u0011\u0005\u0019#T\"A$\u000b\u0005!\u0003\u0014A\u0002\u001fs_>$h(\u0003\u0002Ki\u00051\u0001K]3eK\u001aL!\u0001T'\u0003\rM#(/\u001b8h\u0015\tQE'\u0001\u0004=S:LGO\u0010\u000b\u0004!J\u001b\u0006CA)\u0001\u001b\u0005!\u0003\"B\u001c\u0005\u0001\u0004I\u0004\"\u0002\"\u0005\u0001\u0004\u0019\u0015A\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f^\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005i&lWMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u001f\u0011+g-Y;miRKW.Z8vi\u0002\nA\u0003R3gCVdGOU3uef\u001cFO]1uK\u001eLX#A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011l\u0014!\u0002:fiJL\u0018B\u00014d\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\u0006)B)\u001a4bk2$(+\u001a;ssN#(/\u0019;fOf\u0004\u0013!\u00045uiB\u001cE.[3oiR\u0013\u00180F\u0001k!\rY'\u000f^\u0007\u0002Y*\u0011QN\\\u0001\naV\u0014G.[:iKJT!!K8\u000b\u0005y\u0002(\"A9\u0002\u000fI,\u0017m\u0019;pe&\u00111\u000f\u001c\u0002\u0006'6{gn\u001c\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fA\u0001\u001b;ua*\u0011\u00110P\u0001\tK:$\u0007o\\5oi&\u00111P\u001e\u0002\u000f\u0007>\u0014X\r\u0013;ua\u000ec\u0017.\u001a8u\u0003E9W\r\u001e#fg&<g\u000eR8dk6,g\u000e\u001e\u000b\n}\u0006\u0015\u0011\u0011BA\f\u0003S\u00012a\u001b:\u0000!\r\t\u0016\u0011A\u0005\u0004\u0003\u0007!#A\u0004#fg&<g\u000eR8dk6,g\u000e\u001e\u0005\u0007\u0003\u000fQ\u0001\u0019A\"\u0002\u001b\u0011,7/[4o\t>\u001cg*Y7f\u0011\u001d\tYA\u0003a\u0001\u0003\u001b\t\u0011B\\1nKN\u0004\u0018mY3\u0011\t\u0005=\u00111C\u0007\u0003\u0003#Q!!\n\u0015\n\t\u0005U\u0011\u0011\u0003\u0002\u0018\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8u\u001d\u0006lWm\u001d9bG\u0016D\u0011\"!\u0007\u000b!\u0003\u0005\r!a\u0007\u0002\u000fQLW.Z8viB!\u0011QDA\u0014\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0007\u0005\u0015B'\u0001\u0006d_:\u001cWO\u001d:f]RL1!XA\u0010\u0011!\tYC\u0003I\u0001\u0002\u0004\t\u0017!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170A\u000ehKR$Um]5h]\u0012{7-^7f]R$C-\u001a4bk2$HeM\u000b\u0003\u0003cQC!a\u0007\u00024-\u0012\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003%)hn\u00195fG.,GMC\u0002\u0002@Q\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019%!\u000f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000ehKR$Um]5h]\u0012{7-^7f]R$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0013R3!YA\u001a\u0003U9W\r^!mY\u0012+7/[4o\t>\u001cW/\\3oiN$\u0002\"a\u0014\u0002V\u0005]\u0013\u0011\f\t\u0005W\u0006Es0C\u0002\u0002T1\u0014Qa\u0015$mkbDq!a\u0003\u000e\u0001\u0004\ti\u0001C\u0005\u0002\u001a5\u0001\n\u00111\u0001\u0002\u001c!A\u00111F\u0007\u0011\u0002\u0003\u0007\u0011-A\u0010hKR\fE\u000e\u001c#fg&<g\u000eR8dk6,g\u000e^:%I\u00164\u0017-\u001e7uII\nqdZ3u\u00032dG)Z:jO:$unY;nK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003Q)\bo]3si\u0012+7/[4o\t>\u001cW/\\3oiRQ\u00111MA6\u0003_\n\t(a\u001d\u0011\t-\u0014\u0018Q\r\t\u0004g\u0005\u001d\u0014bAA5i\t!QK\\5u\u0011\u0019\ti\u0007\u0005a\u0001\u007f\u0006I\u0011N\u001c3fq\u0012\u000bG/\u0019\u0005\b\u0003\u0017\u0001\u0002\u0019AA\u0007\u0011%\tI\u0002\u0005I\u0001\u0002\u0004\tY\u0002\u0003\u0005\u0002,A\u0001\n\u00111\u0001b\u0003y)\bo]3si\u0012+7/[4o\t>\u001cW/\\3oi\u0012\"WMZ1vYR$3'\u0001\u0010vaN,'\u000f\u001e#fg&<g\u000eR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0011BM]8q\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8u))\t\u0019'! \u0002\u0000\u0005\u0005\u00151\u0011\u0005\u0007\u0003\u000f\u0019\u0002\u0019A\"\t\u000f\u0005-1\u00031\u0001\u0002\u000e!I\u0011\u0011D\n\u0011\u0002\u0003\u0007\u00111\u0004\u0005\t\u0003W\u0019\u0002\u0013!a\u0001C\u0006aBM]8q\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\b3s_B$Um]5h]\u0012{7-^7f]R$C-\u001a4bk2$H\u0005N\u0001\u0011[\u0006\u0004hj\u001c;G_VtG-\u0012:s_J$\u0002\"!$\u0002 \u0006\r\u0016Q\u0015\t\u0005\u0003\u001f\u000bIJ\u0004\u0003\u0002\u0012\u0006Ueb\u0001$\u0002\u0014&\t\u0011&C\u0002\u0002\u0018R\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0006u%!\u0003+ie><\u0018M\u00197f\u0015\r\t9\n\u000e\u0005\b\u0003C3\u0002\u0019AAG\u0003\tIg\u000e\u0003\u0004\u0002\bY\u0001\ra\u0011\u0005\b\u0003\u00171\u0002\u0019AA\u0007\u0003U\u0001XO\u00197jg\"$Um]5h]\u0012{7-^7f]R$\u0002\"a\u0019\u0002,\u00065\u0016q\u0016\u0005\u0007\u0003\u000f9\u0002\u0019A\"\t\u0013\u0005eq\u0003%AA\u0002\u0005m\u0001\u0002CA\u0016/A\u0005\t\u0019A1\u0002?A,(\r\\5tQ\u0012+7/[4o\t>\u001cW/\\3oi\u0012\"WMZ1vYR$#'A\u0010qk\nd\u0017n\u001d5EKNLwM\u001c#pGVlWM\u001c;%I\u00164\u0017-\u001e7uIM\nQ\u0003]1uQ\u001a{'\u000fR3tS\u001etGi\\2v[\u0016tG\u000f\u0006\u0004\u0002:\u0006\u0015\u0017\u0011\u001a\t\u0006\u0003w\u000b\tmQ\u0007\u0003\u0003{S1!a05\u0003\u0011)H/\u001b7\n\t\u0005\r\u0017Q\u0018\u0002\u0004)JL\bBBAd5\u0001\u00071)\u0001\u0003oC6,\u0007bBA\u00065\u0001\u0007\u0011QB\u0001\u001aa\u0006$\bNR8s\u00032dG)Z:jO:$unY;nK:$8/\u0006\u0002\u0002PB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002Vj\u000bA\u0001\\1oO&\u0019A*a5\u0002\rQ|'j]8o)\u0011\ti.a?\u0011\t\u0005}\u0017q_\u0007\u0003\u0003CTA!a9\u0002f\u0006!an\u001c3f\u0015\u0011\t9/!;\u0002\u0011\u0011\fG/\u00192j]\u0012TA!a;\u0002n\u00069!.Y2lg>t'\u0002BAx\u0003c\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0007=\n\u0019PC\u0002\u0002vv\nA\u0001Z3qg&!\u0011\u0011`Aq\u0005)y%M[3di:{G-\u001a\u0005\u0007\u0003{d\u0002\u0019A@\u0002\u0007\u0011|7-A\u0006tK:$'+Z9vKN$H\u0003\u0002B\u0002\u0005\u0017\u0001Ba\u001b:\u0003\u0006A\u0019QOa\u0002\n\u0007\t%aO\u0001\tD_J,\u0007\n\u001e;q%\u0016\u001c\bo\u001c8tK\"9!QB\u000fA\u0002\t=\u0011a\u0002:fcV,7\u000f\u001e\t\u0004k\nE\u0011b\u0001B\nm\ny1i\u001c:f\u0011R$\bOU3rk\u0016\u001cH/\u0001\rSK\u0006\u001cG/\u001b<f-&,w/\u00138eKbl\u0015M\\1hKJ\u0004\"!U\u0010\u0014\u0005}\u0011DC\u0001B\f\u0003]\u0001\u0018M]:f\u00032dG)Z:jO:$unY;nK:$8\u000f\u0006\u0004\u0003\"\tM\"Q\u0007\t\u0007\u0003w\u000b\tMa\t\u0011\u000b\t\u0015\"qF@\u000e\u0005\t\u001d\"\u0002\u0002B\u0015\u0005W\tq!\\;uC\ndWMC\u0002\u0003.Q\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tDa\n\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\u0005\u0007\u0003C\u000b\u0003\u0019A\"\t\u000f\u0005-\u0011\u00051\u0001\u0002\u000e\u0005\u0019\u0002/\u0019:tK\u0012+7/[4o\t>\u001cW/\\3oiR1!1\bB\u001f\u0005\u007f\u0001R!a/\u0002B~Da!a2#\u0001\u0004\u0019\u0005bBArE\u0001\u0007!\u0011\t\t\u0005\u0005\u0007\u0012I%\u0004\u0002\u0003F)\u0011!qI\u0001\u0006k*\u001cxN\\\u0005\u0005\u0005\u0017\u0012)EA\u0002PE*\u0004")
public class ReactiveViewIndexManager {
    private final CoreCouchbaseOps couchbaseOps;
    private final String bucket;
    private final java.time.Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public java.time.Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    public RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private SMono<CoreHttpClient> httpClientTry() {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return SMono$.MODULE$.just((Object)core.httpClient(RequestTarget.views((String)this.bucket)));
        }
        return SMono$.MODULE$.error((Throwable)CoreProtostellarUtil.unsupportedInProtostellar((String)"views"));
    }

    public SMono<DesignDocument> getDesignDocument(String designDocName, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        return this.httpClientTry().flatMap((Function1 & Serializable)httpClient -> {
            CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
            Try<String> try_ = this.pathForDesignDocument(designDocName, namespace);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String path = (String)success.value();
                return this.sendRequest(httpClient.get(CoreHttpPath.path((String)path), options).build()).onErrorResume((Function1 & Serializable)err -> SMono$.MODULE$.error(this.mapNotFoundError((Throwable)err, designDocName, namespace))).flatMap((Function1 & Serializable)response -> {
                    ResponseStatus responseStatus = response.status();
                    if (ResponseStatus.SUCCESS.equals(responseStatus)) {
                        Try parsed = Try$.MODULE$.apply((Function0 & Serializable)() -> (Obj)default$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), default$.MODULE$.read$default$2(), default$.MODULE$.JsObjR())).flatMap((Function1 & Serializable)json -> ReactiveViewIndexManager$.MODULE$.parseDesignDocument(designDocName, (Obj)json));
                        Try try_ = parsed;
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            DesignDocument designDoc = (DesignDocument)success.value();
                            return SMono$.MODULE$.just((Object)designDoc);
                        }
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable err = failure.exception();
                            return SMono$.MODULE$.error(err);
                        }
                        throw new MatchError((Object)try_);
                    }
                    return SMono$.MODULE$.error((Throwable)new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName)).append("] from namespace ").append(namespace).toString()));
                });
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err2 = failure.exception();
                return SMono$.MODULE$.error(err2);
            }
            throw new MatchError(try_);
        });
    }

    public Duration getDesignDocument$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.DefaultTimeout());
    }

    public RetryStrategy getDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public SFlux<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return ManagerUtil$.MODULE$.sendRequest(core, HttpMethod.GET, this.pathForAllDesignDocuments(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
                ResponseStatus responseStatus = response.status();
                if (ResponseStatus.SUCCESS.equals(responseStatus)) {
                    Try<ArrayBuffer<DesignDocument>> try_ = ReactiveViewIndexManager$.MODULE$.parseAllDesignDocuments(new String(response.content(), StandardCharsets.UTF_8), namespace);
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        ArrayBuffer docs = (ArrayBuffer)success.value();
                        return SFlux$.MODULE$.fromIterable((Iterable)docs);
                    }
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
                    }
                    throw new MatchError(try_);
                }
                return SFlux$.MODULE$.error((Throwable)new CouchbaseException(new StringBuilder(68).append("Failed to get all design documents; response status=").append(response.status()).append("; response body=").append(new String(response.content(), StandardCharsets.UTF_8)).toString()), SFlux$.MODULE$.error$default$2());
            });
        }
        return SFlux$.MODULE$.error((Throwable)CoreProtostellarUtil.unsupportedInProtostellar((String)"views"), SFlux$.MODULE$.error$default$2());
    }

    public Duration getAllDesignDocuments$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.DefaultTimeout());
    }

    public RetryStrategy getAllDesignDocuments$default$3() {
        return this.DefaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertDesignDocument(DesignDocument indexData, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        return this.httpClientTry().flatMap((Function1 & Serializable)httpClient -> {
            CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
            Try<String> try_ = this.pathForDesignDocument(indexData.name(), namespace);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String path = (String)success.value();
                ObjectNode body = this.toJson(indexData);
                CoreHttpRequest request = httpClient.put(CoreHttpPath.path((String)path), options).json(Mapper.encodeAsBytes((Object)body)).build();
                return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
                    CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
                    if (coreCouchbaseOps instanceof Core) {
                        Core core = (Core)coreCouchbaseOps;
                        core.send((Request)request);
                        return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).doOnNext((Function1 & Serializable)x$1 -> {
                            ReactiveViewIndexManager.$anonfun$upsertDesignDocument$3(request, x$1);
                            return BoxedUnit.UNIT;
                        }).doOnError((Function1 & Serializable)err -> {
                            ReactiveViewIndexManager.$anonfun$upsertDesignDocument$4(request, err);
                            return BoxedUnit.UNIT;
                        }).map((Function1 & Serializable)x$2 -> {
                            ReactiveViewIndexManager.$anonfun$upsertDesignDocument$5(x$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    return SMono$.MODULE$.error((Throwable)CoreProtostellarUtil.unsupportedInProtostellar((String)"views"));
                });
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            throw new MatchError(try_);
        });
    }

    public Duration upsertDesignDocument$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.DefaultTimeout());
    }

    public RetryStrategy upsertDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropDesignDocument(String designDocName, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        return this.httpClientTry().flatMap((Function1 & Serializable)httpClient -> {
            CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
            Try<String> try_ = this.pathForDesignDocument(designDocName, namespace);
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                String path = (String)success.value();
                return this.sendRequest(httpClient.delete(CoreHttpPath.path((String)path), options).build()).onErrorResume((Function1 & Serializable)err -> SMono$.MODULE$.error(this.mapNotFoundError((Throwable)err, designDocName, namespace))).flatMap((Function1 & Serializable)response -> {
                    ResponseStatus responseStatus = response.status();
                    if (ResponseStatus.SUCCESS.equals(responseStatus)) {
                        return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                    }
                    return SMono$.MODULE$.error((Throwable)new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName)).append("] from namespace ").append(namespace).toString()));
                });
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err2 = failure.exception();
                return SMono$.MODULE$.error(err2);
            }
            throw new MatchError(try_);
        });
    }

    public Duration dropDesignDocument$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.DefaultTimeout());
    }

    public RetryStrategy dropDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public Throwable mapNotFoundError(Throwable in, String designDocName, DesignDocumentNamespace namespace) {
        Throwable throwable = in;
        if (throwable instanceof ViewServiceException) {
            ViewServiceException viewServiceException = (ViewServiceException)throwable;
            if (viewServiceException.content().contains("not_found")) {
                return DesignDocumentNotFoundException.forName((String)designDocName, (String)namespace.toString());
            }
            return (Throwable)ReactiveViewIndexManager.default$1(designDocName, namespace).apply();
        }
        return (Throwable)ReactiveViewIndexManager.default$1(designDocName, namespace).apply();
    }

    public SMono<BoxedUnit> publishDesignDocument(String designDocName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getDesignDocument(designDocName, DesignDocumentNamespace$Development$.MODULE$, timeout, retryStrategy).map((Function1 & Serializable)doc -> {
            this.upsertDesignDocument(doc, DesignDocumentNamespace$Production$.MODULE$, timeout, retryStrategy);
            return BoxedUnit.UNIT;
        });
    }

    public Duration publishDesignDocument$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.DefaultTimeout());
    }

    public RetryStrategy publishDesignDocument$default$3() {
        return this.DefaultRetryStrategy();
    }

    private Try<String> pathForDesignDocument(String name, DesignDocumentNamespace namespace) {
        return DesignDocumentNamespace$.MODULE$.requireUnqualified(name).map((Function1 & Serializable)unqualifiedName -> {
            String adjusted = namespace.adjustName((String)unqualifiedName);
            return new StringBuilder(10).append("/").append(UrlQueryStringBuilder.urlEncode((String)$this.bucket)).append("/_design/").append(UrlQueryStringBuilder.urlEncode((String)adjusted)).toString();
        });
    }

    private String pathForAllDesignDocuments() {
        return new StringBuilder(29).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)this.bucket)).append("/ddocs").toString();
    }

    private ObjectNode toJson(DesignDocument doc) {
        ObjectNode root = JacksonTransformers.MAPPER.createObjectNode();
        ObjectNode views = root.putObject("views");
        doc.views().foreach((Function1 & Serializable)x -> {
            ReactiveViewIndexManager.$anonfun$toJson$1(views, x);
            return BoxedUnit.UNIT;
        });
        return root;
    }

    private SMono<CoreHttpResponse> sendRequest(CoreHttpRequest request) {
        CoreCouchbaseOps coreCouchbaseOps = this.couchbaseOps();
        if (coreCouchbaseOps instanceof Core) {
            Core core = (Core)coreCouchbaseOps;
            return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
                core.send((Request)request);
                return FutureConversions$.MODULE$.wrap((Request<? extends Response>)request, request.response(), true).doOnNext((Function1 & Serializable)x$3 -> {
                    ReactiveViewIndexManager.$anonfun$sendRequest$2(request, x$3);
                    return BoxedUnit.UNIT;
                }).doOnError((Function1 & Serializable)err -> {
                    ReactiveViewIndexManager.$anonfun$sendRequest$3(request, err);
                    return BoxedUnit.UNIT;
                });
            });
        }
        return SMono$.MODULE$.error((Throwable)CoreProtostellarUtil.unsupportedInProtostellar((String)"views"));
    }

    public static final /* synthetic */ void $anonfun$upsertDesignDocument$3(CoreHttpRequest request$1, CoreHttpResponse x$1) {
        request$1.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$upsertDesignDocument$4(CoreHttpRequest request$1, Throwable err) {
        request$1.context().logicallyComplete(err);
    }

    public static final /* synthetic */ void $anonfun$upsertDesignDocument$5(CoreHttpResponse x$2) {
    }

    private static final Function0 default$1(String designDocName$3, DesignDocumentNamespace namespace$5) {
        return (Function0 & Serializable)() -> new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName$3)).append("] from namespace ").append(namespace$5).toString());
    }

    public static final /* synthetic */ void $anonfun$toJson$1(ObjectNode views$1, Tuple2 x) {
        String key = (String)x._1();
        View value = (View)x._2();
        ObjectNode viewNode = JacksonTransformers.MAPPER.createObjectNode();
        viewNode.put("map", value.map());
        value.reduce().foreach((Function1 & Serializable)r -> viewNode.put("reduce", r));
        views$1.set(key, (JsonNode)viewNode);
    }

    public static final /* synthetic */ void $anonfun$sendRequest$2(CoreHttpRequest request$2, CoreHttpResponse x$3) {
        request$2.context().logicallyComplete();
    }

    public static final /* synthetic */ void $anonfun$sendRequest$3(CoreHttpRequest request$2, Throwable err) {
        request$2.context().logicallyComplete(err);
    }

    public ReactiveViewIndexManager(CoreCouchbaseOps couchbaseOps, String bucket) {
        this.couchbaseOps = couchbaseOps;
        this.bucket = bucket;
        this.DefaultTimeout = couchbaseOps.environment().timeoutConfig().managementTimeout();
        this.DefaultRetryStrategy = couchbaseOps.environment().retryStrategy();
    }
}

