/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.LegacyTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005a4AAC\u0006\u0001-!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!)\u0011\t\u0001C!\u0005\u001e)\u0011m\u0003E\u0001E\u001a)!b\u0003E\u0001G\")\u0001%\u0002C\u0001Y\"9Q.\u0002b\u0001\n\u0003q\u0007BB8\u0006A\u0003%!\u0005C\u0004q\u000b\u0005\u0005I\u0011B9\u0003!1+w-Y2z)J\fgn]2pI\u0016\u0014(B\u0001\u0007\u000e\u0003\u0015\u0019w\u000eZ3d\u0015\tqq\"A\u0003tG\u0006d\u0017M\u0003\u0002\u0011#\u000511\r\\5f]RT!AE\n\u0002\u0013\r|Wo\u00195cCN,'\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019B\u0004\u0005\u0002\u001955\t\u0011DC\u0001\u000f\u0013\tY\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003;yi\u0011aC\u0005\u0003?-\u0011\u0001\u0004\u0016:b]N\u001cw\u000eZ3s/&$\bnU3sS\u0006d\u0017N_3s\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002\u001e\u0001\u00051QM\\2pI\u0016,\"!J\u001a\u0015\u0007\u0019zC\bE\u0002(U1j\u0011\u0001\u000b\u0006\u0003Se\tA!\u001e;jY&\u00111\u0006\u000b\u0002\u0004)JL\bCA\u000f.\u0013\tq3B\u0001\u0007F]\u000e|G-\u001a3WC2,X\rC\u00031\u0005\u0001\u0007\u0011'A\u0003wC2,X\r\u0005\u00023g1\u0001A!\u0002\u001b\u0003\u0005\u0004)$!\u0001+\u0012\u0005YJ\u0004C\u0001\r8\u0013\tA\u0014DA\u0004O_RD\u0017N\\4\u0011\u0005aQ\u0014BA\u001e\u001a\u0005\r\te.\u001f\u0005\u0006{\t\u0001\rAP\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bcA\u000f@c%\u0011\u0001i\u0003\u0002\u000f\u0015N|gnU3sS\u0006d\u0017N_3s\u0003\u0019!WmY8eKV\u00111i\u0012\u000b\u0005\tBCV\f\u0006\u0002F\u0011B\u0019qE\u000b$\u0011\u0005I:E!\u0002\u001b\u0004\u0005\u0004)\u0004\"B%\u0004\u0001\bQ\u0015a\u0001;bOB\u00191J\u0014$\u000e\u00031S!!T\r\u0002\u000fI,g\r\\3di&\u0011q\n\u0014\u0002\t\u00072\f7o\u001d+bO\")\u0011k\u0001a\u0001%\u0006)\u0011N\u001c9viB\u0019\u0001dU+\n\u0005QK\"!B!se\u0006L\bC\u0001\rW\u0013\t9\u0016D\u0001\u0003CsR,\u0007\"B-\u0004\u0001\u0004Q\u0016!\u00024mC\u001e\u001c\bC\u0001\r\\\u0013\ta\u0016DA\u0002J]RDQ!P\u0002A\u0002y\u00032!H0G\u0013\t\u00017B\u0001\tKg>tG)Z:fe&\fG.\u001b>fe\u0006\u0001B*Z4bGf$&/\u00198tG>$WM\u001d\t\u0003;\u0015\u00192!B\fe!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0002j_*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005\u0011\u0017\u0001C%ogR\fgnY3\u0016\u0003\t\n\u0011\"\u00138ti\u0006t7-\u001a\u0011\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e5\u0002\t1\fgnZ\u0005\u0003oR\u0014aa\u00142kK\u000e$\b")
public class LegacyTranscoder
implements TranscoderWithSerializer {
    public static LegacyTranscoder Instance() {
        return LegacyTranscoder$.MODULE$.Instance();
    }

    public <T> Try<EncodedValue> encode(T value, JsonSerializer<T> serializer) {
        T t = value;
        if (t instanceof byte[]) {
            byte[] byArray = (byte[])t;
            return new Success((Object)new EncodedValue(byArray, CodecFlags.BINARY_COMPAT_FLAGS));
        }
        if (t instanceof String) {
            String string = (String)t;
            return new Success((Object)new EncodedValue(string.getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS));
        }
        return serializer.serialize(value).map((Function1 & Serializable)bytes -> new EncodedValue((byte[])bytes, CodecFlags.JSON_COMPAT_FLAGS));
    }

    public <T> Try<T> decode(byte[] input, int flags, JsonDeserializer<T> serializer, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return new Success((Object)input);
        }
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return new Success((Object)new String(input, StandardCharsets.UTF_8));
        }
        return serializer.deserialize(input);
    }
}

