/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\reg\u0001B#G\u0001=C\u0001\"\u0016\u0001\u0003\u0002\u0013\u0006IA\u0016\u0005\n?\u0002\u0011)\u0019!C\u0001\r\u0002D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\nS\u0002\u0011)\u0019!C\u0001\r*D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001b\u0005\u0006e\u0002!\ta\u001d\u0005\ts\u0002\u0011\r\u0011b\u0001Gu\"9\u00111\u0001\u0001!\u0002\u0013Y\b\u0002\u0003/\u0001\u0005\u0004%\t!!\u0002\t\u000f\u0005\u001d\u0001\u0001)A\u00053\"IQ\r\u0001b\u0001\n\u0003Q\u0015\u0011\u0002\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\f!Q\u0011Q\u0003\u0001C\u0002\u0013\u0005a)a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A!\"!\t\u0001\u0005\u0004%\tARA\u0012\u0011!\t\t\u0004\u0001Q\u0001\n\u0005\u0015\u0002BCA\u001a\u0001\t\u0007I\u0011\u0001$\u0002$!A\u0011Q\u0007\u0001!\u0002\u0013\t)\u0003\u0003\u0006\u00028\u0001\u0011\r\u0011\"\u0001G\u0003sA\u0001\"a\u0012\u0001A\u0003%\u00111\b\u0005\u000b\u0003\u0013\u0002!\u0019!C\u0001\r\u0006-\u0003\u0002CA/\u0001\u0001\u0006I!!\u0014\t\u0015\u0005}\u0003A1A\u0005\u0002\u0019\u000b\t\u0007\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA2\u0011-\tY\u0007\u0001EC\u0002\u0013\u0005a)!\u001c\t\u0017\u0005}\u0004\u0001#b\u0001\n\u00031\u0015\u0011\u0011\u0005\f\u0003\u001f\u0003\u0001R1A\u0005\u0002\u0019\u000b\t\n\u0003\u0006\u0002 \u0002\u0011\r\u0011\"\u0001G\u0003CC\u0001\"!-\u0001A\u0003%\u00111\u0015\u0005\u000b\u0003g\u0003\u0001R1A\u0005\u0002\u0005U\u0006BCA_\u0001!\u0015\r\u0011\"\u0001\u0002@\"Q\u0011q\u0019\u0001\t\u0006\u0004%\t!!3\t\u0015\u0005U\u0007\u0001#b\u0001\n\u0003\t9\u000e\u0003\u0006\u0002f\u0002A)\u0019!C\u0001\u0003OD!\"a<\u0001\u0011\u000b\u0007I\u0011AAy\u0011\u001d\tI\t\u0001C\u0001\u0005+Aq!a\u0016\u0001\t\u0003\u00119\u0004C\u0004\u0002X\u0001!\tA!\u0016\t\u0013\tE\u0004!%A\u0005\u0002\tM\u0004\"\u0003BD\u0001E\u0005I\u0011\u0001BE\u0011%\u0011i\tAI\u0001\n\u0003\u0011y\tC\u0004\u0003\u0014\u0002!\tA!&\t\u000f\tM\u0005\u0001\"\u0001\u0003.\"I!1\u0018\u0001\u0012\u0002\u0013\u0005!Q\u0018\u0005\n\u0005\u0003\u0004\u0011\u0013!C\u0001\u0005\u0013CqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003D\u0002!\tAa=\t\u0013\tm\b!%A\u0005\u0002\t%\u0005b\u0002B\u007f\u0001\u0011\u0005!q \u0005\n\u0007\u0017\u0001\u0011\u0013!C\u0001\u0005\u0013Cqa!\u0004\u0001\t\u0003\u0019y\u0001C\u0005\u0004\"\u0001\t\n\u0011\"\u0001\u0004$!91Q\u0002\u0001\u0005\u0002\r\u001d\u0002bBB\u001b\u0001\u0011\u00051q\u0007\u0005\n\u0007\u0013\u0002\u0011\u0013!C\u0001\u0007\u0017Bqa!\u000e\u0001\t\u0003\u0019y\u0005C\u0004\u0004Z\u0001!\taa\u0017\t\u000f\re\u0003\u0001\"\u0001\u0004`!A11\u000e\u0001\u0005\u0002\u0019\u001bigB\u0004\u0004p\u0019C\ta!\u001d\u0007\r\u00153\u0005\u0012AB:\u0011\u0019\u0011X\b\"\u0001\u0004v!91qO\u001f\u0005\u0002\re\u0004bBB<{\u0011\u00051q\u0012\u0005\b\u0007ojD\u0011ABN\u0011!\u0011\u0019-\u0010C\u0001\u0011\u000e=\u0006\u0002CBe{\u0011\u0005\u0001ja3\t\u0011\r%W\b\"\u0001I\u0007+\u0014A\"Q:z]\u000e\u001cE.^:uKJT!a\u0012%\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005%S\u0015AB2mS\u0016tGO\u0003\u0002L\u0019\u0006I1m\\;dQ\n\f7/\u001a\u0006\u0002\u001b\u0006\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0015\t\u0003#Nk\u0011A\u0015\u0006\u0002\u000f&\u0011AK\u0015\u0002\u0007\u0003:L(+\u001a4\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0004#^K\u0016B\u0001-S\u0005!a$-\u001f8b[\u0016t\u0004C\u0001.^\u001b\u0005Y&B\u0001/G\u0003\r)gN^\u0005\u0003=n\u0013!c\u00117vgR,'/\u00128wSJ|g.\\3oi\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012!\u0019\t\u0003E\u001al\u0011a\u0019\u0006\u00039\u0012T!!\u001a%\u0002\t\r|'/Z\u0005\u0003O\u000e\u0014Q\"Q;uQ\u0016tG/[2bi>\u0014\u0018AD1vi\",g\u000e^5dCR|'\u000fI\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001e,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u0012\fA!\u001e;jY&\u0011\u0001/\u001c\u0002\u0011\u0007>tg.Z2uS>t7\u000b\u001e:j]\u001e\f\u0011cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4!\u0003\u0019a\u0014N\\5u}Q!AO^<y!\t)\b!D\u0001G\u0011\u0019)f\u0001\"a\u0001-\")qL\u0002a\u0001C\")\u0011N\u0002a\u0001W\u0006\u0011QmY\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011aPU\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0001{\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0004K\u000e\u0004S#A-\u0002\t\u0015tg\u000fI\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00105\tA-C\u0002\u0002\u0012\u0011\u0014AaQ8sK\u0006)1m\u001c:fA\u0005\u0011\u0001\u000e]\u000b\u0003\u00033\u00012!^A\u000e\u0013\r\tiB\u0012\u0002\u0013\u0011\u0006tG\r\\3s\u0005\u0006\u001c\u0018n\u0019)be\u0006l7/A\u0002ia\u0002\nQb]3be\u000eDG+[7f_V$XCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016{\u0006AA-\u001e:bi&|g.\u0003\u0003\u00020\u0005%\"\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\u001dM,\u0017M]2i)&lWm\\;uA\u0005\u0001\u0012M\\1msRL7m\u001d+j[\u0016|W\u000f^\u0001\u0012C:\fG.\u001f;jGN$\u0016.\\3pkR\u0004\u0013!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0002<A!\u0011QHA\"\u001b\t\tyDC\u0002\u0002B\u0011\fQA]3uefLA!!\u0012\u0002@\ti!+\u001a;ssN#(/\u0019;fOf\faB]3uef\u001cFO]1uK\u001eL\b%\u0001\tb]\u0006d\u0017\u0010^5dg\"\u000bg\u000e\u001a7feV\u0011\u0011Q\n\t\u0005\u0003\u001f\nI&\u0004\u0002\u0002R)!\u00111KA+\u0003!A\u0017M\u001c3mKJ\u001c(bAA,\r\u0006)\u0011/^3ss&!\u00111LA)\u0005A\te.\u00197zi&\u001c7\u000fS1oI2,'/A\tb]\u0006d\u0017\u0010^5dg\"\u000bg\u000e\u001a7fe\u0002\nQb]3be\u000eD\u0007*\u00198eY\u0016\u0014XCAA2!\u0011\ty%!\u001a\n\t\u0005\u001d\u0014\u0011\u000b\u0002\u000e'\u0016\f'o\u00195IC:$G.\u001a:\u0002\u001dM,\u0017M]2i\u0011\u0006tG\r\\3sA\u0005\u0019\"/Z1di&4X-V:fe6\u000bg.Y4feV\u0011\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003\u0011)8/\u001a:\u000b\u0007\u0005ed)A\u0004nC:\fw-\u001a:\n\t\u0005u\u00141\u000f\u0002\u0014%\u0016\f7\r^5wKV\u001bXM]'b]\u0006<WM]\u0001\u0016e\u0016\f7\r^5wK\n+8m[3u\u001b\u0006t\u0017mZ3s+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\u0011\tI)a\u001e\u0002\r\t,8m[3u\u0013\u0011\ti)a\"\u0003+I+\u0017m\u0019;jm\u0016\u0014UoY6fi6\u000bg.Y4fe\u0006i\"/Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/\u0006\u0002\u0002\u0014B!\u0011QSAN\u001b\t\t9J\u0003\u0003\u0002\u001a\u0006]\u0014!C1oC2LH/[2t\u0013\u0011\ti*a&\u0003;I+\u0017m\u0019;jm\u0016\fe.\u00197zi&\u001c7/\u00138eKbl\u0015M\\1hKJ\f\u0001\"];fef|\u0005o]\u000b\u0003\u0003G\u0003B!!*\u0002.6\u0011\u0011q\u0015\u0006\u0005\u0003/\nIKC\u0002\u0002,\u0012\f1!\u00199j\u0013\u0011\ty+a*\u0003\u0019\r{'/Z)vKJLx\n]:\u0002\u0013E,XM]=PaN\u0004\u0013a\u00022vG.,Go]\u000b\u0003\u0003o\u0003B!!\"\u0002:&!\u00111XAD\u0005I\t5/\u001f8d\u0005V\u001c7.\u001a;NC:\fw-\u001a:\u0002\u000bU\u001cXM]:\u0016\u0005\u0005\u0005\u0007\u0003BA9\u0003\u0007LA!!2\u0002t\t\u0001\u0012i]=oGV\u001bXM]'b]\u0006<WM]\u0001\rcV,'/_%oI\u0016DXm]\u000b\u0003\u0003\u0017\u0004B!!4\u0002R6\u0011\u0011q\u001a\u0006\u0005\u0003/\n9(\u0003\u0003\u0002T\u0006='AF!ts:\u001c\u0017+^3ss&sG-\u001a=NC:\fw-\u001a:\u0002\u001bM,\u0017M]2i\u0013:$W\r_3t+\t\tI\u000e\u0005\u0003\u0002\\\u0006\u0005XBAAo\u0015\u0011\ty.a\u001e\u0002\rM,\u0017M]2i\u0013\u0011\t\u0019/!8\u0003/\u0005\u001b\u0018P\\2TK\u0006\u00148\r[%oI\u0016DX*\u00198bO\u0016\u0014\u0018\u0001E1oC2LH/[2t\u0013:$W\r_3t+\t\tI\u000f\u0005\u0003\u0002\u0016\u0006-\u0018\u0002BAw\u0003/\u0013!$Q:z]\u000e\fe.\u00197zi&\u001c7/\u00138eKbl\u0015M\\1hKJ\f\u0011#\u001a<f]RLgn\u001a$v]\u000e$\u0018n\u001c8t+\t\t\u0019\u0010\u0005\u0003\u0002v\u0006mXBAA|\u0015\u0011\tI0a\u001e\u0002\u0011\u00154XM\u001c;j]\u001eLA!!@\u0002x\na\u0012i]=oG\u00163XM\u001c;j]\u001e4UO\\2uS>tW*\u00198bO\u0016\u0014\bfA\u0012\u0003\u0002A!!1\u0001B\b\u001d\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u0005I\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5!qA\u0001\n'R\f'-\u001b7jifLAA!\u0005\u0003\u0014\tYQK\\2p[6LG\u000f^3e\u0015\u0011\u0011iAa\u0002\u0015\t\t]!Q\u0004\t\u0004k\ne\u0011b\u0001B\u000e\r\nY\u0011i]=oG\n+8m[3u\u0011\u001d\u0011y\u0002\na\u0001\u0005C\t!BY;dW\u0016$h*Y7f!\u0011\u0011\u0019C!\r\u000f\t\t\u0015\"Q\u0006\t\u0004\u0005O\u0011VB\u0001B\u0015\u0015\r\u0011YCT\u0001\u0007yI|w\u000e\u001e \n\u0007\t=\"+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005g\u0011)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005_\u0011FC\u0002B\u001d\u0005\u000f\u0012Y\u0005E\u0003}\u0005w\u0011y$C\u0002\u0003>u\u0014aAR;ukJ,\u0007\u0003\u0002B!\u0005\u0007j!!!\u0016\n\t\t\u0015\u0013Q\u000b\u0002\f#V,'/\u001f*fgVdG\u000fC\u0004\u0003J\u0015\u0002\rA!\t\u0002\u0013M$\u0018\r^3nK:$\bb\u0002B'K\u0001\u0007!qJ\u0001\b_B$\u0018n\u001c8t!\u0011\u0011\tE!\u0015\n\t\tM\u0013Q\u000b\u0002\r#V,'/_(qi&|gn\u001d\u000b\u000b\u0005s\u00119F!\u0017\u0003d\t\u001d\u0004b\u0002B%M\u0001\u0007!\u0011\u0005\u0005\n\u000572\u0003\u0013!a\u0001\u0005;\n!\u0002]1sC6,G/\u001a:t!\u0011\u0011\tEa\u0018\n\t\t\u0005\u0014Q\u000b\u0002\u0010#V,'/\u001f)be\u0006lW\r^3sg\"I!Q\r\u0014\u0011\u0002\u0003\u0007\u0011QE\u0001\bi&lWm\\;u\u0011%\u0011IG\nI\u0001\u0002\u0004\u0011Y'A\u0003bI\"|7\rE\u0002R\u0005[J1Aa\u001cS\u0005\u001d\u0011un\u001c7fC:\fq\"];fef$C-\u001a4bk2$HEM\u000b\u0003\u0005kRCA!\u0018\u0003x-\u0012!\u0011\u0010\t\u0005\u0005w\u0012\u0019)\u0004\u0002\u0003~)!!q\u0010BA\u0003%)hn\u00195fG.,GMC\u0002\u0003\nIKAA!\"\u0003~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001fE,XM]=%I\u00164\u0017-\u001e7uIM*\"Aa#+\t\u0005\u0015\"qO\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0013\u0016\u0005\u0005W\u00129(\u0001\bb]\u0006d\u0017\u0010^5dgF+XM]=\u0015\r\t]%1\u0015BS!\u0015a(1\bBM!\u0011\u0011YJa(\u000e\u0005\tu%bAAM\r&!!\u0011\u0015BO\u0005=\te.\u00197zi&\u001c7OU3tk2$\bb\u0002B%U\u0001\u0007!\u0011\u0005\u0005\b\u0005\u001bR\u0003\u0019\u0001BT!\u0011\u0011YJ!+\n\t\t-&Q\u0014\u0002\u0011\u0003:\fG.\u001f;jGN|\u0005\u000f^5p]N$\u0002Ba&\u00030\nE&\u0011\u0018\u0005\b\u0005\u0013Z\u0003\u0019\u0001B\u0011\u0011%\u0011Yf\u000bI\u0001\u0002\u0004\u0011\u0019\f\u0005\u0003\u0003\u001c\nU\u0016\u0002\u0002B\\\u0005;\u00131#\u00118bYf$\u0018nY:QCJ\fW.\u001a;feND\u0011B!\u001a,!\u0003\u0005\r!!\n\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003@*\"!1\u0017B<\u0003a\tg.\u00197zi&\u001c7/U;fef$C-\u001a4bk2$HeM\u0001\fg\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\u0006\u0005\u0003H\n]'1\u001cBu!\u0015a(1\bBe!\u0011\u0011YMa5\u000e\u0005\t5'\u0002\u0002Bh\u0005#\faA]3tk2$(bAAp\r&!!Q\u001bBg\u00051\u0019V-\u0019:dQJ+7/\u001e7u\u0011\u001d\u0011IN\fa\u0001\u0005C\t\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005]c\u00061\u0001\u0003^B!!q\u001cBs\u001b\t\u0011\tO\u0003\u0003\u0003d\nE\u0017aB9vKJLWm]\u0005\u0005\u0005O\u0014\tOA\u0006TK\u0006\u00148\r[)vKJL\bb\u0002B']\u0001\u0007!1\u001e\t\u0005\u0005[\u0014y/\u0004\u0002\u0003R&!!\u0011\u001fBi\u00055\u0019V-\u0019:dQ>\u0003H/[8ogRA!q\u0019B{\u0005o\u0014I\u0010C\u0004\u0003Z>\u0002\rA!\t\t\u000f\u0005]s\u00061\u0001\u0003^\"I!QM\u0018\u0011\u0002\u0003\u0007\u0011QE\u0001\u0016g\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0005\u0007\u0003\u0019I\u0001E\u0003}\u0005w\u0019\u0019\u0001E\u0002R\u0007\u000bI1aa\u0002S\u0005\u0011)f.\u001b;\t\u0013\t\u0015\u0014\u0007%AA\u0002\u0005\u0015\u0012\u0001\u00063jg\u000e|gN\\3di\u0012\"WMZ1vYR$\u0013'A\u0006eS\u0006<gn\\:uS\u000e\u001cH\u0003BB\t\u0007;\u0001R\u0001 B\u001e\u0007'\u0001Ba!\u0006\u0004\u001a5\u00111q\u0003\u0006\u0004\u0007\u001b!\u0017\u0002BB\u000e\u0007/\u0011\u0011\u0003R5bO:|7\u000f^5dgJ+7/\u001e7u\u0011%\u0019yb\rI\u0001\u0002\u0004\u0011\t#\u0001\u0005sKB|'\u000f^%e\u0003U!\u0017.Y4o_N$\u0018nY:%I\u00164\u0017-\u001e7uIE*\"a!\n+\t\t\u0005\"q\u000f\u000b\u0005\u0007#\u0019I\u0003C\u0004\u0003NU\u0002\raa\u000b\u0011\t\r52\u0011G\u0007\u0003\u0007_Q1a!\u0004G\u0013\u0011\u0019\u0019da\f\u0003%\u0011K\u0017m\u001a8pgRL7m](qi&|gn]\u0001\u0005a&tw\r\u0006\u0003\u0004:\r\u0005\u0003#\u0002?\u0003<\rm\u0002\u0003BB\u000b\u0007{IAaa\u0010\u0004\u0018\tQ\u0001+\u001b8h%\u0016\u001cX\u000f\u001c;\t\u0013\t\u0015d\u0007%AA\u0002\r\r\u0003#B)\u0004F\u0005\u0015\u0012bAB$%\n1q\n\u001d;j_:\fa\u0002]5oO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004N)\"11\tB<)\u0011\u0019Id!\u0015\t\u000f\t5\u0003\b1\u0001\u0004TA!1QFB+\u0013\u0011\u00199fa\f\u0003\u0017AKgnZ(qi&|gn]\u0001\u000fo\u0006LG/\u00168uS2\u0014V-\u00193z)\u0011\u0019\ta!\u0018\t\u000f\t\u0015\u0014\b1\u0001\u0002&Q11\u0011AB1\u0007GBqA!\u001a;\u0001\u0004\t)\u0003C\u0004\u0003Ni\u0002\ra!\u001a\u0011\t\r52qM\u0005\u0005\u0007S\u001ayCA\u000bXC&$XK\u001c;jYJ+\u0017\rZ=PaRLwN\\:\u0002)A,'OZ8s[\u001ecwNY1m\u0007>tg.Z2u)\t\u0019\u0019!\u0001\u0007Bgft7m\u00117vgR,'\u000f\u0005\u0002v{M\u0011Q\b\u0015\u000b\u0003\u0007c\nqaY8o]\u0016\u001cG\u000f\u0006\u0005\u0004|\r\u00155qQBF!\u0015\u0019ih!!u\u001b\t\u0019yH\u0003\u0002o%&!11QB@\u0005\r!&/\u001f\u0005\u0007S~\u0002\rA!\t\t\u000f\r%u\b1\u0001\u0003\"\u0005AQo]3s]\u0006lW\rC\u0004\u0004\u000e~\u0002\rA!\t\u0002\u0011A\f7o]<pe\u0012$baa\u001f\u0004\u0012\u000eM\u0005BB5A\u0001\u0004\u0011\t\u0003C\u0004\u0003N\u0001\u0003\ra!&\u0011\u0007U\u001c9*C\u0002\u0004\u001a\u001a\u0013ab\u00117vgR,'o\u00149uS>t7\u000f\u0006\u0004\u0004|\ru5Q\u0016\u0005\b\u0007?\u000b\u0005\u0019ABQ\u0003%\u0019X-\u001a3O_\u0012,7\u000f\u0005\u0004\u0003$\r\r6qU\u0005\u0005\u0007K\u0013)DA\u0002TKR\u00042AWBU\u0013\r\u0019Yk\u0017\u0002\t'\u0016,GMT8eK\"9!QJ!A\u0002\rUECBBY\u0007k\u001b9\r\u0006\u0003\u0003H\u000eM\u0006\"B=C\u0001\bY\bbBB\\\u0005\u0002\u00071\u0011X\u0001\be\u0016\fX/Z:u!\u0011\u0019Yla1\u000e\u0005\ru&\u0002BAp\u0007\u007fS1a!1e\u0003\ri7oZ\u0005\u0005\u0007\u000b\u001ciLA\u0007TK\u0006\u00148\r\u001b*fcV,7\u000f\u001e\u0005\u0007K\n\u0003\r!a\u0003\u00023\u0015DHO]1di\u000ecWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0007\u0007\u001b\u001cym!5\u0011\u000b\ru4\u0011Q-\t\r%\u001c\u0005\u0019\u0001B\u0011\u0011\u001d\u0019\u0019n\u0011a\u0001\u0007+\u000bAa\u001c9ugR!1QZBl\u0011\u001d\u0019\u0019\u000e\u0012a\u0001\u0007+\u0003")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final ConnectionString connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final CoreQueryOps queryOps;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(seedNodes, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(connectionString, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return AsyncCluster$.MODULE$.connect(connectionString, username, password);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public ConnectionString connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveUserManager$lzycompute();
        }
        return this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, options.toCore(), null, null, null), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters).toCore(), null, null, null), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            return this.analyticsHandler().queryAsync(request, this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            return AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> this.env().retryStrategy())), (Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.core().waitUntilReady(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava(), DurationConversions$.MODULE$.scalaDurationToJava(timeout), options.desiredState(), null)).map((Function1 & Serializable)x$1 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$1) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, ConnectionString connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (ConnectionString)connectionString);
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.queryOps = this.core().queryOps();
    }
}

