/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.search.SearchChunkRow;
import com.couchbase.client.core.msg.search.SearchChunkTrailer;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.msg.search.SearchResponse;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.ConnectionStringUtil;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.ClusterOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.ClusterEnvironment$Builder$;
import com.couchbase.client.scala.env.PasswordAuthenticator;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.query.handlers.SearchHandler$;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.result.SearchRow;
import com.couchbase.client.scala.search.result.SearchRow$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Collection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.jdk.CollectionConverters$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class AsyncCluster$ {
    public static final AsyncCluster$ MODULE$ = new AsyncCluster$();

    public Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return this.connect(connectionString, new ClusterOptions(new PasswordAuthenticator(username, password), ClusterOptions$.MODULE$.apply$default$2()));
    }

    public Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return this.extractClusterEnvironment(connectionString, options).map((Function1 & Serializable)ce -> {
            ConnectionString connStr = ConnectionString.create((String)connectionString);
            AsyncCluster cluster = new AsyncCluster((Function0<ClusterEnvironment>)(Function0 & Serializable)() -> ce, options.authenticator(), connStr);
            cluster.performGlobalConnect();
            return cluster;
        });
    }

    public Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return this.connect(ConnectionStringUtil.asConnectionString((Collection)CollectionConverters$.MODULE$.SetHasAsJava((Set)seedNodes.map((Function1 & Serializable)x$2 -> x$2.toCore())).asJava()).original(), options);
    }

    public Future<SearchResult> searchQuery(SearchRequest request, Core core, ExecutionContext ec) {
        core.send((Request)request);
        Future ret = FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).flatMap((Function1 & Serializable)response -> FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows()).map((Function1 & Serializable)row -> SearchRow$.MODULE$.fromResponse((SearchChunkRow)row)).collectSeq().flatMap((Function1 & Serializable)rows -> FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable)trailer -> new SearchResult((Seq<SearchRow>)rows, SearchHandler$.MODULE$.parseSearchFacets((SearchChunkTrailer)trailer), SearchHandler$.MODULE$.parseSearchMeta((SearchResponse)response, (SearchChunkTrailer)trailer))))).toFuture();
        ret.onComplete((Function1 & Serializable)x0$1 -> {
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                return request.context().logicallyComplete();
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return request.context().logicallyComplete(err);
            }
            throw new MatchError((Object)try_);
        }, ec);
        return ret;
    }

    public Try<ClusterEnvironment> extractClusterEnvironment(String connectionString, ClusterOptions opts) {
        Try<ClusterEnvironment> result;
        Try<ClusterEnvironment> try_;
        Option<ClusterEnvironment> option = opts.environment();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterEnvironment env = (ClusterEnvironment)some.value();
            try_ = new Try<ClusterEnvironment>((Object)env);
        } else {
            try_ = result = new ClusterEnvironment.Builder(true, ClusterEnvironment$Builder$.MODULE$.apply$default$2(), ClusterEnvironment$Builder$.MODULE$.apply$default$3(), ClusterEnvironment$Builder$.MODULE$.apply$default$4(), ClusterEnvironment$Builder$.MODULE$.apply$default$5(), ClusterEnvironment$Builder$.MODULE$.apply$default$6(), ClusterEnvironment$Builder$.MODULE$.apply$default$7(), ClusterEnvironment$Builder$.MODULE$.apply$default$8(), ClusterEnvironment$Builder$.MODULE$.apply$default$9(), ClusterEnvironment$Builder$.MODULE$.apply$default$10(), ClusterEnvironment$Builder$.MODULE$.apply$default$11(), ClusterEnvironment$Builder$.MODULE$.apply$default$12(), ClusterEnvironment$Builder$.MODULE$.apply$default$13(), ClusterEnvironment$Builder$.MODULE$.apply$default$14(), ClusterEnvironment$Builder$.MODULE$.apply$default$15(), ClusterEnvironment$Builder$.MODULE$.apply$default$16(), ClusterEnvironment$Builder$.MODULE$.apply$default$17(), ClusterEnvironment$Builder$.MODULE$.apply$default$18(), ClusterEnvironment$Builder$.MODULE$.apply$default$19(), ClusterEnvironment$Builder$.MODULE$.apply$default$20()).connectionString(connectionString).build();
        }
        if (result.isFailure()) {
            return result;
        }
        return Try$.MODULE$.apply(() -> AsyncCluster$.$anonfun$extractClusterEnvironment$1((Try)result, connectionString));
    }

    public Try<ClusterEnvironment> extractClusterEnvironment(ClusterOptions opts) {
        Option<ClusterEnvironment> option = opts.environment();
        if (option instanceof Some) {
            Some some = (Some)option;
            ClusterEnvironment env = (ClusterEnvironment)some.value();
            return new Success((Object)env);
        }
        return new ClusterEnvironment.Builder(true, ClusterEnvironment$Builder$.MODULE$.apply$default$2(), ClusterEnvironment$Builder$.MODULE$.apply$default$3(), ClusterEnvironment$Builder$.MODULE$.apply$default$4(), ClusterEnvironment$Builder$.MODULE$.apply$default$5(), ClusterEnvironment$Builder$.MODULE$.apply$default$6(), ClusterEnvironment$Builder$.MODULE$.apply$default$7(), ClusterEnvironment$Builder$.MODULE$.apply$default$8(), ClusterEnvironment$Builder$.MODULE$.apply$default$9(), ClusterEnvironment$Builder$.MODULE$.apply$default$10(), ClusterEnvironment$Builder$.MODULE$.apply$default$11(), ClusterEnvironment$Builder$.MODULE$.apply$default$12(), ClusterEnvironment$Builder$.MODULE$.apply$default$13(), ClusterEnvironment$Builder$.MODULE$.apply$default$14(), ClusterEnvironment$Builder$.MODULE$.apply$default$15(), ClusterEnvironment$Builder$.MODULE$.apply$default$16(), ClusterEnvironment$Builder$.MODULE$.apply$default$17(), ClusterEnvironment$Builder$.MODULE$.apply$default$18(), ClusterEnvironment$Builder$.MODULE$.apply$default$19(), ClusterEnvironment$Builder$.MODULE$.apply$default$20()).build();
    }

    public static final /* synthetic */ ClusterEnvironment $anonfun$extractClusterEnvironment$1(Try result$1, String connectionString$2) {
        ClusterEnvironment env = (ClusterEnvironment)result$1.get();
        ConnectionStringUtil.checkConnectionString((CoreEnvironment)env.core(), (boolean)env.owned(), (ConnectionString)ConnectionString.create((String)connectionString$2));
        return env;
    }

    private AsyncCluster$() {
    }
}

