/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerRequest;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.user.AuthDomain;
import com.couchbase.client.scala.manager.user.AuthDomain$Local$;
import com.couchbase.client.scala.manager.user.Group;
import com.couchbase.client.scala.manager.user.Group$;
import com.couchbase.client.scala.manager.user.ReactiveUserManager$;
import com.couchbase.client.scala.manager.user.RoleAndDescription;
import com.couchbase.client.scala.manager.user.RoleAndDescription$;
import com.couchbase.client.scala.manager.user.User;
import com.couchbase.client.scala.manager.user.UserAndMetadata;
import com.couchbase.client.scala.manager.user.UserAndMetadata$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0005\t%x!\u0002\u001d:\u0011\u00031e!\u0002%:\u0011\u0003I\u0005\"B(\u0002\t\u0003\u0001\u0006\"B)\u0002\t\u0003\u0011f\u0001\u0002%:\u0001mC\u0001\u0002\u0018\u0003\u0003\u0006\u0004%I!\u0018\u0005\tG\u0012\u0011\t\u0011)A\u0005=\")q\n\u0002C\u0001I\"Aq\r\u0002b\u0001\n\u0003i\u0004\u000e\u0003\u0004r\t\u0001\u0006I!\u001b\u0005\te\u0012\u0011\r\u0011\"\u0001>g\"1!\u0010\u0002Q\u0001\nQDQa\u001f\u0003\u0005\nqDa!a\u0002\u0005\t\u0013a\bbBA\u0005\t\u0011%\u00111\u0002\u0005\u0007\u0003_!A\u0011\u0002?\t\u000f\u0005EB\u0001\"\u0003\u00024!1\u0011\u0011\b\u0003\u0005\nqDq!a\u000f\u0005\t\u0013\ti\u0004C\u0004\u0002<\u0011!I!a\u001b\t\u000f\u0005mB\u0001\"\u0003\u0002,\"9\u0011Q\u0019\u0003\u0005\u0012\u0005\u001d\u0007bBAq\t\u0011\u0005\u00111\u001d\u0005\n\u0003k$\u0011\u0013!C\u0001\u0003oD\u0011B!\u0004\u0005#\u0003%\tAa\u0004\t\u0013\tMA!%A\u0005\u0002\tU\u0001b\u0002B\r\t\u0011\u0005!1\u0004\u0005\n\u0005S!\u0011\u0013!C\u0001\u0003oD\u0011Ba\u000b\u0005#\u0003%\tAa\u0004\t\u0013\t5B!%A\u0005\u0002\tU\u0001b\u0002B\u0018\t\u0011\u0005!\u0011\u0007\u0005\n\u0005\u0007\"\u0011\u0013!C\u0001\u0003oD\u0011B!\u0012\u0005#\u0003%\tAa\u0004\t\u0013\t\u001dC!%A\u0005\u0002\tU\u0001b\u0002B%\t\u0011\u0005!1\n\u0005\n\u0005+\"\u0011\u0013!C\u0001\u0003oD\u0011Ba\u0016\u0005#\u0003%\tAa\u0004\t\u0013\teC!%A\u0005\u0002\tU\u0001b\u0002B.\t\u0011\u0005!Q\f\u0005\n\u0005O\"\u0011\u0013!C\u0001\u0005\u001fA\u0011B!\u001b\u0005#\u0003%\tA!\u0006\t\u000f\t-D\u0001\"\u0001\u0003n!I!1\u0010\u0003\u0012\u0002\u0013\u0005!q\u0002\u0005\n\u0005{\"\u0011\u0013!C\u0001\u0005+AqAa \u0005\t\u0003\u0011\t\tC\u0005\u0003\u0014\u0012\t\n\u0011\"\u0001\u0003\u0010!I!Q\u0013\u0003\u0012\u0002\u0013\u0005!Q\u0003\u0005\b\u0005/#A\u0011\u0001BM\u0011%\u0011\t\u000bBI\u0001\n\u0003\u0011y\u0001C\u0005\u0003$\u0012\t\n\u0011\"\u0001\u0003\u0016!9!Q\u0015\u0003\u0005\u0002\t\u001d\u0006\"\u0003BY\tE\u0005I\u0011\u0001B\b\u0011%\u0011\u0019\fBI\u0001\n\u0003\u0011)\u0002C\u0004\u00036\u0012!\tAa.\t\u0013\t}F!%A\u0005\u0002\t=\u0001\"\u0003Ba\tE\u0005I\u0011\u0001B\u000b\u0003M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0015\tQ4(\u0001\u0003vg\u0016\u0014(B\u0001\u001f>\u0003\u001di\u0017M\\1hKJT!AP \u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u0001\u000b\u0015AB2mS\u0016tGO\u0003\u0002C\u0007\u0006I1m\\;dQ\n\f7/\u001a\u0006\u0002\t\u0006\u00191m\\7\u0004\u0001A\u0011q)A\u0007\u0002s\t\u0019\"+Z1di&4X-V:fe6\u000bg.Y4feN\u0011\u0011A\u0013\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0002}%\u0011a\n\u0014\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0015\u0001D2p]Z,'\u000f\u001e*pY\u0016\u001cHCA*Z!\rYEKV\u0005\u0003+2\u0013Q!\u0011:sCf\u0004\"aS,\n\u0005ac%\u0001\u0002\"zi\u0016DQAW\u0002A\u0002M\u000b!!\u001b8\u0014\u0005\u0011Q\u0015\u0001B2pe\u0016,\u0012A\u0018\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u00039~J!A\u00191\u0003\t\r{'/Z\u0001\u0006G>\u0014X\r\t\u000b\u0003K\u001a\u0004\"a\u0012\u0003\t\u000bq;\u0001\u0019\u00010\u0002+\u0011,g-Y;mi6\u000bg.Y4feRKW.Z8viV\t\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!A/[7f\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\u0011\u0011+(/\u0019;j_:\fa\u0003Z3gCVdG/T1oC\u001e,'\u000fV5nK>,H\u000fI\u0001\u0015I\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e1\u0002\u000bI,GO]=\n\u0005e4(!\u0004*fiJL8\u000b\u001e:bi\u0016<\u00170A\u000beK\u001a\fW\u000f\u001c;SKR\u0014\u0018p\u0015;sCR,w-\u001f\u0011\u0002\u0019A\fG\u000f\u001b$peV\u001bXM]:\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001[\u0006!A.\u00198h\u0013\r\t)a \u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\fG\u000f\u001b$peJ{G.Z:\u0002\u0017A\fG\u000f\u001b$peV\u001bXM\u001d\u000b\u0006{\u00065\u0011q\u0003\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0003\u0019!w.\\1j]B\u0019q)a\u0005\n\u0007\u0005U\u0011H\u0001\u0006BkRDGi\\7bS:Dq!!\u0007\u000f\u0001\u0004\tY\"\u0001\u0005vg\u0016\u0014h.Y7f!\u0011\ti\"a\u000b\u000f\t\u0005}\u0011q\u0005\t\u0004\u0003CaUBAA\u0012\u0015\r\t)#R\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%B*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000b\tiCC\u0002\u0002*1\u000bQ\u0002]1uQ\u001a{'o\u0012:pkB\u001c\u0018\u0001\u00049bi\"4uN]$s_V\u0004HcA?\u00026!9\u0011q\u0007\tA\u0002\u0005m\u0011\u0001\u00028b[\u0016\fq\u0002]1uQ\u001a{'\u000fU1tg^|'\u000fZ\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0002@\u0005\u0005\u0004CBA!\u0003\u001f\n\u0019&\u0004\u0002\u0002D)!\u0011QIA$\u0003%\u0001XO\u00197jg\",'OC\u0002?\u0003\u0013R1\u0001XA&\u0015\t\ti%A\u0004sK\u0006\u001cGo\u001c:\n\t\u0005E\u00131\t\u0002\u0006'6{gn\u001c\t\u0005\u0003+\ni&\u0004\u0002\u0002X)\u0019A(!\u0017\u000b\u0007\u0005m\u0003-A\u0002ng\u001eLA!a\u0018\u0002X\t1r)\u001a8fe&\u001cW*\u00198bO\u0016\u0014(+Z:q_:\u001cX\rC\u0004\u0002dI\u0001\r!!\u001a\u0002\u000fI,\u0017/^3tiB!\u0011QKA4\u0013\u0011\tI'a\u0016\u0003+\u001d+g.\u001a:jG6\u000bg.Y4feJ+\u0017/^3tiRQ\u0011qHA7\u0003#\u000b)*a*\t\u000f\u0005=4\u00031\u0001\u0002r\u00051Q.\u001a;i_\u0012\u0004B!a\u001d\u0002\u000e6\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0003iiR\u0004(\u0002BA>\u0003{\nQaY8eK\u000eTA!a \u0002\u0002\u00069\u0001.\u00198eY\u0016\u0014(\u0002BAB\u0003\u000b\u000bQA\\3uifTA!a\"\u0002\n\u0006\u0011\u0011n\u001c\u0006\u0004\u0003\u0017\u0003\u0017\u0001\u00023faNLA!a$\u0002v\tQ\u0001\n\u001e;q\u001b\u0016$\bn\u001c3\t\u000f\u0005M5\u00031\u0001\u0002\u001c\u0005!\u0001/\u0019;i\u0011\u001d\t9j\u0005a\u0001\u00033\u000bq\u0001^5nK>,H\u000f\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u0011\u0011,(/\u0019;j_:T1!a)M\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0004a\u0006u\u0005BBAU'\u0001\u0007A/A\u0007sKR\u0014\u0018p\u0015;sCR,w-\u001f\u000b\r\u0003\u007f\ti+a,\u00022\u0006\u0005\u00171\u0019\u0005\b\u0003_\"\u0002\u0019AA9\u0011\u001d\t\u0019\n\u0006a\u0001\u00037Aq!a-\u0015\u0001\u0004\t),\u0001\u0003c_\u0012L\b\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m\u0006-\u0001\u0003vi&d\u0017\u0002BA`\u0003s\u0013Q#\u0016:m#V,'/_*ue&twMQ;jY\u0012,'\u000fC\u0004\u0002\u0018R\u0001\r!!'\t\r\u0005%F\u00031\u0001u\u0003-\u0019\u0007.Z2l'R\fG/^:\u0015\r\u0005%\u0017\u0011\\Ao!\u0019\tY-a4\u0002T6\u0011\u0011Q\u001a\u0006\u0004\u0003wc\u0015\u0002BAi\u0003\u001b\u00141\u0001\u0016:z!\rY\u0015Q[\u0005\u0004\u0003/d%\u0001B+oSRDq!a7\u0016\u0001\u0004\t\u0019&\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\ty.\u0006a\u0001\u00037\ta!Y2uS>t\u0017aB4fiV\u001bXM\u001d\u000b\u000b\u0003K\fi/a<\u0002r\u0006M\bCBA!\u0003\u001f\n9\u000fE\u0002H\u0003SL1!a;:\u0005=)6/\u001a:B]\u0012lU\r^1eCR\f\u0007bBA\r-\u0001\u0007\u00111\u0004\u0005\n\u0003\u001f1\u0002\u0013!a\u0001\u0003#A\u0011\"a&\u0017!\u0003\u0005\r!!'\t\u0011\u0005%f\u0003%AA\u0002Q\f\u0011cZ3u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIP\u000b\u0003\u0002\u0012\u0005m8FAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dA*\u0001\u0006b]:|G/\u0019;j_:LAAa\u0003\u0003\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#\u001d,G/V:fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0012)\"\u0011\u0011TA~\u0003E9W\r^+tKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005/Q3\u0001^A~\u0003-9W\r^!mYV\u001bXM]:\u0015\u0011\tu!1\u0005B\u0013\u0005O\u0001b!!\u0011\u0003 \u0005\u001d\u0018\u0002\u0002B\u0011\u0003\u0007\u0012Qa\u0015$mkbD\u0011\"a\u0004\u001b!\u0003\u0005\r!!\u0005\t\u0013\u0005]%\u0004%AA\u0002\u0005e\u0005\u0002CAU5A\u0005\t\u0019\u0001;\u0002+\u001d,G/\u00117m+N,'o\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005)r-\u001a;BY2,6/\u001a:tI\u0011,g-Y;mi\u0012\u0012\u0014!F4fi\u0006cG.V:feN$C-\u001a4bk2$HeM\u0001\u000bkB\u001cXM\u001d;Vg\u0016\u0014HC\u0003B\u001a\u0005k\u0011iDa\u0010\u0003BA1\u0011\u0011IA(\u0003'DaA\u000f\u0010A\u0002\t]\u0002cA$\u0003:%\u0019!1H\u001d\u0003\tU\u001bXM\u001d\u0005\n\u0003\u001fq\u0002\u0013!a\u0001\u0003#A\u0011\"a&\u001f!\u0003\u0005\r!!'\t\u0011\u0005%f\u0004%AA\u0002Q\fA#\u001e9tKJ$Xk]3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001F;qg\u0016\u0014H/V:fe\u0012\"WMZ1vYR$3'\u0001\u000bvaN,'\u000f^+tKJ$C-\u001a4bk2$H\u0005N\u0001\tIJ|\u0007/V:feRQ!1\u0007B'\u0005\u001f\u0012\tFa\u0015\t\u000f\u0005e!\u00051\u0001\u0002\u001c!I\u0011q\u0002\u0012\u0011\u0002\u0003\u0007\u0011\u0011\u0003\u0005\n\u0003/\u0013\u0003\u0013!a\u0001\u00033C\u0001\"!+#!\u0003\u0005\r\u0001^\u0001\u0013IJ|\u0007/V:fe\u0012\"WMZ1vYR$#'\u0001\nee>\u0004Xk]3sI\u0011,g-Y;mi\u0012\u001a\u0014A\u00053s_B,6/\u001a:%I\u00164\u0017-\u001e7uIQ\nab\u00195b]\u001e,\u0007+Y:to>\u0014H\r\u0006\u0005\u00034\t}#1\rB3\u0011\u001d\u0011\tG\na\u0001\u00037\t1B\\3x!\u0006\u001c8o^8sI\"I\u0011q\u0013\u0014\u0011\u0002\u0003\u0007\u0011\u0011\u0014\u0005\t\u0003S3\u0003\u0013!a\u0001i\u0006A2\r[1oO\u0016\u0004\u0016m]:x_J$G\u0005Z3gCVdG\u000f\n\u001a\u00021\rD\u0017M\\4f!\u0006\u001c8o^8sI\u0012\"WMZ1vYR$3'\u0001\bbm\u0006LG.\u00192mKJ{G.Z:\u0015\r\t=$q\u000fB=!\u0019\t\tEa\b\u0003rA\u0019qIa\u001d\n\u0007\tU\u0014H\u0001\nS_2,\u0017I\u001c3EKN\u001c'/\u001b9uS>t\u0007\"CALSA\u0005\t\u0019AAM\u0011!\tI+\u000bI\u0001\u0002\u0004!\u0018\u0001G1wC&d\u0017M\u00197f%>dWm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005A\u0012M^1jY\u0006\u0014G.\u001a*pY\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0011\u001d,Go\u0012:pkB$\u0002Ba!\u0003\f\n=%\u0011\u0013\t\u0007\u0003\u0003\nyE!\"\u0011\u0007\u001d\u00139)C\u0002\u0003\nf\u0012Qa\u0012:pkBDqA!$-\u0001\u0004\tY\"A\u0005he>,\bOT1nK\"I\u0011q\u0013\u0017\u0011\u0002\u0003\u0007\u0011\u0011\u0014\u0005\t\u0003Sc\u0003\u0013!a\u0001i\u0006\u0011r-\u001a;He>,\b\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003I9W\r^$s_V\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019\u001d,G/\u00117m\u000fJ|W\u000f]:\u0015\r\tm%Q\u0014BP!\u0019\t\tEa\b\u0003\u0006\"I\u0011qS\u0018\u0011\u0002\u0003\u0007\u0011\u0011\u0014\u0005\t\u0003S{\u0003\u0013!a\u0001i\u00061r-\u001a;BY2<%o\\;qg\u0012\"WMZ1vYR$\u0013'\u0001\fhKR\fE\u000e\\$s_V\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-)\bo]3si\u001e\u0013x.\u001e9\u0015\u0011\tM\"\u0011\u0016BW\u0005_CqAa+3\u0001\u0004\u0011))A\u0003he>,\b\u000fC\u0005\u0002\u0018J\u0002\n\u00111\u0001\u0002\u001a\"A\u0011\u0011\u0016\u001a\u0011\u0002\u0003\u0007A/A\u000bvaN,'\u000f^$s_V\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002+U\u00048/\u001a:u\u000fJ|W\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005IAM]8q\u000fJ|W\u000f\u001d\u000b\t\u0005g\u0011ILa/\u0003>\"9!QR\u001bA\u0002\u0005m\u0001\"CALkA\u0005\t\u0019AAM\u0011!\tI+\u000eI\u0001\u0002\u0004!\u0018a\u00053s_B<%o\\;qI\u0011,g-Y;mi\u0012\u0012\u0014a\u00053s_B<%o\\;qI\u0011,g-Y;mi\u0012\u001a\u0004f\u0001\u0003\u0003FB!!q\u0019Br\u001d\u0011\u0011IM!8\u000f\t\t-'1\u001c\b\u0005\u0005\u001b\u0014IN\u0004\u0003\u0003P\n]g\u0002\u0002Bi\u0005+tA!!\t\u0003T&\tA)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u00039~J1Aa\u0002a\u0013\u0011\u0011yN!9\u0002\u0013M#\u0018MY5mSRL(b\u0001B\u0004A&!!Q\u001dBt\u0005!1v\u000e\\1uS2,'\u0002\u0002Bp\u0005C\u0004")
public class ReactiveUserManager {
    private final Core core;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public static byte[] convertRoles(byte[] in) {
        return ReactiveUserManager$.MODULE$.convertRoles(in);
    }

    private Core core() {
        return this.core;
    }

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForUsers() {
        return "/settings/rbac/users";
    }

    private String pathForRoles() {
        return "/settings/rbac/roles";
    }

    private String pathForUser(AuthDomain domain, String username) {
        return new StringBuilder(2).append(this.pathForUsers()).append("/").append(UrlQueryStringBuilder.urlEncode((String)domain.alias())).append("/").append(UrlQueryStringBuilder.urlEncode((String)username)).toString();
    }

    private String pathForGroups() {
        return "/settings/rbac/groups";
    }

    private String pathForGroup(String name) {
        return new StringBuilder(1).append(this.pathForGroups()).append("/").append(UrlQueryStringBuilder.urlEncode((String)name)).toString();
    }

    private String pathForPassword() {
        return "/controller/changePassword";
    }

    private SMono<GenericManagerResponse> sendRequest(GenericManagerRequest request) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), request);
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), method, path, timeout, retryStrategy);
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), method, path, body, timeout, retryStrategy);
    }

    public Try<BoxedUnit> checkStatus(GenericManagerResponse response, String action) {
        return ManagerUtil$.MODULE$.checkStatus(response, action);
    }

    public SMono<UserAndMetadata> getUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get ").append(domain).append(" user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            UserAndMetadata value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), UserAndMetadata$.MODULE$.rw());
            return SMono$.MODULE$.just((Object)value);
        });
    }

    public AuthDomain getUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SFlux<UserAndMetadata> getAllUsers(AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUsers(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all users");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            Seq value = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(UserAndMetadata$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
            return SFlux$.MODULE$.fromIterable((Iterable)value);
        });
    }

    public AuthDomain getAllUsers$default$1() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getAllUsers$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllUsers$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertUser(User user, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("name", user.displayName()).add("roles", ((IterableOnceOps)user.roles().map((Function1 & Serializable)x$1 -> x$1.format())).mkString(","));
        Object object = user.groups().nonEmpty() ? params.add("groups", user.groups().mkString(",")) : BoxedUnit.UNIT;
        user.password().foreach((Function1 & Serializable)pwd -> params.add("password", pwd));
        return this.sendRequest(HttpMethod.PUT, this.pathForUser(domain, user.username()), params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(14).append("create user [").append(RedactableArgument.redactUser((Object)user.username())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public AuthDomain upsertUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration upsertUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new UserNotFoundException(domain.alias(), username));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("drop user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public AuthDomain dropUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration dropUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> changePassword(String newPassword, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("password", newPassword);
        return this.sendRequest(HttpMethod.POST, this.pathForPassword(), params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "change user password");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration changePassword$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy changePassword$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<RoleAndDescription> availableRoles(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForRoles(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all roles");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            byte[] converted = ReactiveUserManager$.MODULE$.convertRoles(response.content());
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(converted), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(RoleAndDescription$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
            return SFlux$.MODULE$.fromIterable((Iterable)values);
        });
    }

    public Duration availableRoles$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy availableRoles$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<Group> getGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get group [").append(RedactableArgument.redactMeta((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            Group value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), Group$.MODULE$.rw());
            return SMono$.MODULE$.just((Object)value);
        });
    }

    public Duration getGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<Group> getAllGroups(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroups(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all groups");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SFlux$.MODULE$.error(err, SFlux$.MODULE$.error$default$2());
            }
            Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), CouchbasePickler$.MODULE$.SeqLikeReader(Group$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
            return SFlux$.MODULE$.fromIterable((Iterable)values);
        });
    }

    public Duration getAllGroups$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllGroups$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertGroup(Group group, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("description", group.description()).add("roles", ((IterableOnceOps)group.roles().map((Function1 & Serializable)x$2 -> x$2.format())).mkString(","));
        group.ldapGroupReference().foreach((Function1 & Serializable)lgr -> params.add("ldap_group_ref", lgr));
        return this.sendRequest(HttpMethod.PUT, this.pathForGroup(group.name()), params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(15).append("create group [").append(RedactableArgument.redactSystem((Object)group.name())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration upsertGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                return SMono$.MODULE$.error((Throwable)new GroupNotFoundException(groupName));
            }
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(13).append("drop group [").append(RedactableArgument.redactUser((Object)groupName)).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                return SMono$.MODULE$.error(err);
            }
            return SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
        });
    }

    public Duration dropGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public ReactiveUserManager(Core core) {
        this.core = core;
        this.defaultManagerTimeout = core.context().environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = core.context().environment().retryStrategy();
    }
}

