/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.DefaultResources$;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import java.io.Serializable;
import java.util.Optional;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001B\f\u0019\u0001\u0005B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005Q!AA\u0007\u0001BC\u0002\u0013%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00037\u0011%a\u0004A!b\u0001\n\u0003AR\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0019)\u0005\u0001\"\u0001\u0019\r\"AQ\n\u0001b\u0001\n\u0007Ab\n\u0003\u0004V\u0001\u0001\u0006Ia\u0014\u0005\t-\u0002\u0011\r\u0011\"\u0001\u0019/\"11\f\u0001Q\u0001\naC\u0001\u0002\u0018\u0001C\u0002\u0013\u0005\u0001$\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00020\t\u0011\u001d\u0004!\u0019!C\u00011!Da\u0001\u001d\u0001!\u0002\u0013I\u0007\"B9\u0001\t\u0003\u0011\bBB:\u0001\t\u0003AB\u000fC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003d\u0001\u0011\u0005A\u0010C\u0005\u0002\u0018\u0001\t\n\u0011\"\u0001\u0002\u001a!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002\"CA&\u0001E\u0005I\u0011AA'\u0005)\t5/\u001f8d'\u000e|\u0007/\u001a\u0006\u00033i\tQa]2bY\u0006T!a\u0007\u000f\u0002\r\rd\u0017.\u001a8u\u0015\tib$A\u0005d_V\u001c\u0007NY1tK*\tq$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001EA\u00111%J\u0007\u0002I)\t\u0011$\u0003\u0002'I\t1\u0011I\\=SK\u001a\f\u0011b]2pa\u0016t\u0015-\\3\u0011\u0005%\u0002dB\u0001\u0016/!\tYC%D\u0001-\u0015\ti\u0003%\u0001\u0004=e>|GOP\u0005\u0003_\u0011\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006J\u0001\u000bEV\u001c7.\u001a;OC6,\u0017\u0001B2pe\u0016,\u0012A\u000e\t\u0003oej\u0011\u0001\u000f\u0006\u0003iiI!A\u000f\u001d\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\fK:4\u0018N]8o[\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\t\u0005$A\u0002f]ZL!a\u0011!\u0003%\rcWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e^\u0001\rK:4\u0018N]8o[\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dK%j\u0013'\u0011\u0005!\u0003Q\"\u0001\r\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000bM:\u0001\u0019\u0001\u0015\t\u000bQ:\u0001\u0019\u0001\u001c\t\u000bq:\u0001\u0019\u0001 \u0002\u0005\u0015\u001cW#A(\u0011\u0005A\u001bV\"A)\u000b\u0005I#\u0013AC2p]\u000e,(O]3oi&\u0011A+\u0015\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0003\tA\u0007/F\u0001Y!\tA\u0015,\u0003\u0002[1\t\u0011\u0002*\u00198eY\u0016\u0014()Y:jGB\u000b'/Y7t\u0003\rA\u0007\u000fI\u0001\u0011C:\fG.\u001f;jGND\u0015M\u001c3mKJ,\u0012A\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\f\u0001\u0002[1oI2,'o\u001d\u0006\u0003Gb\tQ!];fefL!!\u001a1\u0003!\u0005s\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014\u0018!E1oC2LH/[2t\u0011\u0006tG\r\\3sA\u0005A\u0011/^3ss>\u00038/F\u0001j!\tQg.D\u0001l\u0015\t\u0019GN\u0003\u0002nq\u0005\u0019\u0011\r]5\n\u0005=\\'\u0001D\"pe\u0016\fV/\u001a:z\u001fB\u001c\u0018!C9vKJLx\n]:!\u0003\u0011q\u0017-\\3\u0016\u0003!\n\u0011\u0003Z3gCVdGoQ8mY\u0016\u001cG/[8o+\u0005)\bC\u0001%w\u0013\t9\bDA\bBgft7mQ8mY\u0016\u001cG/[8o\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u000b\u0003kjDQa\u001f\nA\u0002!\nabY8mY\u0016\u001cG/[8o\u001d\u0006lW\rF\u0003~\u0003\u0013\ti\u0001\u0005\u0003Q}\u0006\u0005\u0011BA@R\u0005\u00191U\u000f^;sKB!\u00111AA\u0003\u001b\u0005\u0011\u0017bAA\u0004E\nY\u0011+^3ssJ+7/\u001e7u\u0011\u0019\tYa\u0005a\u0001Q\u0005I1\u000f^1uK6,g\u000e\u001e\u0005\n\u0003\u001f\u0019\u0002\u0013!a\u0001\u0003#\tqa\u001c9uS>t7\u000f\u0005\u0003\u0002\u0004\u0005M\u0011bAA\u000bE\na\u0011+^3ss>\u0003H/[8og\u0006y\u0011/^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u001c)\"\u0011\u0011CA\u000fW\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0015I\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD1oC2LH/[2t#V,'/\u001f\u000b\u0007\u0003g\t\t%a\u0011\u0011\tAs\u0018Q\u0007\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\r\u0002\u0013\u0005t\u0017\r\\=uS\u000e\u001c\u0018\u0002BA \u0003s\u0011q\"\u00118bYf$\u0018nY:SKN,H\u000e\u001e\u0005\u0007\u0003\u0017)\u0002\u0019\u0001\u0015\t\u0013\u0005=Q\u0003%AA\u0002\u0005\u0015\u0003\u0003BA\u001c\u0003\u000fJA!!\u0013\u0002:\t\u0001\u0012I\\1msRL7m](qi&|gn]\u0001\u0019C:\fG.\u001f;jGN\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAA(U\u0011\t)%!\b")
public class AsyncScope {
    private final String scopeName;
    private final String bucketName;
    private final Core core;
    private final ClusterEnvironment environment;
    private final ExecutionContext ec;
    private final HandlerBasicParams hp;
    private final AnalyticsHandler analyticsHandler;
    private final CoreQueryOps queryOps;

    private Core core() {
        return this.core;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public CoreQueryOps queryOps() {
        return this.queryOps;
    }

    public String name() {
        return this.scopeName;
    }

    public AsyncCollection defaultCollection() {
        return this.collection(DefaultResources$.MODULE$.DefaultCollection());
    }

    public AsyncCollection collection(String collectionName) {
        boolean defaultScopeAndCollection;
        boolean bl = defaultScopeAndCollection = collectionName.equals(DefaultResources$.MODULE$.DefaultCollection()) && this.scopeName.equals(DefaultResources$.MODULE$.DefaultScope());
        if (!defaultScopeAndCollection) {
            this.core().configurationProvider().refreshCollectionId(new CollectionIdentifier(this.bucketName, Optional.of(this.scopeName), Optional.of(collectionName)));
        }
        return new AsyncCollection(collectionName, this.bucketName, this.scopeName, this.core(), this.environment());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return CoreCommonConverters$.MODULE$.convert(this.queryOps().queryAsync(statement, options.toCore(), null, null, null)).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreQueryResult)result), this.ec());
    }

    public QueryOptions query$default$2() {
        return QueryOptions$.MODULE$.apply();
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), this.environment(), (Option<String>)new Some((Object)this.bucketName), (Option<String>)new Some((Object)this.scopeName));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            return this.analyticsHandler().queryAsync(request, this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public AnalyticsOptions analyticsQuery$default$2() {
        return AnalyticsOptions$.MODULE$.Default();
    }

    public AsyncScope(String scopeName, String bucketName, Core core, ClusterEnvironment environment) {
        this.scopeName = scopeName;
        this.bucketName = bucketName;
        this.core = core;
        this.environment = environment;
        this.ec = environment.ec();
        this.hp = new HandlerBasicParams(core, environment);
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.queryOps = core.queryOps();
    }
}

