/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.query.handlers;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.events.request.PreparedStatementRetriedEvent;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.PreparedStatementFailureException;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.LRUCache;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.codec.JsonDeserializer$JsonObjectSafeConvert$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$CompletionStageOps$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.json.JsonObjectSafe;
import com.couchbase.client.scala.query.QueryMetaData;
import com.couchbase.client.scala.query.QueryMetrics;
import com.couchbase.client.scala.query.QueryMetrics$;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.QueryStatus;
import com.couchbase.client.scala.query.QueryStatus$Aborted$;
import com.couchbase.client.scala.query.QueryStatus$Closed$;
import com.couchbase.client.scala.query.QueryStatus$Completed$;
import com.couchbase.client.scala.query.QueryStatus$Errors$;
import com.couchbase.client.scala.query.QueryStatus$Fatal$;
import com.couchbase.client.scala.query.QueryStatus$Running$;
import com.couchbase.client.scala.query.QueryStatus$Stopped$;
import com.couchbase.client.scala.query.QueryStatus$Success$;
import com.couchbase.client.scala.query.QueryStatus$Timeout$;
import com.couchbase.client.scala.query.QueryStatus$Unknown$;
import com.couchbase.client.scala.query.QueryWarning;
import com.couchbase.client.scala.query.ReactiveQueryResult;
import com.couchbase.client.scala.query.handlers.QueryCacheEntry;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tUa!B\r\u001b\u0001y1\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\fMBQ!\u000f\u0001\u0005\u0002iBq\u0001\u0011\u0001C\u0002\u0013%\u0011\t\u0003\u0004H\u0001\u0001\u0006IA\u0011\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003J\u0011\u0019i\u0005\u0001)A\u0005\u0015\"9a\n\u0001b\u0001\n\u0013y\u0005B\u00024\u0001A\u0003%\u0001\u000bC\u0004h\u0001\u0001\u0007I\u0011\u00025\t\u000f1\u0004\u0001\u0019!C\u0005[\"11\u000f\u0001Q!\n%DQ\u0001\u001f\u0001\u0005\neDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002b\u0001!I!a\u0019\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003O\u0003A\u0011BAU\u0011\u001d\t\t\f\u0001C\u0005\u0003gCq!a0\u0001\t\u0013\t\t\rC\u0004\u0002\u001e\u0002!\t!a3\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011\u0011\u001f\u0001\u0005\n\u0005M(\u0001D)vKJL\b*\u00198eY\u0016\u0014(BA\u000e\u001d\u0003!A\u0017M\u001c3mKJ\u001c(BA\u000f\u001f\u0003\u0015\tX/\u001a:z\u0015\ty\u0002%A\u0003tG\u0006d\u0017M\u0003\u0002\"E\u000511\r\\5f]RT!a\t\u0013\u0002\u0013\r|Wo\u00195cCN,'\"A\u0013\u0002\u0007\r|Wn\u0005\u0002\u0001OA\u0011\u0001FK\u0007\u0002S)\tq$\u0003\u0002,S\t1\u0011I\\=SK\u001a\f!\u0001\u001b9\u0004\u0001A\u0011q\u0006M\u0007\u0002=%\u0011\u0011G\b\u0002\u0013\u0011\u0006tG\r\\3s\u0005\u0006\u001c\u0018n\u0019)be\u0006l7/\u0001\u0002fGB\u0011AgN\u0007\u0002k)\u0011a'K\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001d6\u0005A)\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0003w}\"\"\u0001\u0010 \u0011\u0005u\u0002Q\"\u0001\u000e\t\u000bI\u001a\u00019A\u001a\t\u000b1\u001a\u0001\u0019\u0001\u0018\u0002\t\r|'/Z\u000b\u0002\u0005B\u00111)R\u0007\u0002\t*\u0011\u0001\tI\u0005\u0003\r\u0012\u0013AaQ8sK\u0006)1m\u001c:fA\u0005q\u0011+^3ss\u000e\u000b7\r[3TSj,W#\u0001&\u0011\u0005!Z\u0015B\u0001'*\u0005\rIe\u000e^\u0001\u0010#V,'/_\"bG\",7+\u001b>fA\u0005Q\u0011/^3ss\u000e\u000b7\r[3\u0016\u0003A\u0003B!\u0015,YG6\t!K\u0003\u0002T)\u0006!Q\u000f^5m\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u00075\u000b\u0007\u000f\u0005\u0002ZA:\u0011!L\u0018\t\u00037&j\u0011\u0001\u0018\u0006\u0003;6\na\u0001\u0010:p_Rt\u0014BA0*\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}K\u0003CA\u001fe\u0013\t)'DA\bRk\u0016\u0014\u0018pQ1dQ\u0016,e\u000e\u001e:z\u0003-\tX/\u001a:z\u0007\u0006\u001c\u0007.\u001a\u0011\u0002/\u0015t\u0007.\u00198dK\u0012\u0004&/\u001a9be\u0016$WI\\1cY\u0016$W#A5\u0011\u0005!R\u0017BA6*\u0005\u001d\u0011un\u001c7fC:\f1$\u001a8iC:\u001cW\r\u001a)sKB\f'/\u001a3F]\u0006\u0014G.\u001a3`I\u0015\fHC\u00018r!\tAs.\u0003\u0002qS\t!QK\\5u\u0011\u001d\u00118\"!AA\u0002%\f1\u0001\u001f\u00132\u0003a)g\u000e[1oG\u0016$\u0007K]3qCJ,G-\u00128bE2,G\r\t\u0015\u0003\u0019U\u0004\"\u0001\u000b<\n\u0005]L#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002;U\u0004H-\u0019;f\u000b:D\u0017M\\2fIB\u0013X\r]1sK\u0012,e.\u00192mK\u0012$\"A\u001c>\t\u000bml\u0001\u0019\u0001?\u0002\r\r|gNZ5h!\tix0D\u0001\u007f\u0015\tYH)C\u0002\u0002\u0002y\u0014Qb\u00117vgR,'oQ8oM&<\u0017a\u0002:fcV,7\u000f^\u000b\u0005\u0003\u000f\ty\u0005\u0006\u0007\u0002\n\u0005\u0005\u0012QEA\u0019\u0003\u0003\nY\u0005\u0005\u0004\u0002\f\u0005=\u00111C\u0007\u0003\u0003\u001bQ!aU\u0015\n\t\u0005E\u0011Q\u0002\u0002\u0004)JL\b\u0003BA\u000b\u0003;i!!a\u0006\u000b\u0007u\tIBC\u0002\u0002\u001c\u0011\u000b1!\\:h\u0013\u0011\ty\"a\u0006\u0003\u0019E+XM]=SKF,Xm\u001d;\t\r\u0005\rb\u00021\u0001Y\u0003%\u0019H/\u0019;f[\u0016tG\u000fC\u0004\u0002(9\u0001\r!!\u000b\u0002\u000f=\u0004H/[8ogB!\u00111FA\u0017\u001b\u0005a\u0012bAA\u00189\ta\u0011+^3ss>\u0003H/[8og\"9\u00111\u0007\bA\u0002\u0005U\u0012aC3om&\u0014xN\\7f]R\u0004B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wq\u0012aA3om&!\u0011qHA\u001d\u0005I\u0019E.^:uKJ,eN^5s_:lWM\u001c;\t\u000f\u0005\rc\u00021\u0001\u0002F\u00051!-^2lKR\u0004B\u0001KA$1&\u0019\u0011\u0011J\u0015\u0003\r=\u0003H/[8o\u0011\u001d\tiE\u0004a\u0001\u0003\u000b\nQa]2pa\u0016$q!!\u0015\u000f\u0005\u0004\t\u0019FA\u0001U#\u0011\t)&a\u0017\u0011\u0007!\n9&C\u0002\u0002Z%\u0012qAT8uQ&tw\rE\u0002)\u0003;J1!a\u0018*\u0005\r\te._\u0001\u0010G>tg/\u001a:u%\u0016\u001c\bo\u001c8tKR!\u0011QMA6!\u0011\tY#a\u001a\n\u0007\u0005%DDA\nSK\u0006\u001cG/\u001b<f#V,'/\u001f*fgVdG\u000fC\u0004\u0002n=\u0001\r!a\u001c\u0002\u0011I,7\u000f]8og\u0016\u0004B!!\u0006\u0002r%!\u00111OA\f\u00055\tV/\u001a:z%\u0016\u001c\bo\u001c8tK\u0006i\u0011/^3ss&sG/\u001a:oC2$\u0002\"!\u001f\u0002\u000e\u0006=\u0015\u0011\u0013\t\u0007\u0003w\nI)a\u001c\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007}\t\u0019IC\u0002A\u0003\u000bS!!a\"\u0002\u000fI,\u0017m\u0019;pe&!\u00111RA?\u0005\u0015\u0019Vj\u001c8p\u0011\u001d\t\u0019\u0001\u0005a\u0001\u0003'Aq!a\n\u0011\u0001\u0004\tI\u0003\u0003\u0004\u0002\u0014B\u0001\r![\u0001\u0006C\u0012DwnY\u0001\u0017[\u0006L(-\u001a)sKB\f'/Z!oI\u0016CXmY;uKR1\u0011\u0011PAM\u00037Cq!a\u0001\u0012\u0001\u0004\t\u0019\u0002C\u0004\u0002(E\u0001\r!!\u000b\u0002\u001bE,XM]=SK\u0006\u001cG/\u001b<f)\u0019\t\t+a)\u0002&B1\u00111PAE\u0003KBq!a\u0001\u0013\u0001\u0004\t\u0019\u0002C\u0004\u0002(I\u0001\r!!\u000b\u0002'\t,\u0018\u000e\u001c3Qe\u0016\u0004\u0018M]3SKF,Xm\u001d;\u0015\r\u0005M\u00111VAX\u0011\u001d\tik\u0005a\u0001\u0003'\t\u0001b\u001c:jO&t\u0017\r\u001c\u0005\b\u0003O\u0019\u0002\u0019AA\u0015\u0003M\u0011W/\u001b7e\u000bb,7-\u001e;f%\u0016\fX/Z:u)!\t\u0019\"!.\u0002:\u0006m\u0006BBA\\)\u0001\u00071-\u0001\u0006dC\u000eDW-\u00128uefDq!!,\u0015\u0001\u0004\t\u0019\u0002C\u0004\u0002>R\u0001\r!!\u000b\u0002\u001f=\u0014\u0018nZ5oC2|\u0005\u000f^5p]N\fAcY1dQ\u0016,e\u000e\u001e:z'RLG\u000e\u001c,bY&$G#B5\u0002D\u0006\u001d\u0007BBAc+\u0001\u00071-A\u0003f]R\u0014\u0018\u0010\u0003\u0004\u0002JV\u0001\r![\u0001\u0010K:D\u0017M\\2fI\u0016s\u0017M\u00197fIRa\u0011\u0011UAg\u0003\u001f\f\t.a5\u0002V\"1\u00111\u0005\fA\u0002aCq!a\n\u0017\u0001\u0004\tI\u0003C\u0004\u00024Y\u0001\r!!\u000e\t\u000f\u0005\rc\u00031\u0001\u0002F!9\u0011Q\n\fA\u0002\u0005\u0015\u0013AC9vKJL\u0018i]=oGRa\u00111\\At\u0003S\fY/!<\u0002pB)A'!8\u0002b&\u0019\u0011q\\\u001b\u0003\r\u0019+H/\u001e:f!\u0011\tY#a9\n\u0007\u0005\u0015HDA\u0006Rk\u0016\u0014\u0018PU3tk2$\bBBA\u0012/\u0001\u0007\u0001\fC\u0004\u0002(]\u0001\r!!\u000b\t\u000f\u0005Mr\u00031\u0001\u00026!9\u00111I\fA\u0002\u0005\u0015\u0003bBA'/\u0001\u0007\u0011QI\u0001\u000eaJ,\u0007/\u0019:fIJ+GO]=\u0015\r\u0005U(Q\u0002B\t)\u0011\tI(a>\t\u000f\u0005e\b\u00041\u0001\u0002|\u0006\u0019QM\u001d:\u0011\t\u0005u(q\u0001\b\u0005\u0003\u007f\u0014\u0019AD\u0002\\\u0005\u0003I\u0011aH\u0005\u0004\u0005\u000bI\u0013a\u00029bG.\fw-Z\u0005\u0005\u0005\u0013\u0011YAA\u0005UQJ|w/\u00192mK*\u0019!QA\u0015\t\u000f\t=\u0001\u00041\u0001\u0002\u0014\u0005\u0019!/Z9\t\u000f\tM\u0001\u00041\u0001\u0002*\u0005!q\u000e\u001d;t\u0001")
public class QueryHandler {
    private final HandlerBasicParams hp;
    private final ExecutionContext ec;
    private final Core core;
    private final int QueryCacheSize;
    private final Map<String, QueryCacheEntry> queryCache;
    private volatile boolean enhancedPreparedEnabled;

    private Core core() {
        return this.core;
    }

    private int QueryCacheSize() {
        return this.QueryCacheSize;
    }

    private Map<String, QueryCacheEntry> queryCache() {
        return this.queryCache;
    }

    private boolean enhancedPreparedEnabled() {
        return this.enhancedPreparedEnabled;
    }

    private void enhancedPreparedEnabled_$eq(boolean x$1) {
        this.enhancedPreparedEnabled = x$1;
    }

    private void updateEnhancedPreparedEnabled(ClusterConfig config) {
        if (!this.enhancedPreparedEnabled()) {
            Set caps = (Set)config.clusterCapabilities().get(ServiceType.QUERY);
            this.enhancedPreparedEnabled_$eq(caps != null && caps.contains(ClusterCapabilities.ENHANCED_PREPARED_STATEMENTS));
            return;
        }
    }

    private <T> Try<QueryRequest> request(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(statement, "statement").flatMap((Function1 & Serializable)x$15 -> {
            String string = x$15;
            return Validate$.MODULE$.notNull(options, "options").flatMap((Function1 & Serializable)x$14 -> {
                Object object = x$14;
                return Validate$.MODULE$.optNotNull(options.parameters(), "parameters").flatMap((Function1 & Serializable)x$13 -> {
                    Object object = x$13;
                    return Validate$.MODULE$.optNotNull(options.clientContextId(), "clientContextId").flatMap((Function1 & Serializable)x$12 -> {
                        Object object = x$12;
                        return Validate$.MODULE$.optNotNull(options.maxParallelism(), "maxParallelism").flatMap((Function1 & Serializable)x$11 -> {
                            Object object = x$11;
                            return Validate$.MODULE$.notNull(BoxesRunTime.boxToBoolean((boolean)options.metrics()), "metrics").flatMap((Function1 & Serializable)x$10 -> {
                                Object object = x$10;
                                return Validate$.MODULE$.optNotNull(options.pipelineBatch(), "pipelineBatch").flatMap((Function1 & Serializable)x$9 -> {
                                    Object object = x$9;
                                    return Validate$.MODULE$.optNotNull(options.pipelineCap(), "pipelineCap").flatMap((Function1 & Serializable)x$8 -> {
                                        Object object = x$8;
                                        return Validate$.MODULE$.optNotNull(options.profile(), "profile").flatMap((Function1 & Serializable)x$7 -> {
                                            Object object = x$7;
                                            return Validate$.MODULE$.optNotNull(options.readonly(), "readonly").flatMap((Function1 & Serializable)x$6 -> {
                                                Object object = x$6;
                                                return Validate$.MODULE$.optNotNull(options.retryStrategy(), "retryStrategy").flatMap((Function1 & Serializable)x$5 -> {
                                                    Object object = x$5;
                                                    return Validate$.MODULE$.optNotNull(options.scanCap(), "scanCap").flatMap((Function1 & Serializable)x$4 -> {
                                                        Object object = x$4;
                                                        return Validate$.MODULE$.optNotNull(options.scanConsistency(), "scanConsistency").flatMap((Function1 & Serializable)x$3 -> {
                                                            Object object = x$3;
                                                            return Validate$.MODULE$.optNotNull(options.timeout(), "timeout").flatMap((Function1 & Serializable)x$2 -> {
                                                                Object object = x$2;
                                                                return Validate$.MODULE$.optNotNull(options.parentSpan(), "parentSpan").map((Function1 & Serializable)x$1 -> {
                                                                    Object object = x$1;
                                                                    return null;
                                                                });
                                                            });
                                                        });
                                                    });
                                                });
                                            });
                                        });
                                    });
                                });
                            });
                        });
                    });
                });
            });
        });
        if (validations.isFailure()) {
            return validations;
        }
        Option<RuntimeException> option = options.deferredException();
        if (option instanceof Some) {
            Some some = (Some)option;
            RuntimeException deferredException = (RuntimeException)some.value();
            return new Failure((Throwable)deferredException);
        }
        JsonObject params = options.encode();
        params.put("statement", statement);
        Object object = scope.isDefined() ? params.put("query_context", QueryRequest.queryContext((String)((String)bucket.get()), (String)((String)scope.get()))) : BoxedUnit.UNIT;
        return Try$.MODULE$.apply((Function0 & Serializable)() -> JacksonTransformers.MAPPER.writeValueAsString((Object)params)).map((Function1 & Serializable)queryStr -> {
            byte[] queryBytes = queryStr.getBytes(CharsetUtil.UTF_8);
            Duration timeout = (Duration)options.timeout().getOrElse((Function0 & Serializable)() -> DurationConversions$.MODULE$.javaDurationToScala(environment.timeoutConfig().queryTimeout()));
            RetryStrategy retryStrategy = (RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> environment.retryStrategy());
            QueryRequest request = new QueryRequest(DurationConversions$.MODULE$.scalaDurationToJava(timeout), this.core().context(), retryStrategy, this.core().context().authenticator(), statement, queryBytes, BoxesRunTime.unboxToBoolean((Object)options.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), params.str("client_context_id"), $this.hp.tracer().requestSpan("query", (RequestSpan)options.parentSpan().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (String)bucket.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), (String)scope.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            return request;
        });
    }

    private ReactiveQueryResult convertResponse(QueryResponse response) {
        SFlux rows = FutureConversions$.MODULE$.javaFluxToScalaFlux(response.rows());
        SMono meta = FutureConversions$.MODULE$.javaMonoToScalaMono(response.trailer()).map((Function1 & Serializable)addl -> {
            QueryStatus queryStatus;
            Seq warnings2;
            block11: {
                warnings2 = (Seq)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.warnings())).map((Function1 & Serializable)warnings -> (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(ErrorCodeAndMessage.fromJsonArray((byte[])warnings)).asScala().map((Function1 & Serializable)warning -> new QueryWarning(warning.code(), warning.message()))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)Nil$.MODULE$);
                String string = addl.status();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1884319283: {
                        if (!"stopped".equals(string)) break;
                        queryStatus = QueryStatus$Stopped$.MODULE$;
                        break block11;
                    }
                    case -1867169789: {
                        if (!"success".equals(string)) break;
                        queryStatus = QueryStatus$Success$.MODULE$;
                        break block11;
                    }
                    case -1402931637: {
                        if (!"completed".equals(string)) break;
                        queryStatus = QueryStatus$Completed$.MODULE$;
                        break block11;
                    }
                    case -1357520532: {
                        if (!"closed".equals(string)) break;
                        queryStatus = QueryStatus$Closed$.MODULE$;
                        break block11;
                    }
                    case -1313911455: {
                        if (!"timeout".equals(string)) break;
                        queryStatus = QueryStatus$Timeout$.MODULE$;
                        break block11;
                    }
                    case -1294635157: {
                        if (!"errors".equals(string)) break;
                        queryStatus = QueryStatus$Errors$.MODULE$;
                        break block11;
                    }
                    case -1194777649: {
                        if (!"aborted".equals(string)) break;
                        queryStatus = QueryStatus$Aborted$.MODULE$;
                        break block11;
                    }
                    case 97203460: {
                        if (!"fatal".equals(string)) break;
                        queryStatus = QueryStatus$Fatal$.MODULE$;
                        break block11;
                    }
                    case 1550783935: {
                        if (!"running".equals(string)) break;
                        queryStatus = QueryStatus$Running$.MODULE$;
                        break block11;
                    }
                }
                queryStatus = QueryStatus$Unknown$.MODULE$;
            }
            QueryStatus$Unknown$ status = queryStatus;
            QueryMetaData out = new QueryMetaData(response.header().requestId(), (String)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().clientContextId())).getOrElse((Function0 & Serializable)() -> ""), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.header().signature())), (Option<QueryMetrics>)OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.metrics())).flatMap((Function1 & Serializable)in -> QueryMetrics$.MODULE$.fromBytes((byte[])in)), (Seq<QueryWarning>)warnings2, status, OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(addl.profile())));
            return out;
        });
        return new ReactiveQueryResult(rows, (SMono<QueryMetaData>)meta);
    }

    private SMono<QueryResponse> queryInternal(QueryRequest request, QueryOptions options, boolean adhoc) {
        if (adhoc) {
            return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
                this.core().send((Request)request);
                return FutureConversions$.MODULE$.wrap((Request<? extends Response>)request, request.response(), true);
            });
        }
        return this.maybePrepareAndExecute(request, options);
    }

    private SMono<QueryResponse> maybePrepareAndExecute(QueryRequest request, QueryOptions options) {
        QueryCacheEntry cacheEntry = this.queryCache().get(request.statement());
        boolean enhancedEnabled = this.enhancedPreparedEnabled();
        if (cacheEntry != null && this.cacheEntryStillValid(cacheEntry, enhancedEnabled)) {
            return this.queryInternal(this.buildExecuteRequest(cacheEntry, request, options), options, true).onErrorResume((Function1 & Serializable)err -> this.preparedRetry(request, options, (Throwable)err));
        }
        if (enhancedEnabled) {
            return this.queryInternal(this.buildPrepareRequest(request, options), options, true).flatMap((Function1 & Serializable)qr -> {
                Optional preparedName = qr.header().prepared();
                if (!preparedName.isPresent()) {
                    return SMono$.MODULE$.error((Throwable)new CouchbaseException("No prepared name present but must be, this is a query bug!"));
                }
                this.queryCache().put(request.statement(), new QueryCacheEntry((String)preparedName.get(), false, (Option<String>)None$.MODULE$));
                return SMono$.MODULE$.just(qr);
            });
        }
        return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            QueryRequest req = this.buildPrepareRequest(request, options);
            this.core().send((Request)req);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)req, req.response(), true);
        }).flatMapMany((Function1 & Serializable)result -> result.rows()).doOnNext((Function1 & Serializable)row -> {
            QueryHandler.$anonfun$maybePrepareAndExecute$5(this, enhancedEnabled, request, row);
            return BoxedUnit.UNIT;
        }).then().then(SMono$.MODULE$.defer((Function0 & Serializable)() -> this.maybePrepareAndExecute(request, options))).onErrorResume((Function1 & Serializable)err -> this.queryInternal(request, options, true));
    }

    private SMono<ReactiveQueryResult> queryReactive(QueryRequest request, QueryOptions options) {
        return SMono$.MODULE$.defer((Function0 & Serializable)() -> this.queryInternal(request, options, options.adhoc()).map((Function1 & Serializable)v -> this.convertResponse((QueryResponse)v)));
    }

    private QueryRequest buildPrepareRequest(QueryRequest original, QueryOptions options) {
        Object object;
        String statement = new StringBuilder(8).append("PREPARE ").append(original.statement()).toString();
        JsonObject query = JsonObject$.MODULE$.create();
        query.put("statement", statement);
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        if (this.enhancedPreparedEnabled()) {
            query.put("auto_execute", BoxesRunTime.boxToBoolean((boolean)true));
            object = options.encode(query);
        } else {
            object = BoxedUnit.UNIT;
        }
        Object object2 = original.scope() != null ? query.put("query_context", QueryRequest.queryContext((String)original.bucket(), (String)original.scope())) : BoxedUnit.UNIT;
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), statement, query.toString().getBytes(StandardCharsets.UTF_8), true, query.str("client_context_id"), this.hp.tracer().requestSpan("query", (RequestSpan)options.parentSpan().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), original.bucket(), original.scope(), original.target());
    }

    private QueryRequest buildExecuteRequest(QueryCacheEntry cacheEntry, QueryRequest original, QueryOptions originalOptions) {
        JsonObject query = cacheEntry.export();
        query.put("timeout", Golang.encodeDurationToMs((java.time.Duration)original.timeout()));
        Object object = original.scope() != null ? query.put("query_context", QueryRequest.queryContext((String)original.bucket(), (String)original.scope())) : BoxedUnit.UNIT;
        originalOptions.encode(query);
        return new QueryRequest(original.timeout(), (CoreContext)original.context(), original.retryStrategy(), original.credentials(), original.statement(), query.toString().getBytes(StandardCharsets.UTF_8), BoxesRunTime.unboxToBoolean((Object)originalOptions.readonly().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), query.str("client_context_id"), this.hp.tracer().requestSpan("query", (RequestSpan)originalOptions.parentSpan().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), original.bucket(), original.scope(), original.target());
    }

    private boolean cacheEntryStillValid(QueryCacheEntry entry, boolean enhancedEnabled) {
        return enhancedEnabled && !entry.fullPlan() || !enhancedEnabled && entry.fullPlan();
    }

    public SMono<ReactiveQueryResult> queryReactive(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try<QueryRequest> try_ = this.request(statement, options, environment, bucket, scope);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            return this.queryReactive(req, options);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return SMono$.MODULE$.error(err);
        }
        throw new MatchError(try_);
    }

    public Future<QueryResult> queryAsync(String statement, QueryOptions options, ClusterEnvironment environment, Option<String> bucket, Option<String> scope) {
        Try<QueryRequest> try_ = this.request(statement, options, environment, bucket, scope);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            QueryRequest req = (QueryRequest)success.value();
            return this.queryReactive(req, options).flatMap((Function1 & Serializable)response -> response.rows().collectSeq().flatMap((Function1 & Serializable)rows -> response.metaData().map((Function1 & Serializable)meta -> new QueryResult((scala.collection.immutable.Seq<QueryChunkRow>)rows, (QueryMetaData)meta)))).toFuture();
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    private SMono<QueryResponse> preparedRetry(QueryRequest req, QueryOptions opts, Throwable err) {
        PreparedStatementFailureException preparedStatementFailureException;
        Throwable throwable = err;
        if (throwable instanceof PreparedStatementFailureException && (preparedStatementFailureException = (PreparedStatementFailureException)throwable).retryable()) {
            this.queryCache().remove(req.statement());
            RetryReason retryReason = RetryReason.QUERY_PREPARED_STATEMENT_FAILURE;
            CoreEnvironment env = req.context().environment();
            CompletableFuture cf = req.retryStrategy().shouldRetry((Request)req, retryReason);
            return SMono$.MODULE$.fromFuture(FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(cf)), this.ec).flatMap((Function1 & Serializable)retryAction -> {
                Option option = OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(retryAction.duration()));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    java.time.Duration duration = (java.time.Duration)some.value();
                    java.time.Duration cappedDuration = RetryOrchestrator.capDuration((java.time.Duration)duration, (Request)req);
                    req.context().incrementRetryAttempts(cappedDuration, retryReason);
                    env.eventBus().publish((Event)new PreparedStatementRetriedEvent(cappedDuration, req.context(), retryReason, (Throwable)preparedStatementFailureException));
                    return SMono$.MODULE$.delay(DurationConversions$.MODULE$.javaDurationToScala(cappedDuration), env.scheduler()).flatMap((Function1 & Serializable)l -> this.maybePrepareAndExecute(req, opts));
                }
                return SMono$.MODULE$.error((Throwable)preparedStatementFailureException);
            });
        }
        return SMono$.MODULE$.error(err);
    }

    public static final /* synthetic */ void $anonfun$maybePrepareAndExecute$5(QueryHandler $this, boolean enhancedEnabled$1, QueryRequest request$2, QueryChunkRow row) {
        Try<JsonObjectSafe> json = JsonDeserializer$JsonObjectSafeConvert$.MODULE$.deserialize(row.data());
        Option nameOpt = json.flatMap((Function1 & Serializable)x$16 -> x$16.str("name")).toOption();
        None$ plan = enhancedEnabled$1 ? None$.MODULE$ : json.flatMap((Function1 & Serializable)x$17 -> x$17.str("encoded_plan")).toOption();
        Option option = nameOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            QueryCacheEntry entry = new QueryCacheEntry(name, !enhancedEnabled$1, (Option<String>)plan);
            $this.queryCache().put(request$2.statement(), entry);
            return;
        }
    }

    public QueryHandler(HandlerBasicParams hp, ExecutionContext ec) {
        this.hp = hp;
        this.ec = ec;
        this.core = hp.core();
        this.QueryCacheSize = 5000;
        this.queryCache = Collections.synchronizedMap(new LRUCache(this.QueryCacheSize()));
        this.enhancedPreparedEnabled = false;
        this.core().configurationProvider().configs().subscribe(config -> this.updateEnhancedPreparedEnabled((ClusterConfig)config));
    }
}

