/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.collection;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.config.CollectionsManifest;
import com.couchbase.client.core.config.CollectionsManifestCollection;
import com.couchbase.client.core.config.CollectionsManifestScope;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.CollectionExistsException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.ScopeExistsException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.collection.CollectionSpec;
import com.couchbase.client.scala.manager.collection.ScopeSpec;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015b\u0001\u0002\u0015*\u0001YB\u0011\u0002\u0010\u0001\u0003\u0006\u0004%\t!L\u001f\t\u0011\t\u0003!\u0011!Q\u0001\nyBQa\u0011\u0001\u0005\u0002\u0011Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006IA\u0013\u0005\t!\u0002\u0011\r\u0011\"\u0001.#\"1!\f\u0001Q\u0001\nIC\u0001b\u0017\u0001C\u0002\u0013\u0005Q\u0006\u0018\u0005\u0007G\u0002\u0001\u000b\u0011B/\t\r\u0011\u0004A\u0011A\u0017f\u0011!Y\b!%A\u0005\u00025b\bBCA\b\u0001E\u0005I\u0011A\u0017\u0002\u0012!A\u0011Q\u0003\u0001\u0005\u00025\n9\u0002C\u0005\u00028\u0001\t\n\u0011\"\u0001.y\"Q\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005Q&!\u0005\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>!A\u0011\u0011\r\u0001\u0012\u0002\u0013\u0005A\u0010C\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002\u0012!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004\u0002CA:\u0001E\u0005I\u0011\u0001?\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005E\u0001bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\t\u0003\u0013\u0003\u0011\u0013!C\u0001y\"I\u00111\u0012\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011!\t9\nAI\u0001\n\u0003a\b\"CAM\u0001E\u0005I\u0011AA\t\u0011\u001d\tY\n\u0001C\u0001\u0003;C\u0001\"!*\u0001#\u0003%\t\u0001 \u0005\n\u0003O\u0003\u0011\u0013!C\u0001\u0003#Aq!!+\u0001\t\u0003\tY\u000b\u0003\u0005\u00024\u0002\t\n\u0011\"\u0001}\u0011%\t)\fAI\u0001\n\u0003\t\t\u0002C\u0004\u00028\u0002!I!!/\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011Q\u001b\u0001\u0005\n\u0005]\u0007bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003S\u0004A\u0011BAv\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003\u0011\u0011DU3bGRLg/Z\"pY2,7\r^5p]6\u000bg.Y4fe*\u0011!fK\u0001\u000bG>dG.Z2uS>t'B\u0001\u0017.\u0003\u001di\u0017M\\1hKJT!AL\u0018\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\n\u0014AB2mS\u0016tGO\u0003\u00023g\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002i\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\u000e\t\u0003qij\u0011!\u000f\u0006\u0002]%\u00111(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\r\t,8m[3u+\u0005q\u0004CA A\u001b\u0005i\u0013BA!.\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\u0002\u000f\t,8m[3uA\u00051A(\u001b8jiz\"\"!R$\u0011\u0005\u0019\u0003Q\"A\u0015\t\u000bq\u001a\u0001\u0019\u0001 \u0002\t\r|'/Z\u000b\u0002\u0015B\u00111*T\u0007\u0002\u0019*\u0011\u0001jL\u0005\u0003\u001d2\u0013AaQ8sK\u0006)1m\u001c:fA\u0005)B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$X#\u0001*\u0011\u0005MCV\"\u0001+\u000b\u0005U3\u0016\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005]K\u0014AC2p]\u000e,(O]3oi&\u0011\u0011\f\u0016\u0002\t\tV\u0014\u0018\r^5p]\u00061B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$\b%\u0001\u000beK\u001a\fW\u000f\u001c;SKR\u0014\u0018p\u0015;sCR,w-_\u000b\u0002;B\u0011a,Y\u0007\u0002?*\u0011\u0001\rT\u0001\u0006e\u0016$(/_\u0005\u0003E~\u0013QBU3uef\u001cFO]1uK\u001eL\u0018!\u00063fM\u0006,H\u000e\u001e*fiJL8\u000b\u001e:bi\u0016<\u0017\u0010I\u0001\u0011G>dG.Z2uS>tW\t_5tiN$BAZ:xsB\u0019qM\u001c9\u000e\u0003!T!!\u001b6\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u0018l\u0015\tAENC\u0001n\u0003\u001d\u0011X-Y2u_JL!a\u001c5\u0003\u000bMkuN\\8\u0011\u0005a\n\u0018B\u0001::\u0005\u001d\u0011un\u001c7fC:DQA\u000b\u0006A\u0002Q\u0004\"AR;\n\u0005YL#AD\"pY2,7\r^5p]N\u0003Xm\u0019\u0005\bq*\u0001\n\u00111\u0001S\u0003\u001d!\u0018.\\3pkRDqA\u001f\u0006\u0011\u0002\u0003\u0007Q,A\u0007sKR\u0014\u0018p\u0015;sCR,w-_\u0001\u001bG>dG.Z2uS>tW\t_5tiN$C-\u001a4bk2$HEM\u000b\u0002{*\u0012!K`\u0016\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011!C;oG\",7m[3e\u0015\r\tI!O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0007\u0003\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003i\u0019w\u000e\u001c7fGRLwN\\#ySN$8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019B\u000b\u0002^}\u0006Y1oY8qK\u0016C\u0018n\u001d;t)\u001d1\u0017\u0011DA\u001a\u0003kAq!a\u0007\u000e\u0001\u0004\ti\"A\u0005tG>\u0004XMT1nKB!\u0011qDA\u0017\u001d\u0011\t\t#!\u000b\u0011\u0007\u0005\r\u0012(\u0004\u0002\u0002&)\u0019\u0011qE\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tY#O\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0012\u0011\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-\u0012\bC\u0004y\u001bA\u0005\t\u0019\u0001*\t\u000fil\u0001\u0013!a\u0001;\u0006)2oY8qK\u0016C\u0018n\u001d;tI\u0011,g-Y;mi\u0012\u0012\u0014!F:d_B,W\t_5tiN$C-\u001a4bk2$HeM\u0001\tO\u0016$8kY8qKRA\u0011qHA$\u0003\u0013\nY\u0005\u0005\u0003h]\u0006\u0005\u0003c\u0001$\u0002D%\u0019\u0011QI\u0015\u0003\u0013M\u001bw\u000e]3Ta\u0016\u001c\u0007bBA\u000e!\u0001\u0007\u0011Q\u0004\u0005\bqB\u0001\n\u00111\u0001S\u0011\u001dQ\b\u0003%AA\u0002uC3\u0002EA(\u0003+\n9&a\u0017\u0002^A\u0019\u0001(!\u0015\n\u0007\u0005M\u0013H\u0001\u0006eKB\u0014XmY1uK\u0012\fq!\\3tg\u0006<W-\t\u0002\u0002Z\u0005ARo]3!O\u0016$\u0018\t\u001c7TG>\u0004Xm\u001d\u0011j]N$X-\u00193\u0002\u000bMLgnY3\"\u0005\u0005}\u0013!B\u0019/c9\u0012\u0014AE4fiN\u001bw\u000e]3%I\u00164\u0017-\u001e7uII\n!cZ3u'\u000e|\u0007/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005aq-\u001a;BY2\u001c6m\u001c9fgR1\u0011\u0011NA8\u0003c\u0002RaZA6\u0003\u0003J1!!\u001ci\u0005\u0015\u0019f\t\\;y\u0011\u001dA8\u0003%AA\u0002ICqA_\n\u0011\u0002\u0003\u0007Q,\u0001\fhKR\fE\u000e\\*d_B,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003Y9W\r^!mYN\u001bw\u000e]3tI\u0011,g-Y;mi\u0012\u0012\u0014\u0001E2sK\u0006$XmQ8mY\u0016\u001cG/[8o)!\tY(a!\u0002\u0006\u0006\u001d\u0005\u0003B4o\u0003{\u00022\u0001OA@\u0013\r\t\t)\u000f\u0002\u0005+:LG\u000fC\u0003+-\u0001\u0007A\u000fC\u0004y-A\u0005\t\u0019\u0001*\t\u000fi4\u0002\u0013!a\u0001;\u0006Q2M]3bi\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005Q2M]3bi\u0016\u001cu\u000e\u001c7fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%g\u0005qAM]8q\u0007>dG.Z2uS>tG\u0003CA>\u0003#\u000b\u0019*!&\t\u000b)J\u0002\u0019\u0001;\t\u000faL\u0002\u0013!a\u0001%\"9!0\u0007I\u0001\u0002\u0004i\u0016\u0001\u00073s_B\u001cu\u000e\u001c7fGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005ABM]8q\u0007>dG.Z2uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017\r\u0014X-\u0019;f'\u000e|\u0007/\u001a\u000b\t\u0003w\ny*!)\u0002$\"9\u00111\u0004\u000fA\u0002\u0005u\u0001b\u0002=\u001d!\u0003\u0005\rA\u0015\u0005\bur\u0001\n\u00111\u0001^\u0003U\u0019'/Z1uKN\u001bw\u000e]3%I\u00164\u0017-\u001e7uII\nQc\u0019:fCR,7kY8qK\u0012\"WMZ1vYR$3'A\u0005ee>\u00048kY8qKRA\u00111PAW\u0003_\u000b\t\fC\u0004\u0002\u001c}\u0001\r!!\b\t\u000fa|\u0002\u0013!a\u0001%\"9!p\bI\u0001\u0002\u0004i\u0016a\u00053s_B\u001c6m\u001c9fI\u0011,g-Y;mi\u0012\u0012\u0014a\u00053s_B\u001c6m\u001c9fI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049bi\"4uN]*d_B,7\u000f\u0006\u0003\u0002<\u0006%\u0007\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0005Y\u0006twM\u0003\u0002\u0002F\u0006!!.\u0019<b\u0013\u0011\ty#a0\t\u000f\u0005-'\u00051\u0001\u0002\u001e\u0005Q!-^2lKRt\u0015-\\3\u0002\u0019A\fG\u000f\u001b$peN\u001bw\u000e]3\u0015\r\u0005m\u0016\u0011[Aj\u0011\u001d\tYm\ta\u0001\u0003;Aq!a\u0007$\u0001\u0004\ti\"\u0001\nqCRDgi\u001c:D_2dWm\u0019;j_:\u001cHCBA^\u00033\fY\u000eC\u0004\u0002L\u0012\u0002\r!!\b\t\u000f\u0005mA\u00051\u0001\u0002\u001e\u0005\t\u0002/\u0019;i\r>\u00148i\u001c7mK\u000e$\u0018n\u001c8\u0015\u0011\u0005m\u0016\u0011]Ar\u0003KDq!a3&\u0001\u0004\ti\u0002C\u0004\u0002\u001c\u0015\u0002\r!!\b\t\u000f\u0005\u001dX\u00051\u0001\u0002\u001e\u0005q1m\u001c7mK\u000e$\u0018n\u001c8OC6,\u0017\u0001\u00047pC\u0012l\u0015M\\5gKN$HCBAw\u0003w\fi\u0010\u0005\u0003h]\u0006=\b\u0003BAy\u0003ol!!a=\u000b\u0007\u0005UH*\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003s\f\u0019PA\nD_2dWm\u0019;j_:\u001cX*\u00198jM\u0016\u001cH\u000fC\u0003yM\u0001\u0007!\u000bC\u0003{M\u0001\u0007Q,\u0001\bdQ\u0016\u001c7NR8s\u000bJ\u0014xN]:\u0015\u0011\t\r!q\u0002B\u0011\u0005G\u0001bA!\u0002\u0003\f\u0005uTB\u0001B\u0004\u0015\r\u0011I!O\u0001\u0005kRLG.\u0003\u0003\u0003\u000e\t\u001d!a\u0001+ss\"9!\u0011C\u0014A\u0002\tM\u0011\u0001\u0003:fgB|gn]3\u0011\t\tU!QD\u0007\u0003\u0005/Q1\u0001\fB\r\u0015\r\u0011Y\u0002T\u0001\u0004[N<\u0017\u0002\u0002B\u0010\u0005/\u0011acR3oKJL7-T1oC\u001e,'OU3ta>t7/\u001a\u0005\b\u000379\u0003\u0019AA\u000f\u0011\u001d\t9o\na\u0001\u0003;\u0001")
public class ReactiveCollectionManager {
    private final AsyncBucket bucket;
    private final Core core;
    private final Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public AsyncBucket bucket() {
        return this.bucket;
    }

    private Core core() {
        return this.core;
    }

    public Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    public SMono<Object> collectionExists(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable)manifest -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$1(collection, manifest)));
    }

    public Duration collectionExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy collectionExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<Object> scopeExists(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$1(scopeName, x$3)));
    }

    public Duration scopeExists$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy scopeExists$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<ScopeSpec> getScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllScopes(timeout, retryStrategy).collectSeq().flatMap((Function1 & Serializable)scopes -> {
            Option option = scopes.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$getScope$2(scopeName, x$5)));
            if (option instanceof Some) {
                Some some = (Some)option;
                ScopeSpec scope = (ScopeSpec)some.value();
                return SMono$.MODULE$.just((Object)scope);
            }
            return SMono$.MODULE$.error((Throwable)new ScopeNotFoundException(scopeName));
        });
    }

    public Duration getScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<ScopeSpec> getAllScopes(Duration timeout, RetryStrategy retryStrategy) {
        return this.loadManifest(timeout, retryStrategy).flatMapMany((Function1 & Serializable)manifest -> {
            Buffer scopes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(manifest.scopes()).asScala().map((Function1 & Serializable)scope -> {
                Seq collections = (Seq)CollectionConverters$.MODULE$.ListHasAsScala(scope.collections()).asScala().map((Function1 & Serializable)coll -> new CollectionSpec(coll.name(), scope.name()));
                return new ScopeSpec(scope.name(), (Seq<CollectionSpec>)collections);
            });
            return SFlux$.MODULE$.fromIterable((Iterable)scopes);
        });
    }

    public Duration getAllScopes$default$1() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy getAllScopes$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", collection.name());
        String path = this.pathForCollections(this.bucket().name(), collection.scopeName());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration createCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropCollection(CollectionSpec collection, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForCollection(this.bucket().name(), collection.scopeName(), collection.name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable)() -> this.checkForErrors((GenericManagerResponse)response, collection.scopeName(), collection.name())));
    }

    public Duration dropCollection$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropCollection$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> createScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder body = UrlQueryStringBuilder.create().add("name", scopeName);
        String path = this.pathForScopes(this.bucket().name());
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.POST, path, body, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration createScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy createScope$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropScope(String scopeName, Duration timeout, RetryStrategy retryStrategy) {
        String path = this.pathForScope(this.bucket().name(), scopeName);
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.DELETE, path, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> SMono$.MODULE$.fromTry((Function0 & Serializable)() -> this.checkForErrors((GenericManagerResponse)response, scopeName, null)));
    }

    public Duration dropScope$default$2() {
        return this.defaultManagerTimeout();
    }

    public RetryStrategy dropScope$default$3() {
        return this.defaultRetryStrategy();
    }

    private String pathForScopes(String bucketName) {
        return new StringBuilder(30).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)bucketName)).append("/scopes").toString();
    }

    private String pathForScope(String bucketName, String scopeName) {
        return new StringBuilder(1).append(this.pathForScopes(bucketName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)scopeName)).toString();
    }

    private String pathForCollections(String bucketName, String scopeName) {
        return new StringBuilder(12).append(this.pathForScope(bucketName, scopeName)).append("/collections").toString();
    }

    private String pathForCollection(String bucketName, String scopeName, String collectionName) {
        return new StringBuilder(1).append(this.pathForCollections(bucketName, scopeName)).append("/").append(UrlQueryStringBuilder.urlEncode((String)collectionName)).toString();
    }

    private SMono<CollectionsManifest> loadManifest(Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.GET, this.pathForScopes(this.bucket().name()), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            String error = new String(response.content(), StandardCharsets.UTF_8);
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.INVALID_ARGS;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                if (error.contains("Not allowed on this version of cluster")) {
                    return SMono$.MODULE$.error((Throwable)new IllegalArgumentException("This version of Couchbase Server does not support this operation"));
                }
                return SMono$.MODULE$.error((Throwable)new IllegalArgumentException(error));
            }
            return SMono$.MODULE$.fromTry((Function0 & Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable)() -> (CollectionsManifest)JacksonTransformers.MAPPER.readValue(response.content(), CollectionsManifest.class)));
        });
    }

    private Try<BoxedUnit> checkForErrors(GenericManagerResponse response, String scopeName, String collectionName) {
        if (response.status().success()) {
            return new Success((Object)BoxedUnit.UNIT);
        }
        String error = new String(response.content(), StandardCharsets.UTF_8);
        ResponseStatus responseStatus = response.status();
        ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
        if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
            if (error.matches(".*Scope.+not found.*") || error.contains("scope_not_found")) {
                return new Failure((Throwable)new ScopeNotFoundException(scopeName));
            }
            if (error.matches(".*Collection.+not found.*") || error.contains("scope_not_found")) {
                return new Failure((Throwable)new CollectionNotFoundException(collectionName));
            }
            if (error.contains("Not found.") || error.contains("Requested resource not found.")) {
                return new Failure((Throwable)FeatureNotAvailableException.collections());
            }
            return new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()));
        }
        ResponseStatus responseStatus3 = response.status();
        ResponseStatus responseStatus4 = ResponseStatus.INVALID_ARGS;
        if (!(responseStatus3 != null ? !responseStatus3.equals(responseStatus4) : responseStatus4 != null)) {
            if (error.matches(".*Scope.+not found.*") || error.contains("scope_not_found")) {
                return new Failure((Throwable)new ScopeNotFoundException(scopeName));
            }
            if (error.matches(".*Scope.+already exists.*")) {
                return new Failure((Throwable)new ScopeExistsException(scopeName));
            }
            if (error.matches(".*Collection.+already exists.*")) {
                return new Failure((Throwable)new CollectionExistsException(collectionName));
            }
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()));
        }
        return new Failure((Throwable)new CouchbaseException(new StringBuilder(36).append("Unknown error in CollectionManager: ").append(error).toString()));
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$2(CollectionSpec collection$1, CollectionsManifestScope x$1) {
        String string = x$1.name();
        String string2 = collection$1.scopeName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$4(CollectionSpec collection$1, CollectionsManifestCollection x$2) {
        String string = x$2.name();
        String string2 = collection$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$collectionExists$1(CollectionSpec collection$1, CollectionsManifest manifest) {
        Option foundCollection = CollectionConverters$.MODULE$.ListHasAsScala(manifest.scopes()).asScala().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$2(collection$1, x$1))).flatMap((Function1 & Serializable)scope -> CollectionConverters$.MODULE$.ListHasAsScala(scope.collections()).asScala().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$collectionExists$4(collection$1, x$2))));
        return foundCollection.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$2(String scopeName$1, CollectionsManifestScope x$4) {
        String string = x$4.name();
        String string2 = scopeName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$scopeExists$1(String scopeName$1, CollectionsManifest x$3) {
        return CollectionConverters$.MODULE$.ListHasAsScala(x$3.scopes()).asScala().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReactiveCollectionManager.$anonfun$scopeExists$2(scopeName$1, x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$getScope$2(String scopeName$2, ScopeSpec x$5) {
        String string = x$5.name();
        String string2 = scopeName$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ReactiveCollectionManager(AsyncBucket bucket) {
        this.bucket = bucket;
        this.core = bucket.core();
        this.defaultManagerTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.defaultRetryStrategy = this.core().context().environment().retryStrategy();
    }
}

