/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.InsertResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=b!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\ti\u0011J\\:feRD\u0015M\u001c3mKJT!a\u0002\u0005\u0002\u0011!\fg\u000e\u001a7feNT!!\u0003\u0006\u0002\u0005-4(BA\u0006\r\u0003\u0015\u00198-\u00197b\u0015\tia\"\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u001fA\t\u0011bY8vG\"\u0014\u0017m]3\u000b\u0003E\t1aY8n'\r\u00011\u0003\u0007\t\u0003)Yi\u0011!\u0006\u0006\u0002\u0017%\u0011q#\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\teQB$J\u0007\u0002\r%\u00111D\u0002\u0002\u0017\u0017\u0016Lh+\u00197vKJ+\u0017/^3ti\"\u000bg\u000e\u001a7feB\u0011QdI\u0007\u0002=)\u0011\u0011b\b\u0006\u0003A\u0005\n1!\\:h\u0015\t\u0011C\"\u0001\u0003d_J,\u0017B\u0001\u0013\u001f\u00059Ien]3siJ+7\u000f]8og\u0016\u0004\"AJ\u0014\u000e\u0003!I!\u0001\u000b\u0005\u0003\u001d5+H/\u0019;j_:\u0014Vm];mi\u0006\u0011\u0001\u000e]\u0002\u0001!\taS&D\u0001\u000b\u0013\tq#BA\u0007IC:$G.\u001a:QCJ\fWn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005E\u0012\u0004CA\r\u0001\u0011\u0015I#\u00011\u0001,\u0003\u001d\u0011X-];fgR,\"!\u000e)\u0015\u0017YzD*\u00171f_^|\u0018\u0011\u0002\t\u0004oibT\"\u0001\u001d\u000b\u0005e*\u0012\u0001B;uS2L!a\u000f\u001d\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001e{%\u0011aH\b\u0002\u000e\u0013:\u001cXM\u001d;SKF,Xm\u001d;\t\u000b\u0001\u001b\u0001\u0019A!\u0002\u0005%$\u0007C\u0001\"J\u001d\t\u0019u\t\u0005\u0002E+5\tQI\u0003\u0002GU\u00051AH]8pizJ!\u0001S\u000b\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011VAQ!T\u0002A\u00029\u000bqaY8oi\u0016tG\u000f\u0005\u0002P!2\u0001A!B)\u0004\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006C\u0001\u000bU\u0013\t)VCA\u0004O_RD\u0017N\\4\u0011\u0005Q9\u0016B\u0001-\u0016\u0005\r\te.\u001f\u0005\u00065\u000e\u0001\raW\u0001\u000bIV\u0014\u0018MY5mSRL\bC\u0001/_\u001b\u0005i&B\u0001.\u000b\u0013\tyVL\u0001\u0006EkJ\f'-\u001b7jifDQ!Y\u0002A\u0002\t\f1#\u001a=qSJLX\t]8dQRKW.Z*fGN\u0004\"\u0001F2\n\u0005\u0011,\"\u0001\u0002'p]\u001eDQAZ\u0002A\u0002\u001d\fq\u0001^5nK>,H\u000f\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A/[7f\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\u0011\u0011+(/\u0019;j_:DQ\u0001]\u0002A\u0002E\fQB]3uef\u001cFO]1uK\u001eL\bC\u0001:v\u001b\u0005\u0019(B\u0001;\"\u0003\u0015\u0011X\r\u001e:z\u0013\t18OA\u0007SKR\u0014\u0018p\u0015;sCR,w-\u001f\u0005\u0006q\u000e\u0001\r!_\u0001\u000biJ\fgn]2pI\u0016\u0014\bC\u0001>~\u001b\u0005Y(B\u0001?\u000b\u0003\u0015\u0019w\u000eZ3d\u0013\tq8P\u0001\u0006Ue\u0006t7oY8eKJDq!!\u0001\u0004\u0001\u0004\t\u0019!\u0001\u0006tKJL\u0017\r\\5{KJ\u0004BA_A\u0003\u001d&\u0019\u0011qA>\u0003\u001d)\u001bxN\\*fe&\fG.\u001b>fe\"9\u00111B\u0002A\u0002\u00055\u0011A\u00039be\u0016tGo\u00159b]B)A#a\u0004\u0002\u0014%\u0019\u0011\u0011C\u000b\u0003\r=\u0003H/[8o!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\rC\u0005\u00191M\\2\n\t\u0005u\u0011q\u0003\u0002\f%\u0016\fX/Z:u'B\fg.\u0001\u0005sKN\u0004xN\\:f)\u001d)\u00131EA\u0016\u0003[Aaa\r\u0003A\u0002\u0005\u0015\u0002\u0003B\u000f\u0002(qI1!!\u000b\u001f\u0005=YU-\u001f,bYV,'+Z9vKN$\b\"\u0002!\u0005\u0001\u0004\t\u0005BBA\u0010\t\u0001\u0007A\u0004")
public class InsertHandler
implements KeyValueRequestHandler<InsertResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<InsertRequest> request(String id, T content, Durability durability, long expiryEpochTimeSecs, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try<EncodedValue> try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable)x$6 -> {
            String string = x$6;
            return Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable)x$5 -> {
                Object object = x$5;
                return Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable)x$4 -> {
                    Object object = x$4;
                    return Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable)x$3 -> {
                        Object object = x$3;
                        return Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable)x$2 -> {
                            Object object = x$2;
                            return Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable)x$1 -> {
                                Object object = x$1;
                                return null;
                            });
                        });
                    });
                });
            });
        });
        if (validations.isFailure()) {
            return validations;
        }
        RequestSpan span = this.hp.tracer().requestSpan("insert", (RequestSpan)parentSpan.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        RequestSpan encodeSpan = CbTracing.newSpan((RequestTracer)this.hp.tracer(), (String)"request_encoding", (RequestSpan)span);
        long start = System.nanoTime();
        Transcoder transcoder2 = transcoder;
        if (transcoder2 instanceof TranscoderWithSerializer) {
            TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
            try_ = transcoderWithSerializer.encode(content, serializer);
        } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
            TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
            try_ = transcoderWithoutSerializer.encode(content);
        } else {
            throw new MatchError((Object)transcoder2);
        }
        Try<EncodedValue> encoded = try_;
        long end = System.nanoTime();
        encodeSpan.end();
        Try<EncodedValue> try_2 = encoded;
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            EncodedValue en = (EncodedValue)success.value();
            InsertRequest out = new InsertRequest(id, en.encoded(), expiryEpochTimeSecs, en.flags(), timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
            out.context().encodeLatency(end - start);
            return new Success((Object)out);
        }
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable err = failure.exception();
            return new Failure((Throwable)new EncodingFailureException(err));
        }
        throw new MatchError(try_2);
    }

    @Override
    public MutationResult response(KeyValueRequest<InsertResponse> request, String id, InsertResponse response) {
        ResponseStatus responseStatus = response.status();
        if (ResponseStatus.EXISTS.equals(responseStatus) ? true : ResponseStatus.NOT_STORED.equals(responseStatus)) {
            KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (Response)response);
            throw new DocumentExistsException((ErrorContext)ctx);
        }
        if (ResponseStatus.SUCCESS.equals(responseStatus)) {
            return new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        }
        throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
    }

    public InsertHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

