/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u00115a\u0001\u0002'N\u0001YC\u0001\u0002\u0018\u0001\u0003\u0002\u0013\u0006I!\u0018\u0005\nM\u0002\u0011)\u0019!C\u0001\u001b\u001eD\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\na\u0002\u0011)\u0019!C\u0001\u001bFD\u0011\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002:\t\u0017\u0005\r\u0001A!b\u0001\n\u0003i\u0015Q\u0001\u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\u000b\u0003?\u0001!\u0019!C\u0002\u001b\u0006\u0005\u0002\u0002CA\u0018\u0001\u0001\u0006I!a\t\t\u0011\r\u0004!\u0019!C\u0001\u0003cAq!a\r\u0001A\u0003%\u0001\rC\u0005m\u0001\t\u0007I\u0011A)\u00026!A\u0011q\b\u0001!\u0002\u0013\t9\u0004\u0003\u0006\u0002B\u0001\u0011\r\u0011\"\u0001N\u0003\u0007B\u0001\"a\u0013\u0001A\u0003%\u0011Q\t\u0005\u000b\u0003\u001b\u0002!\u0019!C\u0001\u001b\u0006=\u0003\u0002CA/\u0001\u0001\u0006I!!\u0015\t\u0015\u0005}\u0003A1A\u0005\u00025\u000by\u0005\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA)\u0011)\t\u0019\u0007\u0001b\u0001\n\u0003i\u0015Q\r\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002h!Q\u0011Q\u000f\u0001C\u0002\u0013\u0005Q*a\u001e\t\u0011\u0005%\u0005\u0001)A\u0005\u0003sB!\"a#\u0001\u0005\u0004%\t!TAG\u0011!\t)\n\u0001Q\u0001\n\u0005=\u0005BCAL\u0001\t\u0007I\u0011A'\u0002\u001a\"A\u0011\u0011\u0015\u0001!\u0002\u0013\tY\nC\u0006\u0002$\u0002A)\u0019!C\u0001\u001b\u0006\u0015\u0006bCA\\\u0001!\u0015\r\u0011\"\u0001N\u0003sC1\"a2\u0001\u0011\u000b\u0007I\u0011A'\u0002J\"Q\u0011q\u001b\u0001C\u0002\u0013\u0005Q*!7\t\u0011\u0005E\b\u0001)A\u0005\u00037D!\"a=\u0001\u0005\u0004%\t!TA{\u0011!\ti\u0010\u0001Q\u0001\n\u0005]\bBCA\u0000\u0001!\u0015\r\u0011\"\u0001\u0003\u0002!Q!\u0011\u0002\u0001\t\u0006\u0004%\tAa\u0003\t\u0015\tM\u0001\u0001#b\u0001\n\u0003\u0011)\u0002\u0003\u0006\u0003\"\u0001A)\u0019!C\u0001\u0005GA!B!\r\u0001\u0011\u000b\u0007I\u0011\u0001B\u001a\u0011)\u0011Y\u0004\u0001EC\u0002\u0013\u0005!Q\b\u0005\b\u0003\u0003\u0004A\u0011\u0001B1\u0011\u001d\t\u0019\t\u0001C\u0001\u0005[Bq!a!\u0001\t\u0003\u0011Y\tC\u0005\u0003(\u0002\t\n\u0011\"\u0001\u0003*\"I!Q\u0018\u0001\u0012\u0002\u0013\u0005!q\u0018\u0005\n\u0005\u0007\u0004\u0011\u0013!C\u0001\u0005\u000bDqA!3\u0001\t\u0003\u0011Y\rC\u0004\u0003J\u0002!\tAa9\t\u0013\tE\b!%A\u0005\u0002\tM\b\"\u0003B|\u0001E\u0005I\u0011\u0001B`\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005wDqA!?\u0001\t\u0003\u0019I\u0003C\u0005\u00042\u0001\t\n\u0011\"\u0001\u0003@\"911\u0007\u0001\u0005\u0002\rU\u0002\"CB!\u0001E\u0005I\u0011\u0001B`\u0011\u001d\u0019\u0019\u0005\u0001C\u0001\u0007\u000bB\u0011ba\u0016\u0001#\u0003%\ta!\u0017\t\u000f\r\r\u0003\u0001\"\u0001\u0004^!911\u000e\u0001\u0005\u0002\r5\u0004\"CB@\u0001E\u0005I\u0011ABA\u0011\u001d\u0019Y\u0007\u0001C\u0001\u0007\u000bCqaa$\u0001\t\u0003\u0019\t\nC\u0004\u0004\u0010\u0002!\ta!&\t\u0011\r\u0005\u0006\u0001\"\u0001N\u0007G;qa!*N\u0011\u0003\u00199K\u0002\u0004M\u001b\"\u00051\u0011\u0016\u0005\b\u0003\u001f\u0019E\u0011ABV\u0011\u001d\u0019ik\u0011C\u0001\u0007_Cqa!,D\t\u0003\u00199\rC\u0004\u0004.\u000e#\taa5\t\u0011\te8\t\"\u0001P\u00073D\u0001ba=D\t\u0003y5Q\u001f\u0005\t\u0007g\u001cE\u0011A(\u0004\u0000\"AA1A\"\u0005\u0002=#)A\u0001\u0007Bgft7m\u00117vgR,'O\u0003\u0002O\u001f\u0006)1oY1mC*\u0011\u0001+U\u0001\u0007G2LWM\u001c;\u000b\u0005I\u001b\u0016!C2pk\u000eD'-Y:f\u0015\u0005!\u0016aA2p[\u000e\u00011C\u0001\u0001X!\tA&,D\u0001Z\u0015\u0005q\u0015BA.Z\u0005\u0019\te.\u001f*fM\u0006YQM\u001c<je>tW.\u001a8u!\rAf\fY\u0005\u0003?f\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003C\u0012l\u0011A\u0019\u0006\u0003G6\u000b1!\u001a8w\u0013\t)'M\u0001\nDYV\u001cH/\u001a:F]ZL'o\u001c8nK:$\u0018!D1vi\",g\u000e^5dCR|'/F\u0001i!\tIW.D\u0001k\u0015\t\u00197N\u0003\u0002m\u001f\u0006!1m\u001c:f\u0013\tq'NA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003%\u0019X-\u001a3O_\u0012,7/F\u0001s!\r\u0019(0 \b\u0003ib\u0004\"!^-\u000e\u0003YT!a^+\u0002\rq\u0012xn\u001c;?\u0013\tI\u0018,\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u00141aU3u\u0015\tI\u0018\f\u0005\u0002b}&\u0011qP\u0019\u0002\t'\u0016,GMT8eK\u0006Q1/Z3e\u001d>$Wm\u001d\u0011\u0002!\r|gN\\3di&|gn\u0015;sS:<WCAA\u0004!\r\u0019\u0018\u0011B\u0005\u0004\u0003\u0017a(AB*ue&tw-A\td_:tWm\u0019;j_:\u001cFO]5oO\u0002\na\u0001P5oSRtDCCA\n\u0003/\tI\"a\u0007\u0002\u001eA\u0019\u0011Q\u0003\u0001\u000e\u00035Ca\u0001\u0018\u0005\u0005\u0002\u0004i\u0006\"\u00024\t\u0001\u0004A\u0007\"\u00029\t\u0001\u0004\u0011\bbBA\u0002\u0011\u0001\u0007\u0011qA\u0001\u0003K\u000e,\"!a\t\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000bZ\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003[\t9C\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0016\u0003\u0001\fA!\u001a8wAU\u0011\u0011q\u0007\t\u0005\u0003s\tY$D\u0001l\u0013\r\tid\u001b\u0002\u0005\u0007>\u0014X-A\u0003d_J,\u0007%\u0001\u0002iaV\u0011\u0011Q\t\t\u0005\u0003+\t9%C\u0002\u0002J5\u0013!\u0003S1oI2,'OQ1tS\u000e\u0004\u0016M]1ng\u0006\u0019\u0001\u000e\u001d\u0011\u0002\u001bM,\u0017M]2i)&lWm\\;u+\t\t\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\u0011\t9&a\n\u0002\u0011\u0011,(/\u0019;j_:LA!a\u0017\u0002V\tAA)\u001e:bi&|g.\u0001\btK\u0006\u00148\r\u001b+j[\u0016|W\u000f\u001e\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001cH+[7f_V$\u0018!E1oC2LH/[2t)&lWm\\;uA\u0005i!/\u001a;ssN#(/\u0019;fOf,\"!a\u001a\u0011\t\u0005%\u0014qN\u0007\u0003\u0003WR1!!\u001cl\u0003\u0015\u0011X\r\u001e:z\u0013\u0011\t\t(a\u001b\u0003\u001bI+GO]=TiJ\fG/Z4z\u00039\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0002\nA\"];fefD\u0015M\u001c3mKJ,\"!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006A\u0001.\u00198eY\u0016\u00148OC\u0002\u0002\u00046\u000bQ!];fefLA!a\"\u0002~\ta\u0011+^3ss\"\u000bg\u000e\u001a7fe\u0006i\u0011/^3ss\"\u000bg\u000e\u001a7fe\u0002\n\u0001#\u00198bYf$\u0018nY:IC:$G.\u001a:\u0016\u0005\u0005=\u0005\u0003BA>\u0003#KA!a%\u0002~\t\u0001\u0012I\\1msRL7m\u001d%b]\u0012dWM]\u0001\u0012C:\fG.\u001f;jGND\u0015M\u001c3mKJ\u0004\u0013!D:fCJ\u001c\u0007\u000eS1oI2,'/\u0006\u0002\u0002\u001cB!\u00111PAO\u0013\u0011\ty*! \u0003\u001bM+\u0017M]2i\u0011\u0006tG\r\\3s\u00039\u0019X-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0002\n1C]3bGRLg/Z+tKJl\u0015M\\1hKJ,\"!a*\u0011\t\u0005%\u00161W\u0007\u0003\u0003WSA!!,\u00020\u0006!Qo]3s\u0015\r\t\t,T\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\t),a+\u0003'I+\u0017m\u0019;jm\u0016,6/\u001a:NC:\fw-\u001a:\u0002+I,\u0017m\u0019;jm\u0016\u0014UoY6fi6\u000bg.Y4feV\u0011\u00111\u0018\t\u0005\u0003{\u000b\u0019-\u0004\u0002\u0002@*!\u0011\u0011YAX\u0003\u0019\u0011WoY6fi&!\u0011QYA`\u0005U\u0011V-Y2uSZ,')^2lKRl\u0015M\\1hKJ\fQD]3bGRLg/Z!oC2LH/[2t\u0013:$W\r_'b]\u0006<WM]\u000b\u0003\u0003\u0017\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0005\u0003#\fy+A\u0005b]\u0006d\u0017\u0010^5dg&!\u0011Q[Ah\u0005u\u0011V-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014\u0018\u0001F#naRLh*Y7fIB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002\\BA\u0011Q\\At\u0003\u000f\tY/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003%IW.\\;uC\ndWMC\u0002\u0002ff\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI/a8\u0003\u00075\u000b\u0007\u000fE\u0002Y\u0003[L1!a<Z\u0005\r\te._\u0001\u0016\u000b6\u0004H/\u001f(b[\u0016$\u0007+\u0019:b[\u0016$XM]:!\u0003e)U\u000e\u001d;z!>\u001c\u0018\u000e^5p]\u0006d\u0007+\u0019:b[\u0016$XM]:\u0016\u0005\u0005]\bCBAo\u0003s\fY/\u0003\u0003\u0002|\u0006}'aA*fc\u0006QR)\u001c9usB{7/\u001b;j_:\fG\u000eU1sC6,G/\u001a:tA\u00059!-^2lKR\u001cXC\u0001B\u0002!\u0011\tiL!\u0002\n\t\t\u001d\u0011q\u0018\u0002\u0013\u0003NLhn\u0019\"vG.,G/T1oC\u001e,'/A\u0003vg\u0016\u00148/\u0006\u0002\u0003\u000eA!\u0011\u0011\u0016B\b\u0013\u0011\u0011\t\"a+\u0003!\u0005\u001b\u0018P\\2Vg\u0016\u0014X*\u00198bO\u0016\u0014\u0018\u0001D9vKJL\u0018J\u001c3fq\u0016\u001cXC\u0001B\f!\u0011\u0011IB!\b\u000e\u0005\tm!\u0002BAB\u0003_KAAa\b\u0003\u001c\t1\u0012i]=oGF+XM]=J]\u0012,\u00070T1oC\u001e,'/A\u0007tK\u0006\u00148\r[%oI\u0016DXm]\u000b\u0003\u0005K\u0001BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0005\u0005W\ty+\u0001\u0004tK\u0006\u00148\r[\u0005\u0005\u0005_\u0011ICA\fBgft7mU3be\u000eD\u0017J\u001c3fq6\u000bg.Y4fe\u0006\u0001\u0012M\\1msRL7m]%oI\u0016DXm]\u000b\u0003\u0005k\u0001B!!4\u00038%!!\u0011HAh\u0005i\t5/\u001f8d\u0003:\fG.\u001f;jGNLe\u000eZ3y\u001b\u0006t\u0017mZ3s\u0003E)g/\u001a8uS:<g)\u001e8di&|gn]\u000b\u0003\u0005\u007f\u0001BA!\u0011\u0003H5\u0011!1\t\u0006\u0005\u0005\u000b\ny+\u0001\u0005fm\u0016tG/\u001b8h\u0013\u0011\u0011IEa\u0011\u00039\u0005\u001b\u0018P\\2Fm\u0016tG/\u001b8h\rVt7\r^5p]6\u000bg.Y4fe\"\u001a\u0011F!\u0014\u0011\t\t=#1\f\b\u0005\u0005#\u00129&\u0004\u0002\u0003T)\u0019!QK6\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003Z\tM\u0013!C*uC\nLG.\u001b;z\u0013\u0011\u0011iFa\u0018\u0003\u0017Us7m\\7nSR$X\r\u001a\u0006\u0005\u00053\u0012\u0019\u0006\u0006\u0003\u0003d\t%\u0004\u0003BA\u000b\u0005KJ1Aa\u001aN\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\t\u000f\t-$\u00061\u0001\u0002\b\u0005Q!-^2lKRt\u0015-\\3\u0015\r\t=$Q\u0010BA!\u0019\t)C!\u001d\u0003v%!!1OA\u0014\u0005\u00191U\u000f^;sKB!!q\u000fB=\u001b\t\t\t)\u0003\u0003\u0003|\u0005\u0005%aC)vKJL(+Z:vYRDqAa ,\u0001\u0004\t9!A\u0005ti\u0006$X-\\3oi\"9!1Q\u0016A\u0002\t\u0015\u0015aB8qi&|gn\u001d\t\u0005\u0005o\u00129)\u0003\u0003\u0003\n\u0006\u0005%\u0001D)vKJLx\n\u001d;j_:\u001cHC\u0003B8\u0005\u001b\u0013yI!'\u0003\u001e\"9!q\u0010\u0017A\u0002\u0005\u001d\u0001\"\u0003BIYA\u0005\t\u0019\u0001BJ\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0005o\u0012)*\u0003\u0003\u0003\u0018\u0006\u0005%aD)vKJL\b+\u0019:b[\u0016$XM]:\t\u0013\tmE\u0006%AA\u0002\u0005E\u0013a\u0002;j[\u0016|W\u000f\u001e\u0005\n\u0005?c\u0003\u0013!a\u0001\u0005C\u000bQ!\u00193i_\u000e\u00042\u0001\u0017BR\u0013\r\u0011)+\u0017\u0002\b\u0005>|G.Z1o\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001BVU\u0011\u0011\u0019J!,,\u0005\t=\u0006\u0003\u0002BY\u0005sk!Aa-\u000b\t\tU&qW\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0016Z\u0013\u0011\u0011YLa-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tM\u000b\u0003\u0002R\t5\u0016aD9vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u001d'\u0006\u0002BQ\u0005[\u000ba\"\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\u0006\u0004\u0003N\ne'1\u001c\t\u0007\u0003K\u0011\tHa4\u0011\t\tE'Q[\u0007\u0003\u0005'T1!!5N\u0013\u0011\u00119Na5\u0003\u001f\u0005s\u0017\r\\=uS\u000e\u001c(+Z:vYRDqAa 1\u0001\u0004\t9\u0001C\u0004\u0003\u0004B\u0002\rA!8\u0011\t\tE'q\\\u0005\u0005\u0005C\u0014\u0019N\u0001\tB]\u0006d\u0017\u0010^5dg>\u0003H/[8ogRA!Q\u001aBs\u0005O\u0014y\u000fC\u0004\u0003\u0000E\u0002\r!a\u0002\t\u0013\tE\u0015\u0007%AA\u0002\t%\b\u0003\u0002Bi\u0005WLAA!<\u0003T\n\u0019\u0012I\\1msRL7m\u001d)be\u0006lW\r^3sg\"I!1T\u0019\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u0019C:\fG.\u001f;jGN\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001B{U\u0011\u0011IO!,\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$3'A\u0006tK\u0006\u00148\r[)vKJLH\u0003\u0003B\u007f\u0007\u001b\u0019\tba\b\u0011\r\u0005\u0015\"\u0011\u000fB\u0000!\u0011\u0019\ta!\u0003\u000e\u0005\r\r!\u0002BB\u0003\u0007\u000f\taA]3tk2$(b\u0001B\u0016\u001b&!11BB\u0002\u00051\u0019V-\u0019:dQJ+7/\u001e7u\u0011\u001d\u0019y\u0001\u000ea\u0001\u0003\u000f\t\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005\rE\u00071\u0001\u0004\u0014A!1QCB\u000e\u001b\t\u00199B\u0003\u0003\u0004\u001a\r\u001d\u0011aB9vKJLWm]\u0005\u0005\u0007;\u00199BA\u0006TK\u0006\u00148\r[)vKJL\bb\u0002BBi\u0001\u00071\u0011\u0005\t\u0005\u0007G\u0019)#\u0004\u0002\u0004\b%!1qEB\u0004\u00055\u0019V-\u0019:dQ>\u0003H/[8ogRA!Q`B\u0016\u0007[\u0019y\u0003C\u0004\u0004\u0010U\u0002\r!a\u0002\t\u000f\u0005\rU\u00071\u0001\u0004\u0014!I!1T\u001b\u0011\u0002\u0003\u0007\u0011\u0011K\u0001\u0016g\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0005\u0007o\u0019y\u0004\u0005\u0004\u0002&\tE4\u0011\b\t\u00041\u000em\u0012bAB\u001f3\n!QK\\5u\u0011%\u0011Yj\u000eI\u0001\u0002\u0004\t\t&\u0001\u000beSN\u001cwN\u001c8fGR$C-\u001a4bk2$H%M\u0001\fI&\fwM\\8ti&\u001c7\u000f\u0006\u0003\u0004H\rM\u0003CBA\u0013\u0005c\u001aI\u0005\u0005\u0003\u0004L\r=SBAB'\u0015\r\u0019\u0019e[\u0005\u0005\u0007#\u001aiEA\tES\u0006<gn\\:uS\u000e\u001c(+Z:vYRD\u0011b!\u0016:!\u0003\u0005\r!a\u0002\u0002\u0011I,\u0007o\u001c:u\u0013\u0012\fQ\u0003Z5bO:|7\u000f^5dg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\\)\"\u0011q\u0001BW)\u0011\u00199ea\u0018\t\u000f\t\r5\b1\u0001\u0004bA!11MB4\u001b\t\u0019)GC\u0002\u0004D5KAa!\u001b\u0004f\t\u0011B)[1h]>\u001cH/[2t\u001fB$\u0018n\u001c8t\u0003\u0011\u0001\u0018N\\4\u0015\t\r=4q\u000f\t\u0007\u0003K\u0011\th!\u001d\u0011\t\r-31O\u0005\u0005\u0007k\u001aiE\u0001\u0006QS:<'+Z:vYRD\u0011Ba'=!\u0003\u0005\ra!\u001f\u0011\u000ba\u001bY(!\u0015\n\u0007\ru\u0014L\u0001\u0004PaRLwN\\\u0001\u000fa&tw\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019\u0019I\u000b\u0003\u0004z\t5F\u0003BB8\u0007\u000fCqAa!?\u0001\u0004\u0019I\t\u0005\u0003\u0004d\r-\u0015\u0002BBG\u0007K\u00121\u0002U5oO>\u0003H/[8og\u0006qq/Y5u+:$\u0018\u000e\u001c*fC\u0012LH\u0003BB\u001c\u0007'CqAa'@\u0001\u0004\t\t\u0006\u0006\u0004\u00048\r]5\u0011\u0014\u0005\b\u00057\u0003\u0005\u0019AA)\u0011\u001d\u0011\u0019\t\u0011a\u0001\u00077\u0003Baa\u0019\u0004\u001e&!1qTB3\u0005U9\u0016-\u001b;V]RLGNU3bIf|\u0005\u000f^5p]N\fA\u0003]3sM>\u0014Xn\u00127pE\u0006d7i\u001c8oK\u000e$HCAB\u001d\u00031\t5/\u001f8d\u00072,8\u000f^3s!\r\t)bQ\n\u0003\u0007^#\"aa*\u0002\u000f\r|gN\\3diRA1\u0011WB_\u0007\u007f\u001b\u0019\r\u0005\u0004\u00044\u000ee\u00161C\u0007\u0003\u0007kS1aa.Z\u0003\u0011)H/\u001b7\n\t\rm6Q\u0017\u0002\u0004)JL\bbBA\u0002\u000b\u0002\u0007\u0011q\u0001\u0005\b\u0007\u0003,\u0005\u0019AA\u0004\u0003!)8/\u001a:oC6,\u0007bBBc\u000b\u0002\u0007\u0011qA\u0001\ta\u0006\u001c8o^8sIR11\u0011WBe\u0007\u0017Dq!a\u0001G\u0001\u0004\t9\u0001C\u0004\u0003\u0004\u001a\u0003\ra!4\u0011\t\u0005U1qZ\u0005\u0004\u0007#l%AD\"mkN$XM](qi&|gn\u001d\u000b\u0007\u0007c\u001b)na6\t\u000bA<\u0005\u0019\u0001:\t\u000f\t\ru\t1\u0001\u0004NR111\\Bp\u0007c$BA!@\u0004^\"9\u0011q\u0004%A\u0004\u0005\r\u0002bBBq\u0011\u0002\u000711]\u0001\be\u0016\fX/Z:u!\u0011\u0019)o!<\u000e\u0005\r\u001d(\u0002\u0002B\u0016\u0007ST1aa;l\u0003\ri7oZ\u0005\u0005\u0007_\u001c9OA\u0007TK\u0006\u00148\r\u001b*fcV,7\u000f\u001e\u0005\u0007Y\"\u0003\r!a\u000e\u00023\u0015DHO]1di\u000ecWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e\u001e\u000b\u0007\u0007o\u001cIpa?\u0011\u000b\rM6\u0011\u00181\t\u000f\u0005\r\u0011\n1\u0001\u0002\b!91Q`%A\u0002\r5\u0017\u0001B8qiN$Baa>\u0005\u0002!91Q &A\u0002\r5\u0017!H:fK\u0012tu\u000eZ3t\rJ|WnQ8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\u0015\u000bI$9\u0001b\u0003\t\u000f\u0011%1\n1\u0001\u0002\b\u0005\u00111m\u001d\u0005\u00069.\u0003\r\u0001\u0019")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final String connectionString;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(seedNodes, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(connectionString, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return AsyncCluster$.MODULE$.connect(connectionString, username, password);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.reactiveUserManager$lzycompute();
        }
        return this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.reactiveBucketManager$lzycompute();
        }
        return this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.reactiveAnalyticsIndexManager$lzycompute();
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.buckets$lzycompute();
        }
        return this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.users$lzycompute();
        }
        return this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.queryIndexes$lzycompute();
        }
        return this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.searchIndexes$lzycompute();
        }
        return this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.analyticsIndexes$lzycompute();
        }
        return this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.eventingFunctions$lzycompute();
        }
        return this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            return this.analyticsHandler().queryAsync(request, this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            return AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            return Future$.MODULE$.failed(err);
        }
        throw new MatchError(try_);
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            if (this.env().owned()) {
                return this.env().shutdownInternal(timeout);
            }
            return SMono$.MODULE$.empty();
        })).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes, String connectionString) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.connectionString = connectionString;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)CollectionConverters$.MODULE$.SetHasAsJava((Set)seedNodes.map((Function1 & Serializable)x$1 -> x$1.toCore())).asJava(), (String)connectionString);
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)package$.MODULE$.Seq().empty();
    }
}

