/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.ReplaceResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.codec.TranscoderWithSerializer;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionalGeneric$;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandler;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005ub!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000f\u00055\u0002\u0001\"\u0001\u00020\tq!+\u001a9mC\u000e,\u0007*\u00198eY\u0016\u0014(BA\u0004\t\u0003!A\u0017M\u001c3mKJ\u001c(BA\u0005\u000b\u0003\tYgO\u0003\u0002\f\u0019\u0005)1oY1mC*\u0011QBD\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0001\u0012!C2pk\u000eD'-Y:f\u0015\u0005\t\u0012aA2p[N\u0019\u0001a\u0005\r\u0011\u0005Q1R\"A\u000b\u000b\u0003-I!aF\u000b\u0003\r\u0005s\u0017PU3g!\u0011I\"\u0004H\u0013\u000e\u0003\u0019I!a\u0007\u0004\u0003--+\u0017PV1mk\u0016\u0014V-];fgRD\u0015M\u001c3mKJ\u0004\"!H\u0012\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\n\u0013aA7tO*\u0011!\u0005D\u0001\u0005G>\u0014X-\u0003\u0002%=\ty!+\u001a9mC\u000e,'+Z:q_:\u001cX\r\u0005\u0002'O5\t\u0001\"\u0003\u0002)\u0011\tqQ*\u001e;bi&|gNU3tk2$\u0018A\u00015q\u0007\u0001\u0001\"\u0001L\u0017\u000e\u0003)I!A\f\u0006\u0003\u001b!\u000bg\u000e\u001a7feB\u000b'/Y7t\u0003\u0019a\u0014N\\5u}Q\u0011\u0011G\r\t\u00033\u0001AQ!\u000b\u0002A\u0002-\nqA]3rk\u0016\u001cH/\u0006\u00026!Rqag\u0010'Z=\u0016<GN\u001e@\u0002\u000e\u0005]\u0001cA\u001c;y5\t\u0001H\u0003\u0002:+\u0005!Q\u000f^5m\u0013\tY\u0004HA\u0002Uef\u0004\"!H\u001f\n\u0005yr\"A\u0004*fa2\f7-\u001a*fcV,7\u000f\u001e\u0005\u0006\u0001\u000e\u0001\r!Q\u0001\u0003S\u0012\u0004\"AQ%\u000f\u0005\r;\u0005C\u0001#\u0016\u001b\u0005)%B\u0001$+\u0003\u0019a$o\\8u}%\u0011\u0001*F\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I+!)Qj\u0001a\u0001\u001d\u000691m\u001c8uK:$\bCA(Q\u0019\u0001!Q!U\u0002C\u0002I\u0013\u0011\u0001V\t\u0003'Z\u0003\"\u0001\u0006+\n\u0005U+\"a\u0002(pi\"Lgn\u001a\t\u0003)]K!\u0001W\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003[\u0007\u0001\u00071,A\u0002dCN\u0004\"\u0001\u0006/\n\u0005u+\"\u0001\u0002'p]\u001eDQaX\u0002A\u0002\u0001\f!\u0002Z;sC\nLG.\u001b;z!\t\t7-D\u0001c\u0015\ty&\"\u0003\u0002eE\nQA)\u001e:bE&d\u0017\u000e^=\t\u000b\u0019\u001c\u0001\u0019A.\u0002'\u0015D\b/\u001b:z\u000bB|7\r\u001b+j[\u0016\u001cVmY:\t\u000b!\u001c\u0001\u0019A5\u0002\u001dA\u0014Xm]3sm\u0016,\u0005\u0010]5ssB\u0011AC[\u0005\u0003WV\u0011qAQ8pY\u0016\fg\u000eC\u0003n\u0007\u0001\u0007a.A\u0004uS6,w.\u001e;\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018\u0001\u0002;j[\u0016T\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002va\nAA)\u001e:bi&|g\u000eC\u0003x\u0007\u0001\u0007\u00010A\u0007sKR\u0014\u0018p\u0015;sCR,w-\u001f\t\u0003srl\u0011A\u001f\u0006\u0003w\u0006\nQA]3uefL!! >\u0003\u001bI+GO]=TiJ\fG/Z4z\u0011\u0019y8\u00011\u0001\u0002\u0002\u0005QAO]1og\u000e|G-\u001a:\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002\u000b\u0003\u0015\u0019w\u000eZ3d\u0013\u0011\tY!!\u0002\u0003\u0015Q\u0013\u0018M\\:d_\u0012,'\u000fC\u0004\u0002\u0010\r\u0001\r!!\u0005\u0002\u0015M,'/[1mSj,'\u000fE\u0003\u0002\u0004\u0005Ma*\u0003\u0003\u0002\u0016\u0005\u0015!A\u0004&t_:\u001cVM]5bY&TXM\u001d\u0005\b\u00033\u0019\u0001\u0019AA\u000e\u0003)\u0001\u0018M]3oiN\u0003\u0018M\u001c\t\u0006)\u0005u\u0011\u0011E\u0005\u0004\u0003?)\"AB(qi&|g\u000e\u0005\u0003\u0002$\u0005%RBAA\u0013\u0015\r\t9#I\u0001\u0004G:\u001c\u0017\u0002BA\u0016\u0003K\u00111BU3rk\u0016\u001cHo\u00159b]\u0006A!/Z:q_:\u001cX\rF\u0004&\u0003c\tI$a\u000f\t\rM\"\u0001\u0019AA\u001a!\u0011i\u0012Q\u0007\u000f\n\u0007\u0005]bDA\bLKf4\u0016\r\\;f%\u0016\fX/Z:u\u0011\u0015\u0001E\u00011\u0001B\u0011\u0019\ti\u0003\u0002a\u00019\u0001")
public class ReplaceHandler
implements KeyValueRequestHandler<ReplaceResponse, MutationResult> {
    private final HandlerParams hp;

    public <T> Try<ReplaceRequest> request(String id, T content, long cas, Durability durability, long expiryEpochTimeSecs, boolean preserveExpiry, Duration timeout, RetryStrategy retryStrategy, Transcoder transcoder, JsonSerializer<T> serializer, Option<RequestSpan> parentSpan) {
        Try try_;
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable)x$8 -> {
            String string = x$8;
            Try try_ = Validate$.MODULE$.notNull(content, "content").flatMap((Function1 & Serializable)x$7 -> {
                Object object = x$7;
                Try try_ = Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)cas), "cas").flatMap((Function1 & Serializable)x$6 -> {
                    Object object = x$6;
                    Try try_ = Validate$.MODULE$.notNull(durability, "durability").flatMap((Function1 & Serializable)x$5 -> {
                        Object object = x$5;
                        Try try_ = Validate$.MODULE$.notNull(BoxesRunTime.boxToLong((long)expiryEpochTimeSecs), "expiration").flatMap((Function1 & Serializable)x$4 -> {
                            Object object = x$4;
                            Try try_ = Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable)x$3 -> {
                                Object object = x$3;
                                Try try_ = Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable)x$2 -> {
                                    Object object = x$2;
                                    Try try_ = Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable)x$1 -> {
                                        Object object = x$1;
                                        ReplaceRequest replaceRequest = null;
                                        return replaceRequest;
                                    });
                                    return try_;
                                });
                                return try_;
                            });
                            return try_;
                        });
                        return try_;
                    });
                    return try_;
                });
                return try_;
            });
            return try_;
        });
        if (validations.isFailure()) {
            try_ = validations;
        } else {
            Failure failure;
            Try<EncodedValue> try_2;
            RequestSpan span = this.hp.tracer().requestSpan("replace", (RequestSpan)parentSpan.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            RequestSpan encodeSpan = CbTracing.newSpan((RequestTracer)this.hp.tracer(), (String)"request_encoding", (RequestSpan)span);
            long start = System.nanoTime();
            Transcoder transcoder2 = transcoder;
            if (transcoder2 instanceof TranscoderWithSerializer) {
                TranscoderWithSerializer transcoderWithSerializer = (TranscoderWithSerializer)transcoder2;
                try_2 = transcoderWithSerializer.encode(content, serializer);
            } else if (transcoder2 instanceof TranscoderWithoutSerializer) {
                TranscoderWithoutSerializer transcoderWithoutSerializer = (TranscoderWithoutSerializer)transcoder2;
                try_2 = transcoderWithoutSerializer.encode(content);
            } else {
                throw new MatchError((Object)transcoder2);
            }
            Try<EncodedValue> encoded = try_2;
            long end = System.nanoTime();
            encodeSpan.end();
            Try<EncodedValue> try_3 = encoded;
            if (try_3 instanceof Success) {
                Success success = (Success)try_3;
                EncodedValue en = (EncodedValue)success.value();
                ReplaceRequest out = new ReplaceRequest(id, en.encoded(), expiryEpochTimeSecs, preserveExpiry, en.flags(), timeout, cas, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, durability.toDurabilityLevel(), span);
                out.context().encodeLatency(end - start);
                failure = new Success((Object)out);
            } else if (try_3 instanceof Failure) {
                Failure failure2 = (Failure)try_3;
                Throwable err = failure2.exception();
                failure = new Failure((Throwable)new EncodingFailureException(err));
            } else {
                throw new MatchError(try_3);
            }
            try_ = failure;
        }
        return try_;
    }

    @Override
    public MutationResult response(KeyValueRequest<ReplaceResponse> request, String id, ReplaceResponse response) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        MutationResult mutationResult = new MutationResult(response.cas(), OptionConverters$RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(response.mutationToken())));
        return mutationResult;
    }

    public ReplaceHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

