/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.RawJsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.reflect.api.TypeTags;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0006\f\u0001YAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQ\u0001\u0010\u0001\u0005Bu:Q\u0001\\\u0006\t\u000254QAC\u0006\t\u00029DQ\u0001I\u0003\u0005\u0002]Dq\u0001_\u0003C\u0002\u0013\u0005\u0011\u0010\u0003\u0004{\u000b\u0001\u0006IA\t\u0005\bw\u0016\t\t\u0011\"\u0003}\u0005E\u0011\u0016m\u001e&t_:$&/\u00198tG>$WM\u001d\u0006\u0003\u00195\tQaY8eK\u000eT!AD\b\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005A\t\u0012AB2mS\u0016tGO\u0003\u0002\u0013'\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002)\u0005\u00191m\\7\u0004\u0001M\u0019\u0001a\u0006\u000f\u0011\u0005aQR\"A\r\u000b\u00039I!aG\r\u0003\r\u0005s\u0017PU3g!\tib$D\u0001\f\u0013\ty2BA\u000eUe\u0006t7oY8eKJ<\u0016\u000e\u001e5pkR\u001cVM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"!\b\u0001\u0002\r\u0015t7m\u001c3f+\t)3\u0007\u0006\u0002'_A\u0019qE\u000b\u0017\u000e\u0003!R!!K\r\u0002\tU$\u0018\u000e\\\u0005\u0003W!\u00121\u0001\u0016:z!\tiR&\u0003\u0002/\u0017\taQI\\2pI\u0016$g+\u00197vK\")\u0001G\u0001a\u0001c\u0005)a/\u00197vKB\u0011!g\r\u0007\u0001\t\u0015!$A1\u00016\u0005\u0005!\u0016C\u0001\u001c:!\tAr'\u0003\u000293\t9aj\u001c;iS:<\u0007C\u0001\r;\u0013\tY\u0014DA\u0002B]f\fa\u0001Z3d_\u0012,WC\u0001 C)\ry\u0004m\u001a\u000b\u0003\u0001\u000e\u00032a\n\u0016B!\t\u0011$\tB\u00035\u0007\t\u0007Q\u0007C\u0003E\u0007\u0001\u000fQ)A\u0002uC\u001e\u00042A\u0012.B\u001d\t9uK\u0004\u0002I):\u0011\u0011*\u0015\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!T\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0011B\u0001)\u001a\u0003\u001d\u0011XM\u001a7fGRL!AU*\u0002\u000fI,h\u000e^5nK*\u0011\u0001+G\u0005\u0003+Z\u000bq\u0001]1dW\u0006<WM\u0003\u0002S'&\u0011\u0001,W\u0001\tk:Lg/\u001a:tK*\u0011QKV\u0005\u00037r\u00131bV3bWRK\b/\u001a+bO&\u0011QL\u0018\u0002\t)f\u0004X\rV1hg*\u0011qlU\u0001\u0004CBL\u0007\"\u0002\u0019\u0004\u0001\u0004\t\u0007c\u0001\rcI&\u00111-\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00031\u0015L!AZ\r\u0003\t\tKH/\u001a\u0005\u0006Q\u000e\u0001\r![\u0001\u0006M2\fwm\u001d\t\u00031)L!a[\r\u0003\u0007%sG/A\tSC^T5o\u001c8Ue\u0006t7oY8eKJ\u0004\"!H\u0003\u0014\u0007\u00159r\u000e\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006\u0011\u0011n\u001c\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0007TKJL\u0017\r\\5{C\ndW\rF\u0001n\u0003!Ien\u001d;b]\u000e,W#\u0001\u0012\u0002\u0013%s7\u000f^1oG\u0016\u0004\u0013\u0001D<sSR,'+\u001a9mC\u000e,G#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\ta]\u0001\u0005Y\u0006tw-C\u0002\u0002\u0006}\u0014aa\u00142kK\u000e$\b")
public class RawJsonTranscoder
implements TranscoderWithoutSerializer {
    public static RawJsonTranscoder Instance() {
        return RawJsonTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        Success success;
        T t = value;
        if (t instanceof byte[]) {
            byte[] byArray = (byte[])t;
            success = new Success((Object)new EncodedValue(byArray, CodecFlags.JSON_COMPAT_FLAGS));
        } else if (t instanceof String) {
            String string = (String)t;
            success = new Success((Object)new EncodedValue(string.getBytes(StandardCharsets.UTF_8), CodecFlags.JSON_COMPAT_FLAGS));
        } else {
            success = new Failure((Throwable)new IllegalArgumentException("Only Array[Byte] and String types are supported for the RawJsonTranscoder!"));
        }
        return success;
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, TypeTags.WeakTypeTag<T> tag) {
        return ((Class)((Mirrors.RuntimeMirror)tag.mirror()).runtimeClass(tag.tpe())).isAssignableFrom(byte[].class) ? new Success((Object)value) : (((Class)((Mirrors.RuntimeMirror)tag.mirror()).runtimeClass(tag.tpe())).isAssignableFrom(String.class) ? new Success((Object)new String(value, StandardCharsets.UTF_8)) : new Failure((Throwable)new DecodingFailureException("RawJsonTranscoder can only decode into Array[Byte] or String!")));
    }
}

