/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0011\ra\u0001\u0002&L\u0001QC\u0001B\u0017\u0001\u0003\u0002\u0013\u0006Ia\u0017\u0005\nI\u0002\u0011)\u0019!C\u0001\u0017\u0016D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\n]\u0002\u0011)\u0019!C\u0001\u0017>D\u0001B \u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0015\u00055\u0001A1A\u0005\u0004-\u000by\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011!\t\u0007A1A\u0005\u0002\u0005}\u0001bBA\u0011\u0001\u0001\u0006IA\u0018\u0005\nU\u0002\u0011\r\u0011\"\u0001P\u0003GA\u0001\"!\f\u0001A\u0003%\u0011Q\u0005\u0005\u000b\u0003_\u0001!\u0019!C\u0001\u0017\u0006E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u0015\u0005m\u0002A1A\u0005\u0002-\u000bi\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA \u0011)\ti\u0005\u0001b\u0001\n\u0003Y\u0015Q\b\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002@!Q\u0011\u0011\u000b\u0001C\u0002\u0013\u00051*a\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003+B!\"a\u0019\u0001\u0005\u0004%\taSA3\u0011!\t9\b\u0001Q\u0001\n\u0005\u001d\u0004BCA=\u0001\t\u0007I\u0011A&\u0002|!A\u00111\u0011\u0001!\u0002\u0013\ti\b\u0003\u0006\u0002\u0006\u0002\u0011\r\u0011\"\u0001L\u0003\u000fC\u0001\"a$\u0001A\u0003%\u0011\u0011\u0012\u0005\f\u0003#\u0003\u0001R1A\u0005\u0002-\u000b\u0019\nC\u0006\u0002&\u0002A)\u0019!C\u0001\u0017\u0006\u001d\u0006bCA[\u0001!\u0015\r\u0011\"\u0001L\u0003oC!\"!2\u0001\u0005\u0004%\taSAd\u0011!\t)\u000f\u0001Q\u0001\n\u0005%\u0007BCAt\u0001\t\u0007I\u0011A&\u0002j\"A\u0011\u0011\u001f\u0001!\u0002\u0013\tY\u000f\u0003\u0006\u0002t\u0002A)\u0019!C\u0001\u0003kD!\"!@\u0001\u0011\u000b\u0007I\u0011AA\u0000\u0011)\u00119\u0001\u0001EC\u0002\u0013\u0005!\u0011\u0002\u0005\u000b\u0005+\u0001\u0001R1A\u0005\u0002\t]\u0001B\u0003B\u0013\u0001!\u0015\r\u0011\"\u0001\u0003(!Q!q\u0006\u0001\t\u0006\u0004%\tA!\r\t\u000f\u0005=\u0006\u0001\"\u0001\u0003V!9\u0011\u0011\u000f\u0001\u0005\u0002\t\u0005\u0004bBA9\u0001\u0011\u0005!q\u0010\u0005\n\u00057\u0003\u0011\u0013!C\u0001\u0005;C\u0011B!-\u0001#\u0003%\tAa-\t\u0013\t]\u0006!%A\u0005\u0002\te\u0006b\u0002B_\u0001\u0011\u0005!q\u0018\u0005\b\u0005{\u0003A\u0011\u0001Bl\u0011%\u0011)\u000fAI\u0001\n\u0003\u00119\u000fC\u0005\u0003l\u0002\t\n\u0011\"\u0001\u00034\"9!Q\u001e\u0001\u0005\u0002\t=\bb\u0002Bw\u0001\u0011\u00051Q\u0004\u0005\n\u0007K\u0001\u0011\u0013!C\u0001\u0005gCqaa\n\u0001\t\u0003\u0019I\u0003C\u0005\u00046\u0001\t\n\u0011\"\u0001\u00034\"91q\u0007\u0001\u0005\u0002\re\u0002\"CB&\u0001E\u0005I\u0011AB'\u0011\u001d\u00199\u0004\u0001C\u0001\u0007#Bqaa\u0018\u0001\t\u0003\u0019\t\u0007C\u0005\u0004t\u0001\t\n\u0011\"\u0001\u0004v!91q\f\u0001\u0005\u0002\re\u0004bBBB\u0001\u0011\u00051Q\u0011\u0005\b\u0007\u0007\u0003A\u0011ABE\u0011!\u0019)\n\u0001C\u0001\u0017\u000e]uaBBM\u0017\"\u000511\u0014\u0004\u0007\u0015.C\ta!(\t\r}\fE\u0011ABP\u0011\u001d\u0019\t+\u0011C\u0001\u0007GCqa!)B\t\u0003\u0019i\fC\u0004\u0004\"\u0006#\ta!3\t\u0011\t5\u0018\t\"\u0001N\u0007\u001fD\u0001b!;B\t\u0003i51\u001e\u0005\t\u0007S\fE\u0011A'\u0004v\"A1\u0011`!\u0005\u00025\u001bYP\u0001\u0007Bgft7m\u00117vgR,'O\u0003\u0002M\u001b\u0006)1oY1mC*\u0011ajT\u0001\u0007G2LWM\u001c;\u000b\u0005A\u000b\u0016!C2pk\u000eD'-Y:f\u0015\u0005\u0011\u0016aA2p[\u000e\u00011C\u0001\u0001V!\t1\u0006,D\u0001X\u0015\u0005a\u0015BA-X\u0005\u0019\te.\u001f*fM\u0006YQM\u001c<je>tW.\u001a8u!\r1FLX\u0005\u0003;^\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000b1!\u001a8w\u0013\t\u0019\u0007M\u0001\nDYV\u001cH/\u001a:F]ZL'o\u001c8nK:$\u0018!D1vi\",g\u000e^5dCR|'/F\u0001g!\t97.D\u0001i\u0015\t\t\u0017N\u0003\u0002k\u001b\u0006!1m\u001c:f\u0013\ta\u0007NA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003%\u0019X-\u001a3O_\u0012,7/F\u0001q!\r\t\bp\u001f\b\u0003eZ\u0004\"a],\u000e\u0003QT!!^*\u0002\rq\u0012xn\u001c;?\u0013\t9x+\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u00141aU3u\u0015\t9x\u000b\u0005\u0002`y&\u0011Q\u0010\u0019\u0002\t'\u0016,GMT8eK\u0006Q1/Z3e\u001d>$Wm\u001d\u0011\u0002\rqJg.\u001b;?)!\t\u0019!a\u0002\u0002\n\u0005-\u0001cAA\u0003\u00015\t1\n\u0003\u0004[\r\u0011\u0005\ra\u0017\u0005\u0006I\u001a\u0001\rA\u001a\u0005\u0006]\u001a\u0001\r\u0001]\u0001\u0003K\u000e,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006X\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u00037\t)B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0016\u0003y\u000bA!\u001a8wAU\u0011\u0011Q\u0005\t\u0005\u0003O\tI#D\u0001j\u0013\r\tY#\u001b\u0002\u0005\u0007>\u0014X-A\u0003d_J,\u0007%\u0001\u0002iaV\u0011\u00111\u0007\t\u0005\u0003\u000b\t)$C\u0002\u00028-\u0013!\u0003S1oI2,'OQ1tS\u000e\u0004\u0016M]1ng\u0006\u0019\u0001\u000e\u001d\u0011\u0002\u001bM,\u0017M]2i)&lWm\\;u+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%!\u0006\u0002\u0011\u0011,(/\u0019;j_:LA!!\u0013\u0002D\tAA)\u001e:bi&|g.\u0001\btK\u0006\u00148\r\u001b+j[\u0016|W\u000f\u001e\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001cH+[7f_V$\u0018!E1oC2LH/[2t)&lWm\\;uA\u0005i!/\u001a;ssN#(/\u0019;fOf,\"!!\u0016\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017j\u0003\u0015\u0011X\r\u001e:z\u0013\u0011\ty&!\u0017\u0003\u001bI+GO]=TiJ\fG/Z4z\u00039\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0002\nA\"];fefD\u0015M\u001c3mKJ,\"!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005A\u0001.\u00198eY\u0016\u00148OC\u0002\u0002r-\u000bQ!];fefLA!!\u001e\u0002l\ta\u0011+^3ss\"\u000bg\u000e\u001a7fe\u0006i\u0011/^3ss\"\u000bg\u000e\u001a7fe\u0002\n\u0001#\u00198bYf$\u0018nY:IC:$G.\u001a:\u0016\u0005\u0005u\u0004\u0003BA5\u0003\u007fJA!!!\u0002l\t\u0001\u0012I\\1msRL7m\u001d%b]\u0012dWM]\u0001\u0012C:\fG.\u001f;jGND\u0015M\u001c3mKJ\u0004\u0013!D:fCJ\u001c\u0007\u000eS1oI2,'/\u0006\u0002\u0002\nB!\u0011\u0011NAF\u0013\u0011\ti)a\u001b\u0003\u001bM+\u0017M]2i\u0011\u0006tG\r\\3s\u00039\u0019X-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0002\n1C]3bGRLg/Z+tKJl\u0015M\\1hKJ,\"!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006!Qo]3s\u0015\r\tyjS\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\t\u0019+!'\u0003'I+\u0017m\u0019;jm\u0016,6/\u001a:NC:\fw-\u001a:\u0002+I,\u0017m\u0019;jm\u0016\u0014UoY6fi6\u000bg.Y4feV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVAO\u0003\u0019\u0011WoY6fi&!\u00111WAW\u0005U\u0011V-Y2uSZ,')^2lKRl\u0015M\\1hKJ\fQD]3bGRLg/Z!oC2LH/[2t\u0013:$W\r_'b]\u0006<WM]\u000b\u0003\u0003s\u0003B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000bi*A\u0005b]\u0006d\u0017\u0010^5dg&!\u00111YA_\u0005u\u0011V-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014\u0018\u0001F#naRLh*Y7fIB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002JBA\u00111ZAk\u00033\fy.\u0004\u0002\u0002N*!\u0011qZAi\u0003%IW.\\;uC\ndWMC\u0002\u0002T^\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9.!4\u0003\u00075\u000b\u0007\u000fE\u0002r\u00037L1!!8{\u0005\u0019\u0019FO]5oOB\u0019a+!9\n\u0007\u0005\rxKA\u0002B]f\fQ#R7qift\u0015-\\3e!\u0006\u0014\u0018-\\3uKJ\u001c\b%A\rF[B$\u0018\u0010U8tSRLwN\\1m!\u0006\u0014\u0018-\\3uKJ\u001cXCAAv!\u0019\tY-!<\u0002`&!\u0011q^Ag\u0005\r\u0019V-]\u0001\u001b\u000b6\u0004H/\u001f)pg&$\u0018n\u001c8bYB\u000b'/Y7fi\u0016\u00148\u000fI\u0001\bEV\u001c7.\u001a;t+\t\t9\u0010\u0005\u0003\u0002,\u0006e\u0018\u0002BA~\u0003[\u0013!#Q:z]\u000e\u0014UoY6fi6\u000bg.Y4fe\u0006)Qo]3sgV\u0011!\u0011\u0001\t\u0005\u0003/\u0013\u0019!\u0003\u0003\u0003\u0006\u0005e%\u0001E!ts:\u001cWk]3s\u001b\u0006t\u0017mZ3s\u00031\tX/\u001a:z\u0013:$W\r_3t+\t\u0011Y\u0001\u0005\u0003\u0003\u000e\tEQB\u0001B\b\u0015\u0011\t\t(!(\n\t\tM!q\u0002\u0002\u0017\u0003NLhnY)vKJL\u0018J\u001c3fq6\u000bg.Y4fe\u0006i1/Z1sG\"Le\u000eZ3yKN,\"A!\u0007\u0011\t\tm!\u0011E\u0007\u0003\u0005;QAAa\b\u0002\u001e\u000611/Z1sG\"LAAa\t\u0003\u001e\t9\u0012i]=oGN+\u0017M]2i\u0013:$W\r_'b]\u0006<WM]\u0001\u0011C:\fG.\u001f;jGNLe\u000eZ3yKN,\"A!\u000b\u0011\t\u0005m&1F\u0005\u0005\u0005[\tiL\u0001\u000eBgft7-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/A\tfm\u0016tG/\u001b8h\rVt7\r^5p]N,\"Aa\r\u0011\t\tU\"1H\u0007\u0003\u0005oQAA!\u000f\u0002\u001e\u0006AQM^3oi&tw-\u0003\u0003\u0003>\t]\"\u0001H!ts:\u001cWI^3oi&twMR;oGRLwN\\'b]\u0006<WM\u001d\u0015\u0004O\t\u0005\u0003\u0003\u0002B\"\u0005\u001frAA!\u0012\u0003L5\u0011!q\t\u0006\u0004\u0005\u0013J\u0017AC1o]>$\u0018\r^5p]&!!Q\nB$\u0003%\u0019F/\u00192jY&$\u00180\u0003\u0003\u0003R\tM#aC+oG>lW.\u001b;uK\u0012TAA!\u0014\u0003HQ!!q\u000bB/!\u0011\t)A!\u0017\n\u0007\tm3JA\u0006Bgft7MQ;dW\u0016$\bb\u0002B0Q\u0001\u0007\u0011\u0011\\\u0001\u000bEV\u001c7.\u001a;OC6,GC\u0002B2\u0005c\u0012)\b\u0005\u0004\u0002\u0014\t\u0015$\u0011N\u0005\u0005\u0005O\n)B\u0001\u0004GkR,(/\u001a\t\u0005\u0005W\u0012i'\u0004\u0002\u0002p%!!qNA8\u0005-\tV/\u001a:z%\u0016\u001cX\u000f\u001c;\t\u000f\tM\u0014\u00061\u0001\u0002Z\u0006I1\u000f^1uK6,g\u000e\u001e\u0005\b\u0005oJ\u0003\u0019\u0001B=\u0003\u001dy\u0007\u000f^5p]N\u0004BAa\u001b\u0003|%!!QPA8\u00051\tV/\u001a:z\u001fB$\u0018n\u001c8t))\u0011\u0019G!!\u0003\u0004\n5%\u0011\u0013\u0005\b\u0005gR\u0003\u0019AAm\u0011%\u0011)I\u000bI\u0001\u0002\u0004\u00119)\u0001\u0006qCJ\fW.\u001a;feN\u0004BAa\u001b\u0003\n&!!1RA8\u0005=\tV/\u001a:z!\u0006\u0014\u0018-\\3uKJ\u001c\b\"\u0003BHUA\u0005\t\u0019AA \u0003\u001d!\u0018.\\3pkRD\u0011Ba%+!\u0003\u0005\rA!&\u0002\u000b\u0005$\u0007n\\2\u0011\u0007Y\u00139*C\u0002\u0003\u001a^\u0013qAQ8pY\u0016\fg.A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011yJ\u000b\u0003\u0003\b\n\u00056F\u0001BR!\u0011\u0011)K!,\u000e\u0005\t\u001d&\u0002\u0002BU\u0005W\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%s+\u0003\u0003\u00030\n\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y\u0011/^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u00036*\"\u0011q\bBQ\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\"TC\u0001B^U\u0011\u0011)J!)\u0002\u001d\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ssR1!\u0011\u0019Bg\u0005\u001f\u0004b!a\u0005\u0003f\t\r\u0007\u0003\u0002Bc\u0005\u0013l!Aa2\u000b\u0007\u0005}6*\u0003\u0003\u0003L\n\u001d'aD!oC2LH/[2t%\u0016\u001cX\u000f\u001c;\t\u000f\tMd\u00061\u0001\u0002Z\"9!q\u000f\u0018A\u0002\tE\u0007\u0003\u0002Bc\u0005'LAA!6\u0003H\n\u0001\u0012I\\1msRL7m](qi&|gn\u001d\u000b\t\u0005\u0003\u0014INa7\u0003d\"9!1O\u0018A\u0002\u0005e\u0007\"\u0003BC_A\u0005\t\u0019\u0001Bo!\u0011\u0011)Ma8\n\t\t\u0005(q\u0019\u0002\u0014\u0003:\fG.\u001f;jGN\u0004\u0016M]1nKR,'o\u001d\u0005\n\u0005\u001f{\u0003\u0013!a\u0001\u0003\u007f\t\u0001$\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011IO\u000b\u0003\u0003^\n\u0005\u0016\u0001G1oC2LH/[2t#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y1/Z1sG\"\fV/\u001a:z)!\u0011\tp!\u0001\u0004\u0006\rM\u0001CBA\n\u0005K\u0012\u0019\u0010\u0005\u0003\u0003v\nuXB\u0001B|\u0015\u0011\u0011IPa?\u0002\rI,7/\u001e7u\u0015\r\u0011ybS\u0005\u0005\u0005\u007f\u00149P\u0001\u0007TK\u0006\u00148\r\u001b*fgVdG\u000fC\u0004\u0004\u0004I\u0002\r!!7\u0002\u0013%tG-\u001a=OC6,\u0007bBA9e\u0001\u00071q\u0001\t\u0005\u0007\u0013\u0019y!\u0004\u0002\u0004\f)!1Q\u0002B~\u0003\u001d\tX/\u001a:jKNLAa!\u0005\u0004\f\tY1+Z1sG\"\fV/\u001a:z\u0011\u001d\u00119H\ra\u0001\u0007+\u0001Baa\u0006\u0004\u001a5\u0011!1`\u0005\u0005\u00077\u0011YPA\u0007TK\u0006\u00148\r[(qi&|gn\u001d\u000b\t\u0005c\u001cyb!\t\u0004$!911A\u001aA\u0002\u0005e\u0007bBA9g\u0001\u00071q\u0001\u0005\n\u0005\u001f\u001b\u0004\u0013!a\u0001\u0003\u007f\tQc]3be\u000eD\u0017+^3ss\u0012\"WMZ1vYR$3'\u0001\u0006eSN\u001cwN\u001c8fGR$Baa\u000b\u00044A1\u00111\u0003B3\u0007[\u00012AVB\u0018\u0013\r\u0019\td\u0016\u0002\u0005+:LG\u000fC\u0005\u0003\u0010V\u0002\n\u00111\u0001\u0002@\u0005!B-[:d_:tWm\u0019;%I\u00164\u0017-\u001e7uIE\n1\u0002Z5bO:|7\u000f^5dgR!11HB$!\u0019\t\u0019B!\u001a\u0004>A!1qHB\"\u001b\t\u0019\tEC\u0002\u00048%LAa!\u0012\u0004B\t\tB)[1h]>\u001cH/[2t%\u0016\u001cX\u000f\u001c;\t\u0013\r%s\u0007%AA\u0002\u0005e\u0017\u0001\u0003:fa>\u0014H/\u00133\u0002+\u0011L\u0017m\u001a8pgRL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u00111q\n\u0016\u0005\u00033\u0014\t\u000b\u0006\u0003\u0004<\rM\u0003b\u0002B<s\u0001\u00071Q\u000b\t\u0005\u0007/\u001aY&\u0004\u0002\u0004Z)\u00191qG&\n\t\ru3\u0011\f\u0002\u0013\t&\fwM\\8ti&\u001c7o\u00149uS>t7/\u0001\u0003qS:<G\u0003BB2\u0007W\u0002b!a\u0005\u0003f\r\u0015\u0004\u0003BB \u0007OJAa!\u001b\u0004B\tQ\u0001+\u001b8h%\u0016\u001cX\u000f\u001c;\t\u0013\t=%\b%AA\u0002\r5\u0004#\u0002,\u0004p\u0005}\u0012bAB9/\n1q\n\u001d;j_:\fa\u0002]5oO\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004x)\"1Q\u000eBQ)\u0011\u0019\u0019ga\u001f\t\u000f\t]D\b1\u0001\u0004~A!1qKB@\u0013\u0011\u0019\ti!\u0017\u0003\u0017AKgnZ(qi&|gn]\u0001\u000fo\u0006LG/\u00168uS2\u0014V-\u00193z)\u0011\u0019Yca\"\t\u000f\t=U\b1\u0001\u0002@Q111FBF\u0007\u001bCqAa$?\u0001\u0004\ty\u0004C\u0004\u0003xy\u0002\raa$\u0011\t\r]3\u0011S\u0005\u0005\u0007'\u001bIFA\u000bXC&$XK\u001c;jYJ+\u0017\rZ=PaRLwN\\:\u0002)A,'OZ8s[\u001ecwNY1m\u0007>tg.Z2u)\t\u0019i#\u0001\u0007Bgft7m\u00117vgR,'\u000fE\u0002\u0002\u0006\u0005\u001b\"!Q+\u0015\u0005\rm\u0015aB2p]:,7\r\u001e\u000b\t\u0007K\u001b\tl!.\u0004:B11qUBW\u0003\u0007i!a!+\u000b\u0007\r-v+\u0001\u0003vi&d\u0017\u0002BBX\u0007S\u00131\u0001\u0016:z\u0011\u001d\u0019\u0019l\u0011a\u0001\u00033\f\u0001cY8o]\u0016\u001cG/[8o'R\u0014\u0018N\\4\t\u000f\r]6\t1\u0001\u0002Z\u0006AQo]3s]\u0006lW\rC\u0004\u0004<\u000e\u0003\r!!7\u0002\u0011A\f7o]<pe\u0012$ba!*\u0004@\u000e\u0005\u0007bBBZ\t\u0002\u0007\u0011\u0011\u001c\u0005\b\u0005o\"\u0005\u0019ABb!\u0011\t)a!2\n\u0007\r\u001d7J\u0001\bDYV\u001cH/\u001a:PaRLwN\\:\u0015\r\r\u001561ZBg\u0011\u0015qW\t1\u0001q\u0011\u001d\u00119(\u0012a\u0001\u0007\u0007$ba!5\u0004V\u000e\u001dH\u0003\u0002By\u0007'Dq!!\u0004G\u0001\b\t\t\u0002C\u0004\u0004X\u001a\u0003\ra!7\u0002\u000fI,\u0017/^3tiB!11\\Br\u001b\t\u0019iN\u0003\u0003\u0003 \r}'bABqS\u0006\u0019Qn]4\n\t\r\u00158Q\u001c\u0002\u000e'\u0016\f'o\u00195SKF,Xm\u001d;\t\r)4\u0005\u0019AA\u0013\u0003e)\u0007\u0010\u001e:bGR\u001cE.^:uKJ,eN^5s_:lWM\u001c;\u0015\r\r58q^By!\u0015\u00199k!,_\u0011\u001d\u0019\u0019l\u0012a\u0001\u00033Dqaa=H\u0001\u0004\u0019\u0019-\u0001\u0003paR\u001cH\u0003BBw\u0007oDqaa=I\u0001\u0004\u0019\u0019-A\u000ftK\u0016$gj\u001c3fg\u001a\u0013x.\\\"p]:,7\r^5p]N#(/\u001b8h)\u0015\u00018Q C\u0001\u0011\u001d\u0019y0\u0013a\u0001\u00033\f!aY:\t\u000biK\u0005\u0019\u00010")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(seedNodes, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(connectionString, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return AsyncCluster$.MODULE$.connect(connectionString, username, password);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        return (this.bitmap$0 & 1) == 0 ? this.reactiveUserManager$lzycompute() : this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        return (this.bitmap$0 & 2) == 0 ? this.reactiveBucketManager$lzycompute() : this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        return (this.bitmap$0 & 4) == 0 ? this.reactiveAnalyticsIndexManager$lzycompute() : this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        return (this.bitmap$0 & 8) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        return (this.bitmap$0 & 0x10) == 0 ? this.users$lzycompute() : this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return (this.bitmap$0 & 0x20) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return (this.bitmap$0 & 0x40) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return (this.bitmap$0 & 0x80) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        return (this.bitmap$0 & 0x100) == 0 ? this.eventingFunctions$lzycompute() : this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            future = this.analyticsHandler().queryAsync(request, this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Future<SearchResult> future;
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            future = AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable)() -> this.env().owned() ? this.env().shutdownInternal(timeout) : SMono$.MODULE$.empty())).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)CollectionConverters$.MODULE$.SetHasAsJava((Set)seedNodes.map((Function1 & Serializable)x$1 -> x$1.toCore())).asJava());
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)package$.MODULE$.Seq().empty();
    }
}

