/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DesignDocumentNotFoundException;
import com.couchbase.client.core.error.ViewServiceException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.view.DesignDocument;
import com.couchbase.client.scala.manager.view.ReactiveViewIndexManager$;
import com.couchbase.client.scala.manager.view.View;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import com.couchbase.client.scala.view.DesignDocumentNamespace;
import com.couchbase.client.scala.view.DesignDocumentNamespace$;
import com.couchbase.client.scala.view.DesignDocumentNamespace$Development$;
import com.couchbase.client.scala.view.DesignDocumentNamespace$Production$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;
import upickle.default$;

@ScalaSignature(bytes="\u0006\u0005\t}b\u0001\u0002\u0013&\u0001IB\u0011\u0002\u000f\u0001\u0003\u0006\u0004%\t!K\u001d\t\u0011}\u0002!\u0011!Q\u0001\niB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\u0006\u0019\u0002!\t!\u0014\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0011\u0019a\u0006\u0001)A\u0005)\"9Q\f\u0001b\u0001\n\u0013q\u0006BB3\u0001A\u0003%q\fC\u0004g\u0001\t\u0007I\u0011B4\t\rA\u0004\u0001\u0015!\u0003i\u0011\u0015\t\b\u0001\"\u0001s\u0011%\tY\u0002AI\u0001\n\u0003\ti\u0002C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!9\u0011\u0011\b\u0001\u0005\u0002\u0005m\u0002\"CA%\u0001E\u0005I\u0011AA\u000f\u0011%\tY\u0005AI\u0001\n\u0003\t)\u0004C\u0004\u0002N\u0001!\t!a\u0014\t\u0013\u0005\r\u0004!%A\u0005\u0002\u0005u\u0001\"CA3\u0001E\u0005I\u0011AA\u001b\u0011\u001d\t9\u0007\u0001C\u0001\u0003SB\u0011\"a\u001d\u0001#\u0003%\t!!\b\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005U\u0002bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003+\u0003A\u0011AAL\u0011%\ty\nAI\u0001\n\u0003\ti\u0002C\u0005\u0002\"\u0002\t\n\u0011\"\u0001\u00026!9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u0017\u0004A\u0011BAg\u0011\u001d\t\t\u0010\u0001C\u0005\u0003g<qAa\u0002&\u0011\u0003\u0011IA\u0002\u0004%K!\u0005!1\u0002\u0005\u0007\u0019\u0002\"\tA!\u0004\t\u0011\t=\u0001\u0005\"\u0001*\u0005#A\u0001B!\u000b!\t\u0003I#1\u0006\u0002\u0019%\u0016\f7\r^5wKZKWm^%oI\u0016DX*\u00198bO\u0016\u0014(B\u0001\u0014(\u0003\u00111\u0018.Z<\u000b\u0005!J\u0013aB7b]\u0006<WM\u001d\u0006\u0003U-\nQa]2bY\u0006T!\u0001L\u0017\u0002\r\rd\u0017.\u001a8u\u0015\tqs&A\u0005d_V\u001c\u0007NY1tK*\t\u0001'A\u0002d_6\u001c\u0001a\u0005\u0002\u0001gA\u0011AGN\u0007\u0002k)\t!&\u0003\u00028k\t1\u0011I\\=SK\u001a\fAaY8sKV\t!\b\u0005\u0002<{5\tAH\u0003\u00029W%\u0011a\b\u0010\u0002\u0005\u0007>\u0014X-A\u0003d_J,\u0007%\u0001\u0004ck\u000e\\W\r\u001e\t\u0003\u0005&s!aQ$\u0011\u0005\u0011+T\"A#\u000b\u0005\u0019\u000b\u0014A\u0002\u001fs_>$h(\u0003\u0002Ik\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tAU'\u0001\u0004=S:LGO\u0010\u000b\u0004\u001dB\u000b\u0006CA(\u0001\u001b\u0005)\u0003\"\u0002\u001d\u0005\u0001\u0004Q\u0004\"\u0002!\u0005\u0001\u0004\t\u0015A\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f^\u000b\u0002)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\tIV\u0014\u0018\r^5p]*\u0011\u0011,N\u0001\u000bG>t7-\u001e:sK:$\u0018BA.W\u0005!!UO]1uS>t\u0017a\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011+g-Y;miJ+GO]=TiJ\fG/Z4z+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012=\u0003\u0015\u0011X\r\u001e:z\u0013\t!\u0017MA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016\t\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u0003)AG\u000f\u001e9DY&,g\u000e^\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005QR$\bO\u0003\u0002ny\u0005AQM\u001c3q_&tG/\u0003\u0002pU\nq1i\u001c:f\u0011R$\bo\u00117jK:$\u0018a\u00035uiB\u001cE.[3oi\u0002\n\u0011cZ3u\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8u)%\u0019\u0018\u0011AA\u0003\u0003'\t9\u0002E\u0002uwvl\u0011!\u001e\u0006\u0003m^\f\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005)B(B\u0001\u001dz\u0015\u0005Q\u0018a\u0002:fC\u000e$xN]\u0005\u0003yV\u0014QaU'p]>\u0004\"a\u0014@\n\u0005},#A\u0004#fg&<g\u000eR8dk6,g\u000e\u001e\u0005\u0007\u0003\u0007Y\u0001\u0019A!\u0002\u001b\u0011,7/[4o\t>\u001cg*Y7f\u0011\u001d\t9a\u0003a\u0001\u0003\u0013\t\u0011B\\1nKN\u0004\u0018mY3\u0011\t\u0005-\u0011qB\u0007\u0003\u0003\u001bQ!AJ\u0015\n\t\u0005E\u0011Q\u0002\u0002\u0018\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8u\u001d\u0006lWm\u001d9bG\u0016D\u0001\"!\u0006\f!\u0003\u0005\r\u0001V\u0001\bi&lWm\\;u\u0011!\tIb\u0003I\u0001\u0002\u0004y\u0016!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170A\u000ehKR$Um]5h]\u0012{7-^7f]R$C-\u001a4bk2$HeM\u000b\u0003\u0003?Q3\u0001VA\u0011W\t\t\u0019\u0003\u0005\u0003\u0002&\u0005=RBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0017k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0012q\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aG4fi\u0012+7/[4o\t>\u001cW/\\3oi\u0012\"WMZ1vYR$C'\u0006\u0002\u00028)\u001aq,!\t\u0002+\u001d,G/\u00117m\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8ugRA\u0011QHA\"\u0003\u000b\n9\u0005\u0005\u0003u\u0003\u007fi\u0018bAA!k\n)1K\u00127vq\"9\u0011q\u0001\bA\u0002\u0005%\u0001\u0002CA\u000b\u001dA\u0005\t\u0019\u0001+\t\u0011\u0005ea\u0002%AA\u0002}\u000bqdZ3u\u00032dG)Z:jO:$unY;nK:$8\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003}9W\r^!mY\u0012+7/[4o\t>\u001cW/\\3oiN$C-\u001a4bk2$HeM\u0001\u0015kB\u001cXM\u001d;EKNLwM\u001c#pGVlWM\u001c;\u0015\u0015\u0005E\u0013\u0011LA/\u0003?\n\t\u0007\u0005\u0003uw\u0006M\u0003c\u0001\u001b\u0002V%\u0019\u0011qK\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u00037\n\u0002\u0019A?\u0002\u0013%tG-\u001a=ECR\f\u0007bBA\u0004#\u0001\u0007\u0011\u0011\u0002\u0005\t\u0003+\t\u0002\u0013!a\u0001)\"A\u0011\u0011D\t\u0011\u0002\u0003\u0007q,\u0001\u0010vaN,'\u000f\u001e#fg&<g\u000eR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u0005qR\u000f]:feR$Um]5h]\u0012{7-^7f]R$C-\u001a4bk2$H\u0005N\u0001\u0013IJ|\u0007\u000fR3tS\u001etGi\\2v[\u0016tG\u000f\u0006\u0006\u0002R\u0005-\u0014QNA8\u0003cBa!a\u0001\u0015\u0001\u0004\t\u0005bBA\u0004)\u0001\u0007\u0011\u0011\u0002\u0005\t\u0003+!\u0002\u0013!a\u0001)\"A\u0011\u0011\u0004\u000b\u0011\u0002\u0003\u0007q,\u0001\u000fee>\u0004H)Z:jO:$unY;nK:$H\u0005Z3gCVdG\u000fJ\u001a\u00029\u0011\u0014x\u000e\u001d#fg&<g\u000eR8dk6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0001R.\u00199O_R4u.\u001e8e\u000bJ\u0014xN\u001d\u000b\t\u0003w\ni)!%\u0002\u0014B!\u0011QPAD\u001d\u0011\ty(a!\u000f\u0007\u0011\u000b\t)C\u0001+\u0013\r\t))N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI)a#\u0003\u0013QC'o\\<bE2,'bAACk!9\u0011qR\fA\u0002\u0005m\u0014AA5o\u0011\u0019\t\u0019a\u0006a\u0001\u0003\"9\u0011qA\fA\u0002\u0005%\u0011!\u00069vE2L7\u000f\u001b#fg&<g\u000eR8dk6,g\u000e\u001e\u000b\t\u0003#\nI*a'\u0002\u001e\"1\u00111\u0001\rA\u0002\u0005C\u0001\"!\u0006\u0019!\u0003\u0005\r\u0001\u0016\u0005\t\u00033A\u0002\u0013!a\u0001?\u0006y\u0002/\u001e2mSNDG)Z:jO:$unY;nK:$H\u0005Z3gCVdG\u000f\n\u001a\u0002?A,(\r\\5tQ\u0012+7/[4o\t>\u001cW/\\3oi\u0012\"WMZ1vYR$3'A\u000bqCRDgi\u001c:EKNLwM\u001c#pGVlWM\u001c;\u0015\r\u0005\u001d\u00161WA\\!\u0015\tI+a,B\u001b\t\tYKC\u0002\u0002.V\nA!\u001e;jY&!\u0011\u0011WAV\u0005\r!&/\u001f\u0005\u0007\u0003k[\u0002\u0019A!\u0002\t9\fW.\u001a\u0005\b\u0003\u000fY\u0002\u0019AA\u0005\u0003e\u0001\u0018\r\u001e5G_J\fE\u000e\u001c#fg&<g\u000eR8dk6,g\u000e^:\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u0013l!!!1\u000b\t\u0005\r\u0017QY\u0001\u0005Y\u0006twM\u0003\u0002\u0002H\u0006!!.\u0019<b\u0013\rQ\u0015\u0011Y\u0001\u0007i>T5o\u001c8\u0015\t\u0005=\u0017Q\u001e\t\u0005\u0003#\fI/\u0004\u0002\u0002T*!\u0011Q[Al\u0003\u0011qw\u000eZ3\u000b\t\u0005e\u00171\\\u0001\tI\u0006$\u0018MY5oI*!\u0011Q\\Ap\u0003\u001dQ\u0017mY6t_:TA!!9\u0002d\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0004a\u0005\u0015(bAAty\u0005!A-\u001a9t\u0013\u0011\tY/a5\u0003\u0015=\u0013'.Z2u\u001d>$W\r\u0003\u0004\u0002pv\u0001\r!`\u0001\u0004I>\u001c\u0017aC:f]\u0012\u0014V-];fgR$B!!>\u0002~B!Ao_A|!\rI\u0017\u0011`\u0005\u0004\u0003wT'\u0001E\"pe\u0016DE\u000f\u001e9SKN\u0004xN\\:f\u0011\u001d\tyP\ba\u0001\u0005\u0003\tqA]3rk\u0016\u001cH\u000fE\u0002j\u0005\u0007I1A!\u0002k\u0005=\u0019uN]3IiR\u0004(+Z9vKN$\u0018\u0001\u0007*fC\u000e$\u0018N^3WS\u0016<\u0018J\u001c3fq6\u000bg.Y4feB\u0011q\nI\n\u0003AM\"\"A!\u0003\u0002/A\f'o]3BY2$Um]5h]\u0012{7-^7f]R\u001cHC\u0002B\n\u0005K\u00119\u0003\u0005\u0004\u0002*\u0006=&Q\u0003\t\u0006\u0005/\u0011\t#`\u0007\u0003\u00053QAAa\u0007\u0003\u001e\u00059Q.\u001e;bE2,'b\u0001B\u0010k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0003\u0004\u0002\u0010\n\u0002\r!\u0011\u0005\b\u0003\u000f\u0011\u0003\u0019AA\u0005\u0003M\u0001\u0018M]:f\t\u0016\u001c\u0018n\u001a8E_\u000e,X.\u001a8u)\u0019\u0011iCa\f\u00032A)\u0011\u0011VAX{\"1\u0011QW\u0012A\u0002\u0005Cq!!6$\u0001\u0004\u0011\u0019\u0004\u0005\u0003\u00036\tmRB\u0001B\u001c\u0015\t\u0011I$A\u0003vUN|g.\u0003\u0003\u0003>\t]\"aA(cU\u0002")
public class ReactiveViewIndexManager {
    private final Core core;
    private final String bucket;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;
    private final CoreHttpClient httpClient;

    public Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private CoreHttpClient httpClient() {
        return this.httpClient;
    }

    public SMono<DesignDocument> getDesignDocument(String designDocName, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        SMono sMono;
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        Try<String> try_ = this.pathForDesignDocument(designDocName, namespace);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String path = (String)success.value();
            sMono = this.sendRequest(this.httpClient().get(CoreHttpPath.path((String)path), options).build()).onErrorResume((Function1 & Serializable)err -> SMono$.MODULE$.raiseError(this.mapNotFoundError((Throwable)err, designDocName, namespace))).flatMap((Function1 & Serializable)response -> {
                SMono sMono;
                ResponseStatus responseStatus = response.status();
                if (ResponseStatus.SUCCESS.equals(responseStatus)) {
                    SMono sMono2;
                    Try parsed = Try$.MODULE$.apply((Function0 & Serializable)() -> (Obj)default$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), default$.MODULE$.read$default$2(), default$.MODULE$.JsObjR())).flatMap((Function1 & Serializable)json -> ReactiveViewIndexManager$.MODULE$.parseDesignDocument(designDocName, (Obj)json));
                    Try try_ = parsed;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        DesignDocument designDoc = (DesignDocument)success.value();
                        sMono2 = SMono$.MODULE$.just((Object)designDoc);
                    } else if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        sMono2 = SMono$.MODULE$.raiseError(err);
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    sMono = sMono2;
                } else {
                    sMono = SMono$.MODULE$.raiseError((Throwable)new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName)).append("] from namespace ").append(namespace).toString()));
                }
                return sMono;
            });
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err2 = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err2);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Duration getDesignDocument$default$3() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public SFlux<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), HttpMethod.GET, this.pathForAllDesignDocuments(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            SFlux sFlux;
            ResponseStatus responseStatus = response.status();
            if (ResponseStatus.SUCCESS.equals(responseStatus)) {
                SFlux sFlux2;
                Try<ArrayBuffer<DesignDocument>> try_ = ReactiveViewIndexManager$.MODULE$.parseAllDesignDocuments(new String(response.content(), StandardCharsets.UTF_8), namespace);
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    ArrayBuffer docs = (ArrayBuffer)success.value();
                    sFlux2 = SFlux$.MODULE$.fromIterable((Iterable)docs);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sFlux2 = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
                } else {
                    throw new MatchError(try_);
                }
                sFlux = sFlux2;
            } else {
                sFlux = SFlux$.MODULE$.raiseError((Throwable)new CouchbaseException(new StringBuilder(68).append("Failed to get all design documents; response status=").append(response.status()).append("; response body=").append(new String(response.content(), StandardCharsets.UTF_8)).toString()), SFlux$.MODULE$.raiseError$default$2());
            }
            return sFlux;
        });
    }

    public Duration getAllDesignDocuments$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllDesignDocuments$default$3() {
        return this.DefaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertDesignDocument(DesignDocument indexData, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        SMono sMono;
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        Try<String> try_ = this.pathForDesignDocument(indexData.name(), namespace);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String path = (String)success.value();
            ObjectNode body = this.toJson(indexData);
            CoreHttpRequest request = this.httpClient().put(CoreHttpPath.path((String)path), options).json(Mapper.encodeAsBytes((Object)body)).build();
            sMono = SMono$.MODULE$.defer((Function0 & Serializable)() -> {
                this.core().send((Request)request);
                return FutureConversions$.MODULE$.javaCFToScalaMono((Request<?>)request, request.response(), true).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> request.context().logicallyComplete()).map((Function1 & Serializable)x$1 -> {
                    ReactiveViewIndexManager.$anonfun$upsertDesignDocument$3(x$1);
                    return BoxedUnit.UNIT;
                });
            });
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Duration upsertDesignDocument$default$3() {
        return this.DefaultTimeout();
    }

    public RetryStrategy upsertDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropDesignDocument(String designDocName, DesignDocumentNamespace namespace, Duration timeout, RetryStrategy retryStrategy) {
        SMono sMono;
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        Try<String> try_ = this.pathForDesignDocument(designDocName, namespace);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String path = (String)success.value();
            sMono = this.sendRequest(this.httpClient().delete(CoreHttpPath.path((String)path), options).build()).onErrorResume((Function1 & Serializable)err -> SMono$.MODULE$.raiseError(this.mapNotFoundError((Throwable)err, designDocName, namespace))).flatMap((Function1 & Serializable)response -> {
                ResponseStatus responseStatus = response.status();
                SMono sMono = ResponseStatus.SUCCESS.equals(responseStatus) ? SMono$.MODULE$.just((Object)BoxedUnit.UNIT) : SMono$.MODULE$.raiseError((Throwable)new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName)).append("] from namespace ").append(namespace).toString()));
                return sMono;
            });
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err2 = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err2);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Duration dropDesignDocument$default$3() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropDesignDocument$default$4() {
        return this.DefaultRetryStrategy();
    }

    public Throwable mapNotFoundError(Throwable in, String designDocName, DesignDocumentNamespace namespace) {
        ViewServiceException viewServiceException;
        Throwable throwable = in;
        Object object = throwable instanceof ViewServiceException ? ((viewServiceException = (ViewServiceException)throwable).content().contains("not_found") ? DesignDocumentNotFoundException.forName((String)designDocName, (String)namespace.toString()) : (Throwable)ReactiveViewIndexManager.default$1(designDocName, namespace).apply()) : (Throwable)ReactiveViewIndexManager.default$1(designDocName, namespace).apply();
        return object;
    }

    public SMono<BoxedUnit> publishDesignDocument(String designDocName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getDesignDocument(designDocName, DesignDocumentNamespace$Development$.MODULE$, timeout, retryStrategy).map((Function1 & Serializable)doc -> {
            this.upsertDesignDocument(doc, DesignDocumentNamespace$Production$.MODULE$, timeout, retryStrategy);
            return BoxedUnit.UNIT;
        });
    }

    public Duration publishDesignDocument$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy publishDesignDocument$default$3() {
        return this.DefaultRetryStrategy();
    }

    private Try<String> pathForDesignDocument(String name, DesignDocumentNamespace namespace) {
        return DesignDocumentNamespace$.MODULE$.requireUnqualified(name).map((Function1 & Serializable)unqualifiedName -> {
            String adjusted = namespace.adjustName((String)unqualifiedName);
            return new StringBuilder(10).append("/").append(UrlQueryStringBuilder.urlEncode((String)$this.bucket)).append("/_design/").append(UrlQueryStringBuilder.urlEncode((String)adjusted)).toString();
        });
    }

    private String pathForAllDesignDocuments() {
        return new StringBuilder(29).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)this.bucket)).append("/ddocs").toString();
    }

    /*
     * WARNING - void declaration
     */
    private ObjectNode toJson(DesignDocument doc) {
        void var2_2;
        ObjectNode root = JacksonTransformers.MAPPER.createObjectNode();
        ObjectNode views = root.putObject("views");
        doc.views().foreach((Function1 & Serializable)x -> {
            ReactiveViewIndexManager.$anonfun$toJson$1(views, x);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private SMono<CoreHttpResponse> sendRequest(CoreHttpRequest request) {
        return SMono$.MODULE$.defer((Function0 & Serializable)() -> {
            this.core().send((Request)request);
            return FutureConversions$.MODULE$.wrap((Request<? extends Response>)request, request.response(), true).doOnTerminate((Function0)(JFunction0.mcV.sp & Serializable)() -> request.context().logicallyComplete());
        });
    }

    public static final /* synthetic */ void $anonfun$upsertDesignDocument$3(CoreHttpResponse x$1) {
    }

    private static final Function0 default$1(String designDocName$3, DesignDocumentNamespace namespace$4) {
        return (Function0 & Serializable)() -> new CouchbaseException(new StringBuilder(49).append("Failed to drop design document [").append(RedactableArgument.redactMeta((Object)designDocName$3)).append("] from namespace ").append(namespace$4).toString());
    }

    public static final /* synthetic */ void $anonfun$toJson$1(ObjectNode views$1, Tuple2 x) {
        String key = (String)x._1();
        View value = (View)x._2();
        ObjectNode viewNode = JacksonTransformers.MAPPER.createObjectNode();
        viewNode.put("map", value.map());
        value.reduce().foreach((Function1 & Serializable)r -> viewNode.put("reduce", r));
        views$1.set(key, (JsonNode)viewNode);
    }

    public ReactiveViewIndexManager(Core core, String bucket) {
        this.core = core;
        this.bucket = bucket;
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(core.context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = core.context().environment().retryStrategy();
        this.httpClient = core.httpClient(RequestTarget.views((String)bucket));
    }
}

