/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryContext;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.deps.scala.compat.java8.FunctionConverters.package$;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.manager.query.IndexesNotReadyException;
import com.couchbase.client.scala.manager.query.QueryIndex;
import com.couchbase.client.scala.manager.query.QueryIndex$;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.transformers.JacksonTransformers;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.RowTraversalUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0005\t-g\u0001B\u001a5\u0001\u0005C\u0011b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u000f%\t\u00115\u0003!\u0011!Q\u0001\n%C\u0001B\u0014\u0001\u0003\u0006\u0004%\u0019a\u0014\u0005\t-\u0002\u0011\t\u0011)A\u0005!\")q\u000b\u0001C\u00011\"9a\f\u0001b\u0001\n\u0013y\u0006BB3\u0001A\u0003%\u0001\rC\u0004g\u0001\t\u0007I\u0011B4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003{\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013A\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\t\u0013\u0005m\u0003!%A\u0005\u0002\u0005u\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003_C\u0011\"a-\u0001#\u0003%\t!!.\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005m\u0006\"CA`\u0001E\u0005I\u0011AA#\u0011%\t\t\rAI\u0001\n\u0003\ti\u0006C\u0004\u0002D\u0002!\t!!2\t\u0013\u0005]\u0007!%A\u0005\u0002\u0005e\u0007\"CAo\u0001E\u0005I\u0011AAX\u0011%\ty\u000eAI\u0001\n\u0003\t)\fC\u0005\u0002b\u0002\t\n\u0011\"\u0001\u0002<\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003K\u0004\u0011\u0013!C\u0001\u0003;Bq!a:\u0001\t\u0003\tI\u000fC\u0005\u0002x\u0002\t\n\u0011\"\u0001\u00020\"I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003w\u0004\u0011\u0013!C\u0001\u0003;Bq!!@\u0001\t\u0003\ty\u0010C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u00020\"I!1\u0002\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0005\u001b\u0001\u0011\u0013!C\u0001\u0003;BqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0005\u0003\"\u0001\t\n\u0011\"\u0001\u00020\"I!1\u0005\u0001\u0012\u0002\u0013\u0005\u0011Q\f\u0005\b\u0005K\u0001A\u0011\u0002B\u0014\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bB\u0011B!\u0014\u0001#\u0003%\t!!\u0012\t\u0013\t=\u0003!%A\u0005\u0002\u0005u\u0003b\u0002B)\u0001\u0011%!1\u000b\u0005\b\u0005G\u0002A\u0011\u0002B3\u0011%\u0011I\tAI\u0001\n\u0013\t)\u0005C\u0005\u0003\f\u0002\t\n\u0011\"\u0003\u0002^!A!Q\u0012\u0001\u0005\u0002a\u0012y\tC\u0004\u0003,\u0002!\tA!,\u0003-\u0005\u001b\u0018P\\2Rk\u0016\u0014\u00180\u00138eKbl\u0015M\\1hKJT!!\u000e\u001c\u0002\u000bE,XM]=\u000b\u0005]B\u0014aB7b]\u0006<WM\u001d\u0006\u0003si\nQa]2bY\u0006T!a\u000f\u001f\u0002\r\rd\u0017.\u001a8u\u0015\tid(A\u0005d_V\u001c\u0007NY1tK*\tq(A\u0002d_6\u001c\u0001a\u0005\u0002\u0001\u0005B\u00111)R\u0007\u0002\t*\t\u0011(\u0003\u0002G\t\n1\u0011I\\=SK\u001a\fqa\u00197vgR,'/F\u0001J!\tQ5*D\u00019\u0013\ta\u0005H\u0001\u0007Bgft7m\u00117vgR,'/\u0001\u0005dYV\u001cH/\u001a:!\u0003\t)7-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019F)\u0001\u0006d_:\u001cWO\u001d:f]RL!!\u0016*\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\u0018aA3dA\u00051A(\u001b8jiz\"\"!W/\u0015\u0005ic\u0006CA.\u0001\u001b\u0005!\u0004\"\u0002(\u0006\u0001\b\u0001\u0006\"B$\u0006\u0001\u0004I\u0015\u0001B2pe\u0016,\u0012\u0001\u0019\t\u0003C\u000el\u0011A\u0019\u0006\u0003=jJ!\u0001\u001a2\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\u000f\t\u00164\u0017-\u001e7u)&lWm\\;u+\u0005A\u0007CA5m\u001b\u0005Q'BA6S\u0003!!WO]1uS>t\u0017BA7k\u0005!!UO]1uS>t\u0017a\u0004#fM\u0006,H\u000e\u001e+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011+g-Y;miJ+GO]=TiJ\fG/Z4z+\u0005\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;c\u0003\u0015\u0011X\r\u001e:z\u0013\t18OA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016\t\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u0003A\u0001&/[7befLe\u000eZ3y\u001d\u0006lW-F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0005Y\u0006twMC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAP\u0001\u0004TiJLgnZ\u0001\u0012!JLW.\u0019:z\u0013:$W\r\u001f(b[\u0016\u0004\u0013!D4fi\u0006cG.\u00138eKb,7\u000f\u0006\u0005\u0002\f\u0005\r\u00121HA !\u0015\t\u0016QBA\t\u0013\r\tyA\u0015\u0002\u0007\rV$XO]3\u0011\r\u0005M\u0011\u0011DA\u000f\u001b\t\t)BC\u0002\u0002\u0018\u0011\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY\"!\u0006\u0003\u0007M+\u0017\u000fE\u0002\\\u0003?I1!!\t5\u0005)\tV/\u001a:z\u0013:$W\r\u001f\u0005\b\u0003Kq\u0001\u0019AA\u0014\u0003)\u0011WoY6fi:\u000bW.\u001a\t\u0005\u0003S\t9D\u0004\u0003\u0002,\u0005M\u0002cAA\u0017\t6\u0011\u0011q\u0006\u0006\u0004\u0003c\u0001\u0015A\u0002\u001fs_>$h(C\u0002\u00026\u0011\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0002\u0003sQ1!!\u000eE\u0011!\tiD\u0004I\u0001\u0002\u0004A\u0017a\u0002;j[\u0016|W\u000f\u001e\u0005\t\u0003\u0003r\u0001\u0013!a\u0001c\u0006i!/\u001a;ssN#(/\u0019;fOf\fqcZ3u\u00032d\u0017J\u001c3fq\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d#f\u00015\u0002J-\u0012\u00111\n\t\u0005\u0003\u001b\n9&\u0004\u0002\u0002P)!\u0011\u0011KA*\u0003%)hn\u00195fG.,GMC\u0002\u0002V\u0011\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI&a\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fhKR\fE\u000e\\%oI\u0016DXm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\f\u0016\u0004c\u0006%\u0013aC2sK\u0006$X-\u00138eKb$\"#!\u001a\u0002n\u0005=\u00141OAE\u0003'\u000b\u0019+!+\u0002,B)\u0011+!\u0004\u0002hA\u00191)!\u001b\n\u0007\u0005-DI\u0001\u0003V]&$\bbBA\u0013#\u0001\u0007\u0011q\u0005\u0005\b\u0003c\n\u0002\u0019AA\u0014\u0003%Ig\u000eZ3y\u001d\u0006lW\rC\u0004\u0002vE\u0001\r!a\u001e\u0002\r\u0019LW\r\u001c3t!\u0019\tI(a!\u0002(9!\u00111PA@\u001d\u0011\ti#! \n\u0003eJ1!!!E\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\"\u0002\b\nA\u0011\n^3sC\ndWMC\u0002\u0002\u0002\u0012C\u0011\"a#\u0012!\u0003\u0005\r!!$\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ugB\u00191)a$\n\u0007\u0005EEIA\u0004C_>dW-\u00198\t\u0013\u0005U\u0015\u0003%AA\u0002\u0005]\u0015a\u00038v[J+\u0007\u000f\\5dCN\u0004RaQAM\u0003;K1!a'E\u0005\u0019y\u0005\u000f^5p]B\u00191)a(\n\u0007\u0005\u0005FIA\u0002J]RD\u0011\"!*\u0012!\u0003\u0005\r!a*\u0002\u0011\u0011,g-\u001a:sK\u0012\u0004RaQAM\u0003\u001bC\u0001\"!\u0010\u0012!\u0003\u0005\r\u0001\u001b\u0005\t\u0003\u0003\n\u0002\u0013!a\u0001c\u0006)2M]3bi\u0016Le\u000eZ3yI\u0011,g-Y;mi\u0012\"TCAAYU\u0011\ti)!\u0013\u0002+\r\u0014X-\u0019;f\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0017\u0016\u0005\u0003/\u000bI%A\u000bde\u0016\fG/Z%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005u&\u0006BAT\u0003\u0013\nQc\u0019:fCR,\u0017J\u001c3fq\u0012\"WMZ1vYR$s'A\u000bde\u0016\fG/Z%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001d\u0002%\r\u0014X-\u0019;f!JLW.\u0019:z\u0013:$W\r\u001f\u000b\u0011\u0003K\n9-!3\u0002N\u0006=\u0017\u0011[Aj\u0003+Dq!!\n\u0018\u0001\u0004\t9\u0003C\u0005\u0002r]\u0001\n\u00111\u0001\u0002LB)1)!'\u0002(!I\u00111R\f\u0011\u0002\u0003\u0007\u0011Q\u0012\u0005\n\u0003+;\u0002\u0013!a\u0001\u0003/C\u0011\"!*\u0018!\u0003\u0005\r!a*\t\u0011\u0005ur\u0003%AA\u0002!D\u0001\"!\u0011\u0018!\u0003\u0005\r!]\u0001\u001dGJ,\u0017\r^3Qe&l\u0017M]=J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYN\u000b\u0003\u0002L\u0006%\u0013\u0001H2sK\u0006$X\r\u0015:j[\u0006\u0014\u00180\u00138eKb$C-\u001a4bk2$HeM\u0001\u001dGJ,\u0017\r^3Qe&l\u0017M]=J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003q\u0019'/Z1uKB\u0013\u0018.\\1ss&sG-\u001a=%I\u00164\u0017-\u001e7uIU\nAd\u0019:fCR,\u0007K]5nCJL\u0018J\u001c3fq\u0012\"WMZ1vYR$c'\u0001\u000fde\u0016\fG/\u001a)sS6\f'/_%oI\u0016DH\u0005Z3gCVdG\u000fJ\u001c\u0002\u0013\u0011\u0014x\u000e]%oI\u0016DH\u0003DA3\u0003W\fi/a<\u0002t\u0006U\bbBA\u0013=\u0001\u0007\u0011q\u0005\u0005\b\u0003cr\u0002\u0019AA\u0014\u0011%\t\tP\bI\u0001\u0002\u0004\ti)A\tjO:|'/Z%g\u001d>$X\t_5tiND\u0001\"!\u0010\u001f!\u0003\u0005\r\u0001\u001b\u0005\t\u0003\u0003r\u0002\u0013!a\u0001c\u0006\u0019BM]8q\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005\u0019BM]8q\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u0019BM]8q\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u0001BM]8q!JLW.\u0019:z\u0013:$W\r\u001f\u000b\u000b\u0003K\u0012\tAa\u0001\u0003\u0006\t\u001d\u0001bBA\u0013E\u0001\u0007\u0011q\u0005\u0005\n\u0003c\u0014\u0003\u0013!a\u0001\u0003\u001bC\u0001\"!\u0010#!\u0003\u0005\r\u0001\u001b\u0005\t\u0003\u0003\u0012\u0003\u0013!a\u0001c\u0006QBM]8q!JLW.\u0019:z\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005QBM]8q!JLW.\u0019:z\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005QBM]8q!JLW.\u0019:z\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq/\u0019;dQ&sG-\u001a=fgRa\u0011Q\rB\n\u0005+\u0011IBa\u0007\u0003 !9\u0011Q\u0005\u0014A\u0002\u0005\u001d\u0002b\u0002B\fM\u0001\u0007\u0011qO\u0001\u000bS:$W\r\u001f(b[\u0016\u001c\bBBA\u001fM\u0001\u0007\u0001\u000eC\u0005\u0003\u001e\u0019\u0002\n\u00111\u0001\u0002\u000e\u0006aq/\u0019;dQB\u0013\u0018.\\1ss\"A\u0011\u0011\t\u0014\u0011\u0002\u0003\u0007\u0011/\u0001\fxCR\u001c\u0007.\u00138eKb,7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003Y9\u0018\r^2i\u0013:$W\r_3tI\u0011,g-Y;mi\u0012*\u0014a\u0006;p/\u0006$8\r\u001b+j[\u0016|W\u000f^#yG\u0016\u0004H/[8o)\u0019\u0011ICa\u000e\u0003BA!!1\u0006B\u001a\u001b\t\u0011iCC\u0002T\u0005_Q1A!\r\u007f\u0003\u0011)H/\u001b7\n\t\tU\"Q\u0006\u0002\u0011)&lWm\\;u\u000bb\u001cW\r\u001d;j_:DqA!\u000f*\u0001\u0004\u0011Y$A\u0001u!\u0011\tIH!\u0010\n\t\t}\u0012q\u0011\u0002\n)\"\u0014xn^1cY\u0016Da!!\u0010*\u0001\u0004A\u0017\u0001\u00062vS2$G)\u001a4feJ,G-\u00138eKb,7\u000f\u0006\u0005\u0002f\t\u001d#\u0011\nB&\u0011\u001d\t)C\u000ba\u0001\u0003OA\u0001\"!\u0010+!\u0003\u0005\r\u0001\u001b\u0005\t\u0003\u0003R\u0003\u0013!a\u0001c\u0006q\"-^5mI\u0012+g-\u001a:sK\u0012Le\u000eZ3yKN$C-\u001a4bk2$HEM\u0001\u001fEVLG\u000e\u001a#fM\u0016\u0014(/\u001a3J]\u0012,\u00070Z:%I\u00164\u0017-\u001e7uIM\nQ!];pi\u0016$BA!\u0016\u0003`A1!q\u000bB.\u0003Oi!A!\u0017\u000b\u0007\tEB)\u0003\u0003\u0003^\te#a\u0001+ss\"9!\u0011M\u0017A\u0002\u0005\u001d\u0012!A:\u0002\t\u0015DXm\u0019\u000b\u0011\u0003K\u00129Ga\u001b\u0003p\t\u0005%1\u0011BC\u0005\u000fCqA!\u001b/\u0001\u0004\ti)\u0001\u0005sK\u0006$wN\u001c7z\u0011\u001d\u0011iG\fa\u0001\u0003O\t\u0011b\u001d;bi\u0016lWM\u001c;\t\u000f\tEd\u00061\u0001\u0003t\u0005Yq/\u001b;i\u001fB$\u0018n\u001c8t!\u0015\u0019\u0015\u0011\u0014B;!\u0011\u00119H! \u000e\u0005\te$b\u0001B>q\u0005!!n]8o\u0013\u0011\u0011yH!\u001f\u0003\u0015)\u001bxN\\(cU\u0016\u001cG\u000fC\u0004\u0002\f:\u0002\r!!$\t\u000f\u0005Eh\u00061\u0001\u0002\u000e\"A\u0011Q\b\u0018\u0011\u0002\u0003\u0007\u0001\u000e\u0003\u0005\u0002B9\u0002\n\u00111\u0001r\u00039)\u00070Z2%I\u00164\u0017-\u001e7uIY\na\"\u001a=fG\u0012\"WMZ1vYR$s'\u0001\u0007fq\u0016\u001c\u0017J\u001c;fe:\fG\u000e\u0006\u0006\u0003\u0012\nu%q\u0014BT\u0005S\u0003R!UA\u0007\u0005'\u0003BA!&\u0003\u001a6\u0011!q\u0013\u0006\u0003kaJAAa'\u0003\u0018\nY\u0011+^3ssJ+7/\u001e7u\u0011\u001d\u0011I'\ra\u0001\u0003\u001bCqA!\u001c2\u0001\u0004\u0011\t\u000bE\u0002|\u0005GK1A!*}\u00051\u0019\u0005.\u0019:TKF,XM\\2f\u0011\u0019\ti$\ra\u0001Q\"1\u0011\u0011I\u0019A\u0002E\fAa\u001e:baRA\u0011Q\rBX\u0005g\u0013)\fC\u0004\u00032J\u0002\rA!%\u0002\u0005%t\u0007bBAFe\u0001\u0007\u0011Q\u0012\u0005\b\u0003c\u0014\u0004\u0019AAGQ\r\u0001!\u0011\u0018\t\u0005\u0005w\u0013)M\u0004\u0003\u0003>\n\u0005WB\u0001B`\u0015\r\t)FY\u0005\u0005\u0005\u0007\u0014y,A\u0005Ti\u0006\u0014\u0017\u000e\\5us&!!q\u0019Be\u0005!1v\u000e\\1uS2,'\u0002\u0002Bb\u0005\u007f\u0003")
public class AsyncQueryIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;
    private final String PrimaryIndexName;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private String PrimaryIndexName() {
        return this.PrimaryIndexName;
    }

    public Future<Seq<QueryIndex>> getAllIndexes(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        String statement = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(137).append("SELECT idx.* FROM system:indexes AS idx WHERE keyspace_id = \"").append(bucketName).append("\"\n         | AND `using`=\"gsi\" ORDER BY is_primary\n         | DESC, name ASC").toString()));
        return this.execInternal(true, statement, timeout, retryStrategy).map((Function1 & Serializable)x$1 -> x$1.rowsAs(QueryIndex$.MODULE$.codec()), this.ec()).flatMap((Function1 & Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Seq z = (Seq)success.value();
                future = Future$.MODULE$.successful((Object)z);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                future = Future$.MODULE$.failed(err);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, this.ec());
    }

    public Duration getAllIndexes$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> createIndex(String bucketName, String indexName, Iterable<String> fields, boolean ignoreIfExists, Option<Object> numReplicas, Option<Object> deferred, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement;
        JsonObject withOptions = JsonObject$.MODULE$.create();
        numReplicas.foreach((Function1 & Serializable)value -> withOptions.put("num_replica", BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value))));
        deferred.foreach((Function1 & Serializable)value -> withOptions.put("defer_build", BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value))));
        Try try_ = statement = this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> this.quote(indexName).flatMap((Function1 & Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(18).append("CREATE INDEX ").append((String)quotedIndexName).append(" ON ").append((String)quotedBucketName).append(" ").append(fields.mkString("(", ",", ")")).toString()).map((Function1 & Serializable)statement -> statement)));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)new Some((Object)withOptions), ignoreIfExists, false, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean createIndex$default$4() {
        return false;
    }

    public Option<Object> createIndex$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> createIndex$default$6() {
        return None$.MODULE$;
    }

    public Duration createIndex$default$7() {
        return this.DefaultTimeout();
    }

    public RetryStrategy createIndex$default$8() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> createPrimaryIndex(String bucketName, Option<String> indexName, boolean ignoreIfExists, Option<Object> numReplicas, Option<Object> deferred, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement;
        Try try_;
        JsonObject withOptions = JsonObject$.MODULE$.create();
        numReplicas.foreach((Function1 & Serializable)value -> withOptions.put("num_replica", BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value))));
        deferred.foreach((Function1 & Serializable)value -> withOptions.put("defer_build", BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value))));
        Option<String> option = indexName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String in = (String)some.value();
            try_ = this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> this.quote(in).flatMap((Function1 & Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(25).append("CREATE PRIMARY INDEX ").append((String)quotedIndexName).append(" ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable)statement -> statement)));
        } else {
            try_ = this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(24).append("CREATE PRIMARY INDEX ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable)statement -> statement));
        }
        Try try_2 = statement = try_;
        if (try_2 instanceof Success) {
            Success success = (Success)try_2;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)new Some((Object)withOptions), ignoreIfExists, false, timeout, retryStrategy);
        } else if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_2);
        }
        return future;
    }

    public Option<String> createPrimaryIndex$default$2() {
        return None$.MODULE$;
    }

    public boolean createPrimaryIndex$default$3() {
        return false;
    }

    public Option<Object> createPrimaryIndex$default$4() {
        return None$.MODULE$;
    }

    public Option<Object> createPrimaryIndex$default$5() {
        return None$.MODULE$;
    }

    public Duration createPrimaryIndex$default$6() {
        return this.DefaultTimeout();
    }

    public RetryStrategy createPrimaryIndex$default$7() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String bucketName, String indexName, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement = this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> this.quote(indexName).flatMap((Function1 & Serializable)quotedIndexName -> new Success((Object)new java.lang.StringBuilder(12).append("DROP INDEX ").append((String)quotedBucketName).append(".").append((String)quotedIndexName).toString()).map((Function1 & Serializable)statement -> statement)));
        Try try_ = statement;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, ignoreIfNotExists, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean dropIndex$default$3() {
        return false;
    }

    public Duration dropIndex$default$4() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$5() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropPrimaryIndex(String bucketName, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<BoxedUnit> future;
        Try statement = this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(22).append("DROP PRIMARY INDEX ON ").append((String)quotedBucketName).toString()).map((Function1 & Serializable)statement -> statement));
        Try try_ = statement;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String st = (String)success.value();
            future = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, ignoreIfNotExists, timeout, retryStrategy);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError((Object)try_);
        }
        return future;
    }

    public boolean dropPrimaryIndex$default$2() {
        return false;
    }

    public Duration dropPrimaryIndex$default$3() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropPrimaryIndex$default$4() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> watchIndexes(String bucketName, Iterable<String> indexNames, Duration timeout, boolean watchPrimary, RetryStrategy retryStrategy) {
        return SMono$.MODULE$.fromFuture(this.getAllIndexes(bucketName, timeout, retryStrategy), this.ec()).doOnNext((Function1 & Serializable)allIndexes -> {
            AsyncQueryIndexManager.$anonfun$watchIndexes$1(this, indexNames, watchPrimary, allIndexes);
            return BoxedUnit.UNIT;
        }).retryWhen(Retry.onlyIf(package$.MODULE$.asJavaPredicate((Function1 & Serializable)ctx -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$7(ctx)))).exponentialBackoff(DurationConversions$.MODULE$.scalaDurationToJava((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(50)).milliseconds()), DurationConversions$.MODULE$.scalaDurationToJava((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).seconds())).timeout(DurationConversions$.MODULE$.scalaDurationToJava(timeout)).toReactorRetry()).map((Function1 & Serializable)x$6 -> {
            AsyncQueryIndexManager.$anonfun$watchIndexes$8(x$6);
            return BoxedUnit.UNIT;
        }).onErrorMap((PartialFunction)new Serializable(this, timeout){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncQueryIndexManager $outer;
            private final Duration timeout$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof RetryExhaustedException) {
                    RetryExhaustedException retryExhaustedException = (RetryExhaustedException)A1;
                    object = this.$outer.com$couchbase$client$scala$manager$query$AsyncQueryIndexManager$$toWatchTimeoutException((Throwable)retryExhaustedException, this.timeout$1);
                } else {
                    object = A1;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof RetryExhaustedException ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timeout$1 = timeout$1;
            }
        }).toFuture();
    }

    public boolean watchIndexes$default$4() {
        return false;
    }

    public RetryStrategy watchIndexes$default$5() {
        return this.DefaultRetryStrategy();
    }

    public TimeoutException com$couchbase$client$scala$manager$query$AsyncQueryIndexManager$$toWatchTimeoutException(Throwable t, Duration timeout) {
        StringBuilder msg = new StringBuilder(new java.lang.StringBuilder(44).append("A requested index is still not ready after ").append(timeout).append(".").toString());
        return new TimeoutException(msg.toString());
    }

    public Future<BoxedUnit> buildDeferredIndexes(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return this.getAllIndexes(bucketName, timeout, retryStrategy).flatMap((Function1 & Serializable)allIndexes -> {
            Future future;
            Seq deferred = (Seq)((IterableOps)allIndexes.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$buildDeferredIndexes$2(x$7)))).map((Function1 & Serializable)v -> this.quote(v.name()));
            if (deferred.isEmpty()) {
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            } else {
                Future<BoxedUnit> future2;
                Try statement = RowTraversalUtil$.MODULE$.traverse(deferred.iterator()).flatMap((Function1 & Serializable)quotedDefers -> this.quote(bucketName).flatMap((Function1 & Serializable)quotedBucketName -> new Success((Object)new java.lang.StringBuilder(17).append("BUILD INDEX ON ").append((String)quotedBucketName).append("(").append(quotedDefers.mkString(",")).append(")").toString()).map((Function1 & Serializable)statement -> statement)));
                Try try_ = statement;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String st = (String)success.value();
                    future2 = this.exec(false, st, (Option<JsonObject>)None$.MODULE$, false, false, timeout, retryStrategy);
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    future2 = Future$.MODULE$.failed(err);
                } else {
                    throw new MatchError((Object)try_);
                }
                future = future2;
            }
            return future;
        }, this.ec());
    }

    public Duration buildDeferredIndexes$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy buildDeferredIndexes$default$3() {
        return this.DefaultRetryStrategy();
    }

    private Try<String> quote(String s) {
        return s.contains("`") ? new Failure((Throwable)new IllegalArgumentException(new java.lang.StringBuilder(35).append("Value [").append(RedactableArgument.redactMeta((Object)s)).append("] may not contain backticks.").toString())) : new Success((Object)new java.lang.StringBuilder(2).append("`").append(s).append("`").toString());
    }

    private Future<BoxedUnit> exec(boolean readonly, String statement, Option<JsonObject> withOptions, boolean ignoreIfExists, boolean ignoreIfNotExists, Duration timeout, RetryStrategy retryStrategy) {
        Future<QueryResult> future;
        if (withOptions.isEmpty() || ((JsonObject)withOptions.get()).isEmpty()) {
            future = this.execInternal(readonly, statement, timeout, retryStrategy);
        } else {
            String revisedStatement = new java.lang.StringBuilder(6).append(statement).append(" WITH ").append(JacksonTransformers.MAPPER.writeValueAsString(withOptions.get())).toString();
            future = this.execInternal(readonly, revisedStatement, timeout, retryStrategy);
        }
        Future<QueryResult> out = future;
        return this.wrap(out, ignoreIfExists, ignoreIfNotExists);
    }

    private Duration exec$default$6() {
        return this.DefaultTimeout();
    }

    private RetryStrategy exec$default$7() {
        return this.DefaultRetryStrategy();
    }

    public Future<QueryResult> execInternal(boolean readonly, CharSequence statement, Duration timeout, RetryStrategy retryStrategy) {
        QueryOptions queryOpts = QueryOptions$.MODULE$.apply().readonly(readonly).timeout(timeout).retryStrategy(retryStrategy);
        return this.cluster().query(((Object)statement).toString(), queryOpts);
    }

    public Future<BoxedUnit> wrap(Future<QueryResult> in, boolean ignoreIfExists, boolean ignoreIfNotExists) {
        return in.map((Function1 & Serializable)x$8 -> {
            AsyncQueryIndexManager.$anonfun$wrap$1(x$8);
            return BoxedUnit.UNIT;
        }, this.ec()).recover((PartialFunction)new Serializable(null, ignoreIfNotExists, ignoreIfExists){
            private static final long serialVersionUID = 0L;
            private final boolean ignoreIfNotExists$1;
            private final boolean ignoreIfExists$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 instanceof IndexNotFoundException && this.ignoreIfNotExists$1 ? BoxedUnit.UNIT : (A1 instanceof IndexExistsException && this.ignoreIfExists$1 ? BoxedUnit.UNIT : function1.apply(x1));
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IndexNotFoundException && this.ignoreIfNotExists$1 ? true : throwable instanceof IndexExistsException && this.ignoreIfExists$1;
                return bl;
            }
            {
                this.ignoreIfNotExists$1 = ignoreIfNotExists$1;
                this.ignoreIfExists$1 = ignoreIfExists$1;
            }
        }, this.ec());
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$3(QueryIndex v$1, String x$2) {
        String string = x$2;
        String string2 = v$1.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$2(Iterable indexNames$1, boolean watchPrimary$1, QueryIndex v) {
        return indexNames$1.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$3(v, x$2))) || watchPrimary$1 && v.isPrimary();
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$6(QueryIndex x$5) {
        String string = x$5.state();
        String string2 = "online";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$watchIndexes$1(AsyncQueryIndexManager $this, Iterable indexNames$1, boolean watchPrimary$1, Seq allIndexes) {
        Seq matchingIndexes = (Seq)allIndexes.filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$2(indexNames$1, watchPrimary$1, v)));
        boolean primaryIndexPresent = matchingIndexes.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isPrimary()));
        if (watchPrimary$1 && !primaryIndexPresent) {
            throw new IndexNotFoundException($this.PrimaryIndexName());
        }
        scala.collection.immutable.Set matchingIndexNames = ((IterableOnceOps)matchingIndexes.map((Function1 & Serializable)x$4 -> x$4.name())).toSet();
        scala.collection.immutable.Set missingIndexNames = (scala.collection.immutable.Set)indexNames$1.toSet().diff((Set)matchingIndexNames);
        if (missingIndexNames.nonEmpty()) {
            throw new IndexNotFoundException(missingIndexNames.mkString(","));
        }
        Seq offlineIndexes = (Seq)matchingIndexes.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AsyncQueryIndexManager.$anonfun$watchIndexes$6(x$5)));
        if (offlineIndexes.nonEmpty()) {
            throw new IndexesNotReadyException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$watchIndexes$7(RetryContext ctx) {
        return CbThrowables.hasCause((Throwable)ctx.exception(), IndexesNotReadyException.class);
    }

    public static final /* synthetic */ void $anonfun$watchIndexes$8(Seq x$6) {
    }

    public static final /* synthetic */ boolean $anonfun$buildDeferredIndexes$2(QueryIndex x$7) {
        String string = x$7.state();
        String string2 = "deferred";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$wrap$1(QueryResult x$8) {
    }

    public AsyncQueryIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
        this.PrimaryIndexName = "#primary";
    }
}

