/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.bucket;

import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.durability.Durability$Majority$;
import com.couchbase.client.scala.durability.Durability$MajorityAndPersistToActive$;
import com.couchbase.client.scala.durability.Durability$PersistToMajority$;
import com.couchbase.client.scala.json.JsonArray;
import com.couchbase.client.scala.json.JsonArray$;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.json.JsonObject$;
import com.couchbase.client.scala.manager.bucket.BucketSettings;
import com.couchbase.client.scala.manager.bucket.BucketType;
import com.couchbase.client.scala.manager.bucket.BucketType$;
import com.couchbase.client.scala.manager.bucket.CompressionMode;
import com.couchbase.client.scala.manager.bucket.CompressionMode$;
import com.couchbase.client.scala.manager.bucket.CompressionMode$Off$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple11;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;
import upickle.core.Types;

public final class BucketSettings$
implements Serializable {
    public static final BucketSettings$ MODULE$ = new BucketSettings$();
    private static final Types.ReadWriter<Durability> rw = CouchbasePickler$.MODULE$.readwriter(CouchbasePickler$.MODULE$.ReadWriter().join(CouchbasePickler$.MODULE$.StringReader(), CouchbasePickler$.MODULE$.StringWriter())).bimap((Function1 & Serializable)x0$1 -> {
        String string;
        Durability durability = x0$1;
        if (Durability$Disabled$.MODULE$.equals(durability)) {
            string = "none";
        } else if (Durability$Majority$.MODULE$.equals(durability)) {
            string = "majority";
        } else if (Durability$MajorityAndPersistToActive$.MODULE$.equals(durability)) {
            string = "majorityAndPersistActive";
        } else if (Durability$PersistToMajority$.MODULE$.equals(durability)) {
            string = "persistToMajority";
        } else {
            throw new IllegalStateException("Unknown durability");
        }
        return string;
    }, (Function1 & Serializable)x0$2 -> {
        Durability durability;
        block6: {
            String string = x0$2;
            switch (string == null ? 0 : string.hashCode()) {
                case -412092456: {
                    if (!"majorityAndPersistActive".equals(string)) break;
                    durability = Durability$MajorityAndPersistToActive$.MODULE$;
                    break block6;
                }
                case -95420188: {
                    if (!"persistToMajority".equals(string)) break;
                    durability = Durability$PersistToMajority$.MODULE$;
                    break block6;
                }
                case 3387192: {
                    if (!"none".equals(string)) break;
                    durability = Durability$Disabled$.MODULE$;
                    break block6;
                }
                case 22010965: {
                    if (!"majority".equals(string)) break;
                    durability = Durability$Majority$.MODULE$;
                    break block6;
                }
            }
            throw new IllegalStateException("Unknown durability");
        }
        return durability;
    });

    public BucketSettings parseFrom(byte[] raw) {
        JsonObject json = JsonObject$.MODULE$.fromJson(new String(raw, StandardCharsets.UTF_8));
        return this.parseFrom(json);
    }

    public BucketSettings parseFrom(JsonObject json) {
        boolean flushEnabled = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> json.bool("flush")).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        int rawRAM = json.obj("quota").num("rawRAM");
        int ramMB = rawRAM / 0x100000;
        int numReplicas = json.num("replicaNumber");
        JsonArray nodes = json.arr("nodes");
        BooleanRef isHealthy = BooleanRef.create((boolean)nodes.nonEmpty());
        CollectionConverters$.MODULE$.ListHasAsScala(nodes.values()).asScala().foreach((Function1 & Serializable)v -> {
            BucketSettings$.$anonfun$parseFrom$3(isHealthy, v);
            return BoxedUnit.UNIT;
        });
        int maxTTL = BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable)() -> json.num("maxTTL")).toOption().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        CompressionMode compressionMode = (CompressionMode)Try$.MODULE$.apply((Function0 & Serializable)() -> new StringBuilder(2).append("\"").append(json.str("compressionMode")).append("\"").toString()).map((Function1 & Serializable)v -> CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(v), CouchbasePickler$.MODULE$.read$default$2(), CompressionMode$.MODULE$.rw())).getOrElse((Function0 & Serializable)() -> CompressionMode$Off$.MODULE$);
        Durability minimumDurabilityLevel = (Durability)Try$.MODULE$.apply((Function0 & Serializable)() -> new StringBuilder(2).append("\"").append(json.str("durabilityMinLevel")).append("\"").toString()).map((Function1 & Serializable)v -> CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(v), CouchbasePickler$.MODULE$.read$default$2(), MODULE$.rw())).getOrElse((Function0 & Serializable)() -> Durability$Disabled$.MODULE$);
        return new BucketSettings(json.str("name"), flushEnabled, ramMB, numReplicas, BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> json.bool("replicaIndex")).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)), CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(new StringBuilder(2).append("\"").append(json.str("bucketType")).append("\"").toString()), CouchbasePickler$.MODULE$.read$default$2(), BucketType$.MODULE$.rw()), CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromString(new StringBuilder(2).append("\"").append(json.str("evictionPolicy")).append("\"").toString()), CouchbasePickler$.MODULE$.read$default$2(), EjectionMethod$.MODULE$.rw()), maxTTL, compressionMode, minimumDurabilityLevel, isHealthy.elem);
    }

    public Seq<BucketSettings> parseSeqFrom(byte[] raw) {
        JsonArray jsonArr = (JsonArray)JsonArray$.MODULE$.fromJson(new String(raw, StandardCharsets.UTF_8)).get();
        return (Seq)CollectionConverters$.MODULE$.ListHasAsScala(jsonArr.values()).asScala().toSeq().map((Function1 & Serializable)v -> {
            JsonObject j = (JsonObject)v;
            return MODULE$.parseFrom(j);
        });
    }

    public Types.ReadWriter<Durability> rw() {
        return rw;
    }

    public BucketSettings apply(String name, boolean flushEnabled, int ramQuotaMB, int numReplicas, boolean replicaIndexes, BucketType bucketType, EjectionMethod ejectionMethod, int maxTTL, CompressionMode compressionMode, Durability minimumDurabilityLevel, boolean healthy) {
        return new BucketSettings(name, flushEnabled, ramQuotaMB, numReplicas, replicaIndexes, bucketType, ejectionMethod, maxTTL, compressionMode, minimumDurabilityLevel, healthy);
    }

    public Option<Tuple11<String, Object, Object, Object, Object, BucketType, EjectionMethod, Object, CompressionMode, Durability, Object>> unapply(BucketSettings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.name(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.flushEnabled()), (Object)BoxesRunTime.boxToInteger((int)x$0.ramQuotaMB()), (Object)BoxesRunTime.boxToInteger((int)x$0.numReplicas()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.replicaIndexes()), (Object)x$0.bucketType(), (Object)x$0.ejectionMethod(), (Object)BoxesRunTime.boxToInteger((int)x$0.maxTTL()), (Object)x$0.compressionMode(), (Object)x$0.minimumDurabilityLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.healthy())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BucketSettings$.class);
    }

    public static final /* synthetic */ void $anonfun$parseFrom$3(BooleanRef isHealthy$1, Object v) {
        block0: {
            JsonObject j = (JsonObject)v;
            String string = j.str("status");
            String string2 = "healthy";
            if (!(string == null ? string2 != null : !string.equals(string2))) break block0;
            isHealthy$1.elem = false;
        }
    }

    private BucketSettings$() {
    }
}

