/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.user;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.GroupNotFoundException;
import com.couchbase.client.core.error.UserNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerRequest;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.user.AuthDomain;
import com.couchbase.client.scala.manager.user.AuthDomain$Local$;
import com.couchbase.client.scala.manager.user.Group;
import com.couchbase.client.scala.manager.user.Group$;
import com.couchbase.client.scala.manager.user.ReactiveUserManager$;
import com.couchbase.client.scala.manager.user.RoleAndDescription;
import com.couchbase.client.scala.manager.user.RoleAndDescription$;
import com.couchbase.client.scala.manager.user.User;
import com.couchbase.client.scala.manager.user.UserAndMetadata;
import com.couchbase.client.scala.manager.user.UserAndMetadata$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Try;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0005\t=w!\u0002\u001b6\u0011\u0003\u0011e!\u0002#6\u0011\u0003)\u0005\"B&\u0002\t\u0003a\u0005\"B'\u0002\t\u0003qe\u0001\u0002#6\u0001]C\u0001\u0002\u0017\u0003\u0003\u0006\u0004%I!\u0017\u0005\t?\u0012\u0011\t\u0011)A\u00055\")1\n\u0002C\u0001A\"A1\r\u0002b\u0001\n\u0003ID\r\u0003\u0004n\t\u0001\u0006I!\u001a\u0005\t]\u0012\u0011\r\u0011\"\u0001:_\"1a\u000f\u0002Q\u0001\nADQa\u001e\u0003\u0005\naDQa \u0003\u0005\naDq!!\u0001\u0005\t\u0013\t\u0019\u0001\u0003\u0004\u0002(\u0011!I\u0001\u001f\u0005\b\u0003S!A\u0011BA\u0016\u0011\u001d\t\t\u0004\u0002C\u0005\u0003gAq!!\r\u0005\t\u0013\t\t\u0007C\u0004\u00022\u0011!I!!)\t\u000f\u0005mF\u0001\"\u0005\u0002>\"9\u0011q\u001b\u0003\u0005\u0002\u0005e\u0007\"CAv\tE\u0005I\u0011AAw\u0011%\u0011\u0019\u0001BI\u0001\n\u0003\u0011)\u0001C\u0005\u0003\n\u0011\t\n\u0011\"\u0001\u0003\f!9!q\u0002\u0003\u0005\u0002\tE\u0001\"\u0003B\u0010\tE\u0005I\u0011AAw\u0011%\u0011\t\u0003BI\u0001\n\u0003\u0011)\u0001C\u0005\u0003$\u0011\t\n\u0011\"\u0001\u0003\f!9!Q\u0005\u0003\u0005\u0002\t\u001d\u0002\"\u0003B\u001d\tE\u0005I\u0011AAw\u0011%\u0011Y\u0004BI\u0001\n\u0003\u0011)\u0001C\u0005\u0003>\u0011\t\n\u0011\"\u0001\u0003\f!9!q\b\u0003\u0005\u0002\t\u0005\u0003\"\u0003B&\tE\u0005I\u0011AAw\u0011%\u0011i\u0005BI\u0001\n\u0003\u0011)\u0001C\u0005\u0003P\u0011\t\n\u0011\"\u0001\u0003\f!9!\u0011\u000b\u0003\u0005\u0002\tM\u0003\"\u0003B1\tE\u0005I\u0011\u0001B\u0003\u0011%\u0011\u0019\u0007BI\u0001\n\u0003\u0011Y\u0001C\u0004\u0003f\u0011!\tAa\u001a\t\u0013\teD!%A\u0005\u0002\t\u0015\u0001\"\u0003B>\tE\u0005I\u0011\u0001B\u0006\u0011\u001d\u0011i\b\u0002C\u0001\u0005\u007fB\u0011Ba\"\u0005#\u0003%\tA!\u0002\t\u0013\t%E!%A\u0005\u0002\t-\u0001b\u0002BF\t\u0011\u0005!Q\u0012\u0005\n\u0005/#\u0011\u0013!C\u0001\u0005\u000bA\u0011B!'\u0005#\u0003%\tAa\u0003\t\u000f\tmE\u0001\"\u0001\u0003\u001e\"I!Q\u0015\u0003\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u0005O#\u0011\u0013!C\u0001\u0005\u0017\t1CU3bGRLg/Z+tKJl\u0015M\\1hKJT!AN\u001c\u0002\tU\u001cXM\u001d\u0006\u0003qe\nq!\\1oC\u001e,'O\u0003\u0002;w\u0005)1oY1mC*\u0011A(P\u0001\u0007G2LWM\u001c;\u000b\u0005yz\u0014!C2pk\u000eD'-Y:f\u0015\u0005\u0001\u0015aA2p[\u000e\u0001\u0001CA\"\u0002\u001b\u0005)$a\u0005*fC\u000e$\u0018N^3Vg\u0016\u0014X*\u00198bO\u0016\u00148CA\u0001G!\t9\u0015*D\u0001I\u0015\u0005Q\u0014B\u0001&I\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AQ\u0001\rG>tg/\u001a:u%>dWm\u001d\u000b\u0003\u001fV\u00032a\u0012)S\u0013\t\t\u0006JA\u0003BeJ\f\u0017\u0010\u0005\u0002H'&\u0011A\u000b\u0013\u0002\u0005\u0005f$X\rC\u0003W\u0007\u0001\u0007q*\u0001\u0002j]N\u0011AAR\u0001\u0005G>\u0014X-F\u0001[!\tYV,D\u0001]\u0015\tA6(\u0003\u0002_9\n!1i\u001c:f\u0003\u0015\u0019wN]3!)\t\t'\r\u0005\u0002D\t!)\u0001l\u0002a\u00015\u0006)B-\u001a4bk2$X*\u00198bO\u0016\u0014H+[7f_V$X#A3\u0011\u0005\u0019\\W\"A4\u000b\u0005!L\u0017\u0001\u0002;j[\u0016T\u0011A[\u0001\u0005U\u00064\u0018-\u0003\u0002mO\nAA)\u001e:bi&|g.\u0001\feK\u001a\fW\u000f\u001c;NC:\fw-\u001a:US6,w.\u001e;!\u0003Q!WMZ1vYR\u0014V\r\u001e:z'R\u0014\u0018\r^3hsV\t\u0001\u000f\u0005\u0002ri6\t!O\u0003\u0002t9\u0006)!/\u001a;ss&\u0011QO\u001d\u0002\u000e%\u0016$(/_*ue\u0006$XmZ=\u0002+\u0011,g-Y;miJ+GO]=TiJ\fG/Z4zA\u0005a\u0001/\u0019;i\r>\u0014Xk]3sgV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}S\u0006!A.\u00198h\u0013\tq8P\u0001\u0004TiJLgnZ\u0001\ra\u0006$\bNR8s%>dWm]\u0001\fa\u0006$\bNR8s+N,'\u000fF\u0003z\u0003\u000b\ty\u0001C\u0004\u0002\b9\u0001\r!!\u0003\u0002\r\u0011|W.Y5o!\r\u0019\u00151B\u0005\u0004\u0003\u001b)$AC!vi\"$u.\\1j]\"9\u0011\u0011\u0003\bA\u0002\u0005M\u0011\u0001C;tKJt\u0017-\\3\u0011\t\u0005U\u00111\u0005\b\u0005\u0003/\ty\u0002E\u0002\u0002\u001a!k!!a\u0007\u000b\u0007\u0005u\u0011)\u0001\u0004=e>|GOP\u0005\u0004\u0003CA\u0015A\u0002)sK\u0012,g-C\u0002\u007f\u0003KQ1!!\tI\u00035\u0001\u0018\r\u001e5G_J<%o\\;qg\u0006a\u0001/\u0019;i\r>\u0014xI]8vaR\u0019\u00110!\f\t\u000f\u0005=\u0002\u00031\u0001\u0002\u0014\u0005!a.Y7f\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\t\u0005U\u0012q\u000b\t\u0007\u0003o\t)%!\u0013\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007i\nyDC\u0002Y\u0003\u0003R!!a\u0011\u0002\u000fI,\u0017m\u0019;pe&!\u0011qIA\u001d\u0005\u0015\u0019Vj\u001c8p!\u0011\tY%a\u0015\u000e\u0005\u00055#b\u0001\u001d\u0002P)\u0019\u0011\u0011\u000b/\u0002\u00075\u001cx-\u0003\u0003\u0002V\u00055#AF$f]\u0016\u0014\u0018nY'b]\u0006<WM\u001d*fgB|gn]3\t\u000f\u0005e\u0013\u00031\u0001\u0002\\\u00059!/Z9vKN$\b\u0003BA&\u0003;JA!a\u0018\u0002N\t)r)\u001a8fe&\u001cW*\u00198bO\u0016\u0014(+Z9vKN$HCCA\u001b\u0003G\n9)a#\u0002\u001e\"9\u0011Q\r\nA\u0002\u0005\u001d\u0014AB7fi\"|G\r\u0005\u0003\u0002j\u0005\rUBAA6\u0015\u0011\ti'a\u001c\u0002\t!$H\u000f\u001d\u0006\u0005\u0003c\n\u0019(A\u0003d_\u0012,7M\u0003\u0003\u0002v\u0005]\u0014a\u00025b]\u0012dWM\u001d\u0006\u0005\u0003s\nY(A\u0003oKR$\u0018P\u0003\u0003\u0002~\u0005}\u0014AA5p\u0015\r\t\t\tX\u0001\u0005I\u0016\u00048/\u0003\u0003\u0002\u0006\u0006-$A\u0003%uiBlU\r\u001e5pI\"9\u0011\u0011\u0012\nA\u0002\u0005M\u0011\u0001\u00029bi\"Dq!!$\u0013\u0001\u0004\ty)A\u0004uS6,w.\u001e;\u0011\t\u0005E\u00151T\u0007\u0003\u0003'SA!!&\u0002\u0018\u0006AA-\u001e:bi&|gNC\u0002\u0002\u001a\"\u000b!bY8oGV\u0014(/\u001a8u\u0013\ra\u00171\u0013\u0005\u0007\u0003?\u0013\u0002\u0019\u00019\u0002\u001bI,GO]=TiJ\fG/Z4z)1\t)$a)\u0002&\u0006\u001d\u0016qWA]\u0011\u001d\t)g\u0005a\u0001\u0003OBq!!#\u0014\u0001\u0004\t\u0019\u0002C\u0004\u0002*N\u0001\r!a+\u0002\t\t|G-\u001f\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*\u0019\u0011\u0011\u0017/\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003k\u000byKA\u000bVe2\fV/\u001a:z'R\u0014\u0018N\\4Ck&dG-\u001a:\t\u000f\u000555\u00031\u0001\u0002\u0010\"1\u0011qT\nA\u0002A\f1b\u00195fG.\u001cF/\u0019;vgR1\u0011qXAh\u0003'\u0004b!!1\u0002F\u0006%WBAAb\u0015\r\t\t\fS\u0005\u0005\u0003\u000f\f\u0019MA\u0002Uef\u00042aRAf\u0013\r\ti\r\u0013\u0002\u0005+:LG\u000fC\u0004\u0002RR\u0001\r!!\u0013\u0002\u0011I,7\u000f]8og\u0016Dq!!6\u0015\u0001\u0004\t\u0019\"\u0001\u0004bGRLwN\\\u0001\bO\u0016$Xk]3s))\tY.a9\u0002f\u0006\u001d\u0018\u0011\u001e\t\u0007\u0003o\t)%!8\u0011\u0007\r\u000by.C\u0002\u0002bV\u0012q\"V:fe\u0006sG-T3uC\u0012\fG/\u0019\u0005\b\u0003#)\u0002\u0019AA\n\u0011%\t9!\u0006I\u0001\u0002\u0004\tI\u0001C\u0005\u0002\u000eV\u0001\n\u00111\u0001\u0002\u0010\"A\u0011qT\u000b\u0011\u0002\u0003\u0007\u0001/A\thKR,6/\u001a:%I\u00164\u0017-\u001e7uII*\"!a<+\t\u0005%\u0011\u0011_\u0016\u0003\u0003g\u0004B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0005v]\u000eDWmY6fI*\u0019\u0011Q %\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0002\u0005](!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\tr-\u001a;Vg\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u001d!\u0006BAH\u0003c\f\u0011cZ3u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iAK\u0002q\u0003c\f1bZ3u\u00032dWk]3sgRA!1\u0003B\r\u00057\u0011i\u0002\u0005\u0004\u00028\tU\u0011Q\\\u0005\u0005\u0005/\tIDA\u0003T\r2,\b\u0010C\u0005\u0002\be\u0001\n\u00111\u0001\u0002\n!I\u0011QR\r\u0011\u0002\u0003\u0007\u0011q\u0012\u0005\t\u0003?K\u0002\u0013!a\u0001a\u0006)r-\u001a;BY2,6/\u001a:tI\u0011,g-Y;mi\u0012\n\u0014!F4fi\u0006cG.V:feN$C-\u001a4bk2$HEM\u0001\u0016O\u0016$\u0018\t\u001c7Vg\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003))\bo]3siV\u001bXM\u001d\u000b\u000b\u0005S\u0011YCa\r\u00036\t]\u0002CBA\u001c\u0003\u000b\nI\r\u0003\u00047;\u0001\u0007!Q\u0006\t\u0004\u0007\n=\u0012b\u0001B\u0019k\t!Qk]3s\u0011%\t9!\bI\u0001\u0002\u0004\tI\u0001C\u0005\u0002\u000ev\u0001\n\u00111\u0001\u0002\u0010\"A\u0011qT\u000f\u0011\u0002\u0003\u0007\u0001/\u0001\u000bvaN,'\u000f^+tKJ$C-\u001a4bk2$HEM\u0001\u0015kB\u001cXM\u001d;Vg\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002)U\u00048/\u001a:u+N,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003!!'o\u001c9Vg\u0016\u0014HC\u0003B\u0015\u0005\u0007\u0012)Ea\u0012\u0003J!9\u0011\u0011C\u0011A\u0002\u0005M\u0001\"CA\u0004CA\u0005\t\u0019AA\u0005\u0011%\ti)\tI\u0001\u0002\u0004\ty\t\u0003\u0005\u0002 \u0006\u0002\n\u00111\u0001q\u0003I!'o\u001c9Vg\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0002%\u0011\u0014x\u000e]+tKJ$C-\u001a4bk2$HeM\u0001\u0013IJ|\u0007/V:fe\u0012\"WMZ1vYR$C'\u0001\bbm\u0006LG.\u00192mKJ{G.Z:\u0015\r\tU#Q\fB0!\u0019\t9D!\u0006\u0003XA\u00191I!\u0017\n\u0007\tmSG\u0001\nS_2,\u0017I\u001c3EKN\u001c'/\u001b9uS>t\u0007\"CAGKA\u0005\t\u0019AAH\u0011!\ty*\nI\u0001\u0002\u0004\u0001\u0018\u0001G1wC&d\u0017M\u00197f%>dWm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0005A\u0012M^1jY\u0006\u0014G.\u001a*pY\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u0011\u001d,Go\u0012:pkB$\u0002B!\u001b\u0003r\tU$q\u000f\t\u0007\u0003o\t)Ea\u001b\u0011\u0007\r\u0013i'C\u0002\u0003pU\u0012Qa\u0012:pkBDqAa\u001d)\u0001\u0004\t\u0019\"A\u0005he>,\bOT1nK\"I\u0011Q\u0012\u0015\u0011\u0002\u0003\u0007\u0011q\u0012\u0005\t\u0003?C\u0003\u0013!a\u0001a\u0006\u0011r-\u001a;He>,\b\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003I9W\r^$s_V\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019\u001d,G/\u00117m\u000fJ|W\u000f]:\u0015\r\t\u0005%1\u0011BC!\u0019\t9D!\u0006\u0003l!I\u0011QR\u0016\u0011\u0002\u0003\u0007\u0011q\u0012\u0005\t\u0003?[\u0003\u0013!a\u0001a\u00061r-\u001a;BY2<%o\\;qg\u0012\"WMZ1vYR$\u0013'\u0001\fhKR\fE\u000e\\$s_V\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-)\bo]3si\u001e\u0013x.\u001e9\u0015\u0011\t%\"q\u0012BJ\u0005+CqA!%/\u0001\u0004\u0011Y'A\u0003he>,\b\u000fC\u0005\u0002\u000e:\u0002\n\u00111\u0001\u0002\u0010\"A\u0011q\u0014\u0018\u0011\u0002\u0003\u0007\u0001/A\u000bvaN,'\u000f^$s_V\u0004H\u0005Z3gCVdG\u000f\n\u001a\u0002+U\u00048/\u001a:u\u000fJ|W\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005IAM]8q\u000fJ|W\u000f\u001d\u000b\t\u0005S\u0011yJ!)\u0003$\"9!1O\u0019A\u0002\u0005M\u0001\"CAGcA\u0005\t\u0019AAH\u0011!\ty*\rI\u0001\u0002\u0004\u0001\u0018a\u00053s_B<%o\\;qI\u0011,g-Y;mi\u0012\u0012\u0014a\u00053s_B<%o\\;qI\u0011,g-Y;mi\u0012\u001a\u0004f\u0001\u0003\u0003,B!!Q\u0016Be\u001d\u0011\u0011yKa1\u000f\t\tE&\u0011\u0019\b\u0005\u0005g\u0013yL\u0004\u0003\u00036\nuf\u0002\u0002B\\\u0005wsA!!\u0007\u0003:&\t\u0001)\u0003\u0002?\u007f%\u0011A(P\u0005\u00031nJ1!!@]\u0013\u0011\u0011)Ma2\u0002\u0013M#\u0018MY5mSRL(bAA\u007f9&!!1\u001aBg\u0005!1v\u000e\\1uS2,'\u0002\u0002Bc\u0005\u000f\u0004")
public class ReactiveUserManager {
    private final Core core;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public static byte[] convertRoles(byte[] in) {
        return ReactiveUserManager$.MODULE$.convertRoles(in);
    }

    private Core core() {
        return this.core;
    }

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForUsers() {
        return "/settings/rbac/users";
    }

    private String pathForRoles() {
        return "/settings/rbac/roles";
    }

    private String pathForUser(AuthDomain domain, String username) {
        return new StringBuilder(2).append(this.pathForUsers()).append("/").append(UrlQueryStringBuilder.urlEncode((String)domain.alias())).append("/").append(UrlQueryStringBuilder.urlEncode((String)username)).toString();
    }

    private String pathForGroups() {
        return "/settings/rbac/groups";
    }

    private String pathForGroup(String name) {
        return new StringBuilder(1).append(this.pathForGroups()).append("/").append(UrlQueryStringBuilder.urlEncode((String)name)).toString();
    }

    private SMono<GenericManagerResponse> sendRequest(GenericManagerRequest request) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), request);
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), method, path, timeout, retryStrategy);
    }

    private SMono<GenericManagerResponse> sendRequest(HttpMethod method, String path, UrlQueryStringBuilder body, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core(), method, path, body, timeout, retryStrategy);
    }

    public Try<BoxedUnit> checkStatus(GenericManagerResponse response, String action) {
        return ManagerUtil$.MODULE$.checkStatus(response, action);
    }

    public SMono<UserAndMetadata> getUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new UserNotFoundException(domain.alias(), username));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get ").append(domain).append(" user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    UserAndMetadata value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), UserAndMetadata$.MODULE$.rw());
                    sMono2 = SMono$.MODULE$.just((Object)value);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public AuthDomain getUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SFlux<UserAndMetadata> getAllUsers(AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForUsers(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            SFlux sFlux;
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all users");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
            } else {
                Seq value = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.SeqLikeReader(UserAndMetadata$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
                sFlux = SFlux$.MODULE$.fromIterable((Iterable)value);
            }
            return sFlux;
        });
    }

    public AuthDomain getAllUsers$default$1() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration getAllUsers$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllUsers$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertUser(User user, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("name", user.displayName()).add("roles", ((IterableOnceOps)user.roles().map((Function1 & Serializable)x$1 -> x$1.format())).mkString(","));
        Object object = user.groups().nonEmpty() ? params.add("groups", user.groups().mkString(",")) : BoxedUnit.UNIT;
        user.password().foreach((Function1 & Serializable)pwd -> params.add("password", pwd));
        return this.sendRequest(HttpMethod.PUT, this.pathForUser(domain, user.username()), params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(14).append("create user [").append(RedactableArgument.redactUser((Object)user.username())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sMono = SMono$.MODULE$.raiseError(err);
            } else {
                sMono = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
            }
            return sMono;
        });
    }

    public AuthDomain upsertUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration upsertUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropUser(String username, AuthDomain domain, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForUser(domain, username), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new UserNotFoundException(domain.alias(), username));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("drop user [").append(RedactableArgument.redactUser((Object)username)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public AuthDomain dropUser$default$2() {
        return AuthDomain$Local$.MODULE$;
    }

    public Duration dropUser$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropUser$default$4() {
        return this.defaultRetryStrategy();
    }

    public SFlux<RoleAndDescription> availableRoles(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForRoles(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            SFlux sFlux;
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all roles");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
            } else {
                byte[] converted = ReactiveUserManager$.MODULE$.convertRoles(response.content());
                Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(converted), CouchbasePickler$.MODULE$.SeqLikeReader(RoleAndDescription$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
                sFlux = SFlux$.MODULE$.fromIterable((Iterable)values);
            }
            return sFlux;
        });
    }

    public Duration availableRoles$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy availableRoles$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<Group> getGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new GroupNotFoundException(groupName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(12).append("get group [").append(RedactableArgument.redactMeta((Object)groupName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    Group value = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), Group$.MODULE$.rw());
                    sMono2 = SMono$.MODULE$.just((Object)value);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration getGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<Group> getAllGroups(Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.GET, this.pathForGroups(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            SFlux sFlux;
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, "get all groups");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
            } else {
                Seq values = (Seq)CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.SeqLikeReader(Group$.MODULE$.rw(), Seq$.MODULE$.iterableFactory()));
                sFlux = SFlux$.MODULE$.fromIterable((Iterable)values);
            }
            return sFlux;
        });
    }

    public Duration getAllGroups$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllGroups$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> upsertGroup(Group group, Duration timeout, RetryStrategy retryStrategy) {
        UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames().add("description", group.description()).add("roles", ((IterableOnceOps)group.roles().map((Function1 & Serializable)x$2 -> x$2.format())).mkString(","));
        group.ldapGroupReference().foreach((Function1 & Serializable)lgr -> params.add("ldap_group_ref", lgr));
        return this.sendRequest(HttpMethod.PUT, this.pathForGroup(group.name()), params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(15).append("create group [").append(RedactableArgument.redactSystem((Object)group.name())).append("]").toString());
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sMono = SMono$.MODULE$.raiseError(err);
            } else {
                sMono = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
            }
            return sMono;
        });
    }

    public Duration upsertGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy upsertGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> dropGroup(String groupName, Duration timeout, RetryStrategy retryStrategy) {
        return this.sendRequest(HttpMethod.DELETE, this.pathForGroup(groupName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)new GroupNotFoundException(groupName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = this.checkStatus((GenericManagerResponse)response, new StringBuilder(13).append("drop group [").append(RedactableArgument.redactUser((Object)groupName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration dropGroup$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropGroup$default$3() {
        return this.defaultRetryStrategy();
    }

    public ReactiveUserManager(Core core) {
        this.core = core;
        this.defaultManagerTimeout = core.context().environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = core.context().environment().retryStrategy();
    }
}

