/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.bucket;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.error.BucketExistsException;
import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.manager.GenericManagerResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.durability.Durability;
import com.couchbase.client.scala.durability.Durability$Disabled$;
import com.couchbase.client.scala.durability.Durability$Majority$;
import com.couchbase.client.scala.durability.Durability$MajorityAndPersistToActive$;
import com.couchbase.client.scala.durability.Durability$PersistToMajority$;
import com.couchbase.client.scala.manager.ManagerUtil$;
import com.couchbase.client.scala.manager.bucket.BucketSettings;
import com.couchbase.client.scala.manager.bucket.BucketSettings$;
import com.couchbase.client.scala.manager.bucket.BucketType;
import com.couchbase.client.scala.manager.bucket.BucketType$Couchbase$;
import com.couchbase.client.scala.manager.bucket.BucketType$Ephemeral$;
import com.couchbase.client.scala.manager.bucket.BucketType$Memcached$;
import com.couchbase.client.scala.manager.bucket.CreateBucketSettings;
import com.couchbase.client.scala.manager.bucket.EjectionMethod;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$FullEviction$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$NoEviction$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$NotRecentlyUsed$;
import com.couchbase.client.scala.manager.bucket.EjectionMethod$ValueOnly$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001B\u0010!\u00015B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006s\u0001!\tA\u000f\u0005\t}\u0001\u0011\r\u0011\"\u0001%\u007f!1\u0001\n\u0001Q\u0001\n\u0001C\u0001\"\u0013\u0001C\u0002\u0013\u0005AE\u0013\u0005\u0007#\u0002\u0001\u000b\u0011B&\t\u000bI\u0003A\u0011B*\t\u000bi\u0003A\u0011B.\t\u000b!\u0004A\u0011B5\t\u000b-\u0004A\u0011\u00017\t\u0013\u0005U\u0001!%A\u0005\u0002\u0005]\u0001\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003kAq!a\u0013\u0001\t\u0013\ti\u0005C\u0004\u0002^\u0001!\t!a\u0018\t\u0013\u0005\u001d\u0004!%A\u0005\u0002\u0005]\u0001\"CA5\u0001E\u0005I\u0011AA\u0018\u0011\u001d\tY\u0007\u0001C\u0005\u0003[Bq!! \u0001\t\u0003\ty\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\u0018!I\u0011\u0011\u0012\u0001\u0012\u0002\u0013\u0005\u0011q\u0006\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011%\ti\nAI\u0001\n\u0003\t9\u0002C\u0005\u0002 \u0002\t\n\u0011\"\u0001\u00020!9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006\"CAX\u0001E\u0005I\u0011AA\f\u0011%\t\t\fAI\u0001\n\u0003\ty\u0003C\u0004\u00024\u0002!\t!!.\t\u0013\u0005u\u0006!%A\u0005\u0002\u0005]\u0001\"CA`\u0001E\u0005I\u0011AA\u0018\u0005U\u0011V-Y2uSZ,')^2lKRl\u0015M\\1hKJT!!\t\u0012\u0002\r\t,8m[3u\u0015\t\u0019C%A\u0004nC:\fw-\u001a:\u000b\u0005\u00152\u0013!B:dC2\f'BA\u0014)\u0003\u0019\u0019G.[3oi*\u0011\u0011FK\u0001\nG>,8\r\u001b2bg\u0016T\u0011aK\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0002\"aL\u0019\u000e\u0003AR\u0011!J\u0005\u0003eA\u0012a!\u00118z%\u00164\u0017\u0001B2pe\u0016\u0004\"!N\u001c\u000e\u0003YR!a\r\u0014\n\u0005a2$\u0001B\"pe\u0016\fa\u0001P5oSRtDCA\u001e>!\ta\u0004!D\u0001!\u0011\u0015\u0019$\u00011\u00015\u0003U!WMZ1vYRl\u0015M\\1hKJ$\u0016.\\3pkR,\u0012\u0001\u0011\t\u0003\u0003\u001ak\u0011A\u0011\u0006\u0003\u0007\u0012\u000bA\u0001^5nK*\tQ)\u0001\u0003kCZ\f\u0017BA$C\u0005!!UO]1uS>t\u0017A\u00063fM\u0006,H\u000e^'b]\u0006<WM\u001d+j[\u0016|W\u000f\u001e\u0011\u0002)\u0011,g-Y;miJ+GO]=TiJ\fG/Z4z+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(7\u0003\u0015\u0011X\r\u001e:z\u0013\t\u0001VJA\u0007SKR\u0014\u0018p\u0015;sCR,w-_\u0001\u0016I\u00164\u0017-\u001e7u%\u0016$(/_*ue\u0006$XmZ=!\u00039\u0001\u0018\r\u001e5G_J\u0014UoY6fiN,\u0012\u0001\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/\u0012\u000bA\u0001\\1oO&\u0011\u0011L\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\u001bA\fG\u000f\u001b$pe\n+8m[3u)\t!F\fC\u0003^\u0011\u0001\u0007a,\u0001\u0006ck\u000e\\W\r\u001e(b[\u0016\u0004\"a\u00184\u000f\u0005\u0001$\u0007CA11\u001b\u0005\u0011'BA2-\u0003\u0019a$o\\8u}%\u0011Q\rM\u0001\u0007!J,G-\u001a4\n\u0005e;'BA31\u0003I\u0001\u0018\r\u001e5G_J\u0014UoY6fi\u001acWo\u001d5\u0015\u0005QS\u0007\"B/\n\u0001\u0004q\u0016AB2sK\u0006$X\rF\u0003nu~\f\t\u0002E\u0002ok^l\u0011a\u001c\u0006\u0003aF\f\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0005\u0015\u0012(BA\u001at\u0015\u0005!\u0018a\u0002:fC\u000e$xN]\u0005\u0003m>\u0014QaU'p]>\u0004\"a\f=\n\u0005e\u0004$\u0001B+oSRDQa\u001f\u0006A\u0002q\f\u0001b]3ui&twm\u001d\t\u0003yuL!A \u0011\u0003)\r\u0013X-\u0019;f\u0005V\u001c7.\u001a;TKR$\u0018N\\4t\u0011%\t\tA\u0003I\u0001\u0002\u0004\t\u0019!A\u0004uS6,w.\u001e;\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005AA-\u001e:bi&|gNC\u0002\u0002\u000eA\n!bY8oGV\u0014(/\u001a8u\u0013\r9\u0015q\u0001\u0005\t\u0003'Q\u0001\u0013!a\u0001\u0017\u0006i!/\u001a;ssN#(/\u0019;fOf\f\u0001c\u0019:fCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005e!\u0006BA\u0002\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O\u0001\u0014AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0011GJ,\u0017\r^3%I\u00164\u0017-\u001e7uIM*\"!!\r+\u0007-\u000bY\"\u0001\rde\u0016\fG/Z+qI\u0006$XMQ;dW\u0016$8\u000b[1sK\u0012$2\"\\A\u001c\u0003s\ti$a\u0010\u0002B!)10\u0004a\u0001y\"1\u00111H\u0007A\u0002y\u000bA\u0001]1uQ\"9\u0011\u0011A\u0007A\u0002\u0005\r\u0001BBA\n\u001b\u0001\u00071\nC\u0004\u0002D5\u0001\r!!\u0012\u0002\rU\u0004H-\u0019;f!\ry\u0013qI\u0005\u0004\u0003\u0013\u0002$a\u0002\"p_2,\u0017M\\\u0001\u0019G\",7m\u001b,bY&$WI[3di&|g.T3uQ>$G\u0003BA(\u00037\u0002R!!\u0015\u0002X]l!!a\u0015\u000b\u0007\u0005U\u0003'\u0001\u0003vi&d\u0017\u0002BA-\u0003'\u00121\u0001\u0016:z\u0011\u0015Yh\u00021\u0001}\u00031)\b\u000fZ1uK\n+8m[3u)\u001di\u0017\u0011MA2\u0003KBQa_\bA\u0002qD\u0011\"!\u0001\u0010!\u0003\u0005\r!a\u0001\t\u0011\u0005Mq\u0002%AA\u0002-\u000ba#\u001e9eCR,')^2lKR$C-\u001a4bk2$HEM\u0001\u0017kB$\u0017\r^3Ck\u000e\\W\r\u001e\u0013eK\u001a\fW\u000f\u001c;%g\u000592m\u001c8wKJ$8+\u001a;uS:<7\u000fV8QCJ\fWn\u001d\u000b\u0007\u0003_\nI(a\u001f\u0011\t\u0005E\u0014QO\u0007\u0003\u0003gR1!!\u00167\u0013\u0011\t9(a\u001d\u0003+U\u0013H.U;fef\u001cFO]5oO\n+\u0018\u000e\u001c3fe\")1P\u0005a\u0001y\"9\u00111\t\nA\u0002\u0005\u0015\u0013A\u00033s_B\u0014UoY6fiR9Q.!!\u0002\u0004\u0006\u0015\u0005\"B/\u0014\u0001\u0004q\u0006\"CA\u0001'A\u0005\t\u0019AA\u0002\u0011!\t\u0019b\u0005I\u0001\u0002\u0004Y\u0015\u0001\u00063s_B\u0014UoY6fi\u0012\"WMZ1vYR$#'\u0001\u000bee>\u0004()^2lKR$C-\u001a4bk2$HeM\u0001\nO\u0016$()^2lKR$\u0002\"a$\u0002\u0018\u0006e\u00151\u0014\t\u0005]V\f\t\nE\u0002=\u0003'K1!!&!\u00059\u0011UoY6fiN+G\u000f^5oONDQ!\u0018\fA\u0002yC\u0011\"!\u0001\u0017!\u0003\u0005\r!a\u0001\t\u0011\u0005Ma\u0003%AA\u0002-\u000b1cZ3u\u0005V\u001c7.\u001a;%I\u00164\u0017-\u001e7uII\n1cZ3u\u0005V\u001c7.\u001a;%I\u00164\u0017-\u001e7uIM\nQbZ3u\u00032d')^2lKR\u001cHCBAS\u0003W\u000bi\u000bE\u0003o\u0003O\u000b\t*C\u0002\u0002*>\u0014Qa\u0015$mkbD\u0011\"!\u0001\u001a!\u0003\u0005\r!a\u0001\t\u0011\u0005M\u0011\u0004%AA\u0002-\u000bqcZ3u\u00032d')^2lKR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0002/\u001d,G/\u00117m\u0005V\u001c7.\u001a;tI\u0011,g-Y;mi\u0012\u0012\u0014a\u00034mkND')^2lKR$r!\\A\\\u0003s\u000bY\fC\u0003^9\u0001\u0007a\fC\u0005\u0002\u0002q\u0001\n\u00111\u0001\u0002\u0004!A\u00111\u0003\u000f\u0011\u0002\u0003\u00071*A\u000bgYV\u001c\bNQ;dW\u0016$H\u0005Z3gCVdG\u000f\n\u001a\u0002+\u0019dWo\u001d5Ck\u000e\\W\r\u001e\u0013eK\u001a\fW\u000f\u001c;%g!\u001a\u0001!a1\u0011\t\u0005\u0015\u0017\u0011\u001d\b\u0005\u0003\u000f\fYN\u0004\u0003\u0002J\u0006eg\u0002BAf\u0003/tA!!4\u0002V:!\u0011qZAj\u001d\r\t\u0017\u0011[\u0005\u0002W%\u0011\u0011FK\u0005\u0003O!J!a\r\u0014\n\u0007\u0005\u001db'\u0003\u0003\u0002^\u0006}\u0017!C*uC\nLG.\u001b;z\u0015\r\t9CN\u0005\u0005\u0003G\f)O\u0001\u0005W_2\fG/\u001b7f\u0015\u0011\ti.a8")
public class ReactiveBucketManager {
    private final Core core;
    private final java.time.Duration defaultManagerTimeout;
    private final RetryStrategy defaultRetryStrategy;

    public java.time.Duration defaultManagerTimeout() {
        return this.defaultManagerTimeout;
    }

    public RetryStrategy defaultRetryStrategy() {
        return this.defaultRetryStrategy;
    }

    private String pathForBuckets() {
        return "/pools/default/buckets/";
    }

    private String pathForBucket(String bucketName) {
        return new StringBuilder(0).append(this.pathForBuckets()).append(UrlQueryStringBuilder.urlEncode((String)bucketName)).toString();
    }

    private String pathForBucketFlush(String bucketName) {
        return new StringBuilder(42).append("/pools/default/buckets/").append(UrlQueryStringBuilder.urlEncode((String)bucketName)).append("/controller/doFlush").toString();
    }

    public SMono<BoxedUnit> create(CreateBucketSettings settings, Duration timeout, RetryStrategy retryStrategy) {
        return this.createUpdateBucketShared(settings, this.pathForBuckets(), timeout, retryStrategy, false);
    }

    public Duration create$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy create$default$3() {
        return this.defaultRetryStrategy();
    }

    private SMono<BoxedUnit> createUpdateBucketShared(CreateBucketSettings settings, String path, Duration timeout, RetryStrategy retryStrategy, boolean update) {
        SMono sMono;
        Try<BoxedUnit> try_ = this.checkValidEjectionMethod(settings);
        if (try_ instanceof Success) {
            UrlQueryStringBuilder params = this.convertSettingsToParams(settings, update);
            sMono = ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.POST, path, params, timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
                SMono sMono;
                ResponseStatus responseStatus = response.status();
                ResponseStatus responseStatus2 = ResponseStatus.INVALID_ARGS;
                if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null) && response.content() != null) {
                    String content = new String(response.content(), StandardCharsets.UTF_8);
                    sMono = content.contains("Bucket with given name already exists") ? SMono$.MODULE$.raiseError((Throwable)BucketExistsException.forBucket((String)settings.name())) : SMono$.MODULE$.raiseError((Throwable)new CouchbaseException(content));
                } else {
                    SMono sMono2;
                    Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(16).append("create bucket [").append(RedactableArgument.redactMeta((Object)settings)).append("]").toString());
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable err = failure.exception();
                        sMono2 = SMono$.MODULE$.raiseError(err);
                    } else {
                        sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                    }
                    sMono = sMono2;
                }
                return sMono;
            });
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    private Try<BoxedUnit> checkValidEjectionMethod(CreateBucketSettings settings) {
        boolean bl;
        Some some;
        EjectionMethod ejectionMethod;
        Some some2;
        EjectionMethod ejectionMethod2;
        Option<EjectionMethod> option = settings.ejectionMethod();
        boolean bl2 = option instanceof Some && EjectionMethod$FullEviction$.MODULE$.equals(ejectionMethod2 = (EjectionMethod)(some2 = (Some)option).value()) ? true : option instanceof Some && EjectionMethod$ValueOnly$.MODULE$.equals(ejectionMethod = (EjectionMethod)(some = (Some)option).value());
        if (bl2) {
            Some some3;
            BucketType bucketType;
            Option<BucketType> option2 = settings.bucketType();
            boolean bl3 = option2 instanceof Some && BucketType$Couchbase$.MODULE$.equals(bucketType = (BucketType)(some3 = (Some)option2).value()) ? true : None$.MODULE$.equals(option2);
            boolean bl4 = bl3;
            bl = bl4;
        } else {
            Some some4;
            EjectionMethod ejectionMethod3;
            Some some5;
            EjectionMethod ejectionMethod4;
            boolean bl5 = option instanceof Some && EjectionMethod$NoEviction$.MODULE$.equals(ejectionMethod4 = (EjectionMethod)(some5 = (Some)option).value()) ? true : option instanceof Some && EjectionMethod$NotRecentlyUsed$.MODULE$.equals(ejectionMethod3 = (EjectionMethod)(some4 = (Some)option).value());
            if (bl5) {
                Some some6;
                BucketType bucketType;
                Option<BucketType> option3 = settings.bucketType();
                boolean bl6 = option3 instanceof Some && BucketType$Ephemeral$.MODULE$.equals(bucketType = (BucketType)(some6 = (Some)option3).value());
                bl = bl6;
            } else if (None$.MODULE$.equals(option)) {
                bl = true;
            } else {
                throw new MatchError(option);
            }
        }
        boolean validEjectionType = bl;
        return !validEjectionType ? new Failure((Throwable)new InvalidArgumentException(new StringBuilder(54).append("Cannot use ejection policy ").append(settings.ejectionMethod()).append(" together with bucket type ").append(settings.bucketType().getOrElse((Function0 & Serializable)() -> BucketType$Couchbase$.MODULE$)).toString(), null, null)) : new Success((Object)BoxedUnit.UNIT);
    }

    public SMono<BoxedUnit> updateBucket(CreateBucketSettings settings, Duration timeout, RetryStrategy retryStrategy) {
        SMono sMono;
        Try<BoxedUnit> try_ = this.checkValidEjectionMethod(settings);
        if (try_ instanceof Success) {
            sMono = this.getAllBuckets(timeout, retryStrategy).collectSeq().map((Function1 & Serializable)buckets -> BoxesRunTime.boxToBoolean((boolean)buckets.exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReactiveBucketManager.$anonfun$updateBucket$2(settings$2, x$1))))).flatMap((Function1 & Serializable)bucketExists -> this.createUpdateBucketShared(settings, this.pathForBucket(settings.name()), timeout, retryStrategy, BoxesRunTime.unboxToBoolean((Object)bucketExists)));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            sMono = SMono$.MODULE$.raiseError(err);
        } else {
            throw new MatchError(try_);
        }
        return sMono;
    }

    public Duration updateBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy updateBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    private UrlQueryStringBuilder convertSettingsToParams(CreateBucketSettings settings, boolean update) {
        UrlQueryStringBuilder params;
        block4: {
            Some some;
            BucketType bucketType;
            Some some2;
            BucketType bucketType2;
            params = UrlQueryStringBuilder.createForUrlSafeNames();
            params.add("ramQuotaMB", settings.ramQuotaMB());
            Option<BucketType> option = settings.bucketType();
            if (option instanceof Some && BucketType$Memcached$.MODULE$.equals(bucketType2 = (BucketType)(some2 = (Some)option).value())) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                settings.numReplicas().foreach((Function1 & Serializable)v -> params.add("replicaNumber", BoxesRunTime.unboxToInt((Object)v)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            settings.flushEnabled().foreach((Function1 & Serializable)v -> params.add("flushEnabled", BoxesRunTime.unboxToBoolean((Object)v) ? 1 : 0));
            settings.maxTTL().foreach((Function1 & Serializable)v -> params.add("maxTTL", BoxesRunTime.unboxToInt((Object)v)));
            settings.ejectionMethod().foreach((Function1 & Serializable)v -> params.add("evictionPolicy", v.alias()));
            settings.compressionMode().foreach((Function1 & Serializable)v -> params.add("compressionMode", v.alias()));
            settings.minimumDurabilityLevel().filterNot((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)ReactiveBucketManager.$anonfun$convertSettingsToParams$6(d))).map((Function1 & Serializable)x0$1 -> {
                String string;
                Durability durability = x0$1;
                if (Durability$Majority$.MODULE$.equals(durability)) {
                    string = "majority";
                } else if (Durability$MajorityAndPersistToActive$.MODULE$.equals(durability)) {
                    string = "majorityAndPersistActive";
                } else if (Durability$PersistToMajority$.MODULE$.equals(durability)) {
                    string = "persistToMajority";
                } else {
                    throw new IllegalStateException("Unknown durability");
                }
                return string;
            }).foreach((Function1 & Serializable)v -> params.add("durabilityMinLevel", v));
            if (update) break block4;
            params.add("name", settings.name());
            settings.bucketType().foreach((Function1 & Serializable)v -> params.add("bucketType", v.alias()));
            settings.conflictResolutionType().foreach((Function1 & Serializable)v -> params.add("conflictResolutionType", v.alias()));
            Option<BucketType> option2 = settings.bucketType();
            if (option2 instanceof Some && BucketType$Ephemeral$.MODULE$.equals(bucketType = (BucketType)(some = (Some)option2).value())) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                settings.replicaIndexes().foreach((Function1 & Serializable)v -> params.add("replicaIndex", BoxesRunTime.unboxToBoolean((Object)v) ? 1 : 0));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return params;
    }

    public SMono<BoxedUnit> dropBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.DELETE, this.pathForBucket(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(14).append("drop bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration dropBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy dropBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public SMono<BucketSettings> getBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.GET, this.pathForBucket(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(13).append("get bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    BucketSettings bs = BucketSettings$.MODULE$.parseFrom(response.content());
                    sMono2 = SMono$.MODULE$.just((Object)bs);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration getBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public SFlux<BucketSettings> getAllBuckets(Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.GET, this.pathForBuckets(), timeout, retryStrategy).flatMapMany((Function1 & Serializable)response -> {
            SFlux sFlux;
            Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, "get all buckets");
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable err = failure.exception();
                sFlux = SFlux$.MODULE$.raiseError(err, SFlux$.MODULE$.raiseError$default$2());
            } else {
                Seq<BucketSettings> bs = BucketSettings$.MODULE$.parseSeqFrom(response.content());
                sFlux = SFlux$.MODULE$.fromIterable(bs);
            }
            return sFlux;
        });
    }

    public Duration getAllBuckets$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy getAllBuckets$default$2() {
        return this.defaultRetryStrategy();
    }

    public SMono<BoxedUnit> flushBucket(String bucketName, Duration timeout, RetryStrategy retryStrategy) {
        return ManagerUtil$.MODULE$.sendRequest(this.core, HttpMethod.POST, this.pathForBucketFlush(bucketName), timeout, retryStrategy).flatMap((Function1 & Serializable)response -> {
            SMono sMono;
            ResponseStatus responseStatus = response.status();
            ResponseStatus responseStatus2 = ResponseStatus.NOT_FOUND;
            if (!(responseStatus != null ? !responseStatus.equals(responseStatus2) : responseStatus2 != null)) {
                sMono = SMono$.MODULE$.raiseError((Throwable)BucketNotFoundException.forBucket((String)bucketName));
            } else {
                SMono sMono2;
                Try<BoxedUnit> try_ = ManagerUtil$.MODULE$.checkStatus((GenericManagerResponse)response, new StringBuilder(15).append("flush bucket [").append(RedactableArgument.redactMeta((Object)bucketName)).append("]").toString());
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable err = failure.exception();
                    sMono2 = SMono$.MODULE$.raiseError(err);
                } else {
                    sMono2 = SMono$.MODULE$.just((Object)BoxedUnit.UNIT);
                }
                sMono = sMono2;
            }
            return sMono;
        });
    }

    public Duration flushBucket$default$2() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.defaultManagerTimeout());
    }

    public RetryStrategy flushBucket$default$3() {
        return this.defaultRetryStrategy();
    }

    public static final /* synthetic */ boolean $anonfun$updateBucket$2(CreateBucketSettings settings$2, BucketSettings x$1) {
        String string = x$1.name();
        String string2 = settings$2.name();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertSettingsToParams$6(Durability d) {
        Durability durability = d;
        Durability$Disabled$ durability$Disabled$ = Durability$Disabled$.MODULE$;
        return !(durability != null ? !durability.equals(durability$Disabled$) : durability$Disabled$ != null);
    }

    public ReactiveBucketManager(Core core) {
        this.core = core;
        this.defaultManagerTimeout = core.context().environment().timeoutConfig().managementTimeout();
        this.defaultRetryStrategy = core.context().environment().retryStrategy();
    }
}

