/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.RawJsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ScalaSignature;
import scala.reflect.api.Mirrors;
import scala.reflect.api.TypeTags;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005I4A!\u0003\u0006\u0001+!)q\u0004\u0001C\u0001A!)!\u0005\u0001C!G!)1\b\u0001C!y\u001d)1N\u0003E\u0001Y\u001a)\u0011B\u0003E\u0001[\")q$\u0002C\u0001]\"9q.\u0002b\u0001\n\u0003\u0001\bBB9\u0006A\u0003%\u0011EA\tSC^T5o\u001c8Ue\u0006t7oY8eKJT!a\u0003\u0007\u0002\u000b\r|G-Z2\u000b\u00055q\u0011!B:dC2\f'BA\b\u0011\u0003\u0019\u0019G.[3oi*\u0011\u0011CE\u0001\nG>,8\r\u001b2bg\u0016T\u0011aE\u0001\u0004G>l7\u0001A\n\u0004\u0001YY\u0002CA\f\u001a\u001b\u0005A\"\"A\u0007\n\u0005iA\"AB!osJ+g\r\u0005\u0002\u001d;5\t!\"\u0003\u0002\u001f\u0015\tYBK]1og\u000e|G-\u001a:XSRDw.\u001e;TKJL\u0017\r\\5{KJ\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011AB3oG>$W-\u0006\u0002%eQ\u0011QE\f\t\u0004M%ZS\"A\u0014\u000b\u0005!B\u0012\u0001B;uS2L!AK\u0014\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001dY%\u0011QF\u0003\u0002\r\u000b:\u001cw\u000eZ3e-\u0006dW/\u001a\u0005\u0006_\t\u0001\r\u0001M\u0001\u0006m\u0006dW/\u001a\t\u0003cIb\u0001\u0001B\u00034\u0005\t\u0007AGA\u0001U#\t)\u0004\b\u0005\u0002\u0018m%\u0011q\u0007\u0007\u0002\b\u001d>$\b.\u001b8h!\t9\u0012(\u0003\u0002;1\t\u0019\u0011I\\=\u0002\r\u0011,7m\u001c3f+\ti\u0014\tF\u0002??\u001a$\"a\u0010\"\u0011\u0007\u0019J\u0003\t\u0005\u00022\u0003\u0012)1g\u0001b\u0001i!)1i\u0001a\u0002\t\u0006\u0019A/Y4\u0011\u0007\u0015K\u0006I\u0004\u0002G-:\u0011qi\u0015\b\u0003\u0011Bs!!\u0013(\u000f\u0005)kU\"A&\u000b\u00051#\u0012A\u0002\u001fs_>$h(C\u0001\u000e\u0013\ty\u0005$A\u0004sK\u001adWm\u0019;\n\u0005E\u0013\u0016a\u0002:v]RLW.\u001a\u0006\u0003\u001fbI!\u0001V+\u0002\u000fA\f7m[1hK*\u0011\u0011KU\u0005\u0003/b\u000b\u0001\"\u001e8jm\u0016\u00148/\u001a\u0006\u0003)VK!AW.\u0003\u0017]+\u0017m\u001b+za\u0016$\u0016mZ\u0005\u00039v\u0013\u0001\u0002V=qKR\u000bwm\u001d\u0006\u0003=J\u000b1!\u00199j\u0011\u0015y3\u00011\u0001a!\r9\u0012mY\u0005\u0003Eb\u0011Q!\u0011:sCf\u0004\"a\u00063\n\u0005\u0015D\"\u0001\u0002\"zi\u0016DQaZ\u0002A\u0002!\fQA\u001a7bON\u0004\"aF5\n\u0005)D\"aA%oi\u0006\t\"+Y<Kg>tGK]1og\u000e|G-\u001a:\u0011\u0005q)1CA\u0003\u0017)\u0005a\u0017\u0001C%ogR\fgnY3\u0016\u0003\u0005\n\u0011\"\u00138ti\u0006t7-\u001a\u0011")
public class RawJsonTranscoder
implements TranscoderWithoutSerializer {
    public static RawJsonTranscoder Instance() {
        return RawJsonTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        Success success;
        T t = value;
        if (t instanceof byte[]) {
            byte[] byArray = (byte[])t;
            success = new Success((Object)new EncodedValue(byArray, CodecFlags.JSON_COMPAT_FLAGS));
        } else if (t instanceof String) {
            String string = (String)t;
            success = new Success((Object)new EncodedValue(string.getBytes(StandardCharsets.UTF_8), CodecFlags.JSON_COMPAT_FLAGS));
        } else {
            success = new Failure((Throwable)new IllegalArgumentException("Only Array[Byte] and String types are supported for the RawJsonTranscoder!"));
        }
        return success;
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, TypeTags.WeakTypeTag<T> tag) {
        return ((Class)((Mirrors.RuntimeMirror)tag.mirror()).runtimeClass(tag.tpe())).isAssignableFrom(byte[].class) ? new Success((Object)value) : (((Class)((Mirrors.RuntimeMirror)tag.mirror()).runtimeClass(tag.tpe())).isAssignableFrom(String.class) ? new Success((Object)new String(value, StandardCharsets.UTF_8)) : new Failure((Throwable)new DecodingFailureException("RawJsonTranscoder can only decode into Array[Byte] or String!")));
    }
}

