/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\reh\u0001B%K\u0001MC\u0001\"\u0017\u0001\u0003\u0002\u0013\u0006IA\u0017\u0005\nG\u0002\u0011)\u0019!C\u0001\u0015\u0012D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\n[\u0002\u0011)\u0019!C\u0001\u0015:D\u0001\" \u0001\u0003\u0002\u0003\u0006Ia\u001c\u0005\u0006}\u0002!\ta \u0005\u000b\u0003\u0017\u0001!\u0019!C\u0002\u0015\u00065\u0001\u0002CA\u000e\u0001\u0001\u0006I!a\u0004\t\u0011\u0001\u0004!\u0019!C\u0001\u0003;Aq!a\b\u0001A\u0003%Q\fC\u0005j\u0001\t\u0007I\u0011\u0001(\u0002\"!A\u00111\u0006\u0001!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002.\u0001\u0011\r\u0011\"\u0001K\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\u000b\u0003s\u0001!\u0019!C\u0001\u0015\u0006m\u0002\u0002CA%\u0001\u0001\u0006I!!\u0010\t\u0015\u0005-\u0003A1A\u0005\u0002)\u000bY\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA\u001f\u0011)\ty\u0005\u0001b\u0001\n\u0003Q\u0015\u0011\u000b\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002T!Q\u0011\u0011\r\u0001C\u0002\u0013\u0005!*a\u0019\t\u0011\u0005U\u0004\u0001)A\u0005\u0003KB!\"a\u001e\u0001\u0005\u0004%\tASA=\u0011!\t\t\t\u0001Q\u0001\n\u0005m\u0004BCAB\u0001\t\u0007I\u0011\u0001&\u0002\u0006\"A\u0011Q\u0012\u0001!\u0002\u0013\t9\tC\u0006\u0002\u0010\u0002A)\u0019!C\u0001\u0015\u0006E\u0005bCAR\u0001!\u0015\r\u0011\"\u0001K\u0003KC1\"a-\u0001\u0011\u000b\u0007I\u0011\u0001&\u00026\"Q\u00111\u0019\u0001C\u0002\u0013\u0005!*!2\t\u0011\u0005\r\b\u0001)A\u0005\u0003\u000fD!\"!:\u0001\u0005\u0004%\tASAt\u0011!\ty\u000f\u0001Q\u0001\n\u0005%\bBCAy\u0001!\u0015\r\u0011\"\u0001\u0002t\"Q!\u0011\u0003\u0001\t\u0006\u0004%\tAa\u0005\t\u0015\tu\u0001\u0001#b\u0001\n\u0003\u0011y\u0002\u0003\u0006\u0003.\u0001A)\u0019!C\u0001\u0005_A!Ba\u0010\u0001\u0011\u000b\u0007I\u0011\u0001B!\u0011\u001d\ti\u000b\u0001C\u0001\u0005\u0017Bq!a\u001c\u0001\t\u0003\u00119\u0006C\u0004\u0002p\u0001!\tA!\u001e\t\u0013\tE\u0005!%A\u0005\u0002\tM\u0005\"\u0003BT\u0001E\u0005I\u0011\u0001BU\u0011%\u0011i\u000bAI\u0001\n\u0003\u0011y\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\tM\u0006\u0001\"\u0001\u0003N\"I!1\u001c\u0001\u0012\u0002\u0013\u0005!Q\u001c\u0005\n\u0005C\u0004\u0011\u0013!C\u0001\u0005SCqAa9\u0001\t\u0003\u0011)\u000fC\u0004\u0003d\u0002!\taa\u0005\t\u0013\rm\u0001!%A\u0005\u0002\t%\u0006bBB\u000f\u0001\u0011\u00051q\u0004\u0005\n\u0007W\u0001\u0011\u0013!C\u0001\u0005SCqa!\f\u0001\t\u0003\u0019y\u0003C\u0005\u0004B\u0001\t\n\u0011\"\u0001\u0004D!91Q\u0006\u0001\u0005\u0002\r\u001d\u0003bBB+\u0001\u0011\u00051q\u000b\u0005\n\u0007S\u0002\u0011\u0013!C\u0001\u0007WBqa!\u0016\u0001\t\u0003\u0019y\u0007C\u0004\u0004z\u0001!\taa\u001f\t\u000f\re\u0004\u0001\"\u0001\u0004\u0000!A11\u0012\u0001\u0005\u0002)\u001biiB\u0004\u0004\u0010*C\ta!%\u0007\r%S\u0005\u0012ABJ\u0011\u0019q\b\t\"\u0001\u0004\u0016\"91q\u0013!\u0005\u0002\re\u0005bBBL\u0001\u0012\u000511\u0017\u0005\b\u0007/\u0003E\u0011AB`\u0011!\u0011\u0019\u000f\u0011C\u0001\u0019\u000e\u0015\u0007\u0002CBp\u0001\u0012\u0005Aj!9\t\u0011\r}\u0007\t\"\u0001M\u0007WD\u0001ba<A\t\u0003a5\u0011\u001f\u0002\r\u0003NLhnY\"mkN$XM\u001d\u0006\u0003\u00172\u000bQa]2bY\u0006T!!\u0014(\u0002\r\rd\u0017.\u001a8u\u0015\ty\u0005+A\u0005d_V\u001c\u0007NY1tK*\t\u0011+A\u0002d_6\u001c\u0001a\u0005\u0002\u0001)B\u0011QkV\u0007\u0002-*\t1*\u0003\u0002Y-\n1\u0011I\\=SK\u001a\f1\"\u001a8wSJ|g.\\3oiB\u0019QkW/\n\u0005q3&\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0005y\u000bW\"A0\u000b\u0005\u0001T\u0015aA3om&\u0011!m\u0018\u0002\u0013\u00072,8\u000f^3s\u000b:4\u0018N]8o[\u0016tG/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u0002KB\u0011aM[\u0007\u0002O*\u0011\u0001\r\u001b\u0006\u0003S2\u000bAaY8sK&\u00111n\u001a\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005I1/Z3e\u001d>$Wm]\u000b\u0002_B\u0019\u0001o\u001e>\u000f\u0005E,\bC\u0001:W\u001b\u0005\u0019(B\u0001;S\u0003\u0019a$o\\8u}%\u0011aOV\u0001\u0007!J,G-\u001a4\n\u0005aL(aA*fi*\u0011aO\u0016\t\u0003=nL!\u0001`0\u0003\u0011M+W\r\u001a(pI\u0016\f!b]3fI:{G-Z:!\u0003\u0019a\u0014N\\5u}QA\u0011\u0011AA\u0003\u0003\u000f\tI\u0001E\u0002\u0002\u0004\u0001i\u0011A\u0013\u0005\u00073\u001a!\t\u0019\u0001.\t\u000b\r4\u0001\u0019A3\t\u000b54\u0001\u0019A8\u0002\u0005\u0015\u001cWCAA\b!\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b-\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005e\u00111\u0003\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!+\u0005i\u0016\u0001B3om\u0002*\"!a\t\u0011\t\u0005\u0015\u0012qE\u0007\u0002Q&\u0019\u0011\u0011\u00065\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\u0003QB,\"!!\r\u0011\t\u0005\r\u00111G\u0005\u0004\u0003kQ%A\u0005%b]\u0012dWM\u001d\"bg&\u001c\u0007+\u0019:b[N\f1\u0001\u001b9!\u00035\u0019X-\u0019:dQRKW.Z8viV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\n\u0003!!WO]1uS>t\u0017\u0002BA$\u0003\u0003\u0012\u0001\u0002R;sCRLwN\\\u0001\u000fg\u0016\f'o\u00195US6,w.\u001e;!\u0003A\tg.\u00197zi&\u001c7\u000fV5nK>,H/A\tb]\u0006d\u0017\u0010^5dgRKW.Z8vi\u0002\nQB]3uef\u001cFO]1uK\u001eLXCAA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-Q\u0006)!/\u001a;ss&!\u0011QLA,\u00055\u0011V\r\u001e:z'R\u0014\u0018\r^3hs\u0006q!/\u001a;ssN#(/\u0019;fOf\u0004\u0013\u0001D9vKJL\b*\u00198eY\u0016\u0014XCAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0001\u0002[1oI2,'o\u001d\u0006\u0004\u0003_R\u0015!B9vKJL\u0018\u0002BA:\u0003S\u0012A\"U;fefD\u0015M\u001c3mKJ\fQ\"];fefD\u0015M\u001c3mKJ\u0004\u0013\u0001E1oC2LH/[2t\u0011\u0006tG\r\\3s+\t\tY\b\u0005\u0003\u0002h\u0005u\u0014\u0002BA@\u0003S\u0012\u0001#\u00118bYf$\u0018nY:IC:$G.\u001a:\u0002#\u0005t\u0017\r\\=uS\u000e\u001c\b*\u00198eY\u0016\u0014\b%A\u0007tK\u0006\u00148\r\u001b%b]\u0012dWM]\u000b\u0003\u0003\u000f\u0003B!a\u001a\u0002\n&!\u00111RA5\u00055\u0019V-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0006q1/Z1sG\"D\u0015M\u001c3mKJ\u0004\u0013a\u0005:fC\u000e$\u0018N^3Vg\u0016\u0014X*\u00198bO\u0016\u0014XCAAJ!\u0011\t)*a(\u000e\u0005\u0005]%\u0002BAM\u00037\u000bA!^:fe*\u0019\u0011Q\u0014&\u0002\u000f5\fg.Y4fe&!\u0011\u0011UAL\u0005M\u0011V-Y2uSZ,Wk]3s\u001b\u0006t\u0017mZ3s\u0003U\u0011X-Y2uSZ,')^2lKRl\u0015M\\1hKJ,\"!a*\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WSA!!,\u0002\u001c\u00061!-^2lKRLA!!-\u0002,\n)\"+Z1di&4XMQ;dW\u0016$X*\u00198bO\u0016\u0014\u0018!\b:fC\u000e$\u0018N^3B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:\u0016\u0005\u0005]\u0006\u0003BA]\u0003\u007fk!!a/\u000b\t\u0005u\u00161T\u0001\nC:\fG.\u001f;jGNLA!!1\u0002<\ni\"+Z1di&4X-\u00118bYf$\u0018nY:J]\u0012,\u00070T1oC\u001e,'/\u0001\u000bF[B$\u0018PT1nK\u0012\u0004\u0016M]1nKR,'o]\u000b\u0003\u0003\u000f\u0004\u0002\"!3\u0002T\u0006]\u0017Q\\\u0007\u0003\u0003\u0017TA!!4\u0002P\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003#4\u0016AC2pY2,7\r^5p]&!\u0011Q[Af\u0005\ri\u0015\r\u001d\t\u0004a\u0006e\u0017bAAns\n11\u000b\u001e:j]\u001e\u00042!VAp\u0013\r\t\tO\u0016\u0002\u0004\u0003:L\u0018!F#naRLh*Y7fIB\u000b'/Y7fi\u0016\u00148\u000fI\u0001\u001a\u000b6\u0004H/\u001f)pg&$\u0018n\u001c8bYB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002jB1\u0011\u0011ZAv\u0003;LA!!<\u0002L\n\u00191+Z9\u00025\u0015k\u0007\u000f^=Q_NLG/[8oC2\u0004\u0016M]1nKR,'o\u001d\u0011\u0002\u000f\t,8m[3ugV\u0011\u0011Q\u001f\t\u0005\u0003S\u000b90\u0003\u0003\u0002z\u0006-&AE!ts:\u001c')^2lKRl\u0015M\\1hKJD3AIA\u007f!\u0011\tyPa\u0003\u000f\t\t\u0005!qA\u0007\u0003\u0005\u0007Q1A!\u0002i\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0013\u0011\u0019!A\u0005Ti\u0006\u0014\u0017\u000e\\5us&!!Q\u0002B\b\u0005!1v\u000e\\1uS2,'\u0002\u0002B\u0005\u0005\u0007\tQ!^:feN,\"A!\u0006\u0011\t\u0005U%qC\u0005\u0005\u00053\t9J\u0001\tBgft7-V:fe6\u000bg.Y4fe\"\u001a1%!@\u0002\u0019E,XM]=J]\u0012,\u00070Z:\u0016\u0005\t\u0005\u0002\u0003\u0002B\u0012\u0005Oi!A!\n\u000b\t\u0005=\u00141T\u0005\u0005\u0005S\u0011)C\u0001\fBgft7-U;fefLe\u000eZ3y\u001b\u0006t\u0017mZ3sQ\r!\u0013Q`\u0001\u000eg\u0016\f'o\u00195J]\u0012,\u00070Z:\u0016\u0005\tE\u0002\u0003\u0002B\u001a\u0005si!A!\u000e\u000b\t\t]\u00121T\u0001\u0007g\u0016\f'o\u00195\n\t\tm\"Q\u0007\u0002\u0018\u0003NLhnY*fCJ\u001c\u0007.\u00138eKbl\u0015M\\1hKJD3!JA\u007f\u0003A\tg.\u00197zi&\u001c7/\u00138eKb,7/\u0006\u0002\u0003DA!\u0011\u0011\u0018B#\u0013\u0011\u00119%a/\u00035\u0005\u001b\u0018P\\2B]\u0006d\u0017\u0010^5dg&sG-\u001a=NC:\fw-\u001a:)\u0007\u0019\ni\u0010\u0006\u0003\u0003N\tM\u0003\u0003BA\u0002\u0005\u001fJ1A!\u0015K\u0005-\t5/\u001f8d\u0005V\u001c7.\u001a;\t\u000f\tUs\u00051\u0001\u0002X\u0006Q!-^2lKRt\u0015-\\3\u0015\r\te#q\rB6!\u0019\t\tBa\u0017\u0003`%!!QLA\n\u0005\u00191U\u000f^;sKB!!\u0011\rB2\u001b\t\ti'\u0003\u0003\u0003f\u00055$aC)vKJL(+Z:vYRDqA!\u001b)\u0001\u0004\t9.A\u0005ti\u0006$X-\\3oi\"9!Q\u000e\u0015A\u0002\t=\u0014aB8qi&|gn\u001d\t\u0005\u0005C\u0012\t(\u0003\u0003\u0003t\u00055$\u0001D)vKJLx\n\u001d;j_:\u001cHC\u0003B-\u0005o\u0012IHa!\u0003\b\"9!\u0011N\u0015A\u0002\u0005]\u0007\"\u0003B>SA\u0005\t\u0019\u0001B?\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0005C\u0012y(\u0003\u0003\u0003\u0002\u00065$aD)vKJL\b+\u0019:b[\u0016$XM]:\t\u0013\t\u0015\u0015\u0006%AA\u0002\u0005u\u0012a\u0002;j[\u0016|W\u000f\u001e\u0005\n\u0005\u0013K\u0003\u0013!a\u0001\u0005\u0017\u000bQ!\u00193i_\u000e\u00042!\u0016BG\u0013\r\u0011yI\u0016\u0002\b\u0005>|G.Z1o\u0003=\tX/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001BKU\u0011\u0011iHa&,\u0005\te\u0005\u0003\u0002BN\u0005Gk!A!(\u000b\t\t}%\u0011U\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0002W\u0013\u0011\u0011)K!(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YK\u000b\u0003\u0002>\t]\u0015aD9vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tE&\u0006\u0002BF\u0005/\u000ba\"\u00198bYf$\u0018nY:Rk\u0016\u0014\u0018\u0010\u0006\u0004\u00038\n\r'Q\u0019\t\u0007\u0003#\u0011YF!/\u0011\t\tm&qX\u0007\u0003\u0005{S1!!0K\u0013\u0011\u0011\tM!0\u0003\u001f\u0005s\u0017\r\\=uS\u000e\u001c(+Z:vYRDqA!\u001b.\u0001\u0004\t9\u000eC\u0004\u0003n5\u0002\rAa2\u0011\t\tm&\u0011Z\u0005\u0005\u0005\u0017\u0014iL\u0001\tB]\u0006d\u0017\u0010^5dg>\u0003H/[8ogRA!q\u0017Bh\u0005#\u0014I\u000eC\u0004\u0003j9\u0002\r!a6\t\u0013\tmd\u0006%AA\u0002\tM\u0007\u0003\u0002B^\u0005+LAAa6\u0003>\n\u0019\u0012I\\1msRL7m\u001d)be\u0006lW\r^3sg\"I!Q\u0011\u0018\u0011\u0002\u0003\u0007\u0011QH\u0001\u0019C:\fG.\u001f;jGN\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TC\u0001BpU\u0011\u0011\u0019Na&\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$3'A\u0006tK\u0006\u00148\r[)vKJLH\u0003\u0003Bt\u0005o\u0014Yp!\u0003\u0011\r\u0005E!1\fBu!\u0011\u0011YOa=\u000e\u0005\t5(\u0002\u0002Bx\u0005c\faA]3tk2$(b\u0001B\u001c\u0015&!!Q\u001fBw\u00051\u0019V-\u0019:dQJ+7/\u001e7u\u0011\u001d\u0011I0\ra\u0001\u0003/\f\u0011\"\u001b8eKbt\u0015-\\3\t\u000f\u0005=\u0014\u00071\u0001\u0003~B!!q`B\u0003\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\tE\u0018aB9vKJLWm]\u0005\u0005\u0007\u000f\u0019\tAA\u0006TK\u0006\u00148\r[)vKJL\bb\u0002B7c\u0001\u000711\u0002\t\u0005\u0007\u001b\u0019y!\u0004\u0002\u0003r&!1\u0011\u0003By\u00055\u0019V-\u0019:dQ>\u0003H/[8ogRA!q]B\u000b\u0007/\u0019I\u0002C\u0004\u0003zJ\u0002\r!a6\t\u000f\u0005=$\u00071\u0001\u0003~\"I!Q\u0011\u001a\u0011\u0002\u0003\u0007\u0011QH\u0001\u0016g\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0005\u0007C\u0019I\u0003\u0005\u0004\u0002\u0012\tm31\u0005\t\u0004+\u000e\u0015\u0012bAB\u0014-\n!QK\\5u\u0011%\u0011)\t\u000eI\u0001\u0002\u0004\ti$\u0001\u000beSN\u001cwN\u001c8fGR$C-\u001a4bk2$H%M\u0001\fI&\fwM\\8ti&\u001c7\u000f\u0006\u0003\u00042\ru\u0002CBA\t\u00057\u001a\u0019\u0004\u0005\u0003\u00046\reRBAB\u001c\u0015\r\u0019i\u0003[\u0005\u0005\u0007w\u00199DA\tES\u0006<gn\\:uS\u000e\u001c(+Z:vYRD\u0011ba\u00107!\u0003\u0005\r!a6\u0002\u0011I,\u0007o\u001c:u\u0013\u0012\fQ\u0003Z5bO:|7\u000f^5dg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004F)\"\u0011q\u001bBL)\u0011\u0019\td!\u0013\t\u000f\t5\u0004\b1\u0001\u0004LA!1QJB)\u001b\t\u0019yEC\u0002\u0004.)KAaa\u0015\u0004P\t\u0011B)[1h]>\u001cH/[2t\u001fB$\u0018n\u001c8t\u0003\u0011\u0001\u0018N\\4\u0015\t\re3\u0011\r\t\u0007\u0003#\u0011Yfa\u0017\u0011\t\rU2QL\u0005\u0005\u0007?\u001a9D\u0001\u0006QS:<'+Z:vYRD\u0011B!\":!\u0003\u0005\raa\u0019\u0011\u000bU\u001b)'!\u0010\n\u0007\r\u001ddK\u0001\u0004PaRLwN\\\u0001\u000fa&tw\r\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019iG\u000b\u0003\u0004d\t]E\u0003BB-\u0007cBqA!\u001c<\u0001\u0004\u0019\u0019\b\u0005\u0003\u0004N\rU\u0014\u0002BB<\u0007\u001f\u00121\u0002U5oO>\u0003H/[8og\u0006qq/Y5u+:$\u0018\u000e\u001c*fC\u0012LH\u0003BB\u0011\u0007{BqA!\"=\u0001\u0004\ti\u0004\u0006\u0004\u0004\"\r\u000551\u0011\u0005\b\u0005\u000bk\u0004\u0019AA\u001f\u0011\u001d\u0011i'\u0010a\u0001\u0007\u000b\u0003Ba!\u0014\u0004\b&!1\u0011RB(\u0005U9\u0016-\u001b;V]RLGNU3bIf|\u0005\u000f^5p]N\fA\u0003]3sM>\u0014Xn\u00127pE\u0006d7i\u001c8oK\u000e$HCAB\u0012\u00031\t5/\u001f8d\u00072,8\u000f^3s!\r\t\u0019\u0001Q\n\u0003\u0001R#\"a!%\u0002\u000f\r|gN\\3diRA11TBT\u0007W\u001by\u000b\u0005\u0004\u0004\u001e\u000e\r\u0016\u0011A\u0007\u0003\u0007?S1a!)W\u0003\u0011)H/\u001b7\n\t\r\u00156q\u0014\u0002\u0004)JL\bbBBU\u0005\u0002\u0007\u0011q[\u0001\u0011G>tg.Z2uS>t7\u000b\u001e:j]\u001eDqa!,C\u0001\u0004\t9.\u0001\u0005vg\u0016\u0014h.Y7f\u0011\u001d\u0019\tL\u0011a\u0001\u0003/\f\u0001\u0002]1tg^|'\u000f\u001a\u000b\u0007\u00077\u001b)la.\t\u000f\r%6\t1\u0001\u0002X\"9!QN\"A\u0002\re\u0006\u0003BA\u0002\u0007wK1a!0K\u00059\u0019E.^:uKJ|\u0005\u000f^5p]N$baa'\u0004B\u000e\r\u0007\"B7E\u0001\u0004y\u0007b\u0002B7\t\u0002\u00071\u0011\u0018\u000b\u0007\u0007\u000f\u001cYm!8\u0015\t\t\u001d8\u0011\u001a\u0005\b\u0003\u0017)\u00059AA\b\u0011\u001d\u0019i-\u0012a\u0001\u0007\u001f\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0004R\u000eeWBABj\u0015\u0011\u00119d!6\u000b\u0007\r]\u0007.A\u0002ng\u001eLAaa7\u0004T\ni1+Z1sG\"\u0014V-];fgRDa![#A\u0002\u0005\r\u0012!G3yiJ\f7\r^\"mkN$XM]#om&\u0014xN\\7f]R$baa9\u0004f\u000e\u001d\b#BBO\u0007Gk\u0006bBBU\r\u0002\u0007\u0011q\u001b\u0005\b\u0007S4\u0005\u0019AB]\u0003\u0011y\u0007\u000f^:\u0015\t\r\r8Q\u001e\u0005\b\u0007S<\u0005\u0019AB]\u0003u\u0019X-\u001a3O_\u0012,7O\u0012:p[\u000e{gN\\3di&|gn\u0015;sS:<G#B8\u0004t\u000e]\bbBB{\u0011\u0002\u0007\u0011q[\u0001\u0003GNDQ!\u0017%A\u0002u\u0003")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    @Stability.Volatile
    private AsyncBucketManager buckets;
    @Stability.Volatile
    private AsyncUserManager users;
    @Stability.Volatile
    private AsyncQueryIndexManager queryIndexes;
    @Stability.Volatile
    private AsyncSearchIndexManager searchIndexes;
    @Stability.Volatile
    private AsyncAnalyticsIndexManager analyticsIndexes;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile byte bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> seedNodes, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(seedNodes, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, ClusterOptions options) {
        return AsyncCluster$.MODULE$.connect(connectionString, options);
    }

    public static Try<AsyncCluster> connect(String connectionString, String username, String password) {
        return AsyncCluster$.MODULE$.connect(connectionString, username, password);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.reactiveUserManager$lzycompute() : this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.reactiveBucketManager$lzycompute() : this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.reactiveAnalyticsIndexManager$lzycompute() : this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.users$lzycompute() : this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((byte)(this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x80);
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return (byte)(this.bitmap$0 & 0x80) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            future = this.analyticsHandler().queryAsync(request, this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Future<SearchResult> future;
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            future = AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable)() -> this.env().owned() ? this.env().shutdownInternal(timeout) : SMono$.MODULE$.empty())).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : CollectionConverters$.MODULE$.SetHasAsJava(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)CollectionConverters$.MODULE$.SetHasAsJava((Set)seedNodes.map((Function1 & Serializable)x$1 -> x$1.toCore())).asJava());
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)package$.MODULE$.Seq().empty();
    }
}

