/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.datastructures;

import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.scala.Collection;
import com.couchbase.client.scala.codec.JsonDeserializer;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.datastructures.CouchbaseBuffer;
import com.couchbase.client.scala.datastructures.CouchbaseCollectionOptions;
import com.couchbase.client.scala.datastructures.CouchbaseQueue$;
import com.couchbase.client.scala.kv.Get;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.LookupInSpec$;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutateInSpec$;
import com.couchbase.client.scala.kv.Remove;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\n\u0014\u0001yA\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005J\u0001\t\u0005\t\u0015a\u0003K\u0011!\u0001\u0006A!A!\u0002\u0017\t\u0006\u0002\u0003+\u0001\u0005\u0003\u0005\u000b1B+\t\u000bm\u0003A\u0011\u0001/\t\u000f\u0015\u0004!\u0019!C\u0005M\"1Q\u000e\u0001Q\u0001\n\u001dDqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\u0006i\u0002!\t!\u001e\u0005\u0006}\u0002!\ta`\u0004\n\u0003\u0003\u0019\u0012\u0011!E\u0001\u0003\u00071\u0001BE\n\u0002\u0002#\u0005\u0011Q\u0001\u0005\u00077>!\t!!\u0004\t\u0013\u0005=q\"%A\u0005\u0002\u0005E!AD\"pk\u000eD'-Y:f#V,W/\u001a\u0006\u0003)U\ta\u0002Z1uCN$(/^2ukJ,7O\u0003\u0002\u0017/\u0005)1oY1mC*\u0011\u0001$G\u0001\u0007G2LWM\u001c;\u000b\u0005iY\u0012!C2pk\u000eD'-Y:f\u0015\u0005a\u0012aA2p[\u000e\u0001QCA\u0010''\t\u0001\u0001\u0005E\u0002\"E\u0011j\u0011aE\u0005\u0003GM\u0011qbQ8vG\"\u0014\u0017m]3Ck\u001a4WM\u001d\t\u0003K\u0019b\u0001\u0001B\u0003(\u0001\t\u0007\u0001FA\u0001U#\tIc\u0006\u0005\u0002+Y5\t1FC\u0001\u0017\u0013\ti3FA\u0004O_RD\u0017N\\4\u0011\u0005)z\u0013B\u0001\u0019,\u0005\r\te._\u0001\u0003S\u0012\u0004\"a\r\u001e\u000f\u0005QB\u0004CA\u001b,\u001b\u00051$BA\u001c\u001e\u0003\u0019a$o\\8u}%\u0011\u0011hK\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:W\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u0011\u0005}\u0002U\"A\u000b\n\u0005\u0005+\"AC\"pY2,7\r^5p]\u00069q\u000e\u001d;j_:\u001c\bc\u0001\u0016E\r&\u0011Qi\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0005:\u0015B\u0001%\u0014\u0005i\u0019u.^2iE\u0006\u001cXmQ8mY\u0016\u001cG/[8o\u001fB$\u0018n\u001c8t\u0003\u0019!WmY8eKB\u00191J\u0014\u0013\u000e\u00031S!!T\u000b\u0002\u000b\r|G-Z2\n\u0005=c%\u0001\u0005&t_:$Um]3sS\u0006d\u0017N_3s\u0003\u0019)gnY8eKB\u00191J\u0015\u0013\n\u0005Mc%A\u0004&t_:\u001cVM]5bY&TXM]\u0001\u0004i\u0006<\u0007c\u0001,ZI5\tqK\u0003\u0002YW\u00059!/\u001a4mK\u000e$\u0018B\u0001.X\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\b\u0006\u0003^E\u000e$G\u0003\u00020`A\u0006\u00042!\t\u0001%\u0011\u0015Iu\u0001q\u0001K\u0011\u0015\u0001v\u0001q\u0001R\u0011\u0015!v\u0001q\u0001V\u0011\u0015\tt\u00011\u00013\u0011\u0015it\u00011\u0001?\u0011\u001d\u0011u\u0001%AA\u0002\r\u000bq\u0002\\8pWV\u0004\u0018J\\(qi&|gn]\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\u0011!.F\u0001\u0003WZL!\u0001\\5\u0003\u001f1{wn[;q\u0013:|\u0005\u000f^5p]N\f\u0001\u0003\\8pWV\u0004\u0018J\\(qi&|gn\u001d\u0011\u0002\u001f5,H/\u0019;f\u0013:|\u0005\u000f^5p]N,\u0012\u0001\u001d\t\u0003QFL!A]5\u0003\u001f5+H/\u0019;f\u0013:|\u0005\u000f^5p]N\f\u0001#\\;uCR,\u0017J\\(qi&|gn\u001d\u0011\u0002\u000f\u0015t\u0017/^3vKR\u0011a/\u001f\t\u0003U]L!\u0001_\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006u2\u0001\ra_\u0001\u0006K2,Wn\u001d\t\u0004Uq$\u0013BA?,\u0005)a$/\u001a9fCR,GMP\u0001\bI\u0016\fX/Z;f)\u0005!\u0013AD\"pk\u000eD'-Y:f#V,W/\u001a\t\u0003C=\u00192aDA\u0004!\rQ\u0013\u0011B\u0005\u0004\u0003\u0017Y#AB!osJ+g\r\u0006\u0002\u0002\u0004\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*B!a\u0005\u0002*U\u0011\u0011Q\u0003\u0016\u0004\u0007\u0006]1FAA\r!\u0011\tY\"!\n\u000e\u0005\u0005u!\u0002BA\u0010\u0003C\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r2&\u0001\u0006b]:|G/\u0019;j_:LA!a\n\u0002\u001e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b\u001d\n\"\u0019\u0001\u0015")
public class CouchbaseQueue<T>
extends CouchbaseBuffer<T> {
    private final String id;
    private final Collection collection;
    private final JsonDeserializer<T> decode;
    private final ClassTag<T> tag;
    private final LookupInOptions lookupInOptions;
    private final MutateInOptions mutateInOptions;

    public static <T> Option<CouchbaseCollectionOptions> $lessinit$greater$default$3() {
        return CouchbaseQueue$.MODULE$.$lessinit$greater$default$3();
    }

    private LookupInOptions lookupInOptions() {
        return this.lookupInOptions;
    }

    private MutateInOptions mutateInOptions() {
        return this.mutateInOptions;
    }

    public void enqueue(Seq<T> elems) {
        this.$plus$plus$eq((TraversableOnce)elems);
    }

    public T dequeue() {
        Throwable err;
        Try<LookupInResult> op = this.collection.lookupIn(this.id, (Seq<LookupInSpec>)Predef$.MODULE$.wrapRefArray((Object[])new Get[]{LookupInSpec$.MODULE$.get("[-1]")}), this.lookupInOptions());
        Try result2 = op.flatMap((Function1 & Serializable & scala.Serializable)result -> result.contentAs(0, $this.decode, $this.tag));
        boolean bl = false;
        Failure failure = null;
        Try try_ = result2;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Object value = success.value();
            Try<MutateInResult> mutateResult = this.collection.mutateIn(this.id, (Seq<MutateInSpec>)Predef$.MODULE$.wrapRefArray((Object[])new Remove[]{MutateInSpec$.MODULE$.remove("[-1]")}), this.mutateInOptions().cas(((LookupInResult)op.get()).cas()));
            boolean bl2 = false;
            Failure failure2 = null;
            Try<MutateInResult> try_2 = mutateResult;
            if (try_2 instanceof Success) {
                return (T)value;
            }
            if (try_2 instanceof Failure) {
                bl2 = true;
                failure2 = (Failure)try_2;
                Throwable err2 = failure2.exception();
                if (err2 instanceof CasMismatchException) {
                    return this.dequeue();
                }
            }
            if (bl2) {
                Throwable err3 = failure2.exception();
                throw new CouchbaseException("Found element, but unable to dequeue it", err3);
            }
            throw new MatchError(try_2);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable err4 = failure.exception();
            if (err4 instanceof PathNotFoundException) {
                throw new NoSuchElementException();
            }
        }
        if (bl && (err = failure.exception()) instanceof DocumentNotFoundException) {
            throw new NoSuchElementException();
        }
        if (bl) {
            Throwable err5 = failure.exception();
            throw err5;
        }
        throw new MatchError((Object)try_);
    }

    public CouchbaseQueue(String id, Collection collection, Option<CouchbaseCollectionOptions> options, JsonDeserializer<T> decode, JsonSerializer<T> encode, ClassTag<T> tag) {
        this.id = id;
        this.collection = collection;
        this.decode = decode;
        this.tag = tag;
        super(id, collection, options, decode, encode, tag);
        this.lookupInOptions = new LookupInOptions(LookupInOptions$.MODULE$.apply$default$1(), LookupInOptions$.MODULE$.apply$default$2(), LookupInOptions$.MODULE$.apply$default$3(), LookupInOptions$.MODULE$.apply$default$4(), LookupInOptions$.MODULE$.apply$default$5(), LookupInOptions$.MODULE$.apply$default$6()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy());
        this.mutateInOptions = new MutateInOptions(MutateInOptions$.MODULE$.apply$default$1(), MutateInOptions$.MODULE$.apply$default$2(), MutateInOptions$.MODULE$.apply$default$3(), MutateInOptions$.MODULE$.apply$default$4(), MutateInOptions$.MODULE$.apply$default$5(), MutateInOptions$.MODULE$.apply$default$6(), MutateInOptions$.MODULE$.apply$default$7(), MutateInOptions$.MODULE$.apply$default$8(), MutateInOptions$.MODULE$.apply$default$9(), MutateInOptions$.MODULE$.apply$default$10(), MutateInOptions$.MODULE$.apply$default$11(), MutateInOptions$.MODULE$.apply$default$12()).timeout(this.opts().timeout()).retryStrategy(this.opts().retryStrategy()).durability(this.opts().durability());
    }
}

