/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.scala.codec.EncodedValue;
import com.couchbase.client.scala.codec.RawJsonTranscoder$;
import com.couchbase.client.scala.codec.TranscoderWithoutSerializer;
import java.nio.charset.StandardCharsets;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001-4AAC\u0006\u0001-!)\u0001\u0005\u0001C\u0001C!)1\u0005\u0001C!I!)A\b\u0001C!{\u001d)qk\u0003E\u00011\u001a)!b\u0003E\u00013\")\u0001%\u0002C\u0001;\"9a,\u0002b\u0001\n\u0003y\u0006B\u00021\u0006A\u0003%!\u0005C\u0004b\u000b\u0005\u0005I\u0011\u00022\u0003#I\u000bwOS:p]R\u0013\u0018M\\:d_\u0012,'O\u0003\u0002\r\u001b\u0005)1m\u001c3fG*\u0011abD\u0001\u0006g\u000e\fG.\u0019\u0006\u0003!E\taa\u00197jK:$(B\u0001\n\u0014\u0003%\u0019w.^2iE\u0006\u001cXMC\u0001\u0015\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q\u0003\b\t\u00031ii\u0011!\u0007\u0006\u0002\u001d%\u00111$\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005uqR\"A\u0006\n\u0005}Y!a\u0007+sC:\u001c8m\u001c3fe^KG\u000f[8viN+'/[1mSj,'/\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u0011Q\u0004A\u0001\u0007K:\u001cw\u000eZ3\u0016\u0005\u0015\u001aDC\u0001\u00140!\r9#\u0006L\u0007\u0002Q)\u0011\u0011&G\u0001\u0005kRLG.\u0003\u0002,Q\t\u0019AK]=\u0011\u0005ui\u0013B\u0001\u0018\f\u00051)enY8eK\u00124\u0016\r\\;f\u0011\u0015\u0001$\u00011\u00012\u0003\u00151\u0018\r\\;f!\t\u00114\u0007\u0004\u0001\u0005\u000bQ\u0012!\u0019A\u001b\u0003\u0003Q\u000b\"AN\u001d\u0011\u0005a9\u0014B\u0001\u001d\u001a\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0007\u001e\n\u0005mJ\"aA!os\u00061A-Z2pI\u0016,\"A\u0010\"\u0015\u0007}Z%\u000b\u0006\u0002A\u0007B\u0019qEK!\u0011\u0005I\u0012E!\u0002\u001b\u0004\u0005\u0004)\u0004\"\u0002#\u0004\u0001\b)\u0015a\u0001;bOB\u0019a)S!\u000e\u0003\u001dS!\u0001S\r\u0002\u000fI,g\r\\3di&\u0011!j\u0012\u0002\t\u00072\f7o\u001d+bO\")\u0001g\u0001a\u0001\u0019B\u0019\u0001$T(\n\u00059K\"!B!se\u0006L\bC\u0001\rQ\u0013\t\t\u0016D\u0001\u0003CsR,\u0007\"B*\u0004\u0001\u0004!\u0016!\u00024mC\u001e\u001c\bC\u0001\rV\u0013\t1\u0016DA\u0002J]R\f\u0011CU1x\u0015N|g\u000e\u0016:b]N\u001cw\u000eZ3s!\tiRaE\u0002\u0006/i\u0003\"\u0001G.\n\u0005qK\"\u0001D*fe&\fG.\u001b>bE2,G#\u0001-\u0002\u0011%s7\u000f^1oG\u0016,\u0012AI\u0001\n\u0013:\u001cH/\u00198dK\u0002\n1B]3bIJ+7o\u001c7wKR\t1\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!A.\u00198h\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\r=\u0013'.Z2u\u0001")
public class RawJsonTranscoder
implements TranscoderWithoutSerializer {
    public static RawJsonTranscoder Instance() {
        return RawJsonTranscoder$.MODULE$.Instance();
    }

    @Override
    public <T> Try<EncodedValue> encode(T value) {
        T t = value;
        if (t instanceof byte[]) {
            byte[] byArray = (byte[])t;
            return new Success((Object)new EncodedValue(byArray, CodecFlags.JSON_COMPAT_FLAGS));
        }
        if (t instanceof String) {
            String string = (String)t;
            return new Success((Object)new EncodedValue(string.getBytes(StandardCharsets.UTF_8), CodecFlags.JSON_COMPAT_FLAGS));
        }
        return new Failure((Throwable)new IllegalArgumentException("Only Array[Byte] and String types are supported for the RawJsonTranscoder!"));
    }

    @Override
    public <T> Try<T> decode(byte[] value, int flags, ClassTag<T> tag) {
        if (tag.runtimeClass().isAssignableFrom(byte[].class)) {
            return new Success((Object)value);
        }
        if (tag.runtimeClass().isAssignableFrom(String.class)) {
            return new Success((Object)new String(value, StandardCharsets.UTF_8));
        }
        return new Failure((Throwable)new DecodingFailureException("RawJsonTranscoder can only decode into Array[Byte] or String!"));
    }
}

