/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.scala.AsyncCluster;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.FutureConverters$CompletionStageOps$;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager$;
import com.couchbase.client.scala.manager.search.SearchIndex;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper;
import com.couchbase.client.scala.manager.search.SearchIndexWrapper$;
import com.couchbase.client.scala.util.CouchbasePickler$;
import com.couchbase.client.scala.util.DurationConversions$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;

@Stability.Volatile
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u0011#\u0001=B\u0011\"\u000e\u0001\u0003\u0006\u0004%\tA\n\u001c\t\u0011m\u0002!\u0011!Q\u0001\n]B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\u0019!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!)Q\t\u0001C\u0001\r\"9A\n\u0001b\u0001\n\u0013i\u0005BB*\u0001A\u0003%a\nC\u0004U\u0001\t\u0007I\u0011B+\t\rq\u0003\u0001\u0015!\u0003W\u0011\u001di\u0006A1A\u0005\nyCa!\u001a\u0001!\u0002\u0013y\u0006b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007a\u0002\u0001\u000b\u0011\u00025\t\u000bE\u0004A\u0011\u0001:\t\u0013\u0005U\u0001!%A\u0005\u0002\u0005]\u0001\"CA\u0017\u0001E\u0005I\u0011AA\u0018\u0011\u001d\t\u0019\u0004\u0001C\u0001\u0003kA\u0011\"a\u0014\u0001#\u0003%\t!a\u0006\t\u0013\u0005E\u0003!%A\u0005\u0002\u0005=\u0002bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\n\u0003O\u0002\u0011\u0013!C\u0001\u0003/A\u0011\"!\u001b\u0001#\u0003%\t!a\f\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n!I\u0011Q\u000f\u0001\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003o\u0002\u0011\u0013!C\u0001\u0003_Aq!!\u001f\u0001\t\u0013\tY\bC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\u001e9\u00111\u0016\u0012\t\u0002\u00055fAB\u0011#\u0011\u0003\ty\u000b\u0003\u0004F=\u0011\u0005\u0011\u0011\u0017\u0005\t\u0003gsB\u0011\u0001\u0014\u00026\n9\u0012i]=oGN+\u0017M]2i\u0013:$W\r_'b]\u0006<WM\u001d\u0006\u0003G\u0011\naa]3be\u000eD'BA\u0013'\u0003\u001di\u0017M\\1hKJT!a\n\u0015\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005%R\u0013AB2mS\u0016tGO\u0003\u0002,Y\u0005I1m\\;dQ\n\f7/\u001a\u0006\u0002[\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cMj\u0011A\r\u0006\u0002O%\u0011AG\r\u0002\u0007\u0003:L(+\u001a4\u0002\u000f\rdWo\u001d;feV\tq\u0007\u0005\u00029s5\ta%\u0003\u0002;M\ta\u0011i]=oG\u000ecWo\u001d;fe\u0006A1\r\\;ti\u0016\u0014\b%\u0001\u0002fGV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002Be\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0003%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u001d[EC\u0001%K!\tI\u0005!D\u0001#\u0011\u0015aT\u0001q\u0001?\u0011\u0015)T\u00011\u00018\u0003\u0011\u0019wN]3\u0016\u00039\u0003\"aT)\u000e\u0003AS!\u0001\u0014\u0015\n\u0005I\u0003&\u0001B\"pe\u0016\fQaY8sK\u0002\na\u0002R3gCVdG\u000fV5nK>,H/F\u0001W!\t9&,D\u0001Y\u0015\tI\u0006)\u0001\u0005ekJ\fG/[8o\u0013\tY\u0006L\u0001\u0005EkJ\fG/[8o\u0003=!UMZ1vYR$\u0016.\\3pkR\u0004\u0013\u0001\u0006#fM\u0006,H\u000e\u001e*fiJL8\u000b\u001e:bi\u0016<\u00170F\u0001`!\t\u00017-D\u0001b\u0015\t\u0011\u0007+A\u0003sKR\u0014\u00180\u0003\u0002eC\ni!+\u001a;ssN#(/\u0019;fOf\fQ\u0003R3gCVdGOU3uef\u001cFO]1uK\u001eL\b%\u0001\u0006iiR\u00048\t\\5f]R,\u0012\u0001\u001b\t\u0003S:l\u0011A\u001b\u0006\u0003W2\fA\u0001\u001b;ua*\u0011Q\u000eU\u0001\tK:$\u0007o\\5oi&\u0011qN\u001b\u0002\u000f\u0007>\u0014X\r\u0013;ua\u000ec\u0017.\u001a8u\u0003-AG\u000f\u001e9DY&,g\u000e\u001e\u0011\u0002\u0011\u001d,G/\u00138eKb$ba]=\u0002\u000e\u0005E\u0001cA um&\u0011Q\u000f\u0011\u0002\u0007\rV$XO]3\u0011\u0005%;\u0018B\u0001=#\u0005-\u0019V-\u0019:dQ&sG-\u001a=\t\u000bit\u0001\u0019A>\u0002\u0013%tG-\u001a=OC6,\u0007c\u0001?\u0002\b9\u0019Q0a\u0001\u0011\u0005y\u0014T\"A@\u000b\u0007\u0005\u0005a&\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000b\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\n\u0005-!AB*ue&twMC\u0002\u0002\u0006IB\u0001\"a\u0004\u000f!\u0003\u0005\rAV\u0001\bi&lWm\\;u\u0011!\t\u0019B\u0004I\u0001\u0002\u0004y\u0016!\u0004:fiJL8\u000b\u001e:bi\u0016<\u00170\u0001\nhKRLe\u000eZ3yI\u0011,g-Y;mi\u0012\u0012TCAA\rU\r1\u00161D\u0016\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0005\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0005\u0005\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0011r-\u001a;J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tDK\u0002`\u00037\tQbZ3u\u00032d\u0017J\u001c3fq\u0016\u001cHCBA\u001c\u0003\u0017\ni\u0005\u0005\u0003@i\u0006e\u0002#BA\u001e\u0003\u000b2h\u0002BA\u001f\u0003\u0003r1A`A \u0013\u00059\u0013bAA\"e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA$\u0003\u0013\u00121aU3r\u0015\r\t\u0019E\r\u0005\t\u0003\u001f\t\u0002\u0013!a\u0001-\"A\u00111C\t\u0011\u0002\u0003\u0007q,A\fhKR\fE\u000e\\%oI\u0016DXm\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u00059r-\u001a;BY2Le\u000eZ3yKN$C-\u001a4bk2$HEM\u0001\fkB\u001cXM\u001d;J]\u0012,\u0007\u0010\u0006\u0005\u0002X\u0005}\u00131MA3!\u0011yD/!\u0017\u0011\u0007E\nY&C\u0002\u0002^I\u0012A!\u00168ji\"1\u0011\u0011\r\u000bA\u0002Y\fq\"\u001b8eKb$UMZ5oSRLwN\u001c\u0005\t\u0003\u001f!\u0002\u0013!a\u0001-\"A\u00111\u0003\u000b\u0011\u0002\u0003\u0007q,A\u000bvaN,'\u000f^%oI\u0016DH\u0005Z3gCVdG\u000f\n\u001a\u0002+U\u00048/\u001a:u\u0013:$W\r\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005IAM]8q\u0013:$W\r\u001f\u000b\t\u0003/\ny'!\u001d\u0002t!)!p\u0006a\u0001w\"A\u0011qB\f\u0011\u0002\u0003\u0007a\u000b\u0003\u0005\u0002\u0014]\u0001\n\u00111\u0001`\u0003M!'o\u001c9J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003M!'o\u001c9J]\u0012,\u0007\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003-Ig\u000eZ3yKN\u0004\u0016\r\u001e5\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\u0011\tI!!!\u0002\u0013%tG-\u001a=QCRDG\u0003BA?\u0003\u001fCQA_\u000eA\u0002m\fa\"\u001b8eKb\u001cu.\u001e8u!\u0006$\b\u000e\u0006\u0003\u0002~\u0005U\u0005\"\u0002>\u001d\u0001\u0004Y\bf\u0001\u0001\u0002\u001aB!\u00111TAS\u001d\u0011\ti*!)\u000e\u0005\u0005}%bAA\u0014!&!\u00111UAP\u0003%\u0019F/\u00192jY&$\u00180\u0003\u0003\u0002(\u0006%&\u0001\u0003,pY\u0006$\u0018\u000e\\3\u000b\t\u0005\r\u0016qT\u0001\u0018\u0003NLhnY*fCJ\u001c\u0007.\u00138eKbl\u0015M\\1hKJ\u0004\"!\u0013\u0010\u0014\u0005y\u0001DCAAW\u00031\u0001\u0018M]:f\u0013:$W\r_3t)\u0011\tI$a.\t\u000f\u0005e\u0006\u00051\u0001\u0002<\u0006\u0011\u0011N\u001c\t\u0006c\u0005u\u0016\u0011Y\u0005\u0004\u0003\u007f\u0013$!B!se\u0006L\bcA\u0019\u0002D&\u0019\u0011Q\u0019\u001a\u0003\t\tKH/\u001a")
public class AsyncSearchIndexManager {
    private final AsyncCluster cluster;
    private final ExecutionContext ec;
    private final Core core;
    private final Duration DefaultTimeout;
    private final RetryStrategy DefaultRetryStrategy;
    private final CoreHttpClient httpClient;

    public AsyncCluster cluster() {
        return this.cluster;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    private Core core() {
        return this.core;
    }

    private Duration DefaultTimeout() {
        return this.DefaultTimeout;
    }

    private RetryStrategy DefaultRetryStrategy() {
        return this.DefaultRetryStrategy;
    }

    private CoreHttpClient httpClient() {
        return this.httpClient;
    }

    public Future<SearchIndex> getIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        CoreHttpRequest request = this.httpClient().get(CoreHttpPath.path((String)this.indexPath(indexName)), options).build();
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> {
            SearchIndexWrapper read = CouchbasePickler$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(response.content()), CouchbasePickler$.MODULE$.read$default$2(), SearchIndexWrapper$.MODULE$.rw());
            int x$1 = read.numPlanPIndexes();
            String x$2 = read.indexDef().copy$default$1();
            String x$3 = read.indexDef().copy$default$2();
            Option<String> x$4 = read.indexDef().copy$default$3();
            Option<String> x$5 = read.indexDef().copy$default$4();
            Option<Obj> x$6 = read.indexDef().copy$default$5();
            Option<String> x$7 = read.indexDef().copy$default$6();
            Option<Obj> x$8 = read.indexDef().copy$default$7();
            Option<String> x$9 = read.indexDef().copy$default$8();
            Option<Obj> x$10 = read.indexDef().copy$default$9();
            return read.indexDef().copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$1);
        }, this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$1 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<Seq<SearchIndex>> getAllIndexes(Duration timeout, RetryStrategy retryStrategy) {
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        CoreHttpRequest request = this.httpClient().get(CoreHttpPath.path((String)this.indexesPath()), options).build();
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response())).map((Function1 & Serializable & scala.Serializable)response -> AsyncSearchIndexManager$.MODULE$.parseIndexes(response.content()), this.ec());
        out.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> request.context().logicallyComplete(), this.ec());
        return out;
    }

    public Duration getAllIndexes$default$1() {
        return this.DefaultTimeout();
    }

    public RetryStrategy getAllIndexes$default$2() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> upsertIndex(SearchIndex indexDefinition, Duration timeout, RetryStrategy retryStrategy) {
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        CoreHttpRequest request = this.httpClient().put(CoreHttpPath.path((String)this.indexPath(indexDefinition.name())), options).header((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache").json(indexDefinition.toJson().getBytes(StandardCharsets.UTF_8)).build();
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> request.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$4 -> {
            AsyncSearchIndexManager.$anonfun$upsertIndex$2(x$4);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration upsertIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy upsertIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    public Future<BoxedUnit> dropIndex(String indexName, Duration timeout, RetryStrategy retryStrategy) {
        CoreCommonOptions options = CoreCommonOptions.of((java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (RetryStrategy)retryStrategy, null);
        CoreHttpRequest request = this.httpClient().delete(CoreHttpPath.path((String)this.indexPath(indexName)), options).build();
        this.core().send((Request)request);
        Future out = FutureConverters$CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(request.response()));
        out.onComplete((Function1 & Serializable & scala.Serializable)x$5 -> request.context().logicallyComplete(), this.ec());
        return out.map((Function1 & Serializable & scala.Serializable)x$6 -> {
            AsyncSearchIndexManager.$anonfun$dropIndex$2(x$6);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public Duration dropIndex$default$2() {
        return this.DefaultTimeout();
    }

    public RetryStrategy dropIndex$default$3() {
        return this.DefaultRetryStrategy();
    }

    private String indexesPath() {
        return "/api/index";
    }

    private String indexPath(String indexName) {
        return new StringBuilder(1).append(this.indexesPath()).append("/").append(UrlQueryStringBuilder.urlEncode((String)indexName)).toString();
    }

    private String indexCountPath(String indexName) {
        return new StringBuilder(6).append(this.indexPath(indexName)).append("/count").toString();
    }

    public static final /* synthetic */ void $anonfun$upsertIndex$2(CoreHttpResponse x$4) {
    }

    public static final /* synthetic */ void $anonfun$dropIndex$2(CoreHttpResponse x$6) {
    }

    public AsyncSearchIndexManager(AsyncCluster cluster, ExecutionContext ec) {
        this.cluster = cluster;
        this.ec = ec;
        this.core = cluster.core();
        this.DefaultTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.core().context().environment().timeoutConfig().managementTimeout());
        this.DefaultRetryStrategy = this.core().context().environment().retryStrategy();
        this.httpClient = this.core().httpClient(RequestTarget.search());
    }
}

