/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.ClusterState;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.diagnostics.WaitUntilReadyHelper;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.search.SearchRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBucket;
import com.couchbase.client.scala.AsyncCluster$;
import com.couchbase.client.scala.ClusterOptions;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.ReactiveCluster;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsParameters;
import com.couchbase.client.scala.analytics.AnalyticsParameters$None$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$;
import com.couchbase.client.scala.deps.scala.compat.java8.OptionConverters$RichOptionForJava8$;
import com.couchbase.client.scala.diagnostics.DiagnosticsOptions;
import com.couchbase.client.scala.diagnostics.PingOptions;
import com.couchbase.client.scala.diagnostics.PingOptions$;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.scala.diagnostics.WaitUntilReadyOptions$;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.env.SeedNode;
import com.couchbase.client.scala.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.scala.manager.analytics.ReactiveAnalyticsIndexManager;
import com.couchbase.client.scala.manager.bucket.AsyncBucketManager;
import com.couchbase.client.scala.manager.bucket.ReactiveBucketManager;
import com.couchbase.client.scala.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.scala.manager.query.AsyncQueryIndexManager;
import com.couchbase.client.scala.manager.search.AsyncSearchIndexManager;
import com.couchbase.client.scala.manager.user.AsyncUserManager;
import com.couchbase.client.scala.manager.user.ReactiveUserManager;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryParameters;
import com.couchbase.client.scala.query.QueryParameters$None$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import com.couchbase.client.scala.query.handlers.SearchHandler;
import com.couchbase.client.scala.search.HighlightStyle;
import com.couchbase.client.scala.search.SearchOptions;
import com.couchbase.client.scala.search.SearchOptions$;
import com.couchbase.client.scala.search.SearchScanConsistency;
import com.couchbase.client.scala.search.facet.SearchFacet;
import com.couchbase.client.scala.search.queries.SearchQuery;
import com.couchbase.client.scala.search.result.SearchResult;
import com.couchbase.client.scala.search.sort.SearchSort;
import com.couchbase.client.scala.util.DurationConversions$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015a\u0001\u0002&L\u0001QC\u0001B\u0017\u0001\u0003\u0002\u0013\u0006Ia\u0017\u0005\nI\u0002\u0011)\u0019!C\u0001\u0017\u0016D\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\n]\u0002\u0011)\u0019!C\u0001\u0017>D\u0001B \u0001\u0003\u0002\u0003\u0006I\u0001\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\t\u0015\u00055\u0001A1A\u0005\u0004-\u000by\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\t\u0011!\t\u0007A1A\u0005\u0002\u0005}\u0001bBA\u0011\u0001\u0001\u0006IA\u0018\u0005\nU\u0002\u0011\r\u0011\"\u0001P\u0003GA\u0001\"!\f\u0001A\u0003%\u0011Q\u0005\u0005\u000b\u0003_\u0001!\u0019!C\u0001\u0017\u0006E\u0002\u0002CA\u001d\u0001\u0001\u0006I!a\r\t\u0015\u0005m\u0002A1A\u0005\u0002-\u000bi\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA \u0011)\ti\u0005\u0001b\u0001\n\u0003Y\u0015Q\b\u0005\t\u0003\u001f\u0002\u0001\u0015!\u0003\u0002@!Q\u0011\u0011\u000b\u0001C\u0002\u0013\u00051*a\u0015\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003+B!\"a\u0019\u0001\u0005\u0004%\taSA3\u0011!\t9\b\u0001Q\u0001\n\u0005\u001d\u0004BCA=\u0001\t\u0007I\u0011A&\u0002|!A\u00111\u0011\u0001!\u0002\u0013\ti\b\u0003\u0006\u0002\u0006\u0002\u0011\r\u0011\"\u0001L\u0003\u000fC\u0001\"a$\u0001A\u0003%\u0011\u0011\u0012\u0005\f\u0003#\u0003\u0001R1A\u0005\u0002-\u000b\u0019\nC\u0006\u0002&\u0002A)\u0019!C\u0001\u0017\u0006\u001d\u0006bCA[\u0001!\u0015\r\u0011\"\u0001L\u0003oC!\"!2\u0001\u0005\u0004%\taSAd\u0011!\t)\u000f\u0001Q\u0001\n\u0005%\u0007BCAt\u0001\t\u0007I\u0011A&\u0002j\"A\u00111\u001f\u0001!\u0002\u0013\tY\u000f\u0003\u0006\u0002v\u0002A)\u0019!C\u0001\u0003oD!\"a@\u0001\u0011\u000b\u0007I\u0011\u0001B\u0001\u0011)\u0011I\u0001\u0001EC\u0002\u0013\u0005!1\u0002\u0005\u000b\u0005/\u0001\u0001R1A\u0005\u0002\te\u0001B\u0003B\u0014\u0001!\u0015\r\u0011\"\u0001\u0003*!Q!\u0011\u0007\u0001\t\u0006\u0004%\tAa\r\t\u000f\u0005=\u0006\u0001\"\u0001\u0003X!9\u0011\u0011\u000f\u0001\u0005\u0002\t\r\u0004bBA9\u0001\u0011\u0005!\u0011\u0011\u0005\n\u0005;\u0003\u0011\u0013!C\u0001\u0005?C\u0011Ba-\u0001#\u0003%\tA!.\t\u0013\te\u0006!%A\u0005\u0002\tm\u0006b\u0002B`\u0001\u0011\u0005!\u0011\u0019\u0005\b\u0005\u007f\u0003A\u0011\u0001Bm\u0011%\u00119\u000fAI\u0001\n\u0003\u0011I\u000fC\u0005\u0003n\u0002\t\n\u0011\"\u0001\u00036\"9!q\u001e\u0001\u0005\u0002\tE\bb\u0002Bx\u0001\u0011\u00051q\u0004\u0005\n\u0007O\u0001\u0011\u0013!C\u0001\u0005kCqa!\u000b\u0001\t\u0003\u0019Y\u0003C\u0005\u00048\u0001\t\n\u0011\"\u0001\u00036\"91\u0011\b\u0001\u0005\u0002\rm\u0002\"CB'\u0001E\u0005I\u0011AB(\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007'Bqa!\u0019\u0001\t\u0003\u0019\u0019\u0007C\u0005\u0004v\u0001\t\n\u0011\"\u0001\u0004x!91\u0011\r\u0001\u0005\u0002\rm\u0004bBBC\u0001\u0011\u00051q\u0011\u0005\b\u0007\u000b\u0003A\u0011ABF\u0011!\u00199\n\u0001C\u0001\u0017\u000eeuaBBN\u0017\"\u00051Q\u0014\u0004\u0007\u0015.C\taa(\t\r}\fE\u0011ABQ\u0011\u001d\u0019\u0019+\u0011C\u0001\u0007KCqaa)B\t\u0003\u0019y\fC\u0004\u0004$\u0006#\taa3\t\u0011\t=\u0018\t\"\u0001N\u0007#D\u0001ba;B\t\u0003i5Q\u001e\u0005\t\u0007W\fE\u0011A'\u0004x\"A11`!\u0005\u00025\u001biP\u0001\u0007Bgft7m\u00117vgR,'O\u0003\u0002M\u001b\u0006)1oY1mC*\u0011ajT\u0001\u0007G2LWM\u001c;\u000b\u0005A\u000b\u0016!C2pk\u000eD'-Y:f\u0015\u0005\u0011\u0016aA2p[\u000e\u00011C\u0001\u0001V!\t1\u0006,D\u0001X\u0015\u0005a\u0015BA-X\u0005\u0019\te.\u001f*fM\u0006YQM\u001c<je>tW.\u001a8u!\r1FLX\u0005\u0003;^\u0013\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C.\u000b1!\u001a8w\u0013\t\u0019\u0007M\u0001\nDYV\u001cH/\u001a:F]ZL'o\u001c8nK:$\u0018!D1vi\",g\u000e^5dCR|'/F\u0001g!\t97.D\u0001i\u0015\t\t\u0017N\u0003\u0002k\u001b\u0006!1m\u001c:f\u0013\ta\u0007NA\u0007BkRDWM\u001c;jG\u0006$xN]\u0001\u000fCV$\b.\u001a8uS\u000e\fGo\u001c:!\u0003%\u0019X-\u001a3O_\u0012,7/F\u0001q!\r\t\bp\u001f\b\u0003eZ\u0004\"a],\u000e\u0003QT!!^*\u0002\rq\u0012xn\u001c;?\u0013\t9x+\u0001\u0004Qe\u0016$WMZ\u0005\u0003sj\u00141aU3u\u0015\t9x\u000b\u0005\u0002`y&\u0011Q\u0010\u0019\u0002\t'\u0016,GMT8eK\u0006Q1/Z3e\u001d>$Wm\u001d\u0011\u0002\rqJg.\u001b;?)!\t\u0019!a\u0002\u0002\n\u0005-\u0001cAA\u0003\u00015\t1\n\u0003\u0004[\r\u0011\u0005\ra\u0017\u0005\u0006I\u001a\u0001\rA\u001a\u0005\u0006]\u001a\u0001\r\u0001]\u0001\u0003K\u000e,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006X\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u00037\t)B\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0016\u0003y\u000bA!\u001a8wAU\u0011\u0011Q\u0005\t\u0005\u0003O\tI#D\u0001j\u0013\r\tY#\u001b\u0002\u0005\u0007>\u0014X-A\u0003d_J,\u0007%\u0001\u0002iaV\u0011\u00111\u0007\t\u0005\u0003\u000b\t)$C\u0002\u00028-\u0013!\u0003S1oI2,'OQ1tS\u000e\u0004\u0016M]1ng\u0006\u0019\u0001\u000e\u001d\u0011\u0002\u001bM,\u0017M]2i)&lWm\\;u+\t\ty\u0004\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\u0011\t)%!\u0006\u0002\u0011\u0011,(/\u0019;j_:LA!!\u0013\u0002D\tAA)\u001e:bi&|g.\u0001\btK\u0006\u00148\r\u001b+j[\u0016|W\u000f\u001e\u0011\u0002!\u0005t\u0017\r\\=uS\u000e\u001cH+[7f_V$\u0018!E1oC2LH/[2t)&lWm\\;uA\u0005i!/\u001a;ssN#(/\u0019;fOf,\"!!\u0016\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017j\u0003\u0015\u0011X\r\u001e:z\u0013\u0011\ty&!\u0017\u0003\u001bI+GO]=TiJ\fG/Z4z\u00039\u0011X\r\u001e:z'R\u0014\u0018\r^3hs\u0002\nA\"];fefD\u0015M\u001c3mKJ,\"!a\u001a\u0011\t\u0005%\u00141O\u0007\u0003\u0003WRA!!\u001c\u0002p\u0005A\u0001.\u00198eY\u0016\u00148OC\u0002\u0002r-\u000bQ!];fefLA!!\u001e\u0002l\ta\u0011+^3ss\"\u000bg\u000e\u001a7fe\u0006i\u0011/^3ss\"\u000bg\u000e\u001a7fe\u0002\n\u0001#\u00198bYf$\u0018nY:IC:$G.\u001a:\u0016\u0005\u0005u\u0004\u0003BA5\u0003\u007fJA!!!\u0002l\t\u0001\u0012I\\1msRL7m\u001d%b]\u0012dWM]\u0001\u0012C:\fG.\u001f;jGND\u0015M\u001c3mKJ\u0004\u0013!D:fCJ\u001c\u0007\u000eS1oI2,'/\u0006\u0002\u0002\nB!\u0011\u0011NAF\u0013\u0011\ti)a\u001b\u0003\u001bM+\u0017M]2i\u0011\u0006tG\r\\3s\u00039\u0019X-\u0019:dQ\"\u000bg\u000e\u001a7fe\u0002\n1C]3bGRLg/Z+tKJl\u0015M\\1hKJ,\"!!&\u0011\t\u0005]\u0015\u0011U\u0007\u0003\u00033SA!a'\u0002\u001e\u0006!Qo]3s\u0015\r\tyjS\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\t\u0019+!'\u0003'I+\u0017m\u0019;jm\u0016,6/\u001a:NC:\fw-\u001a:\u0002+I,\u0017m\u0019;jm\u0016\u0014UoY6fi6\u000bg.Y4feV\u0011\u0011\u0011\u0016\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVAO\u0003\u0019\u0011WoY6fi&!\u00111WAW\u0005U\u0011V-Y2uSZ,')^2lKRl\u0015M\\1hKJ\fQD]3bGRLg/Z!oC2LH/[2t\u0013:$W\r_'b]\u0006<WM]\u000b\u0003\u0003s\u0003B!a/\u0002B6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000bi*A\u0005b]\u0006d\u0017\u0010^5dg&!\u00111YA_\u0005u\u0011V-Y2uSZ,\u0017I\\1msRL7m]%oI\u0016DX*\u00198bO\u0016\u0014\u0018\u0001F#naRLh*Y7fIB\u000b'/Y7fi\u0016\u00148/\u0006\u0002\u0002JBA\u00111ZAk\u00033\fy.\u0004\u0002\u0002N*!\u0011qZAi\u0003%IW.\\;uC\ndWMC\u0002\u0002T^\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9.!4\u0003\u00075\u000b\u0007\u000fE\u0002r\u00037L1!!8{\u0005\u0019\u0019FO]5oOB\u0019a+!9\n\u0007\u0005\rxKA\u0002B]f\fQ#R7qift\u0015-\\3e!\u0006\u0014\u0018-\\3uKJ\u001c\b%A\rF[B$\u0018\u0010U8tSRLwN\\1m!\u0006\u0014\u0018-\\3uKJ\u001cXCAAv!\u0019\ti/a<\u0002`6\u0011\u0011\u0011[\u0005\u0005\u0003c\f\tNA\u0002TKF\f!$R7qif\u0004vn]5uS>t\u0017\r\u001c)be\u0006lW\r^3sg\u0002\nqAY;dW\u0016$8/\u0006\u0002\u0002zB!\u00111VA~\u0013\u0011\ti0!,\u0003%\u0005\u001b\u0018P\\2Ck\u000e\\W\r^'b]\u0006<WM]\u0001\u0006kN,'o]\u000b\u0003\u0005\u0007\u0001B!a&\u0003\u0006%!!qAAM\u0005A\t5/\u001f8d+N,'/T1oC\u001e,'/\u0001\u0007rk\u0016\u0014\u00180\u00138eKb,7/\u0006\u0002\u0003\u000eA!!q\u0002B\n\u001b\t\u0011\tB\u0003\u0003\u0002r\u0005u\u0015\u0002\u0002B\u000b\u0005#\u0011a#Q:z]\u000e\fV/\u001a:z\u0013:$W\r_'b]\u0006<WM]\u0001\u000eg\u0016\f'o\u00195J]\u0012,\u00070Z:\u0016\u0005\tm\u0001\u0003\u0002B\u000f\u0005Gi!Aa\b\u000b\t\t\u0005\u0012QT\u0001\u0007g\u0016\f'o\u00195\n\t\t\u0015\"q\u0004\u0002\u0018\u0003NLhnY*fCJ\u001c\u0007.\u00138eKbl\u0015M\\1hKJ\f\u0001#\u00198bYf$\u0018nY:J]\u0012,\u00070Z:\u0016\u0005\t-\u0002\u0003BA^\u0005[IAAa\f\u0002>\nQ\u0012i]=oG\u0006s\u0017\r\\=uS\u000e\u001c\u0018J\u001c3fq6\u000bg.Y4fe\u0006\tRM^3oi&twMR;oGRLwN\\:\u0016\u0005\tU\u0002\u0003\u0002B\u001c\u0005{i!A!\u000f\u000b\t\tm\u0012QT\u0001\tKZ,g\u000e^5oO&!!q\bB\u001d\u0005q\t5/\u001f8d\u000bZ,g\u000e^5oO\u001a+hn\u0019;j_:l\u0015M\\1hKJD3a\nB\"!\u0011\u0011)E!\u0015\u000f\t\t\u001d#QJ\u0007\u0003\u0005\u0013R1Aa\u0013j\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0012I%A\u0005Ti\u0006\u0014\u0017\u000e\\5us&!!1\u000bB+\u0005-)fnY8n[&$H/\u001a3\u000b\t\t=#\u0011\n\u000b\u0005\u00053\u0012y\u0006\u0005\u0003\u0002\u0006\tm\u0013b\u0001B/\u0017\nY\u0011i]=oG\n+8m[3u\u0011\u001d\u0011\t\u0007\u000ba\u0001\u00033\f!BY;dW\u0016$h*Y7f)\u0019\u0011)Ga\u001d\u0003xA1\u00111\u0003B4\u0005WJAA!\u001b\u0002\u0016\t1a)\u001e;ve\u0016\u0004BA!\u001c\u0003p5\u0011\u0011qN\u0005\u0005\u0005c\nyGA\u0006Rk\u0016\u0014\u0018PU3tk2$\bb\u0002B;S\u0001\u0007\u0011\u0011\\\u0001\ngR\fG/Z7f]RDqA!\u001f*\u0001\u0004\u0011Y(A\u0004paRLwN\\:\u0011\t\t5$QP\u0005\u0005\u0005\u007f\nyG\u0001\u0007Rk\u0016\u0014\u0018p\u00149uS>t7\u000f\u0006\u0006\u0003f\t\r%Q\u0011BH\u0005'CqA!\u001e+\u0001\u0004\tI\u000eC\u0005\u0003\b*\u0002\n\u00111\u0001\u0003\n\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\t5$1R\u0005\u0005\u0005\u001b\u000byGA\bRk\u0016\u0014\u0018\u0010U1sC6,G/\u001a:t\u0011%\u0011\tJ\u000bI\u0001\u0002\u0004\ty$A\u0004uS6,w.\u001e;\t\u0013\tU%\u0006%AA\u0002\t]\u0015!B1eQ>\u001c\u0007c\u0001,\u0003\u001a&\u0019!1T,\u0003\u000f\t{w\u000e\\3b]\u0006y\u0011/^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\"*\"!\u0011\u0012BRW\t\u0011)\u000b\u0005\u0003\u0003(\n=VB\u0001BU\u0015\u0011\u0011YK!,\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B&/&!!\u0011\u0017BU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010cV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0017\u0016\u0005\u0003\u007f\u0011\u0019+A\brk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iL\u000b\u0003\u0003\u0018\n\r\u0016AD1oC2LH/[2t#V,'/\u001f\u000b\u0007\u0005\u0007\u0014yM!5\u0011\r\u0005M!q\rBc!\u0011\u00119Ma3\u000e\u0005\t%'bAA`\u0017&!!Q\u001aBe\u0005=\te.\u00197zi&\u001c7OU3tk2$\bb\u0002B;]\u0001\u0007\u0011\u0011\u001c\u0005\b\u0005sr\u0003\u0019\u0001Bj!\u0011\u00119M!6\n\t\t]'\u0011\u001a\u0002\u0011\u0003:\fG.\u001f;jGN|\u0005\u000f^5p]N$\u0002Ba1\u0003\\\nu'Q\u001d\u0005\b\u0005kz\u0003\u0019AAm\u0011%\u00119i\fI\u0001\u0002\u0004\u0011y\u000e\u0005\u0003\u0003H\n\u0005\u0018\u0002\u0002Br\u0005\u0013\u00141#\u00118bYf$\u0018nY:QCJ\fW.\u001a;feND\u0011B!%0!\u0003\u0005\r!a\u0010\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0003l*\"!q\u001cBR\u0003a\tg.\u00197zi&\u001c7/U;fef$C-\u001a4bk2$HeM\u0001\fg\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010\u0006\u0005\u0003t\u000e\r1qAB\u000b!\u0019\t\u0019Ba\u001a\u0003vB!!q\u001fB\u0000\u001b\t\u0011IP\u0003\u0003\u0003|\nu\u0018A\u0002:fgVdGOC\u0002\u0003\"-KAa!\u0001\u0003z\na1+Z1sG\"\u0014Vm];mi\"91Q\u0001\u001aA\u0002\u0005e\u0017!C5oI\u0016Dh*Y7f\u0011\u001d\t\tH\ra\u0001\u0007\u0013\u0001Baa\u0003\u0004\u00125\u00111Q\u0002\u0006\u0005\u0007\u001f\u0011i0A\u0004rk\u0016\u0014\u0018.Z:\n\t\rM1Q\u0002\u0002\f'\u0016\f'o\u00195Rk\u0016\u0014\u0018\u0010C\u0004\u0003zI\u0002\raa\u0006\u0011\t\re11D\u0007\u0003\u0005{LAa!\b\u0003~\ni1+Z1sG\"|\u0005\u000f^5p]N$\u0002Ba=\u0004\"\r\r2Q\u0005\u0005\b\u0007\u000b\u0019\u0004\u0019AAm\u0011\u001d\t\th\ra\u0001\u0007\u0013A\u0011B!%4!\u0003\u0005\r!a\u0010\u0002+M,\u0017M]2i#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005QA-[:d_:tWm\u0019;\u0015\t\r52Q\u0007\t\u0007\u0003'\u00119ga\f\u0011\u0007Y\u001b\t$C\u0002\u00044]\u0013A!\u00168ji\"I!\u0011S\u001b\u0011\u0002\u0003\u0007\u0011qH\u0001\u0015I&\u001c8m\u001c8oK\u000e$H\u0005Z3gCVdG\u000fJ\u0019\u0002\u0017\u0011L\u0017m\u001a8pgRL7m\u001d\u000b\u0005\u0007{\u0019I\u0005\u0005\u0004\u0002\u0014\t\u001d4q\b\t\u0005\u0007\u0003\u001a)%\u0004\u0002\u0004D)\u00191\u0011H5\n\t\r\u001d31\t\u0002\u0012\t&\fwM\\8ti&\u001c7OU3tk2$\b\"CB&oA\u0005\t\u0019AAm\u0003!\u0011X\r]8si&#\u0017!\u00063jC\u001etwn\u001d;jGN$C-\u001a4bk2$H%M\u000b\u0003\u0007#RC!!7\u0003$R!1QHB+\u0011\u001d\u0011I(\u000fa\u0001\u0007/\u0002Ba!\u0017\u0004^5\u001111\f\u0006\u0004\u0007sY\u0015\u0002BB0\u00077\u0012!\u0003R5bO:|7\u000f^5dg>\u0003H/[8og\u0006!\u0001/\u001b8h)\u0011\u0019)g!\u001c\u0011\r\u0005M!qMB4!\u0011\u0019\te!\u001b\n\t\r-41\t\u0002\u000b!&twMU3tk2$\b\"\u0003BIuA\u0005\t\u0019AB8!\u001516\u0011OA \u0013\r\u0019\u0019h\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u001dALgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u00111\u0011\u0010\u0016\u0005\u0007_\u0012\u0019\u000b\u0006\u0003\u0004f\ru\u0004b\u0002B=y\u0001\u00071q\u0010\t\u0005\u00073\u001a\t)\u0003\u0003\u0004\u0004\u000em#a\u0003)j]\u001e|\u0005\u000f^5p]N\fab^1jiVsG/\u001b7SK\u0006$\u0017\u0010\u0006\u0003\u0004.\r%\u0005b\u0002BI{\u0001\u0007\u0011q\b\u000b\u0007\u0007[\u0019iia$\t\u000f\tEe\b1\u0001\u0002@!9!\u0011\u0010 A\u0002\rE\u0005\u0003BB-\u0007'KAa!&\u0004\\\t)r+Y5u+:$\u0018\u000e\u001c*fC\u0012Lx\n\u001d;j_:\u001c\u0018\u0001\u00069fe\u001a|'/\\$m_\n\fGnQ8o]\u0016\u001cG\u000f\u0006\u0002\u00040\u0005a\u0011i]=oG\u000ecWo\u001d;feB\u0019\u0011QA!\u0014\u0005\u0005+FCABO\u0003\u001d\u0019wN\u001c8fGR$\u0002ba*\u00044\u000e]61\u0018\t\u0007\u0007S\u001by+a\u0001\u000e\u0005\r-&bABW/\u0006!Q\u000f^5m\u0013\u0011\u0019\tla+\u0003\u0007Q\u0013\u0018\u0010C\u0004\u00046\u000e\u0003\r!!7\u0002!\r|gN\\3di&|gn\u0015;sS:<\u0007bBB]\u0007\u0002\u0007\u0011\u0011\\\u0001\tkN,'O\\1nK\"91QX\"A\u0002\u0005e\u0017\u0001\u00039bgN<xN\u001d3\u0015\r\r\u001d6\u0011YBb\u0011\u001d\u0019)\f\u0012a\u0001\u00033DqA!\u001fE\u0001\u0004\u0019)\r\u0005\u0003\u0002\u0006\r\u001d\u0017bABe\u0017\nq1\t\\;ti\u0016\u0014x\n\u001d;j_:\u001cHCBBT\u0007\u001b\u001cy\rC\u0003o\u000b\u0002\u0007\u0001\u000fC\u0004\u0003z\u0015\u0003\ra!2\u0015\r\rM7q[Bu)\u0011\u0011\u0019p!6\t\u000f\u00055a\tq\u0001\u0002\u0012!91\u0011\u001c$A\u0002\rm\u0017a\u0002:fcV,7\u000f\u001e\t\u0005\u0007;\u001c)/\u0004\u0002\u0004`*!!\u0011EBq\u0015\r\u0019\u0019/[\u0001\u0004[N<\u0017\u0002BBt\u0007?\u0014QbU3be\u000eD'+Z9vKN$\bB\u00026G\u0001\u0004\t)#A\rfqR\u0014\u0018m\u0019;DYV\u001cH/\u001a:F]ZL'o\u001c8nK:$HCBBx\u0007c\u001c\u0019\u0010E\u0003\u0004*\u000e=f\fC\u0004\u00046\u001e\u0003\r!!7\t\u000f\rUx\t1\u0001\u0004F\u0006!q\u000e\u001d;t)\u0011\u0019yo!?\t\u000f\rU\b\n1\u0001\u0004F\u0006i2/Z3e\u001d>$Wm\u001d$s_6\u001cuN\u001c8fGRLwN\\*ue&tw\rF\u0003q\u0007\u007f$\u0019\u0001C\u0004\u0005\u0002%\u0003\r!!7\u0002\u0005\r\u001c\b\"\u0002.J\u0001\u0004q\u0006")
public class AsyncCluster {
    private ReactiveUserManager reactiveUserManager;
    private ReactiveBucketManager reactiveBucketManager;
    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager;
    private AsyncBucketManager buckets;
    private AsyncUserManager users;
    private AsyncQueryIndexManager queryIndexes;
    private AsyncSearchIndexManager searchIndexes;
    private AsyncAnalyticsIndexManager analyticsIndexes;
    @Stability.Uncommitted
    private AsyncEventingFunctionManager eventingFunctions;
    private final Function0<ClusterEnvironment> environment;
    private final Authenticator authenticator;
    private final scala.collection.immutable.Set<SeedNode> seedNodes;
    private final ExecutionContext ec;
    private final ClusterEnvironment env;
    private final Core core;
    private final HandlerBasicParams hp;
    private final Duration searchTimeout;
    private final Duration analyticsTimeout;
    private final RetryStrategy retryStrategy;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;
    private final SearchHandler searchHandler;
    private final Map<String, Object> EmptyNamedParameters;
    private final Seq<Object> EmptyPositionalParameters;
    private volatile int bitmap$0;

    public static Try<AsyncCluster> connect(scala.collection.immutable.Set<SeedNode> set, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(set, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, ClusterOptions clusterOptions) {
        return AsyncCluster$.MODULE$.connect(string, clusterOptions);
    }

    public static Try<AsyncCluster> connect(String string, String string2, String string3) {
        return AsyncCluster$.MODULE$.connect(string, string2, string3);
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public scala.collection.immutable.Set<SeedNode> seedNodes() {
        return this.seedNodes;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public ClusterEnvironment env() {
        return this.env;
    }

    public Core core() {
        return this.core;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public Duration searchTimeout() {
        return this.searchTimeout;
    }

    public Duration analyticsTimeout() {
        return this.analyticsTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public SearchHandler searchHandler() {
        return this.searchHandler;
    }

    private ReactiveUserManager reactiveUserManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 1) == 0) {
                this.reactiveUserManager = new ReactiveUserManager(this.core());
                this.bitmap$0 |= 1;
            }
        }
        return this.reactiveUserManager;
    }

    public ReactiveUserManager reactiveUserManager() {
        return (this.bitmap$0 & 1) == 0 ? this.reactiveUserManager$lzycompute() : this.reactiveUserManager;
    }

    private ReactiveBucketManager reactiveBucketManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 2) == 0) {
                this.reactiveBucketManager = new ReactiveBucketManager(this.core());
                this.bitmap$0 |= 2;
            }
        }
        return this.reactiveBucketManager;
    }

    public ReactiveBucketManager reactiveBucketManager() {
        return (this.bitmap$0 & 2) == 0 ? this.reactiveBucketManager$lzycompute() : this.reactiveBucketManager;
    }

    private ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 4) == 0) {
                this.reactiveAnalyticsIndexManager = new ReactiveAnalyticsIndexManager(new ReactiveCluster(this), (Function0<AsyncAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.analyticsIndexes());
                this.bitmap$0 |= 4;
            }
        }
        return this.reactiveAnalyticsIndexManager;
    }

    public ReactiveAnalyticsIndexManager reactiveAnalyticsIndexManager() {
        return (this.bitmap$0 & 4) == 0 ? this.reactiveAnalyticsIndexManager$lzycompute() : this.reactiveAnalyticsIndexManager;
    }

    public Map<String, Object> EmptyNamedParameters() {
        return this.EmptyNamedParameters;
    }

    public Seq<Object> EmptyPositionalParameters() {
        return this.EmptyPositionalParameters;
    }

    private AsyncBucketManager buckets$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 8) == 0) {
                this.buckets = new AsyncBucketManager(this.reactiveBucketManager(), this.ec());
                this.bitmap$0 |= 8;
            }
        }
        return this.buckets;
    }

    public AsyncBucketManager buckets() {
        return (this.bitmap$0 & 8) == 0 ? this.buckets$lzycompute() : this.buckets;
    }

    private AsyncUserManager users$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.users = new AsyncUserManager(this.reactiveUserManager());
                this.bitmap$0 |= 0x10;
            }
        }
        return this.users;
    }

    public AsyncUserManager users() {
        return (this.bitmap$0 & 0x10) == 0 ? this.users$lzycompute() : this.users;
    }

    private AsyncQueryIndexManager queryIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.queryIndexes = new AsyncQueryIndexManager(this, this.ec());
                this.bitmap$0 |= 0x20;
            }
        }
        return this.queryIndexes;
    }

    public AsyncQueryIndexManager queryIndexes() {
        return (this.bitmap$0 & 0x20) == 0 ? this.queryIndexes$lzycompute() : this.queryIndexes;
    }

    private AsyncSearchIndexManager searchIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.searchIndexes = new AsyncSearchIndexManager(this, this.ec());
                this.bitmap$0 |= 0x40;
            }
        }
        return this.searchIndexes;
    }

    public AsyncSearchIndexManager searchIndexes() {
        return (this.bitmap$0 & 0x40) == 0 ? this.searchIndexes$lzycompute() : this.searchIndexes;
    }

    private AsyncAnalyticsIndexManager analyticsIndexes$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.analyticsIndexes = new AsyncAnalyticsIndexManager((Function0<ReactiveAnalyticsIndexManager>)(Function0 & Serializable & scala.Serializable)() -> this.reactiveAnalyticsIndexManager(), this.ec());
                this.bitmap$0 |= 0x80;
            }
        }
        return this.analyticsIndexes;
    }

    public AsyncAnalyticsIndexManager analyticsIndexes() {
        return (this.bitmap$0 & 0x80) == 0 ? this.analyticsIndexes$lzycompute() : this.analyticsIndexes;
    }

    private AsyncEventingFunctionManager eventingFunctions$lzycompute() {
        AsyncCluster asyncCluster = this;
        synchronized (asyncCluster) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.eventingFunctions = new AsyncEventingFunctionManager(this.env(), this.core(), this.ec());
                this.bitmap$0 |= 0x100;
            }
        }
        return this.eventingFunctions;
    }

    public AsyncEventingFunctionManager eventingFunctions() {
        return (this.bitmap$0 & 0x100) == 0 ? this.eventingFunctions$lzycompute() : this.eventingFunctions;
    }

    public AsyncBucket bucket(String bucketName) {
        this.core().openBucket(bucketName);
        return new AsyncBucket(bucketName, this.core(), (ClusterEnvironment)this.environment.apply());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.env(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Future<QueryResult> query(String statement, QueryParameters parameters, Duration timeout, boolean adhoc) {
        QueryOptions opts = QueryOptions$.MODULE$.apply().adhoc(adhoc).timeout(timeout).parameters(parameters);
        return this.query(statement, opts);
    }

    public QueryParameters query$default$2() {
        return QueryParameters$None$.MODULE$;
    }

    public Duration query$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public boolean query$default$4() {
        return true;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), (ClusterEnvironment)this.environment.apply(), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            future = this.analyticsHandler().queryAsync(request, this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsParameters parameters, Duration timeout) {
        AnalyticsOptions opts = new AnalyticsOptions(AnalyticsOptions$.MODULE$.apply$default$1(), AnalyticsOptions$.MODULE$.apply$default$2(), AnalyticsOptions$.MODULE$.apply$default$3(), AnalyticsOptions$.MODULE$.apply$default$4(), AnalyticsOptions$.MODULE$.apply$default$5(), AnalyticsOptions$.MODULE$.apply$default$6(), AnalyticsOptions$.MODULE$.apply$default$7(), AnalyticsOptions$.MODULE$.apply$default$8(), AnalyticsOptions$.MODULE$.apply$default$9()).timeout(timeout).parameters(parameters);
        return this.analyticsQuery(statement, opts);
    }

    public AnalyticsParameters analyticsQuery$default$2() {
        return AnalyticsParameters$None$.MODULE$;
    }

    public Duration analyticsQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().queryTimeout());
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        Future<SearchResult> future;
        Try<SearchRequest> try_ = this.searchHandler().request(indexName, query, options, this.core(), (ClusterEnvironment)this.environment.apply());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            SearchRequest request = (SearchRequest)success.value();
            future = AsyncCluster$.MODULE$.searchQuery(request, this.core(), this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public Future<SearchResult> searchQuery(String indexName, SearchQuery query, Duration timeout) {
        Some x$1 = new Some((Object)timeout);
        Option<Object> x$2 = SearchOptions$.MODULE$.apply$default$1();
        Option<Object> x$3 = SearchOptions$.MODULE$.apply$default$2();
        Option<Object> x$4 = SearchOptions$.MODULE$.apply$default$3();
        Option<HighlightStyle> x$5 = SearchOptions$.MODULE$.apply$default$4();
        Option<Seq<String>> x$6 = SearchOptions$.MODULE$.apply$default$5();
        Option<Seq<String>> x$7 = SearchOptions$.MODULE$.apply$default$6();
        Option<Seq<String>> x$8 = SearchOptions$.MODULE$.apply$default$7();
        Option<Seq<SearchSort>> x$9 = SearchOptions$.MODULE$.apply$default$8();
        Option<Map<String, SearchFacet>> x$10 = SearchOptions$.MODULE$.apply$default$9();
        Option<Duration> x$11 = SearchOptions$.MODULE$.apply$default$10();
        Option<RuntimeException> x$12 = SearchOptions$.MODULE$.apply$default$11();
        Option<SearchScanConsistency> x$13 = SearchOptions$.MODULE$.apply$default$12();
        Option<RetryStrategy> x$14 = SearchOptions$.MODULE$.apply$default$14();
        Option<RequestSpan> x$15 = SearchOptions$.MODULE$.apply$default$15();
        Option<Map<String, Object>> x$16 = SearchOptions$.MODULE$.apply$default$16();
        boolean x$17 = SearchOptions$.MODULE$.apply$default$17();
        boolean x$18 = SearchOptions$.MODULE$.apply$default$18();
        return this.searchQuery(indexName, query, new SearchOptions(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, (Option<Duration>)x$1, x$14, x$15, x$16, x$17, x$18));
    }

    public Duration searchQuery$default$3() {
        return DurationConversions$.MODULE$.javaDurationToScala(((ClusterEnvironment)this.environment.apply()).timeoutConfig().searchTimeout());
    }

    public Future<BoxedUnit> disconnect(Duration timeout) {
        return FutureConversions$.MODULE$.javaMonoToScalaMono(this.core().shutdown(DurationConversions$.MODULE$.scalaDurationToJava(timeout))).then(SMono$.MODULE$.defer((Function0 & Serializable & scala.Serializable)() -> this.env().owned() ? this.env().shutdownInternal(timeout) : SMono$.MODULE$.empty())).toFuture();
    }

    public Duration disconnect$default$1() {
        return DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().disconnectTimeout());
    }

    public Future<DiagnosticsResult> diagnostics(String reportId) {
        return this.diagnostics(new DiagnosticsOptions((Option<String>)new Some((Object)reportId)));
    }

    public Future<DiagnosticsResult> diagnostics(DiagnosticsOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DiagnosticsResult(this.core().diagnostics().collect(Collectors.groupingBy(v1 -> v1.type())), this.core().context().environment().userAgent().formattedShort(), (String)options.reportId().getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())), this.ec());
    }

    public String diagnostics$default$1() {
        return UUID.randomUUID().toString();
    }

    public Future<PingResult> ping(Option<Duration> timeout) {
        ObjectRef opts = ObjectRef.create((Object)new PingOptions(PingOptions$.MODULE$.apply$default$1(), PingOptions$.MODULE$.apply$default$2(), PingOptions$.MODULE$.apply$default$3(), PingOptions$.MODULE$.apply$default$4()));
        timeout.foreach((Function1 & Serializable & scala.Serializable)v -> {
            opts.elem = ((PingOptions)opts.elem).timeout(v);
            return BoxedUnit.UNIT;
        });
        return this.ping((PingOptions)opts.elem);
    }

    public Future<PingResult> ping(PingOptions options) {
        CompletableFuture future = HealthPinger.ping((Core)this.core(), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.timeout().map((Function1 & Serializable & scala.Serializable)in -> DurationConversions$.MODULE$.scalaDurationToJava((Duration)in)))), (RetryStrategy)((RetryStrategy)options.retryStrategy().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.env().retryStrategy())), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), OptionConverters$RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(options.reportId())), Optional.empty()).toFuture();
        return FutureConversions$.MODULE$.javaCFToScalaFuture(future);
    }

    public Option<Duration> ping$default$1() {
        return None$.MODULE$;
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, new WaitUntilReadyOptions(WaitUntilReadyOptions$.MODULE$.apply$default$1(), WaitUntilReadyOptions$.MODULE$.apply$default$2()));
    }

    public Future<BoxedUnit> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(WaitUntilReadyHelper.waitUntilReady((Core)this.core(), (java.util.Set)(options.serviceTypes().isEmpty() ? null : (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(options.serviceTypes()).asJava()), (java.time.Duration)DurationConversions$.MODULE$.scalaDurationToJava(timeout), (ClusterState)options.desiredState(), Optional.empty())).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            AsyncCluster.$anonfun$waitUntilReady$1(x$2);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void performGlobalConnect() {
        this.core().initGlobalConfig();
    }

    public static final /* synthetic */ void $anonfun$waitUntilReady$1(Void x$2) {
    }

    public AsyncCluster(Function0<ClusterEnvironment> environment, Authenticator authenticator, scala.collection.immutable.Set<SeedNode> seedNodes) {
        this.environment = environment;
        this.authenticator = authenticator;
        this.seedNodes = seedNodes;
        this.ec = ((ClusterEnvironment)environment.apply()).ec();
        this.env = (ClusterEnvironment)environment.apply();
        this.core = Core.create((CoreEnvironment)((ClusterEnvironment)environment.apply()).coreEnv(), (Authenticator)authenticator, (java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)seedNodes.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toCore(), Set$.MODULE$.canBuildFrom())).asJava()));
        this.hp = new HandlerBasicParams(this.core(), this.env());
        this.searchTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().searchTimeout());
        this.analyticsTimeout = DurationConversions$.MODULE$.javaDurationToScala(this.env().timeoutConfig().analyticsTimeout());
        this.retryStrategy = this.env().retryStrategy();
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
        this.searchHandler = new SearchHandler(this.hp());
        this.EmptyNamedParameters = Predef$.MODULE$.Map().empty();
        this.EmptyPositionalParameters = (Seq)Nil$.MODULE$;
    }
}

