/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala.kv.handlers;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.GetResponse;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.HandlerParams;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.json.JsonObject;
import com.couchbase.client.scala.kv.DefaultErrors$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.handlers.KeyValueRequestHandlerWithTranscoder;
import com.couchbase.client.scala.util.Validate$;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0003\u0007\u0001)\u0011\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u000b=\u0002A\u0011\u0001\u0019\t\u000bM\u0002A\u0011\u0001\u001b\t\u000bI\u0004A\u0011I:\u0003#\u001d+GOR;mY\u0012{7\rS1oI2,'O\u0003\u0002\b\u0011\u0005A\u0001.\u00198eY\u0016\u00148O\u0003\u0002\n\u0015\u0005\u00111N\u001e\u0006\u0003\u00171\tQa]2bY\u0006T!!\u0004\b\u0002\r\rd\u0017.\u001a8u\u0015\ty\u0001#A\u0005d_V\u001c\u0007NY1tK*\t\u0011#A\u0002d_6\u001c2\u0001A\n\u0019!\t!b#D\u0001\u0016\u0015\u0005Y\u0011BA\f\u0016\u0005\u0019\te.\u001f*fMB!\u0011D\u0007\u000f&\u001b\u00051\u0011BA\u000e\u0007\u0005\u0011ZU-\u001f,bYV,'+Z9vKN$\b*\u00198eY\u0016\u0014x+\u001b;i)J\fgn]2pI\u0016\u0014\bCA\u000f$\u001b\u0005q\"BA\u0005 \u0015\t\u0001\u0013%A\u0002ng\u001eT!A\t\u0007\u0002\t\r|'/Z\u0005\u0003Iy\u00111bR3u%\u0016\u001c\bo\u001c8tKB\u0011aeJ\u0007\u0002\u0011%\u0011\u0001\u0006\u0003\u0002\n\u000f\u0016$(+Z:vYR\f!\u0001\u001b9\u0004\u0001A\u0011A&L\u0007\u0002\u0015%\u0011aF\u0003\u0002\u000e\u0011\u0006tG\r\\3s!\u0006\u0014\u0018-\\:\u0002\rqJg.\u001b;?)\t\t$\u0007\u0005\u0002\u001a\u0001!)\u0011F\u0001a\u0001W\u00059!/Z9vKN$XCA\u001bj)\u00151t\b\u0014,_!\r9$\bP\u0007\u0002q)\u0011\u0011(F\u0001\u0005kRLG.\u0003\u0002<q\t\u0019AK]=\u0011\u0005ui\u0014B\u0001 \u001f\u0005)9U\r\u001e*fcV,7\u000f\u001e\u0005\u0006\u0001\u000e\u0001\r!Q\u0001\u0003S\u0012\u0004\"AQ%\u000f\u0005\r;\u0005C\u0001#\u0016\u001b\u0005)%B\u0001$+\u0003\u0019a$o\\8u}%\u0011\u0001*F\u0001\u0007!J,G-\u001a4\n\u0005)[%AB*ue&twM\u0003\u0002I+!)Qj\u0001a\u0001\u001d\u00069A/[7f_V$\bCA(U\u001b\u0005\u0001&BA)S\u0003\u0011!\u0018.\\3\u000b\u0003M\u000bAA[1wC&\u0011Q\u000b\u0015\u0002\t\tV\u0014\u0018\r^5p]\")qk\u0001a\u00011\u0006i!/\u001a;ssN#(/\u0019;fOf\u0004\"!\u0017/\u000e\u0003iS!aW\u0011\u0002\u000bI,GO]=\n\u0005uS&!\u0004*fiJL8\u000b\u001e:bi\u0016<\u0017\u0010C\u0003`\u0007\u0001\u0007\u0001-\u0001\u0006qCJ,g\u000e^*qC:\u00042\u0001F1d\u0013\t\u0011WC\u0001\u0004PaRLwN\u001c\t\u0003I\u001el\u0011!\u001a\u0006\u0003M\u0006\n1a\u00198d\u0013\tAWMA\u0006SKF,Xm\u001d;Ta\u0006tG!\u00026\u0004\u0005\u0004Y'!\u0001+\u0012\u00051|\u0007C\u0001\u000bn\u0013\tqWCA\u0004O_RD\u0017N\\4\u0011\u0005Q\u0001\u0018BA9\u0016\u0005\r\te._\u0001\te\u0016\u001c\bo\u001c8tKR)Q\u0005\u001e=zu\")1\u0007\u0002a\u0001kB\u0019QD\u001e\u000f\n\u0005]t\"aD&fsZ\u000bG.^3SKF,Xm\u001d;\t\u000b\u0001#\u0001\u0019A!\t\u000bI$\u0001\u0019\u0001\u000f\t\u000bm$\u0001\u0019\u0001?\u0002\u0015Q\u0014\u0018M\\:d_\u0012,'\u000fE\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f*\tQaY8eK\u000eL1!a\u0001\u007f\u0005)!&/\u00198tG>$WM\u001d")
public class GetFullDocHandler
implements KeyValueRequestHandlerWithTranscoder<GetResponse, GetResult> {
    private final HandlerParams hp;

    public <T> Try<GetRequest> request(String id, Duration timeout, RetryStrategy retryStrategy, Option<RequestSpan> parentSpan) {
        Try validations = Validate$.MODULE$.notNullOrEmpty(id, "id").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(timeout, "timeout").flatMap((Function1 & Serializable & scala.Serializable)_ -> Validate$.MODULE$.notNull(retryStrategy, "retryStrategy").flatMap((Function1 & Serializable & scala.Serializable)_2 -> Validate$.MODULE$.notNull(parentSpan, "parentSpan").map((Function1 & Serializable & scala.Serializable)_ -> null))));
        return validations.isFailure() ? validations : new Success((Object)new GetRequest(id, timeout, this.hp.core().context(), this.hp.collectionIdentifier(), retryStrategy, this.hp.tracer().requestSpan("get", (RequestSpan)parentSpan.orNull(Predef$.MODULE$.$conforms()))));
    }

    @Override
    public GetResult response(KeyValueRequest<GetResponse> request, String id, GetResponse response, Transcoder transcoder) {
        ResponseStatus responseStatus = response.status();
        if (!ResponseStatus.SUCCESS.equals(responseStatus)) {
            if (ResponseStatus.NOT_FOUND.equals(responseStatus)) {
                KeyValueErrorContext ctx = KeyValueErrorContext.completedRequest(request, (ResponseStatus)response.status());
                throw new DocumentNotFoundException((ErrorContext)ctx);
            }
            throw DefaultErrors$.MODULE$.throwOnBadResult(request, (Response)response);
        }
        GetResult getResult = new GetResult(id, (Either<byte[], JsonObject>)package$.MODULE$.Left().apply((Object)response.content()), response.flags(), response.cas(), (Option<Instant>)Option$.MODULE$.empty(), transcoder);
        return getResult;
    }

    public GetFullDocHandler(HandlerParams hp) {
        this.hp = hp;
    }
}

