/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.scala.AsyncCollection;
import com.couchbase.client.scala.DefaultResources$;
import com.couchbase.client.scala.HandlerBasicParams;
import com.couchbase.client.scala.analytics.AnalyticsOptions;
import com.couchbase.client.scala.analytics.AnalyticsOptions$;
import com.couchbase.client.scala.analytics.AnalyticsResult;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.query.QueryOptions;
import com.couchbase.client.scala.query.QueryOptions$;
import com.couchbase.client.scala.query.QueryResult;
import com.couchbase.client.scala.query.handlers.AnalyticsHandler;
import com.couchbase.client.scala.query.handlers.QueryHandler;
import java.util.Optional;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\f\u0019\u0001\u0005B\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005Q!AA\u0007\u0001BC\u0002\u0013%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00037\u0011%a\u0004A!b\u0001\n\u0003AR\b\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003?\u0011\u0019)\u0005\u0001\"\u0001\u0019\r\"AQ\n\u0001b\u0001\n\u0007Ab\n\u0003\u0004V\u0001\u0001\u0006Ia\u0014\u0005\t-\u0002\u0011\r\u0011\"\u0001\u0019/\"11\f\u0001Q\u0001\naC\u0001\u0002\u0018\u0001C\u0002\u0013\u0005\u0001$\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00020\t\u0011\u001d\u0004!\u0019!C\u00011!Da\u0001\u001c\u0001!\u0002\u0013I\u0007\"B7\u0001\t\u0003q\u0007BB8\u0001\t\u0003A\u0002\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003d\u0001\u0011\u0005\u0001\u0010C\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012!9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002\"CA\"\u0001E\u0005I\u0011AA#\u0005)\t5/\u001f8d'\u000e|\u0007/\u001a\u0006\u00033i\tQa]2bY\u0006T!a\u0007\u000f\u0002\r\rd\u0017.\u001a8u\u0015\tib$A\u0005d_V\u001c\u0007NY1tK*\tq$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001EA\u00111%J\u0007\u0002I)\t\u0011$\u0003\u0002'I\t1\u0011I\\=SK\u001a\f\u0011b]2pa\u0016t\u0015-\\3\u0011\u0005%\u0002dB\u0001\u0016/!\tYC%D\u0001-\u0015\ti\u0003%\u0001\u0004=e>|GOP\u0005\u0003_\u0011\na\u0001\u0015:fI\u00164\u0017BA\u00193\u0005\u0019\u0019FO]5oO*\u0011q\u0006J\u0001\u000bEV\u001c7.\u001a;OC6,\u0017\u0001B2pe\u0016,\u0012A\u000e\t\u0003oej\u0011\u0001\u000f\u0006\u0003iiI!A\u000f\u001d\u0003\t\r{'/Z\u0001\u0006G>\u0014X\rI\u0001\fK:4\u0018N]8o[\u0016tG/F\u0001?!\ty$)D\u0001A\u0015\t\t\u0005$A\u0002f]ZL!a\u0011!\u0003%\rcWo\u001d;fe\u0016sg/\u001b:p]6,g\u000e^\u0001\rK:4\u0018N]8o[\u0016tG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u001dK%j\u0013'\u0011\u0005!\u0003Q\"\u0001\r\t\u000b\u001d:\u0001\u0019\u0001\u0015\t\u000bM:\u0001\u0019\u0001\u0015\t\u000bQ:\u0001\u0019\u0001\u001c\t\u000bq:\u0001\u0019\u0001 \u0002\u0005\u0015\u001cW#A(\u0011\u0005A\u001bV\"A)\u000b\u0005I#\u0013AC2p]\u000e,(O]3oi&\u0011A+\u0015\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f1!Z2!\u0003\tA\u0007/F\u0001Y!\tA\u0015,\u0003\u0002[1\t\u0011\u0002*\u00198eY\u0016\u0014()Y:jGB\u000b'/Y7t\u0003\rA\u0007\u000fI\u0001\rcV,'/\u001f%b]\u0012dWM]\u000b\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\tQ\u0006tG\r\\3sg*\u00111\rG\u0001\u0006cV,'/_\u0005\u0003K\u0002\u0014A\"U;fefD\u0015M\u001c3mKJ\fQ\"];fefD\u0015M\u001c3mKJ\u0004\u0013\u0001E1oC2LH/[2t\u0011\u0006tG\r\\3s+\u0005I\u0007CA0k\u0013\tY\u0007M\u0001\tB]\u0006d\u0017\u0010^5dg\"\u000bg\u000e\u001a7fe\u0006\t\u0012M\\1msRL7m\u001d%b]\u0012dWM\u001d\u0011\u0002\t9\fW.Z\u000b\u0002Q\u0005\tB-\u001a4bk2$8i\u001c7mK\u000e$\u0018n\u001c8\u0016\u0003E\u0004\"\u0001\u0013:\n\u0005MD\"aD!ts:\u001c7i\u001c7mK\u000e$\u0018n\u001c8\u0002\u0015\r|G\u000e\\3di&|g\u000e\u0006\u0002rm\")qO\u0005a\u0001Q\u0005q1m\u001c7mK\u000e$\u0018n\u001c8OC6,G#B=\u0002\u0002\u0005\u0015\u0001c\u0001){y&\u001110\u0015\u0002\u0007\rV$XO]3\u0011\u0005utX\"\u00012\n\u0005}\u0014'aC)vKJL(+Z:vYRDa!a\u0001\u0014\u0001\u0004A\u0013!C:uCR,W.\u001a8u\u0011%\t9a\u0005I\u0001\u0002\u0004\tI!A\u0004paRLwN\\:\u0011\u0007u\fY!C\u0002\u0002\u000e\t\u0014A\"U;fef|\u0005\u000f^5p]N\fq\"];fef$C-\u001a4bk2$HEM\u000b\u0003\u0003'QC!!\u0003\u0002\u0016-\u0012\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003%)hn\u00195fG.,GMC\u0002\u0002\"\u0011\n!\"\u00198o_R\fG/[8o\u0013\u0011\t)#a\u0007\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bb]\u0006d\u0017\u0010^5dgF+XM]=\u0015\r\u0005-\u0012\u0011HA\u001e!\u0011\u0001&0!\f\u0011\t\u0005=\u0012QG\u0007\u0003\u0003cQ1!a\r\u0019\u0003%\tg.\u00197zi&\u001c7/\u0003\u0003\u00028\u0005E\"aD!oC2LH/[2t%\u0016\u001cX\u000f\u001c;\t\r\u0005\rQ\u00031\u0001)\u0011%\t9!\u0006I\u0001\u0002\u0004\ti\u0004\u0005\u0003\u00020\u0005}\u0012\u0002BA!\u0003c\u0011\u0001#\u00118bYf$\u0018nY:PaRLwN\\:\u00021\u0005t\u0017\r\\=uS\u000e\u001c\u0018+^3ss\u0012\"WMZ1vYR$#'\u0006\u0002\u0002H)\"\u0011QHA\u000b\u0001")
public class AsyncScope {
    private final String scopeName;
    private final String bucketName;
    private final Core core;
    private final ClusterEnvironment environment;
    private final ExecutionContext ec;
    private final HandlerBasicParams hp;
    private final QueryHandler queryHandler;
    private final AnalyticsHandler analyticsHandler;

    private Core core() {
        return this.core;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public HandlerBasicParams hp() {
        return this.hp;
    }

    public QueryHandler queryHandler() {
        return this.queryHandler;
    }

    public AnalyticsHandler analyticsHandler() {
        return this.analyticsHandler;
    }

    public String name() {
        return this.scopeName;
    }

    public AsyncCollection defaultCollection() {
        return this.collection(DefaultResources$.MODULE$.DefaultCollection());
    }

    public AsyncCollection collection(String collectionName) {
        boolean defaultScopeAndCollection;
        boolean bl = defaultScopeAndCollection = collectionName.equals(DefaultResources$.MODULE$.DefaultCollection()) && this.scopeName.equals(DefaultResources$.MODULE$.DefaultScope());
        if (!defaultScopeAndCollection) {
            this.core().configurationProvider().refreshCollectionId(new CollectionIdentifier(this.bucketName, Optional.of(this.scopeName), Optional.of(collectionName)));
        }
        return new AsyncCollection(collectionName, this.bucketName, this.scopeName, this.core(), this.environment());
    }

    public Future<QueryResult> query(String statement, QueryOptions options) {
        return this.queryHandler().queryAsync(statement, options, this.environment(), (Option<String>)new Some((Object)this.bucketName), (Option<String>)new Some((Object)this.scopeName));
    }

    public QueryOptions query$default$2() {
        return QueryOptions$.MODULE$.apply();
    }

    public Future<AnalyticsResult> analyticsQuery(String statement, AnalyticsOptions options) {
        Future future;
        Try<AnalyticsRequest> try_ = this.analyticsHandler().request(statement, options, this.core(), this.environment(), (Option<String>)new Some((Object)this.bucketName), (Option<String>)new Some((Object)this.scopeName));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            AnalyticsRequest request = (AnalyticsRequest)success.value();
            future = this.analyticsHandler().queryAsync(request, this.ec());
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            future = Future$.MODULE$.failed(err);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    public AnalyticsOptions analyticsQuery$default$2() {
        return AnalyticsOptions$.MODULE$.Default();
    }

    public AsyncScope(String scopeName, String bucketName, Core core, ClusterEnvironment environment) {
        this.scopeName = scopeName;
        this.bucketName = bucketName;
        this.core = core;
        this.environment = environment;
        this.ec = environment.ec();
        this.hp = new HandlerBasicParams(core, environment);
        this.queryHandler = new QueryHandler(this.hp(), this.ec());
        this.analyticsHandler = new AnalyticsHandler(this.hp());
    }
}

