/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.util;

import com.couchbase.client.kotlin.util.StorageSizeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001&B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\r\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0005H\u0002J\b\u0010%\u001a\u00020\u001fH\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\t\u00a8\u0006'"}, d2={"Lcom/couchbase/client/kotlin/util/StorageSize;", "", "value", "", "unit", "Lcom/couchbase/client/kotlin/util/StorageSizeUnit;", "(JLcom/couchbase/client/kotlin/util/StorageSizeUnit;)V", "inBytes", "getInBytes", "()J", "inWholeGibibytes", "getInWholeGibibytes$kotlin_client", "inWholeKibibytes", "getInWholeKibibytes$kotlin_client", "inWholeMebibytes", "getInWholeMebibytes$kotlin_client", "inWholePebibytes", "getInWholePebibytes$kotlin_client", "inWholeTebibytes", "getInWholeTebibytes$kotlin_client", "getUnit", "()Lcom/couchbase/client/kotlin/util/StorageSizeUnit;", "getValue", "compareTo", "", "other", "equals", "", "", "hashCode", "serialize", "", "serialize$kotlin_client", "simplify", "simplify$kotlin_client", "toLong", "destUnit", "toString", "Companion", "kotlin-client"})
@SourceDebugExtension(value={"SMAP\nStorageSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageSize.kt\ncom/couchbase/client/kotlin/util/StorageSize\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StorageSize.kt\ncom/couchbase/client/kotlin/util/StorageSize$Companion\n*L\n1#1,124:1\n1#2:125\n66#3,8:126\n*S KotlinDebug\n*F\n+ 1 StorageSize.kt\ncom/couchbase/client/kotlin/util/StorageSize\n*L\n92#1:126,8\n*E\n"})
public final class StorageSize
implements Comparable<StorageSize> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long value;
    @NotNull
    private final StorageSizeUnit unit;
    private final long inBytes;

    public StorageSize(long value2, @NotNull StorageSizeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this.value = value2;
        this.unit = unit;
        if (!(this.value >= 0L)) {
            boolean bl = false;
            String string = "Storage size value must not be negative, but got: " + this.value + ' ' + this.unit.getShortName$kotlin_client();
            throw new IllegalArgumentException(string.toString());
        }
        try {
            this.inBytes = Math.multiplyExact(this.value, this.unit.getScale$kotlin_client());
        }
        catch (ArithmeticException _) {
            throw new IllegalArgumentException("" + this.value + ' ' + this.unit.getShortName$kotlin_client() + " is more than the max value, 9223372036854775807 bytes.");
        }
    }

    public final long getValue() {
        return this.value;
    }

    @NotNull
    public final StorageSizeUnit getUnit() {
        return this.unit;
    }

    public final long getInBytes() {
        return this.inBytes;
    }

    public final long getInWholeKibibytes$kotlin_client() {
        return this.toLong(StorageSizeUnit.KIBIBYTES);
    }

    public final long getInWholeMebibytes$kotlin_client() {
        return this.toLong(StorageSizeUnit.MEBIBYTES);
    }

    public final long getInWholeGibibytes$kotlin_client() {
        return this.toLong(StorageSizeUnit.GIBIBYTES);
    }

    public final long getInWholeTebibytes$kotlin_client() {
        return this.toLong(StorageSizeUnit.TEBIBYTES);
    }

    public final long getInWholePebibytes$kotlin_client() {
        return this.toLong(StorageSizeUnit.PEBIBYTES);
    }

    private final long toLong(StorageSizeUnit destUnit) {
        return this.inBytes / destUnit.getScale$kotlin_client();
    }

    @NotNull
    public final String serialize$kotlin_client() {
        return "" + this.value + ' ' + this.unit.getShortName$kotlin_client();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StorageSize simplify$kotlin_client() {
        StorageSizeUnit storageSizeUnit;
        if (this.inBytes == 0L) {
            void this_$iv;
            Companion companion = Companion;
            int $this$bytes$iv = 0;
            boolean $i$f$getBytes = false;
            void var4_5 = this_$iv;
            long $this$bytes$iv$iv = $this$bytes$iv;
            boolean $i$f$getBytes2 = false;
            return new StorageSize($this$bytes$iv$iv, StorageSizeUnit.BYTES);
        }
        if (this.value % (long)1024 != 0L) {
            return this;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.unit.ordinal()]) {
            case 1: {
                storageSizeUnit = StorageSizeUnit.KIBIBYTES;
                break;
            }
            case 2: {
                storageSizeUnit = StorageSizeUnit.MEBIBYTES;
                break;
            }
            case 3: {
                storageSizeUnit = StorageSizeUnit.GIBIBYTES;
                break;
            }
            case 4: {
                storageSizeUnit = StorageSizeUnit.TEBIBYTES;
                break;
            }
            case 5: {
                storageSizeUnit = StorageSizeUnit.PEBIBYTES;
                break;
            }
            default: {
                return this;
            }
        }
        StorageSizeUnit nextUnit = storageSizeUnit;
        return new StorageSize(this.value / (long)1024, nextUnit).simplify$kotlin_client();
    }

    @NotNull
    public String toString() {
        return this.serialize$kotlin_client();
    }

    @Override
    public int compareTo(@NotNull StorageSize other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.inBytes, (long)other.inBytes);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.couchbase.client.kotlin.util.StorageSize");
        StorageSize cfr_ignored_0 = (StorageSize)other;
        return this.inBytes == ((StorageSize)other).inBytes;
    }

    public int hashCode() {
        return Long.hashCode(this.inBytes);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0016\u0010\n\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\n\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\f\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0016\u0010\u000e\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0016\u0010\u000e\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0007R\u0016\u0010\u0010\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0016\u0010\u0012\u001a\u00020\u0004*\u00020\u00058\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0016\u0010\u0012\u001a\u00020\u0004*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/couchbase/client/kotlin/util/StorageSize$Companion;", "", "()V", "bytes", "Lcom/couchbase/client/kotlin/util/StorageSize;", "", "getBytes", "(I)Lcom/couchbase/client/kotlin/util/StorageSize;", "", "(J)Lcom/couchbase/client/kotlin/util/StorageSize;", "gibibytes", "getGibibytes", "kibibytes", "getKibibytes", "mebibytes", "getMebibytes", "pebibytes", "getPebibytes", "tebibytes", "getTebibytes", "kotlin-client"})
    @SourceDebugExtension(value={"SMAP\nStorageSize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageSize.kt\ncom/couchbase/client/kotlin/util/StorageSize$Companion\n*L\n1#1,124:1\n73#1:125\n74#1:126\n75#1:127\n76#1:128\n77#1:129\n78#1:130\n*S KotlinDebug\n*F\n+ 1 StorageSize.kt\ncom/couchbase/client/kotlin/util/StorageSize$Companion\n*L\n66#1:125\n67#1:126\n68#1:127\n69#1:128\n70#1:129\n71#1:130\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StorageSize getBytes(int $this$bytes) {
            boolean $i$f$getBytes = false;
            Companion companion = this;
            long $this$bytes$iv = $this$bytes;
            boolean $i$f$getBytes2 = false;
            return new StorageSize($this$bytes$iv, StorageSizeUnit.BYTES);
        }

        @NotNull
        public final StorageSize getKibibytes(int $this$kibibytes) {
            boolean $i$f$getKibibytes = false;
            Companion companion = this;
            long $this$kibibytes$iv = $this$kibibytes;
            boolean $i$f$getKibibytes2 = false;
            return new StorageSize($this$kibibytes$iv, StorageSizeUnit.KIBIBYTES);
        }

        @NotNull
        public final StorageSize getMebibytes(int $this$mebibytes) {
            boolean $i$f$getMebibytes = false;
            Companion companion = this;
            long $this$mebibytes$iv = $this$mebibytes;
            boolean $i$f$getMebibytes2 = false;
            return new StorageSize($this$mebibytes$iv, StorageSizeUnit.MEBIBYTES);
        }

        @NotNull
        public final StorageSize getGibibytes(int $this$gibibytes) {
            boolean $i$f$getGibibytes = false;
            Companion companion = this;
            long $this$gibibytes$iv = $this$gibibytes;
            boolean $i$f$getGibibytes2 = false;
            return new StorageSize($this$gibibytes$iv, StorageSizeUnit.GIBIBYTES);
        }

        @NotNull
        public final StorageSize getTebibytes(int $this$tebibytes) {
            boolean $i$f$getTebibytes = false;
            Companion companion = this;
            long $this$tebibytes$iv = $this$tebibytes;
            boolean $i$f$getTebibytes2 = false;
            return new StorageSize($this$tebibytes$iv, StorageSizeUnit.TEBIBYTES);
        }

        @NotNull
        public final StorageSize getPebibytes(int $this$pebibytes) {
            boolean $i$f$getPebibytes = false;
            Companion companion = this;
            long $this$pebibytes$iv = $this$pebibytes;
            boolean $i$f$getPebibytes2 = false;
            return new StorageSize($this$pebibytes$iv, StorageSizeUnit.PEBIBYTES);
        }

        @NotNull
        public final StorageSize getBytes(long $this$bytes) {
            boolean $i$f$getBytes = false;
            return new StorageSize($this$bytes, StorageSizeUnit.BYTES);
        }

        @NotNull
        public final StorageSize getKibibytes(long $this$kibibytes) {
            boolean $i$f$getKibibytes = false;
            return new StorageSize($this$kibibytes, StorageSizeUnit.KIBIBYTES);
        }

        @NotNull
        public final StorageSize getMebibytes(long $this$mebibytes) {
            boolean $i$f$getMebibytes = false;
            return new StorageSize($this$mebibytes, StorageSizeUnit.MEBIBYTES);
        }

        @NotNull
        public final StorageSize getGibibytes(long $this$gibibytes) {
            boolean $i$f$getGibibytes = false;
            return new StorageSize($this$gibibytes, StorageSizeUnit.GIBIBYTES);
        }

        @NotNull
        public final StorageSize getTebibytes(long $this$tebibytes) {
            boolean $i$f$getTebibytes = false;
            return new StorageSize($this$tebibytes, StorageSizeUnit.TEBIBYTES);
        }

        @NotNull
        public final StorageSize getPebibytes(long $this$pebibytes) {
            boolean $i$f$getPebibytes = false;
            return new StorageSize($this$pebibytes, StorageSizeUnit.PEBIBYTES);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageSizeUnit.values().length];
            try {
                nArray[StorageSizeUnit.BYTES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageSizeUnit.KIBIBYTES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageSizeUnit.MEBIBYTES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageSizeUnit.GIBIBYTES.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageSizeUnit.TEBIBYTES.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

