/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.http;

import com.couchbase.client.kotlin.http.NameValuePairs;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/couchbase/client/kotlin/http/HttpBody;", "", "contentType", "", "content", "", "(Ljava/lang/String;[B)V", "getContent", "()[B", "getContentType", "()Ljava/lang/String;", "Companion", "kotlin-client"})
public final class HttpBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String contentType;
    @NotNull
    private final byte[] content;

    public HttpBody(@NotNull String contentType, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.contentType = contentType;
        this.content = content;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final byte[] getContent() {
        return this.content;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J7\u0010\u0003\u001a\u00020\u00042*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b0\u0007\"\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"Lcom/couchbase/client/kotlin/http/HttpBody$Companion;", "", "()V", "form", "Lcom/couchbase/client/kotlin/http/HttpBody;", "values", "Lcom/couchbase/client/kotlin/http/NameValuePairs;", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;)Lcom/couchbase/client/kotlin/http/HttpBody;", "", "json", "", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpBody json(@NotNull byte[] json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new HttpBody("application/json", json);
        }

        @NotNull
        public final HttpBody json(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            String string = json;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new HttpBody("application/json", byArray);
        }

        @NotNull
        public final HttpBody form(@NotNull NameValuePairs values) {
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            String string = values.getUrlEncoded$kotlin_client();
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new HttpBody("application/x-www-form-urlencoded", byArray);
        }

        @NotNull
        public final HttpBody form(@NotNull Map<String, ? extends Object> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.form(NameValuePairs.Companion.of(values));
        }

        @NotNull
        public final HttpBody form(Pair<String, ? extends Object> ... values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return this.form(NameValuePairs.Companion.of(Arrays.copyOf(values, values.length)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

