/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.diagnostics.HealthPinger;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.msg.view.ViewRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.AsyncScope;
import com.couchbase.client.java.ReactiveBucket;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.manager.collection.AsyncCollectionManager;
import com.couchbase.client.java.manager.view.AsyncViewIndexManager;
import com.couchbase.client.java.view.ViewAccessor;
import com.couchbase.client.java.view.ViewOptions;
import com.couchbase.client.java.view.ViewResult;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class AsyncBucket {
    private final String name;
    private final ClusterEnvironment environment;
    private final CoreCouchbaseOps couchbaseOps;
    private final AsyncCluster cluster;
    private final Map<String, AsyncScope> scopeCache = new ConcurrentHashMap<String, AsyncScope>();

    AsyncBucket(String name, CoreCouchbaseOps couchbaseOps, ClusterEnvironment environment, AsyncCluster cluster) {
        this.couchbaseOps = Objects.requireNonNull(couchbaseOps);
        this.environment = Objects.requireNonNull(environment);
        this.name = Objects.requireNonNull(name);
        this.cluster = Objects.requireNonNull(cluster);
    }

    public String name() {
        return this.name;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    @Stability.Volatile
    public Core core() {
        return this.couchbaseOps.asCore();
    }

    public AsyncCollectionManager collections() {
        return new AsyncCollectionManager(this.couchbaseOps.collectionManager(this.name), this.cluster);
    }

    public AsyncViewIndexManager viewIndexes() {
        return new AsyncViewIndexManager(this.core(), this.name, this.cluster);
    }

    public AsyncScope scope(String name) {
        return this.maybeCreateAsyncScope(name);
    }

    public AsyncScope defaultScope() {
        return this.maybeCreateAsyncScope("_default");
    }

    private AsyncScope maybeCreateAsyncScope(String scopeName) {
        return this.scopeCache.computeIfAbsent(scopeName, ignored -> new AsyncScope(scopeName, this.name, this.couchbaseOps, this.environment, this.cluster));
    }

    public AsyncCollection defaultCollection() {
        return this.defaultScope().defaultCollection();
    }

    public AsyncCollection collection(String collectionName) {
        return this.defaultScope().collection(collectionName);
    }

    public CompletableFuture<ViewResult> viewQuery(String designDoc, String viewName) {
        return this.viewQuery(designDoc, viewName, ReactiveBucket.DEFAULT_VIEW_OPTIONS);
    }

    public CompletableFuture<ViewResult> viewQuery(String designDoc, String viewName, ViewOptions options) {
        Validators.notNull((Object)options, (String)"ViewOptions", () -> new ReducedViewErrorContext(designDoc, viewName, this.name));
        ViewOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return ViewAccessor.viewQueryAsync(this.core(), this.viewRequest(designDoc, viewName, opts), serializer);
    }

    ViewRequest viewRequest(String designDoc, String viewName, ViewOptions.Built opts) {
        Validators.notNullOrEmpty((String)designDoc, (String)"DesignDoc", () -> new ReducedViewErrorContext(designDoc, viewName, this.name));
        Validators.notNullOrEmpty((String)viewName, (String)"ViewName", () -> new ReducedViewErrorContext(designDoc, viewName, this.name));
        String query = opts.query();
        Optional<byte[]> keysJson = Optional.ofNullable(opts.keys()).map(s -> s.getBytes(StandardCharsets.UTF_8));
        boolean development = opts.development();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().viewTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment().requestTracer().requestSpan("views", (RequestSpan)opts.parentSpan().orElse(null));
        ViewRequest request = new ViewRequest(timeout, this.core().context(), retryStrategy, this.core().context().authenticator(), this.name, designDoc, viewName, query, keysJson, development, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<PingResult> ping() {
        return this.ping(ReactiveCluster.DEFAULT_PING_OPTIONS);
    }

    public CompletableFuture<PingResult> ping(PingOptions options) {
        Validators.notNull((Object)options, (String)"PingOptions");
        PingOptions.Built opts = options.build();
        return HealthPinger.ping((Core)this.core(), opts.timeout(), (RetryStrategy)opts.retryStrategy().orElse(this.environment.retryStrategy()), opts.serviceTypes(), opts.reportId(), Optional.of(this.name)).toFuture();
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout) {
        return this.waitUntilReady(timeout, ReactiveCluster.DEFAULT_WAIT_UNTIL_READY_OPTIONS);
    }

    public CompletableFuture<Void> waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        Validators.notNull((Object)options, (String)"WaitUntilReadyOptions");
        WaitUntilReadyOptions.Built opts = options.build();
        return this.couchbaseOps.waitUntilReady(opts.serviceTypes(), timeout, opts.desiredState(), this.name);
    }
}

