/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result;

import com.couchbase.client.core.api.search.result.CoreSearchRow;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.result.SearchRowLocations;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SearchRow {
    private final CoreSearchRow internal;
    private final JsonSerializer serializer;

    public SearchRow(CoreSearchRow internal, JsonSerializer serializer) {
        this.internal = internal;
        this.serializer = serializer;
    }

    public String index() {
        return this.internal.index();
    }

    public String id() {
        return this.internal.id();
    }

    public double score() {
        return this.internal.score();
    }

    public JsonObject explanation() {
        byte[] bytes = this.internal.explanation();
        return bytes.length == 0 ? JsonObject.create() : JsonObject.fromJson(bytes);
    }

    public Optional<SearchRowLocations> locations() {
        return this.internal.locations().map(SearchRowLocations::new);
    }

    public Map<String, List<String>> fragments() {
        return this.internal.fragments();
    }

    public <T> T fieldsAs(Class<T> target) {
        if (this.internal.fields() == null) {
            return null;
        }
        return this.serializer.deserialize(target, this.internal.fields());
    }

    public <T> T fieldsAs(TypeRef<T> target) {
        if (this.internal.fields() == null) {
            return null;
        }
        return this.serializer.deserialize(target, this.internal.fields());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchRow searchRow = (SearchRow)o;
        return Objects.equals(this.internal, searchRow.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }

    public String toString() {
        return this.internal.toString();
    }
}

