/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class Expiry {
    private static final int LATEST_VALID_EXPIRY_DURATION = (int)TimeUnit.DAYS.toSeconds(365L) * 50;
    private static final Expiry NONE = new Expiry(CoreExpiry.NONE);
    private final CoreExpiry core;

    private Expiry(CoreExpiry core) {
        this.core = Objects.requireNonNull(core);
    }

    public static Expiry none() {
        return NONE;
    }

    public static Expiry relative(Duration expiry) {
        Validators.notNull((Object)expiry, (String)"expiry");
        if (expiry.isZero()) {
            return Expiry.none();
        }
        long seconds = expiry.getSeconds();
        if (seconds <= 0L) {
            throw InvalidArgumentException.fromMessage((String)("When specifying expiry as a Duration, it must be either zero (to explicitly disable expiration) or at least 1 second, but got " + expiry + ". If for some reason you want the document to expire immediately, use Instant.ofEpochSecond(DAYS.toSeconds(31))"));
        }
        if (seconds > (long)LATEST_VALID_EXPIRY_DURATION) {
            throw InvalidArgumentException.fromMessage((String)("When specifying expiry as a Duration, it must not be longer than " + LATEST_VALID_EXPIRY_DURATION + ", but got " + expiry + ". If you truly require a longer expiry, please specify it as an Instant instead."));
        }
        return new Expiry(CoreExpiry.of((Duration)expiry));
    }

    public static Expiry absolute(Instant expiry) {
        Validators.notNull((Object)expiry, (String)"expiry");
        return new Expiry(CoreExpiry.of((Instant)expiry));
    }

    public CoreExpiry encode() {
        return this.core;
    }

    public String toString() {
        return this.core.toString();
    }
}

