/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.vector.VectorSearch;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class SearchRequest {
    @Nullable
    private SearchQuery searchQuery;
    @Nullable
    private VectorSearch vectorSearch;

    private SearchRequest(@Nullable SearchQuery searchQuery, @Nullable VectorSearch vectorSearch) {
        this.searchQuery = searchQuery;
        this.vectorSearch = vectorSearch;
    }

    public static SearchRequest create(VectorSearch vectorSearch) {
        return new SearchRequest(null, vectorSearch);
    }

    public static SearchRequest create(SearchQuery searchQuery) {
        return new SearchRequest(searchQuery, null);
    }

    public SearchRequest searchQuery(SearchQuery searchQuery) {
        if (this.searchQuery != null) {
            throw new InvalidArgumentException("A SearchQuery has already been specified.  Note that a ConjunctionQuery or DisjunctionQuery can be used to combine multiple SearchQuery objects.", null, null);
        }
        this.searchQuery = searchQuery;
        return this;
    }

    public SearchRequest vectorSearch(VectorSearch vectorSearch) {
        if (this.vectorSearch != null) {
            throw new InvalidArgumentException("A VectorSearch has already been specified.  Note that a single VectorSearch can take multiple VectorQuery objects, allowing multiple vector queries to be run.", null, null);
        }
        this.vectorSearch = vectorSearch;
        return this;
    }

    @Stability.Internal
    public CoreSearchRequest toCore() {
        return new CoreSearchRequest(this.searchQuery == null ? null : this.searchQuery.toCore(), this.vectorSearch == null ? null : this.vectorSearch.toCore());
    }
}

