/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCollection;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.datastructures.CouchbaseArrayList;
import com.couchbase.client.java.datastructures.CouchbaseArraySet;
import com.couchbase.client.java.datastructures.CouchbaseMap;
import com.couchbase.client.java.datastructures.CouchbaseQueue;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.ArrayListOptions;
import com.couchbase.client.java.kv.ArraySetOptions;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MapOptions;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.QueueOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanResult;
import com.couchbase.client.java.kv.ScanType;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.manager.query.CollectionQueryIndexManager;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Stream;

public class Collection {
    private final AsyncCollection asyncCollection;
    private final ReactiveCollection reactiveCollection;
    private final BinaryCollection binaryCollection;
    private final CoreKvOps kvOps;
    private final CollectionQueryIndexManager queryIndexManager;

    Collection(AsyncCollection asyncCollection) {
        this.asyncCollection = asyncCollection;
        this.reactiveCollection = new ReactiveCollection(asyncCollection);
        this.binaryCollection = new BinaryCollection(asyncCollection.binary());
        this.kvOps = asyncCollection.kvOps;
        this.queryIndexManager = new CollectionQueryIndexManager(asyncCollection.queryIndexes());
    }

    public AsyncCollection async() {
        return this.asyncCollection;
    }

    public ReactiveCollection reactive() {
        return this.reactiveCollection;
    }

    public String name() {
        return this.asyncCollection.name();
    }

    public String bucketName() {
        return this.asyncCollection.bucketName();
    }

    public String scopeName() {
        return this.asyncCollection.scopeName();
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCollection.core();
    }

    public ClusterEnvironment environment() {
        return this.asyncCollection.environment();
    }

    public BinaryCollection binary() {
        return this.binaryCollection;
    }

    @Stability.Volatile
    public CollectionQueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public GetResult get(String id) {
        return this.get(id, ReactiveCollection.DEFAULT_GET_OPTIONS);
    }

    public GetResult get(String id, GetOptions options) {
        GetOptions.Built opts = ((GetOptions)Validators.notNull((Object)options, (String)"options")).build();
        return new GetResult(this.kvOps.getBlocking((CoreCommonOptions)opts, id, opts.projections(), opts.withExpiry()), opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder());
    }

    public GetResult getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, ReactiveCollection.DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public GetResult getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        GetAndLockOptions.Built opts = ((GetAndLockOptions)Validators.notNull((Object)options, (String)"options")).build();
        return new GetResult(this.kvOps.getAndLockBlocking((CoreCommonOptions)opts, id, lockTime), opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder());
    }

    public GetResult getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public GetResult getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.relative(expiry), options);
    }

    public GetResult getAndTouch(String id, Instant expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public GetResult getAndTouch(String id, Instant expiry, GetAndTouchOptions options) {
        return this.getAndTouch(id, Expiry.absolute(expiry), options);
    }

    private GetResult getAndTouch(String id, Expiry expiry, GetAndTouchOptions options) {
        Validators.notNull((Object)expiry, (String)"expiry");
        GetAndTouchOptions.Built opts = ((GetAndTouchOptions)Validators.notNull((Object)options, (String)"options")).build();
        return new GetResult(this.kvOps.getAndTouchBlocking((CoreCommonOptions)opts, id, expiry.encode()), opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder());
    }

    public Stream<GetReplicaResult> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public Stream<GetReplicaResult> getAllReplicas(String id, GetAllReplicasOptions options) {
        return this.reactiveCollection.getAllReplicas(id, options).toStream();
    }

    public GetReplicaResult getAnyReplica(String id) {
        return AsyncUtils.block(this.asyncCollection.getAnyReplica(id));
    }

    public GetReplicaResult getAnyReplica(String id, GetAnyReplicaOptions options) {
        return AsyncUtils.block(this.asyncCollection.getAnyReplica(id, options));
    }

    public ExistsResult exists(String id) {
        return this.exists(id, ReactiveCollection.DEFAULT_EXISTS_OPTIONS);
    }

    public ExistsResult exists(String id, ExistsOptions options) {
        ExistsOptions.Built opts = ((ExistsOptions)Validators.notNull((Object)options, (String)"options")).build();
        return ExistsResult.from(this.kvOps.existsBlocking((CoreCommonOptions)opts, id));
    }

    public MutationResult remove(String id) {
        return this.remove(id, ReactiveCollection.DEFAULT_REMOVE_OPTIONS);
    }

    public MutationResult remove(String id, RemoveOptions options) {
        Validators.notNull((Object)options, (String)"RemoveOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        RemoveOptions.Built opts = options.build();
        return new MutationResult(this.kvOps.removeBlocking((CoreCommonOptions)opts, id, opts.cas(), opts.toCoreDurability()));
    }

    public MutationResult insert(String id, Object content) {
        return this.insert(id, content, ReactiveCollection.DEFAULT_INSERT_OPTIONS);
    }

    public MutationResult insert(String id, Object content, InsertOptions options) {
        Validators.notNull((Object)options, (String)"InsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        InsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return new MutationResult(this.kvOps.insertBlocking((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode()));
    }

    public MutationResult upsert(String id, Object content) {
        return this.upsert(id, content, ReactiveCollection.DEFAULT_UPSERT_OPTIONS);
    }

    public MutationResult upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull((Object)options, (String)"UpsertOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        UpsertOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return new MutationResult(this.kvOps.upsertBlocking((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()));
    }

    public MutationResult replace(String id, Object content) {
        return this.replace(id, content, ReactiveCollection.DEFAULT_REPLACE_OPTIONS);
    }

    public MutationResult replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull((Object)options, (String)"ReplaceOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)content, (String)"Content", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        ReplaceOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return new MutationResult(this.kvOps.replaceBlocking((CoreCommonOptions)opts, id, () -> transcoder.encode(content), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry()));
    }

    public MutationResult touch(String id, Duration expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public MutationResult touch(String id, Duration expiry, TouchOptions options) {
        Validators.notNull((Object)options, (String)"TouchOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        Validators.notNull((Object)expiry, (String)"Expiry", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        TouchOptions.Built opts = options.build();
        return new MutationResult(this.kvOps.touchBlocking((CoreCommonOptions)opts, id, Expiry.relative(expiry).encode()));
    }

    public void unlock(String id, long cas) {
        this.unlock(id, cas, ReactiveCollection.DEFAULT_UNLOCK_OPTIONS);
    }

    public void unlock(String id, long cas, UnlockOptions options) {
        Validators.notNull((Object)options, (String)"UnlockOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.asyncCollection.collectionIdentifier()));
        UnlockOptions.Built opts = options.build();
        this.kvOps.unlockBlocking((CoreCommonOptions)opts, id, cas);
    }

    public LookupInResult lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public LookupInResult lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        Validators.notNull((Object)options, (String)"LookupInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        Validators.notNull(specs, (String)"LookupInSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        LookupInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        CoreSubdocGetResult coreResult = this.kvOps.subdocGetBlocking((CoreCommonOptions)opts, id, CbCollections.transform(specs, LookupInSpec::toCore), opts.accessDeleted());
        return new LookupInResult(coreResult, serializer);
    }

    public MutateInResult mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, ReactiveCollection.DEFAULT_MUTATE_IN_OPTIONS);
    }

    public MutateInResult mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull((Object)options, (String)"MutateInOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        Validators.notNull(specs, (String)"MutationSpecs", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.async().collectionIdentifier()));
        MutateInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment().jsonSerializer() : opts.serializer();
        CoreSubdocMutateResult coreResult = this.kvOps.subdocMutateBlocking((CoreCommonOptions)opts, id, () -> CbCollections.transform((Iterable)specs, it -> it.toCore(serializer)), opts.storeSemantics().toCore(), opts.cas(), opts.toCoreDurability(), opts.expiry().encode(), opts.preserveExpiry(), opts.accessDeleted(), opts.createAsDeleted());
        return new MutateInResult(coreResult, serializer);
    }

    public <T> List<T> list(String id, Class<T> entityType) {
        return this.list(id, entityType, ArrayListOptions.arrayListOptions());
    }

    public <T> List<T> list(String id, Class<T> entityType, ArrayListOptions options) {
        return new CouchbaseArrayList<T>(id, this, entityType, options);
    }

    public <T> Set<T> set(String id, Class<T> entityType) {
        return this.set(id, entityType, ArraySetOptions.arraySetOptions());
    }

    public <T> Set<T> set(String id, Class<T> entityType, ArraySetOptions options) {
        return new CouchbaseArraySet<T>(id, this, entityType, options);
    }

    public <T> Map<String, T> map(String id, Class<T> entityType) {
        return this.map(id, entityType, MapOptions.mapOptions());
    }

    public <T> Map<String, T> map(String id, Class<T> entityType, MapOptions options) {
        return new CouchbaseMap<T>(id, this, entityType, options);
    }

    public <T> Queue<T> queue(String id, Class<T> entityType) {
        return this.queue(id, entityType, QueueOptions.queueOptions());
    }

    public <T> Queue<T> queue(String id, Class<T> entityType, QueueOptions options) {
        return new CouchbaseQueue<T>(id, this, entityType, options);
    }

    @Stability.Volatile
    public Stream<ScanResult> scan(ScanType scanType) {
        return this.scan(scanType, ScanOptions.scanOptions());
    }

    @Stability.Volatile
    public Stream<ScanResult> scan(ScanType scanType, ScanOptions options) {
        return this.reactive().scan(scanType, options).toStream();
    }
}

