/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.kv.CoreScanTerm;
import com.couchbase.client.core.util.Validators;
import java.nio.charset.StandardCharsets;

@Stability.Volatile
public class ScanTerm {
    private static final ScanTerm MINIMUM = ScanTerm.inclusive(new byte[]{0});
    private static final ScanTerm MAXIMUM = ScanTerm.inclusive(new byte[]{-1});
    private final byte[] id;
    private final boolean exclusive;

    private ScanTerm(byte[] id, boolean exclusive) {
        this.id = (byte[])Validators.notNullOrEmpty((byte[])id, (String)"ScanTerm ID").clone();
        this.exclusive = exclusive;
    }

    private ScanTerm(String id, boolean exclusive) {
        this.id = Validators.notNullOrEmpty((String)id, (String)"ScanTerm ID").getBytes(StandardCharsets.UTF_8);
        this.exclusive = exclusive;
    }

    public byte[] id() {
        return (byte[])this.id.clone();
    }

    public boolean exclusive() {
        return this.exclusive;
    }

    public static ScanTerm inclusive(String id) {
        return new ScanTerm(id, false);
    }

    public static ScanTerm inclusive(byte[] id) {
        return new ScanTerm(id, false);
    }

    public static ScanTerm exclusive(String id) {
        return new ScanTerm(id, true);
    }

    public static ScanTerm exclusive(byte[] id) {
        return new ScanTerm(id, true);
    }

    public static ScanTerm minimum() {
        return MINIMUM;
    }

    public static ScanTerm maximum() {
        return MAXIMUM;
    }

    @Stability.Internal
    public CoreScanTerm toCore() {
        return new CoreScanTerm(this.id, this.exclusive);
    }
}

