/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.api.kv.CoreKvBinaryOps;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.BinaryCollection;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependOptions;
import reactor.core.publisher.Mono;

public class ReactiveBinaryCollection {
    private final CollectionIdentifier collectionIdentifier;
    private final CoreKvBinaryOps coreKvBinaryOps;

    ReactiveBinaryCollection(Core core, AsyncBinaryCollection async) {
        this.collectionIdentifier = async.collectionIdentifier();
        this.coreKvBinaryOps = async.coreKvBinaryOps;
    }

    public Mono<MutationResult> append(String id, byte[] content) {
        return this.append(id, content, BinaryCollection.DEFAULT_APPEND_OPTIONS);
    }

    public Mono<MutationResult> append(String id, byte[] content, AppendOptions options) {
        AppendOptions.Built opts = ((AppendOptions)Validators.notNull((Object)options, (String)"AppendOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return this.coreKvBinaryOps.appendReactive(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()).map(MutationResult::new);
    }

    public Mono<MutationResult> prepend(String id, byte[] content) {
        return this.prepend(id, content, BinaryCollection.DEFAULT_PREPEND_OPTIONS);
    }

    public Mono<MutationResult> prepend(String id, byte[] content, PrependOptions options) {
        PrependOptions.Built opts = ((PrependOptions)Validators.notNull((Object)options, (String)"PrependOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return this.coreKvBinaryOps.prependReactive(id, content, (CoreCommonOptions)opts, opts.cas(), opts.toCoreDurability()).map(MutationResult::new);
    }

    public Mono<CounterResult> increment(String id) {
        return this.increment(id, BinaryCollection.DEFAULT_INCREMENT_OPTIONS);
    }

    public Mono<CounterResult> increment(String id, IncrementOptions options) {
        IncrementOptions.Built opts = ((IncrementOptions)Validators.notNull((Object)options, (String)"IncrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return this.coreKvBinaryOps.incrementReactive(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()).map(CounterResult::new);
    }

    public Mono<CounterResult> decrement(String id) {
        return this.decrement(id, BinaryCollection.DEFAULT_DECREMENT_OPTIONS);
    }

    public Mono<CounterResult> decrement(String id, DecrementOptions options) {
        DecrementOptions.Built opts = ((DecrementOptions)Validators.notNull((Object)options, (String)"DecrementOptions", () -> ReducedKeyValueErrorContext.create((String)id, (CollectionIdentifier)this.collectionIdentifier))).build();
        return this.coreKvBinaryOps.decrementReactive(id, (CoreCommonOptions)opts, opts.expiry().encode(), opts.delta(), opts.initial(), opts.toCoreDurability()).map(CounterResult::new);
    }
}

