/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.transactions.TransactionGetResult;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import com.couchbase.client.java.transactions.TransactionQueryResult;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import com.couchbase.client.java.transactions.internal.EncodingUtil;
import com.couchbase.client.java.transactions.internal.OptionsUtil;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final JsonSerializer serializer;

    ReactiveTransactionAttemptContext(CoreTransactionAttemptContext internal, JsonSerializer serializer) {
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Stability.Internal
    CoreTransactionAttemptContext ctx() {
        return this.internal;
    }

    public Mono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return this.internal.get(ConverterUtil.makeCollectionIdentifier(collection.async()), id).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer()));
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_insert", (RequestSpan)this.internal.span());
        span.attribute("db.operation", "transaction_insert");
        byte[] encoded = EncodingUtil.encode(content, span, this.serializer, this.internal.core().context());
        return this.internal.insert(ConverterUtil.makeCollectionIdentifier(collection.async()), id, encoded, new SpanWrapper(span)).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer())).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end());
    }

    private JsonSerializer serializer() {
        return this.serializer;
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_replace", (RequestSpan)this.internal.span());
        span.attribute("db.operation", "transaction_replace");
        byte[] encoded = EncodingUtil.encode(content, span, this.serializer, this.internal.core().context());
        return this.internal.replace(doc.internal(), encoded, new SpanWrapper(span)).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer())).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end());
    }

    public Mono<Void> remove(TransactionGetResult doc) {
        RequestSpan span = CbTracing.newSpan((CoreContext)this.internal.core().context(), (String)"transaction_remove", (RequestSpan)this.internal.span());
        span.attribute("db.operation", "transaction_remove");
        return this.internal.remove(doc.internal(), new SpanWrapper(span)).doOnError(err -> span.status(RequestSpan.StatusCode.ERROR)).doOnTerminate(() -> span.end());
    }

    @Stability.Internal
    CoreTransactionLogger logger() {
        return this.internal.logger();
    }

    public Mono<TransactionQueryResult> query(String statement) {
        return this.query(statement, null);
    }

    public Mono<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement, TransactionQueryOptions options) {
        ObjectNode opts = OptionsUtil.createTransactionOptions(scope, statement, options);
        return this.internal.queryBlocking(statement, scope == null ? null : scope.bucketName(), scope == null ? null : scope.name(), opts, false).map(response -> new TransactionQueryResult(response.header, response.rows, response.trailer, this.serializer()));
    }
}

