/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.transactions.TransactionGetResult;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import com.couchbase.client.java.transactions.TransactionQueryResult;
import com.couchbase.client.java.transactions.internal.ConverterUtil;
import java.io.IOException;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ReactiveTransactionAttemptContext {
    private final CoreTransactionAttemptContext internal;
    private final JsonSerializer serializer;

    ReactiveTransactionAttemptContext(CoreTransactionAttemptContext internal, JsonSerializer serializer) {
        this.internal = Objects.requireNonNull(internal);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public Mono<TransactionGetResult> get(ReactiveCollection collection, String id) {
        return this.internal.get(ConverterUtil.makeCollectionIdentifier(collection.async()), id).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer()));
    }

    public Mono<TransactionGetResult> insert(ReactiveCollection collection, String id, Object content) {
        byte[] encoded = this.serializer().serialize(content);
        return this.internal.insert(ConverterUtil.makeCollectionIdentifier(collection.async()), id, encoded).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer()));
    }

    private JsonSerializer serializer() {
        return this.serializer;
    }

    public Mono<TransactionGetResult> replace(TransactionGetResult doc, Object content) {
        byte[] encoded = this.serializer().serialize(content);
        return this.internal.replace(doc.internal(), encoded).map(result -> new TransactionGetResult((CoreTransactionGetResult)result, this.serializer()));
    }

    public Mono<Void> remove(TransactionGetResult doc) {
        return this.internal.remove(doc.internal());
    }

    @Stability.Internal
    CoreTransactionLogger logger() {
        return this.internal.logger();
    }

    public Mono<TransactionQueryResult> query(String statement) {
        return this.query(statement, null);
    }

    public Mono<TransactionQueryResult> query(String statement, TransactionQueryOptions options) {
        return this.query(null, statement, options);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement) {
        return this.query(scope, statement, null);
    }

    public Mono<TransactionQueryResult> query(ReactiveScope scope, String statement, TransactionQueryOptions options) {
        JsonObject json = JsonObject.create().put("statement", statement);
        if (scope != null) {
            json.put("query_context", QueryRequest.queryContext((String)scope.bucketName(), (String)scope.name()));
        }
        if (options != null) {
            options.builder().build().injectParams(json);
        }
        try {
            ObjectNode opts = (ObjectNode)Mapper.reader().readValue(json.toBytes(), ObjectNode.class);
            return this.internal.queryBlocking(statement, scope == null ? null : scope.bucketName(), scope == null ? null : scope.name(), opts, false).map(response -> new TransactionQueryResult(response.header, response.rows, response.trailer, this.serializer()));
        }
        catch (IOException e) {
            throw new EncodingFailureException((Throwable)e);
        }
    }
}

