/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.MutationState;
import com.couchbase.client.java.query.QueryProfile;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class QueryOptions
extends CommonOptions<QueryOptions> {
    private boolean adhoc = true;
    private String clientContextId;
    private MutationState consistentWith;
    private Integer maxParallelism;
    private boolean metrics = false;
    private JsonObject namedParameters;
    private Integer pipelineBatch;
    private Integer pipelineCap;
    private JsonArray positionalParameters;
    private QueryProfile profile;
    private Map<String, Object> raw;
    private boolean readonly = false;
    private String scanWait;
    private Integer scanCap;
    private QueryScanConsistency scanConsistency;
    private JsonSerializer serializer;
    private boolean flexIndex = false;

    protected QueryOptions() {
    }

    public static QueryOptions queryOptions() {
        return new QueryOptions();
    }

    public QueryOptions raw(String key, Object value) {
        Validators.notNullOrEmpty((String)key, (String)"Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, Object>();
        }
        this.raw.put(key, value);
        return this;
    }

    public QueryOptions adhoc(boolean adhoc) {
        this.adhoc = adhoc;
        return this;
    }

    public QueryOptions scanConsistency(QueryScanConsistency scanConsistency) {
        Validators.notNull((Object)((Object)scanConsistency), (String)"QueryScanConsistency");
        this.scanConsistency = scanConsistency;
        this.consistentWith = null;
        return this;
    }

    public QueryOptions serializer(JsonSerializer serializer) {
        Validators.notNull((Object)serializer, (String)"JsonSerializer");
        this.serializer = serializer;
        return this;
    }

    public QueryOptions profile(QueryProfile profile) {
        Validators.notNull((Object)((Object)profile), (String)"QueryProfile");
        this.profile = profile;
        return this;
    }

    public QueryOptions clientContextId(String clientContextId) {
        this.clientContextId = clientContextId == null || clientContextId.isEmpty() ? null : clientContextId;
        return this;
    }

    public QueryOptions metrics(boolean metrics) {
        this.metrics = metrics;
        return this;
    }

    public QueryOptions scanWait(Duration wait) {
        Validators.notNull((Object)wait, (String)"Wait Duration");
        this.scanWait = this.scanConsistency != null && this.scanConsistency == QueryScanConsistency.NOT_BOUNDED ? null : Golang.encodeDurationToMs((Duration)wait);
        return this;
    }

    public QueryOptions maxParallelism(int maxParallelism) {
        this.maxParallelism = maxParallelism;
        return this;
    }

    public QueryOptions readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public QueryOptions scanCap(int scanCap) {
        this.scanCap = scanCap;
        return this;
    }

    public QueryOptions pipelineBatch(int pipelineBatch) {
        this.pipelineBatch = pipelineBatch;
        return this;
    }

    public QueryOptions pipelineCap(int pipelineCap) {
        this.pipelineCap = pipelineCap;
        return this;
    }

    public QueryOptions parameters(JsonObject named) {
        Validators.notNull((Object)named, (String)"Named Parameters");
        this.namedParameters = named;
        this.positionalParameters = null;
        return this;
    }

    public QueryOptions parameters(JsonArray positional) {
        Validators.notNull((Object)positional, (String)"Positional Parameters");
        this.positionalParameters = positional;
        this.namedParameters = null;
        return this;
    }

    public QueryOptions consistentWith(MutationState mutationState) {
        Validators.notNull((Object)mutationState, (String)"MutationState");
        this.consistentWith = mutationState;
        this.scanConsistency = null;
        return this;
    }

    public QueryOptions flexIndex(boolean flexIndex) {
        this.flexIndex = flexIndex;
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
        }

        boolean adhoc() {
            return QueryOptions.this.adhoc;
        }

        public boolean readonly() {
            return QueryOptions.this.readonly;
        }

        public JsonSerializer serializer() {
            return QueryOptions.this.serializer;
        }

        public String clientContextId() {
            return QueryOptions.this.clientContextId;
        }

        @Stability.Internal
        public void injectParams(JsonObject queryJson) {
            boolean positionalPresent;
            queryJson.put("client_context_id", QueryOptions.this.clientContextId == null ? UUID.randomUUID().toString() : QueryOptions.this.clientContextId);
            boolean bl = positionalPresent = QueryOptions.this.positionalParameters != null && !QueryOptions.this.positionalParameters.isEmpty();
            if (QueryOptions.this.namedParameters != null && !QueryOptions.this.namedParameters.isEmpty()) {
                if (positionalPresent) {
                    throw InvalidArgumentException.fromMessage((String)"Both positional and named parameters cannot be present at the same time!");
                }
                QueryOptions.this.namedParameters.getNames().forEach(key -> {
                    Object value = QueryOptions.this.namedParameters.get((String)key);
                    if (key.charAt(0) != '$') {
                        queryJson.put('$' + key, value);
                    } else {
                        queryJson.put((String)key, value);
                    }
                });
            }
            if (positionalPresent) {
                queryJson.put("args", QueryOptions.this.positionalParameters);
            }
            if (QueryOptions.this.scanConsistency != null && QueryOptions.this.scanConsistency != QueryScanConsistency.NOT_BOUNDED) {
                queryJson.put("scan_consistency", QueryOptions.this.scanConsistency.toString());
            }
            if (QueryOptions.this.consistentWith != null) {
                JsonObject mutationState = JsonObject.create();
                for (MutationToken token : QueryOptions.this.consistentWith) {
                    JsonObject bucket = mutationState.getObject(token.bucketName());
                    if (bucket == null) {
                        bucket = JsonObject.create();
                        mutationState.put(token.bucketName(), bucket);
                    }
                    bucket.put(String.valueOf(token.partitionID()), JsonArray.from(token.sequenceNumber(), String.valueOf(token.partitionUUID())));
                }
                queryJson.put("scan_vectors", mutationState);
                queryJson.put("scan_consistency", "at_plus");
            }
            if (QueryOptions.this.profile != null && QueryOptions.this.profile != QueryProfile.OFF) {
                queryJson.put("profile", QueryOptions.this.profile.toString());
            }
            if (!(QueryOptions.this.scanWait == null || QueryOptions.this.scanWait.isEmpty() || QueryOptions.this.scanConsistency != null && QueryScanConsistency.NOT_BOUNDED == QueryOptions.this.scanConsistency)) {
                queryJson.put("scan_wait", QueryOptions.this.scanWait);
            }
            if (QueryOptions.this.maxParallelism != null) {
                queryJson.put("max_parallelism", QueryOptions.this.maxParallelism.toString());
            }
            if (QueryOptions.this.pipelineCap != null) {
                queryJson.put("pipeline_cap", QueryOptions.this.pipelineCap.toString());
            }
            if (QueryOptions.this.pipelineBatch != null) {
                queryJson.put("pipeline_batch", QueryOptions.this.pipelineBatch.toString());
            }
            if (QueryOptions.this.scanCap != null) {
                queryJson.put("scan_cap", QueryOptions.this.scanCap.toString());
            }
            if (!QueryOptions.this.metrics) {
                queryJson.put("metrics", false);
            }
            if (QueryOptions.this.readonly) {
                queryJson.put("readonly", true);
            }
            if (QueryOptions.this.flexIndex) {
                queryJson.put("use_fts", true);
            }
            if (QueryOptions.this.raw != null) {
                for (Map.Entry entry : QueryOptions.this.raw.entrySet()) {
                    queryJson.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

