/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StorageBackend {
    private static final ConcurrentMap<String, StorageBackend> interned = new ConcurrentHashMap<String, StorageBackend>();
    public static final StorageBackend COUCHSTORE = StorageBackend.of("couchstore");
    public static final StorageBackend MAGMA = StorageBackend.of("magma");
    private final String alias;

    private StorageBackend(String alias) {
        this.alias = Objects.requireNonNull(alias);
    }

    @JsonCreator
    public static StorageBackend of(String alias) {
        return interned.computeIfAbsent(alias, k -> new StorageBackend(alias));
    }

    @JsonValue
    public String alias() {
        return this.alias;
    }

    public String toString() {
        return this.alias();
    }
}

