/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.cleanup.CleanerFactory;
import com.couchbase.client.core.transaction.cleanup.ClientRecordFactory;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.transactions.TransactionKeyspace;
import com.couchbase.client.java.transactions.config.TransactionsCleanupConfig;
import com.couchbase.client.java.transactions.config.TransactionsQueryConfig;
import com.couchbase.client.java.transactions.internal.TransactionsSupportedExtensionsUtil;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.util.annotation.Nullable;

public class TransactionsConfig {
    private static final Duration TRANSACTION_TIMEOUT_MSECS_DEFAULT = Duration.of(15L, ChronoUnit.SECONDS);

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder cleanupConfig(TransactionsCleanupConfig.Builder config) {
        return TransactionsConfig.builder().cleanupConfig(config);
    }

    @Deprecated
    public static Builder timeout(Duration timeout) {
        return TransactionsConfig.builder().timeout(timeout);
    }

    @Deprecated
    public static Builder durabilityLevel(DurabilityLevel level) {
        return TransactionsConfig.builder().durabilityLevel(level);
    }

    @Deprecated
    public static Builder metadataCollection(TransactionKeyspace collection) {
        return TransactionsConfig.builder().metadataCollection(collection);
    }

    @Deprecated
    public static Builder queryConfig(TransactionsQueryConfig.Builder queryConfig) {
        return TransactionsConfig.builder().queryConfig(queryConfig);
    }

    public static class Builder {
        private DurabilityLevel level = DurabilityLevel.MAJORITY;
        private Optional<Duration> timeout = Optional.empty();
        private TransactionsCleanupConfig.Builder cleanupConfig = new TransactionsCleanupConfig.Builder();
        private Optional<TransactionAttemptContextFactory> attemptContextFactory = Optional.empty();
        private Optional<CleanerFactory> cleanerFactory = Optional.empty();
        private Optional<ClientRecordFactory> clientRecordFactory = Optional.empty();
        private Optional<Integer> numAtrs = Optional.empty();
        private Optional<CollectionIdentifier> metadataCollection = Optional.empty();
        private TransactionsQueryConfig.Builder queryConfig = new TransactionsQueryConfig.Builder();

        @Stability.Internal
        public CoreTransactionsConfig build() {
            return new CoreTransactionsConfig(this.level, this.timeout.orElse(TRANSACTION_TIMEOUT_MSECS_DEFAULT), this.cleanupConfig.build(), this.attemptContextFactory.orElse(new TransactionAttemptContextFactory()), this.cleanerFactory.orElse(new CleanerFactory()), this.clientRecordFactory.orElse(new ClientRecordFactory()), this.numAtrs.orElse(1024).intValue(), this.metadataCollection, this.queryConfig.scanConsistency().map(Enum::name), TransactionsSupportedExtensionsUtil.SUPPORTED);
        }

        @Deprecated
        public Builder cleanupConfig(TransactionsCleanupConfig.Builder config) {
            Validators.notNull((Object)config, (String)"cleanupConfig");
            this.cleanupConfig = config;
            return this;
        }

        @Stability.Uncommitted
        public Builder cleanupConfig(Consumer<TransactionsCleanupConfig.Builder> builderConsumer) {
            builderConsumer.accept(this.cleanupConfig);
            return this;
        }

        public Builder timeout(Duration timeout) {
            Validators.notNull((Object)timeout, (String)"timeout");
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder durabilityLevel(DurabilityLevel level) {
            Validators.notNull((Object)level, (String)"durabilityLevel");
            this.level = level;
            return this;
        }

        @Stability.Internal
        Builder testFactories(@Nullable TransactionAttemptContextFactory attemptContextFactory, @Nullable CleanerFactory cleanerFactory, @Nullable ClientRecordFactory clientRecordFactory) {
            this.attemptContextFactory = Optional.ofNullable(attemptContextFactory);
            this.cleanerFactory = Optional.ofNullable(cleanerFactory);
            this.clientRecordFactory = Optional.ofNullable(clientRecordFactory);
            return this;
        }

        public Builder metadataCollection(TransactionKeyspace collection) {
            Validators.notNull((Object)collection, (String)"metadataCollection");
            CollectionIdentifier coll = new CollectionIdentifier(collection.bucket(), Optional.of(collection.scope()), Optional.of(collection.collection()));
            this.metadataCollection = Optional.ofNullable(coll);
            return this;
        }

        @Deprecated
        public Builder queryConfig(TransactionsQueryConfig.Builder queryConfig) {
            Validators.notNull((Object)queryConfig, (String)"queryConfig");
            this.queryConfig = queryConfig;
            return this;
        }

        public Builder queryConfig(Consumer<TransactionsQueryConfig.Builder> builderConsumer) {
            builderConsumer.accept(this.queryConfig);
            return this;
        }
    }
}

