/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoCoordinates;
import com.couchbase.client.core.api.search.queries.CoreGeoPolygonQuery;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.util.Coordinate;
import java.util.List;

public class GeoPolygonQuery
extends SearchQuery {
    private final List<Coordinate> coordinates;
    private String field;

    public GeoPolygonQuery(List<Coordinate> coordinates) {
        this.coordinates = Validators.notNullOrEmpty(coordinates, (String)"GeoPolygonQuery Coordinates");
    }

    public GeoPolygonQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public GeoPolygonQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    public CoreSearchQuery toCore() {
        return new CoreGeoPolygonQuery(CbCollections.transform(this.coordinates, it -> CoreGeoCoordinates.lat((double)it.lat()).lon(it.lon())), this.field, this.boost);
    }
}

