/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.error.AnalyticsException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.HttpStatusCodeException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.analytics.GenericAnalyticsRequest;
import com.couchbase.client.core.msg.analytics.GenericAnalyticsResponse;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.manager.analytics.AnalyticsDataType;
import com.couchbase.client.java.manager.analytics.AnalyticsDataset;
import com.couchbase.client.java.manager.analytics.AnalyticsDataverse;
import com.couchbase.client.java.manager.analytics.AnalyticsIndex;
import com.couchbase.client.java.manager.analytics.ConnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DisconnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDatasetsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllIndexesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetPendingMutationsAnalyticsOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AsyncAnalyticsIndexManager {
    private static final int DATAVERSE_NOT_FOUND = 24034;
    private static final int DATAVERSE_ALREADY_EXISTS = 24039;
    private static final int DATASET_NOT_FOUND = 24025;
    private static final int DATASET_ALREADY_EXISTS = 24040;
    private static final int INDEX_NOT_FOUND = 24047;
    private static final int INDEX_ALREADY_EXISTS = 24048;
    private static final int LINK_NOT_FOUND = 24006;
    private final AsyncCluster cluster;
    private final Core core;
    private static final String DEFAULT_DATAVERSE = "Default";
    private static final String DEFAULT_LINK = "Local";
    private static final Map<Integer, Function<AnalyticsException, ? extends AnalyticsException>> errorMap = new HashMap<Integer, Function<AnalyticsException, ? extends AnalyticsException>>();

    public AsyncAnalyticsIndexManager(AsyncCluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
        this.core = cluster.core();
    }

    public CompletableFuture<Void> createDataverse(String dataverseName) {
        return this.createDataverse(dataverseName, CreateDataverseAnalyticsOptions.createDataverseAnalyticsOptions());
    }

    public CompletableFuture<Void> createDataverse(String dataverseName, CreateDataverseAnalyticsOptions options) {
        Objects.requireNonNull(dataverseName);
        CreateDataverseAnalyticsOptions.Built builtOpts = options.build();
        String statement = "CREATE DATAVERSE " + AsyncAnalyticsIndexManager.quote(dataverseName);
        if (builtOpts.ignoreIfExists()) {
            statement = statement + " IF NOT EXISTS";
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<List<AnalyticsDataverse>> getAllDataverses() {
        return this.cluster.analyticsQuery("SELECT DataverseName from Metadata.`Dataverse`").thenApply(result -> result.rowsAsObject().stream().map(dv -> dv.put("DataverseName", ((String)dv.get("DataverseName")).replace("@.", "."))).map(AnalyticsDataverse::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropDataverse(String dataverseName) {
        return this.dropDataverse(dataverseName, DropDataverseAnalyticsOptions.dropDataverseAnalyticsOptions());
    }

    public CompletableFuture<Void> dropDataverse(String dataverseName, DropDataverseAnalyticsOptions options) {
        Objects.requireNonNull(dataverseName);
        DropDataverseAnalyticsOptions.Built builtOpts = options.build();
        String statement = "DROP DATAVERSE " + AsyncAnalyticsIndexManager.quote(dataverseName);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<Void> createDataset(String datasetName, String bucketName) {
        return this.createDataset(datasetName, bucketName, CreateDatasetAnalyticsOptions.createDatasetAnalyticsOptions());
    }

    public CompletableFuture<Void> createDataset(String datasetName, String bucketName, CreateDatasetAnalyticsOptions options) {
        Objects.requireNonNull(datasetName);
        Objects.requireNonNull(bucketName);
        CreateDatasetAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String condition = builtOpts.condition().orElse(null);
        String statement = "CREATE DATASET ";
        if (builtOpts.ignoreIfExists()) {
            statement = statement + "IF NOT EXISTS ";
        }
        statement = statement + AsyncAnalyticsIndexManager.quote(dataverseName, datasetName) + " ON " + AsyncAnalyticsIndexManager.quote(bucketName);
        if (condition != null) {
            statement = statement + " WHERE " + condition;
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<Void> dropDataset(String datasetName) {
        return this.dropDataset(datasetName, DropDatasetAnalyticsOptions.dropDatasetAnalyticsOptions());
    }

    public CompletableFuture<Void> dropDataset(String datasetName, DropDatasetAnalyticsOptions options) {
        Objects.requireNonNull(datasetName);
        DropDatasetAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "DROP DATASET " + AsyncAnalyticsIndexManager.quote(dataverseName, datasetName);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<List<AnalyticsDataset>> getAllDatasets() {
        return this.getAllDatasets(GetAllDatasetsAnalyticsOptions.getAllDatasetsAnalyticsOptions());
    }

    public CompletableFuture<List<AnalyticsDataset>> getAllDatasets(GetAllDatasetsAnalyticsOptions options) {
        GetAllDatasetsAnalyticsOptions.Built builtOpts = options.build();
        String statement = "SELECT d.* FROM Metadata.`Dataset` d WHERE d.DataverseName <> \"Metadata\"";
        return this.exec(statement, builtOpts).thenApply(result -> result.rowsAsObject().stream().map(AnalyticsDataset::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields) {
        return this.createIndex(indexName, datasetName, fields, CreateIndexAnalyticsOptions.createIndexAnalyticsOptions());
    }

    public CompletableFuture<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields, CreateIndexAnalyticsOptions options) {
        Objects.requireNonNull(indexName);
        Objects.requireNonNull(datasetName);
        CreateIndexAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "CREATE INDEX " + AsyncAnalyticsIndexManager.quote(indexName);
        if (builtOpts.ignoreIfExists()) {
            statement = statement + " IF NOT EXISTS";
        }
        statement = statement + " ON " + AsyncAnalyticsIndexManager.quote(dataverseName, datasetName) + " " + AsyncAnalyticsIndexManager.formatIndexFields(fields);
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<List<AnalyticsIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllIndexesAnalyticsOptions.getAllIndexesAnalyticsOptions());
    }

    public CompletableFuture<List<AnalyticsIndex>> getAllIndexes(GetAllIndexesAnalyticsOptions options) {
        GetAllIndexesAnalyticsOptions.Built builtOpts = options.build();
        String statement = "SELECT d.* FROM Metadata.`Index` d WHERE d.DataverseName <> \"Metadata\"";
        return this.exec(statement, builtOpts).thenApply(result -> result.rowsAsObject().stream().map(AnalyticsIndex::new).collect(Collectors.toList()));
    }

    private static String formatIndexFields(Map<String, AnalyticsDataType> fields) {
        ArrayList result = new ArrayList();
        fields.forEach((k, v) -> result.add(k + ":" + v.value()));
        return "(" + String.join((CharSequence)",", result) + ")";
    }

    public CompletableFuture<Void> dropIndex(String indexName, String datasetName) {
        return this.dropIndex(indexName, datasetName, DropIndexAnalyticsOptions.dropIndexAnalyticsOptions());
    }

    public CompletableFuture<Void> dropIndex(String indexName, String datasetName, DropIndexAnalyticsOptions options) {
        DropIndexAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "DROP INDEX " + AsyncAnalyticsIndexManager.quote(dataverseName, datasetName, indexName);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<Void> connectLink() {
        return this.connectLink(ConnectLinkAnalyticsOptions.connectLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> connectLink(ConnectLinkAnalyticsOptions options) {
        ConnectLinkAnalyticsOptions.Built builtOpts = options.build();
        String statement = "CONNECT LINK " + AsyncAnalyticsIndexManager.quote(builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE), builtOpts.linkName().orElse(DEFAULT_LINK));
        if (builtOpts.force()) {
            statement = statement + " WITH " + Mapper.encodeAsString(Collections.singletonMap("force", true));
        }
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<Void> disconnectLink() {
        return this.disconnectLink(DisconnectLinkAnalyticsOptions.disconnectLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> disconnectLink(DisconnectLinkAnalyticsOptions options) {
        DisconnectLinkAnalyticsOptions.Built builtOpts = options.build();
        String statement = "DISCONNECT LINK " + AsyncAnalyticsIndexManager.quote(builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE), builtOpts.linkName().orElse(DEFAULT_LINK));
        return this.exec(statement, builtOpts).thenApply(result -> null);
    }

    public CompletableFuture<Map<String, Map<String, Long>>> getPendingMutations() {
        return this.getPendingMutations(GetPendingMutationsAnalyticsOptions.getPendingMutationsAnalyticsOptions());
    }

    public CompletableFuture<Map<String, Map<String, Long>>> getPendingMutations(GetPendingMutationsAnalyticsOptions options) {
        return ((CompletableFuture)this.sendRequest(HttpMethod.GET, "/analytics/node/agg/stats/remaining", options.build()).exceptionally(t -> {
            throw this.translateException((Throwable)t);
        })).thenApply(response -> (Map)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<Map<String, Map<String, Long>>>(){}));
    }

    private CompletableFuture<GenericAnalyticsResponse> sendRequest(HttpMethod method, String path, CommonOptions.BuiltCommonOptions options) {
        return this.sendRequest(new GenericAnalyticsRequest(this.timeout(options), this.core.context(), this.retryStrategy(options), () -> new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, path), method == HttpMethod.GET));
    }

    private CompletableFuture<GenericAnalyticsResponse> sendRequest(GenericAnalyticsRequest request) {
        this.core.send((Request)request);
        return request.response();
    }

    private Duration timeout(CommonOptions.BuiltCommonOptions options) {
        return options.timeout().orElse(this.core.context().environment().timeoutConfig().managementTimeout());
    }

    private RetryStrategy retryStrategy(CommonOptions.BuiltCommonOptions options) {
        return options.retryStrategy().orElse(this.core.context().environment().retryStrategy());
    }

    private CompletableFuture<AnalyticsResult> exec(String statement, CommonOptions.BuiltCommonOptions options) {
        return this.cluster.analyticsQuery(statement, AsyncAnalyticsIndexManager.toAnalyticsOptions(options)).exceptionally(t -> {
            throw this.translateException((Throwable)t);
        });
    }

    private static AnalyticsOptions toAnalyticsOptions(CommonOptions.BuiltCommonOptions options) {
        AnalyticsOptions result = AnalyticsOptions.analyticsOptions();
        options.timeout().ifPresent(result::timeout);
        options.retryStrategy().ifPresent(result::retryStrategy);
        return result;
    }

    private RuntimeException translateException(Throwable t) {
        HttpStatusCodeException httpException = CbThrowables.findCause((Throwable)t, HttpStatusCodeException.class).orElse(null);
        if (httpException != null && httpException.code() == HttpResponseStatus.NOT_FOUND.code()) {
            return new FeatureNotAvailableException(t);
        }
        if (t instanceof AnalyticsException) {
            AnalyticsException e = (AnalyticsException)t;
            for (Integer code : errorMap.keySet()) {
                if (!e.hasErrorCode(code.intValue())) continue;
                return (RuntimeException)errorMap.get(code).apply(e);
            }
        }
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    private static String quote(String s) {
        if (s.contains("`")) {
            throw InvalidArgumentException.fromMessage((String)("Value [" + RedactableArgument.redactMeta((Object)s) + "] may not contain backticks."));
        }
        return "`" + s + "`";
    }

    private static String quote(String ... components) {
        return Arrays.stream(components).map(AsyncAnalyticsIndexManager::quote).collect(Collectors.joining("."));
    }
}

