/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonValueModule;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class JacksonJsonSerializer
implements JsonSerializer {
    private final ObjectMapper mapper;

    public static JacksonJsonSerializer create(ObjectMapper mapper) {
        return new JacksonJsonSerializer(mapper);
    }

    public static JacksonJsonSerializer create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JsonValueModule());
        return JacksonJsonSerializer.create(mapper);
    }

    private JacksonJsonSerializer(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public byte[] serialize(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        try {
            return this.mapper.writeValueAsBytes(input);
        }
        catch (Throwable t) {
            throw new EncodingFailureException("Serializing of content + " + RedactableArgument.redactUser((Object)input) + " to JSON failed.", t);
        }
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) {
        if (target.isAssignableFrom(byte[].class)) {
            return (T)input;
        }
        try {
            return (T)this.mapper.readValue(input, target);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }

    @Override
    public <T> T deserialize(TypeRef<T> target, byte[] input) {
        try {
            JavaType type = this.mapper.getTypeFactory().constructType(target.type());
            return (T)this.mapper.readValue(input, type);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }
}

