/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.json;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JsonObject
extends JsonValue
implements Serializable {
    private static final long serialVersionUID = 8817717605659870262L;
    private final Map<String, Object> content;

    private JsonObject() {
        this.content = new HashMap<String, Object>();
    }

    private JsonObject(int initialCapacity) {
        this.content = new HashMap<String, Object>(initialCapacity);
    }

    public static JsonObject create() {
        return new JsonObject();
    }

    public static JsonObject create(int initialCapacity) {
        return new JsonObject(initialCapacity);
    }

    public static JsonObject from(Map<String, ?> mapData) {
        if (mapData == null) {
            throw new NullPointerException("Null input Map unsupported");
        }
        JsonObject result = new JsonObject(mapData.size());
        try {
            mapData.forEach((key, value) -> {
                Objects.requireNonNull(key, "The key is not allowed to be null");
                result.put((String)key, JsonObject.coerce(value));
            });
        }
        catch (ClassCastException e) {
            throw InvalidArgumentException.fromMessage((String)"Map key must be String", (Throwable)e);
        }
        return result;
    }

    public static JsonObject fromJson(String s) {
        try {
            return JacksonTransformers.stringToJsonObject(s);
        }
        catch (Exception e) {
            throw InvalidArgumentException.fromMessage((String)"Cannot convert string to JsonObject", (Throwable)e);
        }
    }

    public static JsonObject fromJson(byte[] s) {
        try {
            return JacksonTransformers.bytesToJsonObject(s);
        }
        catch (Exception e) {
            throw InvalidArgumentException.fromMessage((String)"Cannot convert byte array to JsonObject", (Throwable)e);
        }
    }

    public JsonObject put(String name, Object value) {
        if (this == value) {
            throw InvalidArgumentException.fromMessage((String)"Cannot put self");
        }
        this.content.put(name, JsonObject.coerce(value));
        return this;
    }

    public Object get(String name) {
        return this.content.get(name);
    }

    public JsonObject put(String name, String value) {
        this.content.put(name, value);
        return this;
    }

    public String getString(String name) {
        return (String)this.content.get(name);
    }

    public JsonObject put(String name, int value) {
        this.content.put(name, value);
        return this;
    }

    public Integer getInt(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public JsonObject put(String name, long value) {
        this.content.put(name, value);
        return this;
    }

    public Long getLong(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public JsonObject put(String name, double value) {
        this.content.put(name, value);
        return this;
    }

    public Double getDouble(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public JsonObject put(String name, boolean value) {
        this.content.put(name, value);
        return this;
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.content.get(name);
    }

    public JsonObject put(String name, JsonObject value) {
        if (this == value) {
            throw InvalidArgumentException.fromMessage((String)"Cannot put self");
        }
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Map<String, ?> value) {
        return this.put(name, JsonObject.from(value));
    }

    public JsonObject getObject(String name) {
        return (JsonObject)this.content.get(name);
    }

    public JsonObject put(String name, JsonArray value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, Number value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, List<?> value) {
        return this.put(name, JsonArray.from(value));
    }

    public JsonArray getArray(String name) {
        return (JsonArray)this.content.get(name);
    }

    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.content.get(name);
    }

    public BigDecimal getBigDecimal(String name) {
        Object found = this.content.get(name);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return new BigDecimal((Double)found);
        }
        return (BigDecimal)found;
    }

    public Number getNumber(String name) {
        return (Number)this.content.get(name);
    }

    public JsonObject putNull(String name) {
        this.content.put(name, null);
        return this;
    }

    public JsonObject removeKey(String name) {
        this.content.remove(name);
        return this;
    }

    public Set<String> getNames() {
        return this.content.keySet();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.content.size());
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            Object content = entry.getValue();
            if (content instanceof JsonObject) {
                copy.put(entry.getKey(), ((JsonObject)content).toMap());
                continue;
            }
            if (content instanceof JsonArray) {
                copy.put(entry.getKey(), ((JsonArray)content).toList());
                continue;
            }
            copy.put(entry.getKey(), content);
        }
        return copy;
    }

    public boolean containsKey(String name) {
        return this.content.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.content.containsValue(value);
    }

    public int size() {
        return this.content.size();
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert JsonObject to Json String", e);
        }
    }

    public byte[] toBytes() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Cannot convert JsonObject to Json byte array", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }
}

